/*
 * Decompiled with CFR 0.152.
 */
package com.nick.chimes;

import com.nick.chimes.ClientRegisteries;
import com.nick.chimes.client.ChimesSettings;
import com.nick.chimes.client.particles.Leaf;
import com.nick.chimes.client.particles.Rest;
import com.nick.chimes.client.tile.AmethystChimesRenderer;
import com.nick.chimes.client.tile.BambooChimesRenderer;
import com.nick.chimes.client.tile.CopperChimesRenderer;
import com.nick.chimes.client.tile.MetalChimesRenderer;
import com.nick.chimes.common.blocks.AmethystChimes;
import com.nick.chimes.common.blocks.BambooChimes;
import com.nick.chimes.common.blocks.BambooChimesStripped;
import com.nick.chimes.common.blocks.CopperChimes;
import com.nick.chimes.common.blocks.MetalChimes;
import com.nick.chimes.common.tileentity.AmethystChimesTile;
import com.nick.chimes.common.tileentity.BambooChimesTile;
import com.nick.chimes.common.tileentity.CopperChimesTile;
import com.nick.chimes.common.tileentity.MetalChimesTile;
import com.nick.chimes.util.lists.ChimesBlocks;
import com.nick.chimes.util.lists.ChimesParticles;
import com.nick.chimes.util.lists.ChimesSounds;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.criterion.PositionTrigger;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.particles.ParticleType;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="chimes")
public class Chimes {
    public static final String modid = "chimes";
    public static final PositionTrigger CONSTRUCT_BEACON = (PositionTrigger)CriteriaTriggers.func_192118_a((ICriterionTrigger)new PositionTrigger(new ResourceLocation("near_chiming")));
    public static final PositionTrigger NEAR_SILENCED = (PositionTrigger)CriteriaTriggers.func_192118_a((ICriterionTrigger)new PositionTrigger(new ResourceLocation("near_silenced")));

    public Chimes() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::ClientSetup);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, ChimesSettings.SPEC);
        ChimesSounds.SOUNDS.register(modEventBus);
        ChimesParticles.PARTICLES.register(modEventBus);
    }

    public void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> CONSTRUCT_BEACON);
        event.enqueueWork(() -> NEAR_SILENCED);
    }

    private void ClientSetup(FMLClientSetupEvent event) {
        ClientRegisteries.registerExtensionPoint();
        RenderType CUTOUT = RenderType.func_228643_e_();
        ClientRegistry.bindTileEntityRenderer(ChimesBlocks.BAMBOOCHIMES_TILE, BambooChimesRenderer::new);
        ClientRegistry.bindTileEntityRenderer(ChimesBlocks.METALCHIMES_TILE, MetalChimesRenderer::new);
        ClientRegistry.bindTileEntityRenderer(ChimesBlocks.AMETHYSTCHIMES_TILE, AmethystChimesRenderer::new);
        ClientRegistry.bindTileEntityRenderer(ChimesBlocks.COPPERCHIMES_TILE, CopperChimesRenderer::new);
        RenderTypeLookup.setRenderLayer((Block)ChimesBlocks.BAMBOOCHIMES, (RenderType)CUTOUT);
        RenderTypeLookup.setRenderLayer((Block)ChimesBlocks.METALCHIMES, (RenderType)CUTOUT);
        RenderTypeLookup.setRenderLayer((Block)ChimesBlocks.STRIPPEDBAMBOOCHIMES, (RenderType)CUTOUT);
        RenderTypeLookup.setRenderLayer((Block)ChimesBlocks.COPPERCHIMES, (RenderType)CUTOUT);
        RenderTypeLookup.setRenderLayer((Block)ChimesBlocks.AMETHYSTCHIMES, (RenderType)CUTOUT);
    }

    @Mod.EventBusSubscriber(modid="chimes", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> event) {
            event.getRegistry().register(new BambooChimes(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151669_i).func_200948_a(0.5f, 0.25f).func_200947_a(SoundType.field_222468_o).harvestTool(ToolType.AXE).func_226896_b_()).setRegistryName("bamboo_chimes"));
            event.getRegistry().register(new BambooChimesStripped(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151669_i).func_200948_a(0.5f, 0.25f).func_200947_a(SoundType.field_222470_q).harvestTool(ToolType.AXE).func_226896_b_()).setRegistryName("carved_bamboo_chimes"));
            event.getRegistry().register(new MetalChimes(AbstractBlock.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151669_i).func_200948_a(1.0f, 0.25f).func_200947_a(SoundType.field_235597_S_).harvestTool(ToolType.PICKAXE).func_226896_b_()).setRegistryName("iron_chimes"));
            event.getRegistry().register(new CopperChimes(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(1.0f, 0.25f).func_200947_a(SoundType.field_235597_S_).harvestTool(ToolType.PICKAXE).func_226896_b_()).setRegistryName("copper_chimes"));
            event.getRegistry().register(new AmethystChimes(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(1.25f, 0.25f).func_200947_a(SoundType.field_185852_e).harvestTool(ToolType.PICKAXE).func_235838_a_(value -> 7).func_226896_b_()).setRegistryName("amethyst_chimes"));
        }

        @SubscribeEvent
        public static void onItemsRegistry(RegistryEvent.Register<Item> event) {
            event.getRegistry().register(new BlockItem((Block)ChimesBlocks.BAMBOOCHIMES, new Item.Properties().func_200916_a(ItemGroup.field_78031_c)).setRegistryName("bamboo_chimes"));
            event.getRegistry().register(new BlockItem((Block)ChimesBlocks.STRIPPEDBAMBOOCHIMES, new Item.Properties().func_200916_a(ItemGroup.field_78031_c)).setRegistryName("carved_bamboo_chimes"));
            event.getRegistry().register(new BlockItem((Block)ChimesBlocks.METALCHIMES, new Item.Properties().func_200916_a(ItemGroup.field_78031_c)).setRegistryName("iron_chimes"));
            event.getRegistry().register(new BlockItem((Block)ChimesBlocks.COPPERCHIMES, new Item.Properties().func_200916_a(ItemGroup.field_78031_c)).setRegistryName("copper_chimes"));
            event.getRegistry().register(new BlockItem((Block)ChimesBlocks.AMETHYSTCHIMES, new Item.Properties().func_200916_a(ItemGroup.field_78031_c)).setRegistryName("amethyst_chimes"));
        }

        @SubscribeEvent
        public static void onTileEntityRegistry(RegistryEvent.Register<TileEntityType<?>> event) {
            event.getRegistry().register(TileEntityType.Builder.func_223042_a(BambooChimesTile::new, (Block[])new Block[]{ChimesBlocks.BAMBOOCHIMES, ChimesBlocks.STRIPPEDBAMBOOCHIMES}).func_206865_a(null).setRegistryName("bamboo_chimes_tile"));
            event.getRegistry().register(TileEntityType.Builder.func_223042_a(MetalChimesTile::new, (Block[])new Block[]{ChimesBlocks.METALCHIMES}).func_206865_a(null).setRegistryName("metal_chimes_tile"));
            event.getRegistry().register(TileEntityType.Builder.func_223042_a(AmethystChimesTile::new, (Block[])new Block[]{ChimesBlocks.AMETHYSTCHIMES}).func_206865_a(null).setRegistryName("amethyst_chimes_tile"));
            event.getRegistry().register(TileEntityType.Builder.func_223042_a(CopperChimesTile::new, (Block[])new Block[]{ChimesBlocks.COPPERCHIMES}).func_206865_a(null).setRegistryName("copper_chimes_tile"));
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void onParticleRegistry(ParticleFactoryRegisterEvent event) {
            Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)ChimesParticles.LEAF.get(), Leaf.Factory::new);
            Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)ChimesParticles.REST.get(), Rest.Factory::new);
        }

        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        public static void onTextureStitch(TextureStitchEvent.Pre event) {
            if (!event.getMap().func_229223_g_().equals((Object)AtlasTexture.field_110575_b)) {
                return;
            }
            event.addSprite(new ResourceLocation(Chimes.modid, "block/bamboo_chimes"));
            event.addSprite(new ResourceLocation(Chimes.modid, "block/bamboo_chimes_carved"));
            event.addSprite(new ResourceLocation(Chimes.modid, "block/metal_chimes"));
            event.addSprite(new ResourceLocation(Chimes.modid, "block/copper_chimes"));
            event.addSprite(new ResourceLocation(Chimes.modid, "block/amethyst_chimes"));
        }
    }
}

