/*
 * Decompiled with CFR 0.152.
 */
package com.nick.chimes.client.tile;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.nick.chimes.client.ChimesSettings;
import com.nick.chimes.client.settings.Animated;
import com.nick.chimes.common.blocks.Placement;
import com.nick.chimes.common.tileentity.CopperChimesTile;
import com.nick.chimes.util.lists.ChimesStates;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CopperChimesRenderer
extends TileEntityRenderer<CopperChimesTile> {
    public static final RenderMaterial COPPER = new RenderMaterial(AtlasTexture.field_110575_b, new ResourceLocation("chimes", "block/copper_chimes"));
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.field_208163_P;
    public static final BooleanProperty CHIMING = ChimesStates.CHIMING;
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final EnumProperty<Placement> PLACEMENT = ChimesStates.PLACEMENT;
    private final ModelRenderer CopperUpper = new ModelRenderer(64, 64, 0, 0);
    private final ModelRenderer StringBone1;
    private final ModelRenderer Pipe1U;
    private final ModelRenderer StringBone2;
    private final ModelRenderer Pipe2U;
    private final ModelRenderer StringBone3;
    private final ModelRenderer Pipe3U;
    private final ModelRenderer StringBone4;
    private final ModelRenderer Pipe4U;
    private final ModelRenderer CopperLower;
    private final ModelRenderer StringBone1A;
    private final ModelRenderer Pipe1L;
    private final ModelRenderer StringBone2A;
    private final ModelRenderer Pipe2L;
    private final ModelRenderer StringBone3A;
    private final ModelRenderer Pipe3L;
    private final ModelRenderer StringBone4A;
    private final ModelRenderer Pipe4L;

    public CopperChimesRenderer(TileEntityRendererDispatcher p_i226005_1_) {
        super(p_i226005_1_);
        this.CopperUpper.func_78793_a(0.0f, 8.0f, 0.0f);
        ModelRenderer string2_r1 = new ModelRenderer(64, 64, 0, 0);
        string2_r1.func_78793_a(0.0f, 2.0f, 0.0f);
        this.CopperUpper.func_78792_a(string2_r1);
        this.setRotationAngle(string2_r1, 0.0f, -0.7854f, 0.0f);
        string2_r1.func_78784_a(34, 1).func_228303_a_(0.0f, -2.0f, -5.5f, 0.0f, 4.0f, 11.0f, 0.0f, false);
        ModelRenderer string1_r1 = new ModelRenderer(64, 64, 0, 0);
        string1_r1.func_78793_a(0.0f, 2.0f, 0.0f);
        this.CopperUpper.func_78792_a(string1_r1);
        this.setRotationAngle(string1_r1, -3.1416f, -0.7854f, 3.1416f);
        string1_r1.func_78784_a(34, 1).func_228303_a_(0.0f, -2.0f, -5.5f, 0.0f, 4.0f, 11.0f, 0.0f, false);
        ModelRenderer platform = new ModelRenderer(64, 64, 0, 0);
        platform.func_78793_a(0.0f, 4.0f, 0.0f);
        this.CopperUpper.func_78792_a(platform);
        platform.func_78784_a(0, 0).func_228303_a_(-5.0f, 0.0f, -5.0f, 10.0f, 2.0f, 10.0f, 0.0f, false);
        this.StringBone1 = new ModelRenderer(64, 64, 0, 0);
        this.StringBone1.func_78793_a(-3.5f, 2.0f, 0.5f);
        platform.func_78792_a(this.StringBone1);
        ModelRenderer string1_r2 = new ModelRenderer(64, 64, 0, 0);
        string1_r2.func_78793_a(0.0f, 2.0f, 0.0f);
        this.StringBone1.func_78792_a(string1_r2);
        this.setRotationAngle(string1_r2, 0.0f, 1.5f, 0.0f);
        string1_r2.func_78784_a(24, 18).func_228303_a_(-2.5f, -2.0f, 0.0f, 5.0f, 4.0f, 0.0f, 0.0f, false);
        this.Pipe1U = new ModelRenderer(64, 64, 0, 0);
        this.Pipe1U.func_78793_a(0.0f, 3.5f, 0.0f);
        this.StringBone1.func_78792_a(this.Pipe1U);
        this.Pipe1U.func_78784_a(0, 12).func_228303_a_(-1.5f, -1.5f, -1.5f, 3.0f, 8.0f, 3.0f, 0.0f, false);
        this.StringBone2 = new ModelRenderer(64, 64, 0, 0);
        this.StringBone2.func_78793_a(0.5f, 2.0f, 3.5f);
        platform.func_78792_a(this.StringBone2);
        this.StringBone2.func_78784_a(24, 16).func_228303_a_(-2.5f, 0.0f, 0.0f, 5.0f, 6.0f, 0.0f, 0.0f, false);
        this.Pipe2U = new ModelRenderer(64, 64, 0, 0);
        this.Pipe2U.func_78793_a(0.0f, 5.5f, 0.0f);
        this.StringBone2.func_78792_a(this.Pipe2U);
        this.Pipe2U.func_78784_a(12, 12).func_228303_a_(-1.5f, -1.5f, -1.5f, 3.0f, 6.0f, 3.0f, 0.0f, false);
        this.StringBone3 = new ModelRenderer(64, 64, 0, 0);
        this.StringBone3.func_78793_a(3.5f, 2.0f, -0.5f);
        platform.func_78792_a(this.StringBone3);
        ModelRenderer string3_r1 = new ModelRenderer(64, 64, 0, 0);
        string3_r1.func_78793_a(0.0f, 4.0f, 0.0f);
        this.StringBone3.func_78792_a(string3_r1);
        this.setRotationAngle(string3_r1, 0.0f, 1.5f, 0.0f);
        string3_r1.func_78784_a(24, 14).func_228303_a_(-2.5f, -4.0f, 0.0f, 5.0f, 8.0f, 0.0f, 0.0f, false);
        this.Pipe3U = new ModelRenderer(64, 64, 0, 0);
        this.Pipe3U.func_78793_a(0.0f, 7.5f, 0.0f);
        this.StringBone3.func_78792_a(this.Pipe3U);
        this.Pipe3U.func_78784_a(12, 12).func_228303_a_(-1.5f, -1.5f, -1.5f, 3.0f, 4.0f, 3.0f, 0.0f, false);
        this.StringBone4 = new ModelRenderer(64, 64, 0, 0);
        this.StringBone4.func_78793_a(-0.5f, 2.0f, -3.5f);
        platform.func_78792_a(this.StringBone4);
        this.StringBone4.func_78784_a(24, 12).func_228303_a_(-2.5f, 0.0f, 0.0f, 5.0f, 10.0f, 0.0f, 0.0f, false);
        this.Pipe4U = new ModelRenderer(64, 64, 0, 0);
        this.Pipe4U.func_78793_a(0.0f, 9.5f, 0.0f);
        this.StringBone4.func_78792_a(this.Pipe4U);
        this.Pipe4U.func_78784_a(12, 12).func_228303_a_(-1.5f, -1.5f, -1.5f, 3.0f, 2.0f, 3.0f, 0.0f, false);
        this.CopperLower = new ModelRenderer(64, 64, 0, 0);
        this.CopperLower.func_78793_a(0.0f, 8.0f, 0.0f);
        ModelRenderer topB = new ModelRenderer(64, 64, 0, 0);
        topB.func_78793_a(0.0f, 4.0f, 0.0f);
        this.CopperLower.func_78792_a(topB);
        this.StringBone1A = new ModelRenderer(64, 64, 0, 0);
        this.StringBone1A.func_78793_a(-3.5f, 2.0f, 0.5f);
        topB.func_78792_a(this.StringBone1A);
        this.Pipe1L = new ModelRenderer(64, 64, 0, 0);
        this.Pipe1L.func_78793_a(0.0f, 3.5f, 0.0f);
        this.StringBone1A.func_78792_a(this.Pipe1L);
        this.Pipe1L.func_78784_a(12, 38).func_228303_a_(-1.5f, 6.5f, -1.5f, 3.0f, 12.0f, 3.0f, 0.0f, false);
        this.StringBone2A = new ModelRenderer(64, 64, 0, 0);
        this.StringBone2A.func_78793_a(-0.5f, 2.0f, -3.5f);
        topB.func_78792_a(this.StringBone2A);
        this.Pipe2L = new ModelRenderer(64, 64, 0, 0);
        this.Pipe2L.func_78793_a(0.0f, 9.5f, 0.0f);
        this.StringBone2A.func_78792_a(this.Pipe2L);
        this.Pipe2L.func_78784_a(24, 22).func_228303_a_(-1.5f, 0.5f, -1.5f, 3.0f, 18.0f, 3.0f, 0.0f, false);
        this.StringBone3A = new ModelRenderer(64, 64, 0, 0);
        this.StringBone3A.func_78793_a(3.5f, 2.0f, -0.5f);
        topB.func_78792_a(this.StringBone3A);
        this.Pipe3L = new ModelRenderer(64, 64, 0, 0);
        this.Pipe3L.func_78793_a(0.0f, 7.5f, 0.0f);
        this.StringBone3A.func_78792_a(this.Pipe3L);
        this.Pipe3L.func_78784_a(0, 28).func_228303_a_(-1.5f, 2.5f, -1.5f, 3.0f, 16.0f, 3.0f, 0.0f, false);
        this.StringBone4A = new ModelRenderer(64, 64, 0, 0);
        this.StringBone4A.func_78793_a(0.5f, 2.0f, 3.5f);
        topB.func_78792_a(this.StringBone4A);
        this.Pipe4L = new ModelRenderer(64, 64, 0, 0);
        this.Pipe4L.func_78793_a(0.0f, 5.5f, 0.0f);
        this.StringBone4A.func_78792_a(this.Pipe4L);
        this.Pipe4L.func_78784_a(12, 21).func_228303_a_(-1.5f, 4.5f, -1.5f, 3.0f, 14.0f, 3.0f, 0.0f, false);
    }

    public void render(CopperChimesTile tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        IVertexBuilder normal = COPPER.func_229311_a_(bufferIn, RenderType::func_228638_b_);
        BlockState blockstate = tileEntityIn.func_195044_w();
        BlockPos pos = tileEntityIn.func_174877_v();
        Direction flag3 = (Direction)blockstate.func_177229_b((Property)FACING);
        ChimesSettings animateoptioncheck = ChimesSettings.getInstance();
        float animated = 1.0f;
        float f = (float)tileEntityIn.ringingTicks + partialTicks;
        float f1 = (float)tileEntityIn.func_145831_w().func_82737_E() + partialTicks;
        float f3 = 1.0f;
        if ((float)tileEntityIn.velocityTicks <= 0.0f || (float)tileEntityIn.velocityTicks >= 2.0f) {
            f3 = (float)tileEntityIn.velocityTicks * 0.25f;
        }
        if ((float)tileEntityIn.velocityTicks >= 0.0f && (float)tileEntityIn.velocityTicks <= 2.0f) {
            if (blockstate.func_177229_b((Property)CHIMING) == Boolean.TRUE) {
                f3 = ((float)tileEntityIn.velocityTicks + partialTicks) * 0.25f;
            }
            if (blockstate.func_177229_b((Property)CHIMING) == Boolean.FALSE) {
                f3 = ((float)tileEntityIn.velocityTicks - partialTicks) * 0.25f;
            }
        }
        float s1 = 1.0f;
        if (tileEntityIn.silencingTicks <= 0 || tileEntityIn.silencingTicks >= 200) {
            s1 = 0.0f;
        }
        if (tileEntityIn.silencingTicks >= 0 && tileEntityIn.silencingTicks <= 200 && blockstate.func_177229_b((Property)CHIMING) == Boolean.FALSE) {
            s1 = (float)tileEntityIn.silencingTicks + partialTicks;
        }
        float f2 = MathHelper.func_76126_a((float)(f1 * 2.151f / (float)Math.PI)) * 0.048f;
        float f4 = MathHelper.func_76126_a((float)(f * 0.59f / (float)Math.PI)) / (5.0f + f / 2.9f);
        float f5 = MathHelper.func_76126_a((float)(f * 0.59f / (float)Math.PI)) / (10.0f + f / 2.9f);
        float f7 = (float)Math.sin(f1 * 0.1f) * 0.025f;
        float f8 = MathHelper.func_76126_a((float)(f1 * 0.8f / (float)Math.PI)) * 1.0f / 1.0f;
        float f9 = (float)Math.sin(f1 * 0.052f) * 0.25f;
        float f01 = (float)Math.sin(f1 * 0.05f) * 0.25f;
        float f91 = (float)(Math.sin(f1 * 0.02f) * (double)0.01f) * f3;
        float f11 = (float)Math.sin(f1 * 0.0f) * 0.25f;
        float f09 = (float)Math.sin(f1 * 0.08f) * 0.055f * f3;
        float f010 = (float)Math.sin(f1 * 0.095f) * 0.055f * f3;
        float f011 = (float)Math.sin(f1 * 0.09f) * 0.055f * f3;
        float f012 = (float)Math.sin(f1 * 0.08f) * 0.055f * f3;
        if (animateoptioncheck.currentAnimated() == Animated.ANIMATED) {
            if (flag3 == Direction.EAST || flag3 == Direction.WEST) {
                // empty if block
            }
            if (tileEntityIn.isSwinging) {
                f91 = f4 * 0.45f;
                f09 = f5 * 0.45f;
                f010 = f5 * 0.45f;
                f011 = f5 * 0.45f;
                f012 = f5 * 0.45f;
            }
            this.StringBone1.field_78796_g = -f9;
            this.StringBone1A.field_78796_g = -f9;
            this.StringBone4.field_78796_g = f01;
            this.StringBone2A.field_78796_g = f01;
            this.StringBone3.field_78796_g = f9;
            this.StringBone3A.field_78796_g = f9;
            this.StringBone2.field_78796_g = f01;
            this.StringBone4A.field_78796_g = f01;
            this.Pipe2U.field_78795_f = f91;
            this.Pipe4U.field_78795_f = f91;
            this.Pipe2L.field_78795_f = f91;
            this.Pipe4L.field_78795_f = f91;
            this.Pipe1U.field_78808_h = f91;
            this.Pipe3U.field_78808_h = f91;
            this.Pipe1L.field_78808_h = f91;
            this.Pipe3L.field_78808_h = f91;
            this.StringBone1.field_78795_f = f09;
            this.StringBone2.field_78795_f = f010;
            this.StringBone3.field_78795_f = f011;
            this.StringBone4.field_78795_f = f012;
            this.StringBone1A.field_78795_f = f09;
            this.StringBone4A.field_78795_f = f010;
            this.StringBone3A.field_78795_f = f011;
            this.StringBone2A.field_78795_f = f012;
            this.StringBone1.field_78808_h = 0.0f;
            this.StringBone2.field_78808_h = 0.0f;
            this.StringBone3.field_78808_h = 0.0f;
            this.StringBone4.field_78808_h = 0.0f;
            this.StringBone1A.field_78808_h = 0.0f;
            this.StringBone4A.field_78808_h = 0.0f;
            this.StringBone3A.field_78808_h = 0.0f;
            this.StringBone2A.field_78808_h = 0.0f;
        }
        this.CopperUpper.field_78808_h = (float)Math.PI;
        this.CopperLower.field_78808_h = (float)Math.PI;
        this.CopperUpper.func_78793_a(8.0f, 16.0f, 8.0f);
        this.CopperLower.func_78793_a(8.0f, 32.0f, 8.0f);
        if (flag3 == Direction.NORTH) {
            this.CopperUpper.field_78796_g = (float)Math.PI;
            this.CopperLower.field_78796_g = (float)Math.PI;
        }
        if (flag3 == Direction.EAST) {
            this.CopperUpper.field_78796_g = 4.712389f;
            this.CopperLower.field_78796_g = 4.712389f;
        }
        if (flag3 == Direction.SOUTH) {
            this.CopperUpper.field_78796_g = (float)Math.PI * 2;
            this.CopperLower.field_78796_g = (float)Math.PI * 2;
        }
        if (flag3 == Direction.WEST) {
            this.CopperUpper.field_78796_g = 7.853982f;
            this.CopperLower.field_78796_g = 7.853982f;
        }
        if (tileEntityIn.func_195044_w().func_177229_b(HALF) == DoubleBlockHalf.UPPER) {
            this.CopperUpper.func_228308_a_(matrixStackIn, normal, combinedLightIn, combinedOverlayIn);
        }
        if (tileEntityIn.func_195044_w().func_177229_b(HALF) == DoubleBlockHalf.LOWER) {
            this.CopperLower.func_228308_a_(matrixStackIn, normal, combinedLightIn, combinedOverlayIn);
        }
    }

    public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }
}

