/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.commands.client;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.keksuccino.fancymenu.commands.client.ClientExecutor;
import de.keksuccino.fancymenu.commands.client.CommandUtils;
import de.keksuccino.fancymenu.menu.variables.VariableHandler;
import de.keksuccino.fancymenu.networking.PacketHandler;
import de.keksuccino.fancymenu.networking.packets.command.commands.variable.VariableCommandSuggestionsPacketMessage;
import de.keksuccino.konkrete.localization.Locals;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class VariableCommand {
    protected static Screen lastScreen = null;
    protected static boolean initialized = false;

    public static void register(CommandDispatcher<CommandSource> d) {
        if (!initialized) {
            MinecraftForge.EVENT_BUS.register((Object)new VariableCommand());
            initialized = true;
        }
        d.register((LiteralArgumentBuilder)Commands.func_197057_a((String)"fmvariable").then(Commands.func_197056_a((String)"action", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> CommandUtils.getStringSuggestions(builder, "get", "set")).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"variable_name", (ArgumentType)StringArgumentType.string()).executes(stack -> VariableCommand.getVariable((CommandSource)stack.getSource(), StringArgumentType.getString((CommandContext)stack, (String)"action"), StringArgumentType.getString((CommandContext)stack, (String)"variable_name")))).suggests((context, builder) -> CommandUtils.getStringSuggestions(builder, VariableCommand.getVariableNameSuggestions())).then(Commands.func_197056_a((String)"set_to_value", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            if (StringArgumentType.getString((CommandContext)context, (String)"action").equalsIgnoreCase("set")) {
                return CommandUtils.getStringSuggestions(builder, "<set_to_value>");
            }
            return CommandUtils.getStringSuggestions(builder, new String[0]);
        }).then(Commands.func_197056_a((String)"send_chat_feedback", (ArgumentType)BoolArgumentType.bool()).executes(stack -> VariableCommand.setVariable((CommandSource)stack.getSource(), StringArgumentType.getString((CommandContext)stack, (String)"action"), StringArgumentType.getString((CommandContext)stack, (String)"variable_name"), StringArgumentType.getString((CommandContext)stack, (String)"set_to_value"), BoolArgumentType.getBool((CommandContext)stack, (String)"send_chat_feedback"))))))));
    }

    private static String[] getVariableNameSuggestions() {
        List<String> l = VariableHandler.getVariableNames();
        if (l.isEmpty()) {
            l.add("<no_variables_found>");
        }
        return l.toArray(new String[0]);
    }

    private static int getVariable(CommandSource stack, String getOrSet, String variableName) {
        ClientExecutor.execute(() -> {
            try {
                if (getOrSet.equalsIgnoreCase("get")) {
                    String s = VariableHandler.getVariable(variableName);
                    if (s != null) {
                        stack.func_197030_a((ITextComponent)new StringTextComponent(Locals.localize((String)"fancymenu.commands.variable.get.success", (String[])new String[]{s})), false);
                    } else {
                        stack.func_197021_a((ITextComponent)new StringTextComponent(Locals.localize((String)"fancymenu.commands.variable.not_found", (String[])new String[0])));
                    }
                }
            }
            catch (Exception e) {
                stack.func_197021_a((ITextComponent)new StringTextComponent("Error while executing command!"));
                e.printStackTrace();
            }
        });
        return 1;
    }

    private static int setVariable(CommandSource stack, String getOrSet, String variableName, String setToValue, boolean sendFeedback) {
        ClientExecutor.execute(() -> {
            try {
                if (getOrSet.equalsIgnoreCase("set")) {
                    VariableHandler.setVariable(variableName, setToValue);
                    if (sendFeedback) {
                        stack.func_197030_a((ITextComponent)new StringTextComponent(Locals.localize((String)"fancymenu.commands.variable.set.success", (String[])new String[]{setToValue})), false);
                    }
                }
            }
            catch (Exception e) {
                stack.func_197021_a((ITextComponent)new StringTextComponent("Error while executing command!"));
                e.printStackTrace();
            }
        });
        return 1;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent e) {
        Screen s = Minecraft.func_71410_x().field_71462_r;
        if (s instanceof ChatScreen && (lastScreen == null || lastScreen != s)) {
            VariableCommandSuggestionsPacketMessage msg = new VariableCommandSuggestionsPacketMessage();
            msg.direction = "server";
            msg.variableNameSuggestions.addAll(Arrays.asList(VariableCommand.getVariableNameSuggestions()));
            PacketHandler.sendToServer(msg);
        }
        lastScreen = s;
    }
}

