/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.mainwindow;

import de.keksuccino.fancymenu.FancyMenu;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;

public class MainWindowHandler {
    private static String windowtitle = null;
    private static File icondir = new File(FancyMenu.MOD_DIR, "/minecraftwindow/icons");

    public static void init() {
        if (!icondir.exists()) {
            icondir.mkdirs();
        }
    }

    public static void handleForceFullscreen() {
        try {
            if (Minecraft.func_71410_x() != null && Minecraft.func_71410_x().func_228018_at_() != null) {
                if (((Boolean)FancyMenu.config.getOrDefault("forcefullscreen", (Object)false)).booleanValue() && !Minecraft.func_71410_x().func_228018_at_().func_198113_j()) {
                    Minecraft.func_71410_x().func_228018_at_().func_198077_g();
                    FancyMenu.LOGGER.info("[FANCYMENU] Forced window to fullscreen!");
                }
            } else {
                FancyMenu.LOGGER.error("[FANCYMENU] Force fullscreen failed! Instance or window was NULL!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateWindowIcon() {
        if (((Boolean)FancyMenu.config.getOrDefault("customwindowicon", (Object)false)).booleanValue()) {
            try {
                File i16 = new File(icondir.getPath() + "/icon16x16.png");
                File i32 = new File(icondir.getPath() + "/icon32x32.png");
                if (!i16.exists() || !i32.exists()) {
                    System.out.println("## ERROR ## [FANCYMENU] Unable to set custom icons: 'icon16x16.png' or 'icon32x32.png' missing!");
                    return;
                }
                BufferedImage i16buff = ImageIO.read(i16);
                if (i16buff.getHeight() != 16 || i16buff.getWidth() != 16) {
                    System.out.println("'## ERROR ## [FANCYMENU] Unable to set custom icons: 'icon16x16.png' not 16x16!");
                    return;
                }
                BufferedImage i32buff = ImageIO.read(i32);
                if (i32buff.getHeight() != 32 || i32buff.getWidth() != 32) {
                    System.out.println("'## ERROR ## [FANCYMENU] Unable to set custom icons: 'icon32x32.png' not 32x32!");
                    return;
                }
                FileInputStream icon16 = new FileInputStream(i16);
                FileInputStream icon32 = new FileInputStream(i32);
                Minecraft.func_71410_x().func_228018_at_().func_216529_a((InputStream)icon16, (InputStream)icon32);
                System.out.println("[FANCYMENU] Custom minecraft icon successfully loaded!");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void updateWindowTitle() {
        String s = (String)FancyMenu.config.getOrDefault("customwindowtitle", (Object)"");
        if (s != null && !s.equals("")) {
            windowtitle = s;
            MainWindowHandler.setWindowTitle();
        } else {
            windowtitle = null;
        }
    }

    private static void setWindowTitle() {
        if (windowtitle != null) {
            Minecraft.func_71410_x().func_228018_at_().func_230148_b_(windowtitle);
        }
    }

    public static String getCustomWindowTitle() {
        return windowtitle;
    }

    public static int getWindowGuiWidth() {
        Screen s = Minecraft.func_71410_x().field_71462_r;
        if (s != null) {
            double mcScale = Minecraft.func_71410_x().func_228018_at_().func_216521_a((int)Minecraft.func_71410_x().func_228018_at_().func_198100_s(), Minecraft.func_71410_x().field_71474_y.field_211842_aO);
            float baseUIScale = 1.0f;
            float sc = (float)((double)baseUIScale * ((double)baseUIScale / mcScale));
            return (int)((float)s.field_230708_k_ / sc);
        }
        return 0;
    }

    public static int getWindowGuiHeight() {
        Screen s = Minecraft.func_71410_x().field_71462_r;
        if (s != null) {
            double mcScale = Minecraft.func_71410_x().func_228018_at_().func_216521_a((int)Minecraft.func_71410_x().func_228018_at_().func_198100_s(), Minecraft.func_71410_x().field_71474_y.field_211842_aO);
            float baseUIScale = 1.0f;
            float sc = (float)((double)baseUIScale * ((double)baseUIScale / mcScale));
            return (int)((float)s.field_230709_l_ / sc);
        }
        return 0;
    }
}

