/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.animation;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.konkrete.rendering.animation.IAnimationRenderer;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IngameGui;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.resources.IResource;
import net.minecraft.util.ResourceLocation;

public class ResourcePackAnimationRenderer
implements IAnimationRenderer {
    protected String resourceNamespace;
    protected List<String> frameNames;
    protected int fps;
    protected boolean loop;
    protected int width;
    protected int height;
    protected int x;
    protected int y;
    public List<ResourceLocation> resources = new ArrayList<ResourceLocation>();
    protected boolean stretch = false;
    protected boolean hide = false;
    protected volatile boolean done = false;
    private int frame = 0;
    private long prevTime = 0L;
    protected float opacity = 1.0f;
    private boolean ready = false;
    protected boolean sizeSet = false;

    public ResourcePackAnimationRenderer(String resourceNamespace, List<String> frameNames, int fps, boolean loop, int posX, int posY, int width, int height) {
        this.fps = fps;
        this.loop = loop;
        this.x = posX;
        this.y = posY;
        this.width = width;
        this.height = height;
        this.resourceNamespace = resourceNamespace;
        this.frameNames = frameNames;
        this.loadAnimationFrames();
    }

    private void loadAnimationFrames() {
        try {
            for (String s : this.frameNames) {
                ResourceLocation r = this.resourceNamespace == null ? new ResourceLocation(s) : new ResourceLocation(this.resourceNamespace, s);
                this.resources.add(r);
            }
            this.ready = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void render(MatrixStack matrix) {
        if (this.resources == null || this.resources.isEmpty()) {
            return;
        }
        if (this.fps < 0) {
            this.fps = -1;
        }
        if (this.frame > this.resources.size() - 1) {
            if (this.loop) {
                this.resetAnimation();
            } else {
                this.done = true;
                if (!this.hide) {
                    this.frame = this.resources.size() - 1;
                } else {
                    return;
                }
            }
        }
        this.renderFrame(matrix);
        long time = System.currentTimeMillis();
        if (this.fps == -1) {
            this.updateFrame(time);
        } else if (this.prevTime + (long)(1000 / this.fps) <= time) {
            this.updateFrame(time);
        }
    }

    protected void renderFrame(MatrixStack matrix) {
        int h = this.height;
        int w = this.width;
        int x2 = this.x;
        int y2 = this.y;
        if (this.stretch) {
            h = Minecraft.func_71410_x().field_71462_r.field_230709_l_;
            w = Minecraft.func_71410_x().field_71462_r.field_230708_k_;
            x2 = 0;
            y2 = 0;
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.resources.get(this.frame));
        RenderSystem.enableBlend();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.opacity);
        IngameGui.func_238463_a_((MatrixStack)matrix, (int)x2, (int)y2, (float)0.0f, (float)0.0f, (int)w, (int)h, (int)w, (int)h);
        RenderSystem.disableBlend();
    }

    public void setOpacity(float opacity) {
        this.opacity = opacity;
    }

    private void updateFrame(long time) {
        ++this.frame;
        this.prevTime = time;
    }

    public void resetAnimation() {
        this.frame = 0;
        this.prevTime = 0L;
        this.done = false;
    }

    public void setStretchImageToScreensize(boolean b) {
        this.stretch = b;
    }

    public void setHideAfterLastFrame(boolean b) {
        this.hide = b;
    }

    public boolean isFinished() {
        return this.done;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int currentFrame() {
        return this.frame;
    }

    public boolean isReady() {
        return this.ready;
    }

    public void setPosX(int x) {
        this.x = x;
    }

    public void setPosY(int y) {
        this.y = y;
    }

    public int animationFrames() {
        return this.resources.size();
    }

    public List<ResourceLocation> getAnimationFrames() {
        return this.resources;
    }

    public String getPath() {
        return this.resourceNamespace;
    }

    public void setFPS(int fps) {
        this.fps = fps;
    }

    public int getFPS() {
        return this.fps;
    }

    public void setLooped(boolean b) {
        this.loop = b;
    }

    public void prepareAnimation() {
    }

    public boolean isGettingLooped() {
        return this.loop;
    }

    public boolean isStretchedToStreensize() {
        return this.stretch;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getPosX() {
        return this.x;
    }

    public int getPosY() {
        return this.y;
    }

    public boolean setupAnimationSize() {
        if (this.sizeSet) {
            return true;
        }
        try {
            List<ResourceLocation> l = this.getAnimationFrames();
            if (!l.isEmpty()) {
                InputStream in;
                ResourceLocation r = l.get(0);
                IResource res = Minecraft.func_71410_x().func_195551_G().func_199002_a(r);
                if (res != null && (in = res.func_199027_b()) != null) {
                    NativeImage i = NativeImage.func_195713_a((InputStream)in);
                    this.width = i.func_195702_a();
                    this.height = i.func_195714_b();
                    System.out.println("[FANCYMENU] Successfully updated width and height for resource pack animation: " + this.resourceNamespace);
                    this.sizeSet = true;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.err.println("[FANCYMENU] ERROR: Failed to update width and height for resource pack animation: " + this.resourceNamespace);
        return false;
    }
}

