/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.item;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.menu.fancy.item.CustomizationItemBase;
import de.keksuccino.fancymenu.menu.placeholder.v2.PlaceholderParser;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.math.MathHelper;

public class StringCustomizationItem
extends CustomizationItemBase {
    public float scale = 1.0f;
    public boolean shadow = false;
    public CustomizationItemBase.Alignment alignment = CustomizationItemBase.Alignment.LEFT;
    public String valueRaw;

    public StringCustomizationItem(PropertiesSection item) {
        super(item);
        if (this.action != null && this.action.equalsIgnoreCase("addtext")) {
            String al;
            String sc;
            this.valueRaw = item.getEntryValue("value");
            this.updateValue();
            String sh = item.getEntryValue("shadow");
            if (sh != null && sh.equalsIgnoreCase("true")) {
                this.shadow = true;
            }
            if ((sc = item.getEntryValue("scale")) != null && MathUtils.isFloat((String)sc)) {
                this.scale = Float.parseFloat(sc);
            }
            if ((al = item.getEntryValue("alignment")) != null) {
                if (al.equalsIgnoreCase("right")) {
                    this.alignment = CustomizationItemBase.Alignment.RIGHT;
                }
                if (al.equalsIgnoreCase("centered")) {
                    this.alignment = CustomizationItemBase.Alignment.CENTERED;
                }
            }
        }
    }

    protected void updateValue() {
        if (this.valueRaw != null) {
            this.value = !StringCustomizationItem.isEditorActive() ? PlaceholderParser.replacePlaceholders(this.valueRaw) : StringUtils.convertFormatCodes((String)this.valueRaw, (String)"&", (String)"\u00a7");
        }
        this.setWidth((int)((float)Minecraft.func_71410_x().field_71466_p.func_78256_a(this.value) * this.scale));
        Minecraft.func_71410_x().field_71466_p.getClass();
        this.setHeight((int)(9.0f * this.scale));
    }

    @Override
    public void render(MatrixStack matrix, Screen menu) throws IOException {
        if (!this.shouldRender()) {
            return;
        }
        this.updateValue();
        int x = this.getPosX(menu);
        int y = this.getPosY(menu);
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        RenderSystem.enableBlend();
        matrix.func_227860_a_();
        matrix.func_227862_a_(this.scale, this.scale, this.scale);
        if (this.shadow) {
            font.func_238405_a_(matrix, "\u00a7f" + this.value, (float)x, (float)y, 0 | MathHelper.func_76123_f((float)(this.opacity * 255.0f)) << 24);
        } else {
            font.func_238421_b_(matrix, "\u00a7f" + this.value, (float)x, (float)y, 0 | MathHelper.func_76123_f((float)(this.opacity * 255.0f)) << 24);
        }
        matrix.func_227865_b_();
        RenderSystem.disableBlend();
    }

    @Override
    public int getPosX(Screen menu) {
        int x = super.getPosX(menu);
        if (this.value != null) {
            if (this.alignment == CustomizationItemBase.Alignment.CENTERED) {
                x -= (int)((float)(Minecraft.func_71410_x().field_71466_p.func_78256_a(this.value) / 2) * this.scale);
            } else if (this.alignment == CustomizationItemBase.Alignment.RIGHT) {
                x -= (int)((float)Minecraft.func_71410_x().field_71466_p.func_78256_a(this.value) * this.scale);
            }
        }
        x = (int)((float)x / this.scale);
        return x;
    }

    @Override
    public int getPosY(Screen menu) {
        return (int)((float)super.getPosY(menu) / this.scale);
    }
}

