/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.menuhandler.deepcustomizationlayer.layers.titlescreen.splash;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.deepcustomizationlayer.DeepCustomizationElement;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.deepcustomizationlayer.DeepCustomizationItem;
import de.keksuccino.konkrete.file.FileUtils;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class TitleScreenSplashItem
extends DeepCustomizationItem {
    public static String cachedSplashText;
    public String splashTextFilePath;
    public int splashRotation = -20;
    public Color splashColor = new Color(255, 255, 0);
    public String splashColorHEX = "#ffff00";
    protected int lastSplashPosX = 0;
    protected int lastSplashPosY = 0;

    public TitleScreenSplashItem(DeepCustomizationElement parentElement, PropertiesSection item) {
        super(parentElement, item);
        Color c;
        String splashCol;
        this.splashTextFilePath = item.getEntryValue("splash_file_path");
        String splashRot = item.getEntryValue("splash_rotation");
        if (splashRot != null && MathUtils.isInteger((String)splashRot)) {
            this.splashRotation = Integer.parseInt(splashRot);
        }
        if ((splashCol = item.getEntryValue("splash_color")) != null && (c = RenderUtils.getColorFromHexString((String)splashCol)) != null) {
            this.splashColor = c;
            this.splashColorHEX = splashCol;
        }
    }

    @Override
    public int getPosX(Screen menu) {
        return this.lastSplashPosX - this.getWidth() / 2;
    }

    @Override
    public int getPosY(Screen menu) {
        return this.lastSplashPosY - this.getHeight() / 2;
    }

    @Override
    public void render(MatrixStack matrix, Screen menu) throws IOException {
        this.setWidth(60);
        this.setHeight(30);
        if (!this.hidden) {
            RenderSystem.enableBlend();
            this.renderSplash(matrix, Minecraft.func_71410_x().field_71466_p, menu);
        }
    }

    protected void renderSplash(MatrixStack matrix, FontRenderer font, Screen s) {
        float finalPosX = s.field_230708_k_ / 2 + 90;
        float finalPosY = 70.0f;
        int originX = 0;
        int originY = 0;
        if (this.orientation.equalsIgnoreCase("original")) {
            originX = (int)finalPosX;
            originY = (int)finalPosY;
        } else if (!this.orientation.equalsIgnoreCase("top-left")) {
            if (this.orientation.equalsIgnoreCase("mid-left")) {
                originY = s.field_230709_l_ / 2;
            } else if (this.orientation.equalsIgnoreCase("bottom-left")) {
                originY = s.field_230709_l_;
            } else if (this.orientation.equalsIgnoreCase("top-centered")) {
                originX = s.field_230708_k_ / 2;
            } else if (this.orientation.equalsIgnoreCase("mid-centered")) {
                originX = s.field_230708_k_ / 2;
                originY = s.field_230709_l_ / 2;
            } else if (this.orientation.equalsIgnoreCase("bottom-centered")) {
                originX = s.field_230708_k_ / 2;
                originY = s.field_230709_l_;
            } else if (this.orientation.equalsIgnoreCase("top-right")) {
                originX = s.field_230708_k_;
            } else if (this.orientation.equalsIgnoreCase("mid-right")) {
                originX = s.field_230708_k_;
                originY = s.field_230709_l_ / 2;
            } else if (this.orientation.equalsIgnoreCase("bottom-right")) {
                originX = s.field_230708_k_;
                originY = s.field_230709_l_;
            }
        }
        finalPosX = originX + this.posX;
        finalPosY = originY + this.posY;
        this.lastSplashPosX = (int)finalPosX;
        this.lastSplashPosY = (int)finalPosY;
        if (cachedSplashText == null) {
            cachedSplashText = this.getRandomSplashText();
        }
        if (cachedSplashText == null) {
            cachedSplashText = "\u00a7c< ERROR! UNABLE TO GET SPLASH TEXT! >";
        }
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)finalPosX, (float)finalPosY, (float)0.0f);
        RenderSystem.rotatef((float)this.splashRotation, (float)0.0f, (float)0.0f, (float)1.0f);
        float f = 1.8f - MathHelper.func_76135_e((float)(MathHelper.func_76126_a((float)((float)(Util.func_211177_b() % 1000L) / 1000.0f * ((float)Math.PI * 2))) * 0.1f));
        f = f * 100.0f / (float)(font.func_78256_a(cachedSplashText) + 32);
        RenderSystem.scalef((float)f, (float)f, (float)f);
        TitleScreenSplashItem.func_238472_a_((MatrixStack)matrix, (FontRenderer)font, (ITextComponent)new StringTextComponent(cachedSplashText), (int)0, (int)-8, (int)this.splashColor.getRGB());
        RenderSystem.popMatrix();
    }

    public String getRandomSplashText() {
        List l;
        File f;
        if (this.splashTextFilePath != null && !this.splashTextFilePath.replace(" ", "").equals("") && (f = new File(this.splashTextFilePath)).exists() && f.isFile() && f.getPath().toLowerCase().endsWith(".txt") && (l = FileUtils.getFileLines((File)f)) != null && !l.isEmpty()) {
            int random = MathUtils.getRandomNumberInRange((int)0, (int)(l.size() - 1));
            return (String)l.get(random);
        }
        return Minecraft.func_71410_x().func_213269_at().func_215276_a();
    }
}

