/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.loadingrequirement.v2.requirements;

import de.keksuccino.fancymenu.menu.fancy.helper.ui.texteditor.TextEditorFormattingRule;
import de.keksuccino.fancymenu.menu.loadingrequirement.v2.LoadingRequirement;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import de.keksuccino.konkrete.math.MathUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IsNumberRequirement
extends LoadingRequirement {
    private static final Logger LOGGER = LogManager.getLogger();

    public IsNumberRequirement() {
        super("fancymenu_visibility_requirement_is_number");
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isRequirementMet(String value) {
        if (value != null) {
            List<String> secStrings = IsNumberRequirement.getSections(value);
            if (secStrings.isEmpty()) {
                return false;
            }
            boolean b = true;
            for (String s : secStrings) {
                if (IsNumberRequirement.isSectionMet(IsNumberRequirement.parseSection(s))) continue;
                b = false;
            }
            return b;
        }
        return false;
    }

    private static boolean isSectionMet(List<String> section) {
        if (!section.isEmpty()) {
            String mode = section.get(0);
            String number = section.get(1);
            String compareWith = section.get(2);
            if (MathUtils.isDouble((String)number) && MathUtils.isDouble((String)compareWith)) {
                double num = Double.parseDouble(number);
                double comp = Double.parseDouble(compareWith);
                if (mode.equals("equals")) {
                    return num == comp;
                }
                if (mode.equals("bigger-than")) {
                    return num > comp;
                }
                if (mode.equals("smaller-than")) {
                    return num < comp;
                }
                if (mode.equals("bigger-than-or-equals")) {
                    return num >= comp;
                }
                if (mode.equals("smaller-than-or-equals")) {
                    return num <= comp;
                }
            }
        }
        return false;
    }

    private static List<String> parseSection(String section) {
        ArrayList<String> l = new ArrayList<String>();
        int currentIndex = 0;
        int currentStartIndex = 0;
        String mode = null;
        String number = null;
        String compareWith = null;
        for (char c : section.toCharArray()) {
            String s = String.valueOf(c);
            if (s.equals("\"")) {
                if (currentIndex >= 7 && section.substring(currentIndex - 7).startsWith("\"mode\":\"")) {
                    currentStartIndex = currentIndex + 1;
                }
                if (section.substring(currentIndex).startsWith("\",\"number\":\"")) {
                    mode = section.substring(currentStartIndex, currentIndex);
                }
                if (currentIndex >= 9 && section.substring(currentIndex - 9).startsWith("\"number\":\"")) {
                    currentStartIndex = currentIndex + 1;
                }
                if (section.substring(currentIndex).startsWith("\",\"compare_with\":\"")) {
                    number = section.substring(currentStartIndex, currentIndex);
                }
                if (currentIndex >= 15 && section.substring(currentIndex - 15).startsWith("\"compare_with\":\"")) {
                    currentStartIndex = currentIndex + 1;
                }
                if (section.substring(currentIndex).startsWith("\"]$")) {
                    compareWith = section.substring(currentStartIndex, currentIndex);
                }
            }
            ++currentIndex;
        }
        if (mode != null && number != null && compareWith != null) {
            l.add(mode);
            l.add(number);
            l.add(compareWith);
        }
        return l;
    }

    private static List<String> getSections(String value) {
        ArrayList<String> l = new ArrayList<String>();
        int currentIndex = 0;
        int currentStartIndex = 0;
        for (char c : value.toCharArray()) {
            String s = String.valueOf(c);
            if (s.equals("[") && value.substring(currentIndex).startsWith("[\"mode\":\"")) {
                currentStartIndex = currentIndex;
            }
            if (currentIndex >= 1 && s.equals("]") && value.substring(currentIndex - 1).startsWith("\"]$")) {
                l.add(value.substring(currentStartIndex, currentIndex + 2));
            }
            ++currentIndex;
        }
        return l;
    }

    @Override
    public String getDisplayName() {
        return Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.is_number", (String[])new String[0]);
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.is_number.desc", (String[])new String[0]), (String)"%n%"));
    }

    @Override
    public String getCategory() {
        return null;
    }

    @Override
    public String getValueDisplayName() {
        return Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.is_number.valuename", (String[])new String[0]);
    }

    @Override
    public String getValuePreset() {
        return "[\"mode\":\"...\",\"number\":\"...\",\"compare_with\":\"...\"]$";
    }

    @Override
    public List<TextEditorFormattingRule> getValueFormattingRules() {
        return null;
    }
}

