/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.placeholder.v2.placeholders.client;

import de.keksuccino.fancymenu.menu.placeholder.v2.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.menu.placeholder.v2.Placeholder;
import de.keksuccino.konkrete.Konkrete;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.ModList;

public class TotalModsPlaceholder
extends Placeholder {
    private static final File MOD_DIRECTORY = new File(Minecraft.func_71410_x().field_71412_D, "mods");
    private static int cachedTotalMods = -10;

    public TotalModsPlaceholder() {
        super("totalmods");
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        int loaded = TotalModsPlaceholder.getLoadedMods();
        int total = TotalModsPlaceholder.getTotalMods();
        if (total < loaded) {
            total = loaded;
        }
        return "" + total;
    }

    private static int getLoadedMods() {
        try {
            int i = 0;
            if (Konkrete.isOptifineLoaded) {
                ++i;
            }
            return ModList.get().getMods().size() + i;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    private static int getTotalMods() {
        if (cachedTotalMods == -10) {
            if (MOD_DIRECTORY.exists()) {
                int i = 0;
                for (File f : MOD_DIRECTORY.listFiles()) {
                    if (!f.isFile() || !f.getName().toLowerCase().endsWith(".jar")) continue;
                    ++i;
                }
                cachedTotalMods = i + 2;
            } else {
                cachedTotalMods = -1;
            }
        }
        return cachedTotalMods;
    }

    @Override
    public List<String> getValueNames() {
        return null;
    }

    @Override
    public String getDisplayName() {
        return Locals.localize((String)"helper.ui.dynamicvariabletextfield.variables.totalmods", (String[])new String[0]);
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList(StringUtils.splitLines((String)Locals.localize((String)"helper.ui.dynamicvariabletextfield.variables.totalmods.desc", (String[])new String[0]), (String)"%n%"));
    }

    @Override
    public String getCategory() {
        return Locals.localize((String)"fancymenu.helper.ui.dynamicvariabletextfield.categories.client", (String[])new String[0]);
    }

    @Override
    @Nonnull
    public DeserializedPlaceholderString getDefaultPlaceholderString() {
        DeserializedPlaceholderString dps = new DeserializedPlaceholderString();
        dps.placeholder = this.getIdentifier();
        return dps;
    }
}

