/*
 * Decompiled with CFR 0.152.
 */
package com.grimbo.chipped;

import com.grimbo.chipped.block.ChippedBlockTypes;
import com.grimbo.chipped.block.ChippedBlocks;
import com.grimbo.chipped.container.ChippedContainerType;
import com.grimbo.chipped.container.ChippedScreen;
import com.grimbo.chipped.item.ChippedItems;
import com.grimbo.chipped.recipe.ChippedSerializer;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.GlassBlock;
import net.minecraft.block.StainedGlassBlock;
import net.minecraft.block.VineBlock;
import net.minecraft.block.WebBlock;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShearsItem;
import net.minecraft.item.SwordItem;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.jetbrains.annotations.NotNull;

@Mod(value="chipped")
public class Chipped {
    public static final String MOD_ID = "chipped";
    public static final ItemGroup CHIPPED = new ItemGroup("chippedTab"){

        @NotNull
        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)ChippedBlocks.BOTANIST_WORKBENCH.get());
        }
    }.func_199783_b("chipped_tab");

    public Chipped() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ChippedBlocks.BLOCKS.register(eventBus);
        ChippedBlocks.register();
        ChippedItems.ITEMS.register(eventBus);
        ChippedSerializer.SERIALIZER.register(eventBus);
        ChippedContainerType.CONTAINER.register(eventBus);
        eventBus.addListener(this::clientRender);
        eventBus.addListener(this::onClientSetupEvent);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void checkHarvest(PlayerEvent.HarvestCheck event) {
        Item held = event.getPlayer().func_184614_ca().func_77973_b();
        if ((held instanceof SwordItem || held instanceof ShearsItem) && event.getTargetBlock().func_177230_c() instanceof WebBlock) {
            event.setCanHarvest(true);
        }
    }

    @SubscribeEvent
    public void clientRender(FMLClientSetupEvent event) {
        RenderTypeLookup.setRenderLayer((Block)((Block)ChippedBlocks.BOTANIST_WORKBENCH.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ChippedBlocks.LOOM_TABLE.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ChippedBlocks.ALCHEMY_BENCH.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ChippedBlocks.MECHANIST_WORKBENCH.get()), (RenderType)RenderType.func_228643_e_());
        for (RegistryObject<GlassBlock> registryObject : ChippedBlockTypes.GLASSES) {
            RenderTypeLookup.setRenderLayer((Block)((Block)registryObject.get()), (RenderType)RenderType.func_228643_e_());
        }
        for (RegistryObject<GlassBlock> registryObject : ChippedBlockTypes.GLASS_PANES) {
            RenderTypeLookup.setRenderLayer((Block)((Block)registryObject.get()), (RenderType)RenderType.func_228643_e_());
        }
        for (int id = 0; id < 16; ++id) {
            DyeColor dyeColor = DyeColor.func_196056_a((int)id);
            for (RegistryObject<StainedGlassBlock> registryObject : ChippedBlockTypes.STAINED_GLASSES.get(dyeColor)) {
                RenderTypeLookup.setRenderLayer((Block)((Block)registryObject.get()), (RenderType)RenderType.func_228645_f_());
            }
            for (RegistryObject<StainedGlassBlock> registryObject : ChippedBlockTypes.STAINED_GLASS_PANES.get(dyeColor)) {
                RenderTypeLookup.setRenderLayer((Block)((Block)registryObject.get()), (RenderType)RenderType.func_228645_f_());
            }
        }
        for (RegistryObject<VineBlock> registryObject : ChippedBlockTypes.VINES) {
            RenderTypeLookup.setRenderLayer((Block)((Block)registryObject.get()), (RenderType)RenderType.func_228643_e_());
        }
        for (RegistryObject<VineBlock> registryObject : ChippedBlockTypes.BROWN_MUSHROOMS) {
            RenderTypeLookup.setRenderLayer((Block)((Block)registryObject.get()), (RenderType)RenderType.func_228643_e_());
        }
        for (RegistryObject<VineBlock> registryObject : ChippedBlockTypes.RED_MUSHROOMS) {
            RenderTypeLookup.setRenderLayer((Block)((Block)registryObject.get()), (RenderType)RenderType.func_228643_e_());
        }
        for (RegistryObject<VineBlock> registryObject : ChippedBlockTypes.WARPED_FUNGUS) {
            RenderTypeLookup.setRenderLayer((Block)((Block)registryObject.get()), (RenderType)RenderType.func_228643_e_());
        }
        for (RegistryObject<VineBlock> registryObject : ChippedBlockTypes.CRIMSON_FUNGUS) {
            RenderTypeLookup.setRenderLayer((Block)((Block)registryObject.get()), (RenderType)RenderType.func_228643_e_());
        }
        for (RegistryObject<VineBlock> registryObject : ChippedBlockTypes.WARPED_ROOTS) {
            RenderTypeLookup.setRenderLayer((Block)((Block)registryObject.get()), (RenderType)RenderType.func_228643_e_());
        }
        for (RegistryObject<VineBlock> registryObject : ChippedBlockTypes.CRIMSON_ROOTS) {
            RenderTypeLookup.setRenderLayer((Block)((Block)registryObject.get()), (RenderType)RenderType.func_228643_e_());
        }
        for (RegistryObject<VineBlock> registryObject : ChippedBlockTypes.NETHER_SPROUTS) {
            RenderTypeLookup.setRenderLayer((Block)((Block)registryObject.get()), (RenderType)RenderType.func_228643_e_());
        }
        for (RegistryObject<VineBlock> registryObject : ChippedBlockTypes.LILY_PAD) {
            RenderTypeLookup.setRenderLayer((Block)((Block)registryObject.get()), (RenderType)RenderType.func_228643_e_());
        }
        for (RegistryObject<VineBlock> registryObject : ChippedBlockTypes.REDSTONE_TORCHES) {
            RenderTypeLookup.setRenderLayer((Block)((Block)registryObject.get()), (RenderType)RenderType.func_228643_e_());
        }
        for (RegistryObject<VineBlock> registryObject : ChippedBlocks.REDSTONE_WALL_TORCHES) {
            RenderTypeLookup.setRenderLayer((Block)((Block)registryObject.get()), (RenderType)RenderType.func_228643_e_());
        }
        for (RegistryObject<VineBlock> registryObject : ChippedBlockTypes.COBWEBS) {
            RenderTypeLookup.setRenderLayer((Block)((Block)registryObject.get()), (RenderType)RenderType.func_228643_e_());
        }
        for (RegistryObject<VineBlock> registryObject : ChippedBlockTypes.TORCHES) {
            RenderTypeLookup.setRenderLayer((Block)((Block)registryObject.get()), (RenderType)RenderType.func_228643_e_());
        }
        for (RegistryObject<VineBlock> registryObject : ChippedBlocks.WALL_TORCHES) {
            RenderTypeLookup.setRenderLayer((Block)((Block)registryObject.get()), (RenderType)RenderType.func_228643_e_());
        }
        for (RegistryObject<VineBlock> registryObject : ChippedBlockTypes.LANTERNS) {
            RenderTypeLookup.setRenderLayer((Block)((Block)registryObject.get()), (RenderType)RenderType.func_228643_e_());
        }
        for (RegistryObject<VineBlock> registryObject : ChippedBlockTypes.SOUL_LANTERNS) {
            RenderTypeLookup.setRenderLayer((Block)((Block)registryObject.get()), (RenderType)RenderType.func_228643_e_());
        }
    }

    @SubscribeEvent
    public void onClientSetupEvent(FMLClientSetupEvent event) {
        for (ContainerType container : ChippedContainerType.CONTAINER.getEntries().stream().map(RegistryObject::get).collect(Collectors.toList())) {
            ScreenManager.func_216911_a((ContainerType)container, ChippedScreen::new);
        }
    }

    public static int getTorchAngleFromDir(Direction direction) {
        switch (direction) {
            case WEST: {
                return 180;
            }
            case NORTH: {
                return 270;
            }
            case SOUTH: {
                return 90;
            }
        }
        return 0;
    }

    public static int getAngleFromDir(Direction direction) {
        switch (direction) {
            case WEST: {
                return 270;
            }
            case SOUTH: {
                return 180;
            }
            case EAST: {
                return 90;
            }
        }
        return 0;
    }
}

