/*
 * Decompiled with CFR 0.152.
 */
package com.grimbo.chipped.block;

import com.grimbo.chipped.Chipped;
import com.grimbo.chipped.api.BenchType;
import com.grimbo.chipped.api.BlockRegistry;
import com.grimbo.chipped.api.ChippedBlockType;
import com.grimbo.chipped.api.ChippedWoodType;
import com.grimbo.chipped.block.ChippedBlockTypes;
import com.grimbo.chipped.block.ChippedLantern;
import com.grimbo.chipped.block.ChippedWorkbench;
import com.grimbo.chipped.container.ChippedContainer;
import com.grimbo.chipped.container.ChippedContainerType;
import com.grimbo.chipped.item.ChippedItems;
import com.grimbo.chipped.recipe.ChippedSerializer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CarpetBlock;
import net.minecraft.block.CarvedPumpkinBlock;
import net.minecraft.block.CryingObsidianBlock;
import net.minecraft.block.GlassBlock;
import net.minecraft.block.HayBlock;
import net.minecraft.block.HugeMushroomBlock;
import net.minecraft.block.LanternBlock;
import net.minecraft.block.LilyPadBlock;
import net.minecraft.block.MelonBlock;
import net.minecraft.block.MushroomBlock;
import net.minecraft.block.NetherRootsBlock;
import net.minecraft.block.NetherSproutsBlock;
import net.minecraft.block.PaneBlock;
import net.minecraft.block.PumpkinBlock;
import net.minecraft.block.RedstoneLampBlock;
import net.minecraft.block.RedstoneTorchBlock;
import net.minecraft.block.RedstoneWallTorchBlock;
import net.minecraft.block.SoulSandBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.StainedGlassBlock;
import net.minecraft.block.StainedGlassPaneBlock;
import net.minecraft.block.TorchBlock;
import net.minecraft.block.VineBlock;
import net.minecraft.block.WallTorchBlock;
import net.minecraft.block.WebBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.LilyPadItem;
import net.minecraft.item.WallOrFloorItem;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;

public class ChippedBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"chipped");
    private static final AbstractBlock.Properties LANTERN_PROPERTIES = AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_222432_lU);
    private static final AbstractBlock.IPositionPredicate ALWAYS_FALSE_POSITION = (state, world, position) -> false;
    private static final AbstractBlock.IExtendedPositionPredicate<EntityType<?>> VALID_SPAWN = (state, world, position, type) -> false;
    public static final List<RegistryObject<WallTorchBlock>> WALL_TORCHES = new ArrayList<RegistryObject<WallTorchBlock>>();
    public static final List<RegistryObject<RedstoneWallTorchBlock>> REDSTONE_WALL_TORCHES = new ArrayList<RegistryObject<RedstoneWallTorchBlock>>();
    public static final List<RegistryObject<CarvedPumpkinBlock>> SPECIAL_CARVED_PUMPKINS = new ArrayList<RegistryObject<CarvedPumpkinBlock>>();
    public static final List<RegistryObject<CarvedPumpkinBlock>> VANILLA_CARVED_PUMPKINS = new ArrayList<RegistryObject<CarvedPumpkinBlock>>();
    public static final List<ChippedBlockType<Block>> stones18 = Stream.of("granite", "diorite", "andesite", "prismarine", "dark_prismarine", "purpur_block", "quartz_block", "sandstone", "red_sandstone", "nether_bricks", "red_nether_bricks").map(ChippedBlockType::new).collect(Collectors.toList());
    public static final String[] specialPumpkinList = new String[]{"end", "end2", "nether"};
    public static final String[] carvedPumpkinList = new String[]{"happy", "angry", "bigeyes", "bighappy", "boo", "bruh", "classic", "enthusiastic", "grinning", "kawaii", "mourn", "owo", "plotting", "sans", "scared", "smallhappy", "squashy", "stretchy", "upsidedown"};
    public static final RegistryObject<Block> BOTANIST_WORKBENCH = ChippedBlocks.register("botanist_workbench", () -> new ChippedWorkbench((id, inv, pos) -> new ChippedContainer(id, inv, pos, (ContainerType<ChippedContainer>)((ContainerType)ChippedContainerType.BOTANIST_WORKBENCH.get()), ChippedSerializer.BOTANIST_WORKBENCH_TYPE, (Block)BOTANIST_WORKBENCH.get()), AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(2.5f).func_200947_a(SoundType.field_185848_a).func_226896_b_().func_235827_a_(VALID_SPAWN).func_235828_a_(ALWAYS_FALSE_POSITION).func_235842_b_(ALWAYS_FALSE_POSITION).func_235847_c_(ALWAYS_FALSE_POSITION)));
    public static final RegistryObject<Block> GLASSBLOWER = ChippedBlocks.register("glassblower", () -> new ChippedWorkbench((id, inv, pos) -> new ChippedContainer(id, inv, pos, (ContainerType<ChippedContainer>)((ContainerType)ChippedContainerType.GLASSBLOWER.get()), ChippedSerializer.GLASSBLOWER_TYPE, (Block)GLASSBLOWER.get()), AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(2.5f).func_200947_a(SoundType.field_185848_a).func_226896_b_().func_235827_a_(VALID_SPAWN).func_235828_a_(ALWAYS_FALSE_POSITION).func_235842_b_(ALWAYS_FALSE_POSITION).func_235847_c_(ALWAYS_FALSE_POSITION)));
    public static final RegistryObject<Block> CARPENTERS_TABLE = ChippedBlocks.register("carpenters_table", () -> new ChippedWorkbench((id, inv, pos) -> new ChippedContainer(id, inv, pos, (ContainerType<ChippedContainer>)((ContainerType)ChippedContainerType.CARPENTERS_TABLE.get()), ChippedSerializer.CARPENTERS_TABLE_TYPE, (Block)CARPENTERS_TABLE.get()), AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(2.5f).func_200947_a(SoundType.field_185848_a).func_226896_b_().func_235827_a_(VALID_SPAWN).func_235828_a_(ALWAYS_FALSE_POSITION).func_235842_b_(ALWAYS_FALSE_POSITION).func_235847_c_(ALWAYS_FALSE_POSITION)));
    public static final RegistryObject<Block> LOOM_TABLE = ChippedBlocks.register("loom_table", () -> new ChippedWorkbench((id, inv, pos) -> new ChippedContainer(id, inv, pos, (ContainerType<ChippedContainer>)((ContainerType)ChippedContainerType.LOOM_TABLE.get()), ChippedSerializer.LOOM_TABLE_TYPE, (Block)LOOM_TABLE.get()), AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(2.5f).func_200947_a(SoundType.field_185848_a).func_226896_b_().func_235827_a_(VALID_SPAWN).func_235828_a_(ALWAYS_FALSE_POSITION).func_235842_b_(ALWAYS_FALSE_POSITION).func_235847_c_(ALWAYS_FALSE_POSITION)));
    public static final RegistryObject<Block> MASON_TABLE = ChippedBlocks.register("mason_table", () -> new ChippedWorkbench((id, inv, pos) -> new ChippedContainer(id, inv, pos, (ContainerType<ChippedContainer>)((ContainerType)ChippedContainerType.MASON_TABLE.get()), ChippedSerializer.MASON_TABLE_TYPE, (Block)MASON_TABLE.get()), AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(5.0f, 6.0f).func_200947_a(SoundType.field_185852_e).func_226896_b_().func_235827_a_(VALID_SPAWN).func_235828_a_(ALWAYS_FALSE_POSITION).func_235842_b_(ALWAYS_FALSE_POSITION).func_235847_c_(ALWAYS_FALSE_POSITION).func_235861_h_()));
    public static final RegistryObject<Block> ALCHEMY_BENCH = ChippedBlocks.register("alchemy_bench", () -> new ChippedWorkbench((id, inv, pos) -> new ChippedContainer(id, inv, pos, (ContainerType<ChippedContainer>)((ContainerType)ChippedContainerType.ALCHEMY_BENCH.get()), ChippedSerializer.ALCHEMY_BENCH_TYPE, (Block)ALCHEMY_BENCH.get()), AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(2.5f).func_200947_a(SoundType.field_185848_a).func_226896_b_().func_235827_a_(VALID_SPAWN).func_235828_a_(ALWAYS_FALSE_POSITION).func_235842_b_(ALWAYS_FALSE_POSITION).func_235847_c_(ALWAYS_FALSE_POSITION)));
    public static final RegistryObject<Block> MECHANIST_WORKBENCH = ChippedBlocks.register("mechanist_workbench", () -> new ChippedWorkbench((id, inv, pos) -> new ChippedContainer(id, inv, pos, (ContainerType<ChippedContainer>)((ContainerType)ChippedContainerType.MECHANIST_WORKBENCH.get()), ChippedSerializer.MECHANIST_WORKBENCH_TYPE, (Block)MECHANIST_WORKBENCH.get()), AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(2.5f).func_200947_a(SoundType.field_185848_a).func_226896_b_().func_235827_a_(VALID_SPAWN).func_235828_a_(ALWAYS_FALSE_POSITION).func_235842_b_(ALWAYS_FALSE_POSITION).func_235847_c_(ALWAYS_FALSE_POSITION)));

    public static void register() {
        int i;
        RegistryObject<LanternBlock> lantern;
        for (ChippedBlockType<Block> type : stones18) {
            ChippedBlocks.registerVanillaBlocks(BenchType.MASON, type, 18);
        }
        ChippedBlocks.registerVanillaBlocks(BenchType.MASON, ChippedBlockTypes.STONE, 18);
        ChippedBlocks.registerVanillaBlocks(BenchType.MASON, ChippedBlockTypes.COBBLESTONE, 18);
        ChippedBlocks.registerVanillaBlocks(BenchType.MASON, ChippedBlockTypes.END_STONE, 18);
        ChippedBlocks.registerVanillaBlocks(BenchType.MASON, ChippedBlockTypes.NETHERRACK, 18);
        ChippedBlocks.registerVanillaBlocks(BenchType.MASON, Blocks.field_235387_nA_, ChippedBlockTypes.GILDED_BLACKSTONES, 26);
        ChippedBlocks.registerVanillaBlocks(BenchType.MASON, Blocks.field_235406_np_, ChippedBlockTypes.BLACKSTONES, 21);
        ChippedBlocks.registerVanillaBlocks(BenchType.MASON, Blocks.field_235337_cO_, ChippedBlockTypes.BASALTS, 20);
        for (int id = 0; id < 16; ++id) {
            DyeColor color = DyeColor.func_196056_a((int)id);
            ChippedBlocks.registerVanillaBlocks(BenchType.MASON, ChippedBlockTypes.TERRACOTTAS.computeIfAbsent(color, k -> new ChippedBlockType(k + "_terracotta")), 18);
            ChippedBlocks.registerVanillaBlocks(BenchType.MASON, ChippedBlockTypes.CONCRETES.computeIfAbsent(color, k -> new ChippedBlockType(k + "_concrete")), 18);
        }
        ChippedBlocks.registerVanillaBlocks(BenchType.ALCHEMY, Blocks.field_150343_Z, ChippedBlockTypes.OBSIDIAN, 20);
        AbstractBlock.Properties CRYING_OBSIDIAN_PROPERTIES = AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_235399_ni_);
        ChippedBlocks.registerBlocks(BenchType.ALCHEMY, ChippedBlockTypes.CRYING_OBSIDIAN, () -> new CryingObsidianBlock(CRYING_OBSIDIAN_PROPERTIES), 20);
        ChippedBlocks.registerVanillaBlocks(BenchType.ALCHEMY, Blocks.field_150426_aN, ChippedBlockTypes.GLOWSTONES, 20);
        ChippedBlocks.registerVanillaBlocks(BenchType.ALCHEMY, Blocks.field_180398_cJ, ChippedBlockTypes.SEA_LANTERNS, 16);
        ChippedBlocks.registerVanillaBlocks(BenchType.BOTANIST, Blocks.field_235383_mw_, ChippedBlockTypes.SHROOMLIGHTS, 16);
        AbstractBlock.Properties REDSTONE_LAMP_PROPERTIES = AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150379_bu);
        ChippedBlocks.registerBlocks(BenchType.MECHANIST, ChippedBlockTypes.REDSTONE_LAMPS, () -> new RedstoneLampBlock(REDSTONE_LAMP_PROPERTIES), 18);
        AbstractBlock.Properties WOOL_PROPERTIES = AbstractBlock.Properties.func_200945_a((Material)Material.field_151580_n).func_200943_b(0.1f).func_200947_a(SoundType.field_185854_g);
        for (int id = 0; id < 16; ++id) {
            DyeColor color = DyeColor.func_196056_a((int)id);
            ChippedBlocks.registerVanillaBlocks(BenchType.LOOM, ChippedBlockTypes.WOOL.computeIfAbsent(color, k -> new ChippedBlockType(k + "_wool")), 18);
            ChippedBlocks.registerBlocks(BenchType.LOOM, ChippedBlockTypes.CARPETS.computeIfAbsent(color, k -> new ChippedBlockType(k + "_carpet")), () -> new CarpetBlock(color, WOOL_PROPERTIES), 18);
        }
        AbstractBlock.Properties GLASS_PROPERTIES = AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150359_w);
        AbstractBlock.Properties GLASS_PANE_PROPERTIES = AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150410_aZ);
        ChippedBlocks.registerBlocks(BenchType.GLASSBLOWER, ChippedBlockTypes.GLASSES, () -> new GlassBlock(GLASS_PROPERTIES), 14);
        ChippedBlocks.registerBlocks(BenchType.GLASSBLOWER, ChippedBlockTypes.GLASS_PANES, () -> new PaneBlock(GLASS_PANE_PROPERTIES), 14);
        for (ChippedWoodType type : ChippedWoodType.VALUES) {
            ChippedBlocks.registerBlocks(BenchType.GLASSBLOWER, ChippedBlockTypes.GLASSES, (Object)((Object)type) + "_wood_glass", () -> new GlassBlock(GLASS_PROPERTIES), 6);
            ChippedBlocks.registerBlocks(BenchType.GLASSBLOWER, ChippedBlockTypes.GLASS_PANES, (Object)((Object)type) + "_wood_glass_pane", () -> new PaneBlock(GLASS_PANE_PROPERTIES), 6);
        }
        for (int id = 0; id < 16; ++id) {
            DyeColor color = DyeColor.func_196056_a((int)id);
            ChippedBlocks.registerBlocks(BenchType.GLASSBLOWER, ChippedBlockTypes.STAINED_GLASSES.computeIfAbsent(color, k -> new ChippedBlockType(k + "_stained_glass")), () -> new StainedGlassBlock(color, GLASS_PROPERTIES), 8);
            ChippedBlocks.registerBlocks(BenchType.GLASSBLOWER, ChippedBlockTypes.STAINED_GLASS_PANES.computeIfAbsent(color, k -> new ChippedBlockType(k + "_stained_glass_pane")), () -> new StainedGlassPaneBlock(color, GLASS_PANE_PROPERTIES), 8);
        }
        ChippedBlocks.registerVanillaBlocks(BenchType.MASON, Blocks.field_150435_aG, ChippedBlockTypes.CLAYS, 19);
        ChippedBlocks.registerVanillaBlocks(BenchType.BOTANIST, Blocks.field_203216_jz, ChippedBlockTypes.DRIED_KELP_BLOCKS, 12);
        AbstractBlock.Properties woodProperties = AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a);
        for (ChippedWoodType type : ChippedWoodType.VALUES) {
            ChippedBlocks.registerBlocks(BenchType.CARPENTERS, ChippedBlockTypes.PLANKS.computeIfAbsent(type, k -> new ChippedBlockType((Object)k + "_planks")), () -> new Block(woodProperties), 18);
        }
        AbstractBlock.Properties hayProperties = AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150407_cf);
        ChippedBlocks.registerBlocks(BenchType.BOTANIST, ChippedBlockTypes.HAY_BLOCKS, () -> new HayBlock(hayProperties), 8);
        AbstractBlock.Properties melonProperties = AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150440_ba);
        ChippedBlocks.registerBlocks(BenchType.BOTANIST, ChippedBlockTypes.MELONS, () -> new MelonBlock(melonProperties), 10);
        AbstractBlock.Properties vineProperties = AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150395_bd);
        ChippedBlocks.registerBlocks(BenchType.BOTANIST, ChippedBlockTypes.VINES, () -> new VineBlock(vineProperties), 17);
        AbstractBlock.Properties brownMushroomProperties = AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150338_P);
        ChippedBlocks.registerBlocks(BenchType.BOTANIST, ChippedBlockTypes.BROWN_MUSHROOMS, () -> new MushroomBlock(brownMushroomProperties), 15);
        AbstractBlock.Properties redMushroomProperties = AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150337_Q);
        ChippedBlocks.registerBlocks(BenchType.BOTANIST, ChippedBlockTypes.RED_MUSHROOMS, () -> new MushroomBlock(redMushroomProperties), 15);
        AbstractBlock.Properties warpedFungusProperties = AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_235373_mm_);
        ChippedBlocks.registerBlocks(BenchType.BOTANIST, ChippedBlockTypes.WARPED_FUNGUS, () -> new MushroomBlock(warpedFungusProperties), 14);
        AbstractBlock.Properties crimsonFungusProperties = AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_235382_mv_);
        ChippedBlocks.registerBlocks(BenchType.BOTANIST, ChippedBlockTypes.CRIMSON_FUNGUS, () -> new MushroomBlock(crimsonFungusProperties), 15);
        AbstractBlock.Properties warpedRootsProperties = AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_235375_mo_);
        ChippedBlocks.registerBlocks(BenchType.BOTANIST, ChippedBlockTypes.WARPED_ROOTS, () -> new NetherRootsBlock(warpedRootsProperties), 9);
        AbstractBlock.Properties crimsonRootsProperties = AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_235343_mB_);
        ChippedBlocks.registerBlocks(BenchType.BOTANIST, ChippedBlockTypes.CRIMSON_ROOTS, () -> new NetherRootsBlock(crimsonRootsProperties), 14);
        AbstractBlock.Properties netherSproutsProperties = AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_235376_mp_);
        ChippedBlocks.registerBlocks(BenchType.BOTANIST, ChippedBlockTypes.NETHER_SPROUTS, () -> new NetherSproutsBlock(netherSproutsProperties), 20);
        AbstractBlock.Properties brownMushroomBlockProperties = AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150420_aW);
        ChippedBlocks.registerBlocks(BenchType.BOTANIST, ChippedBlockTypes.BROWN_MUSHROOM_BLOCK, () -> new HugeMushroomBlock(brownMushroomBlockProperties), 24);
        AbstractBlock.Properties redMushroomBlockProperties = AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150419_aX);
        ChippedBlocks.registerBlocks(BenchType.BOTANIST, ChippedBlockTypes.RED_MUSHROOM_BLOCK, () -> new HugeMushroomBlock(redMushroomBlockProperties), 15);
        ChippedBlocks.registerVanillaBlocks(BenchType.BOTANIST, ChippedBlockTypes.WARPED_WART_BLOCK, 14);
        ChippedBlocks.registerVanillaBlocks(BenchType.BOTANIST, ChippedBlockTypes.NETHER_WART_BLOCK, 13);
        AbstractBlock.Properties cobwebProperties = AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_196553_aF).func_200948_a(0.26666668f, 4.0f);
        ChippedBlocks.registerBlocks(BenchType.BOTANIST, ChippedBlockTypes.COBWEBS, () -> new WebBlock(cobwebProperties), 10);
        AbstractBlock.Properties soulSandProperties = AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150425_aM);
        ChippedBlocks.registerBlocks(BenchType.ALCHEMY, ChippedBlockTypes.SOUL_SANDS, () -> new SoulSandBlock(soulSandProperties), 11);
        AbstractBlock.Properties lilyPadProperties = AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_196651_dG);
        for (int i2 = 1; i2 <= 6; ++i2) {
            String name = ChippedBlockTypes.LILY_PAD.getId() + "_" + i2;
            RegistryObject lilyPad = BLOCKS.register(name, () -> new LilyPadBlock(lilyPadProperties){

                public PlantType getPlantType(IBlockReader world, BlockPos pos) {
                    return PlantType.WATER;
                }
            });
            BlockRegistry.addBlock(BenchType.BOTANIST, ChippedBlockTypes.LILY_PAD, lilyPad);
            ChippedItems.ITEMS.register(name, () -> new LilyPadItem((Block)lilyPad.get(), new Item.Properties().func_200916_a(Chipped.CHIPPED)));
        }
        VoxelShape CHONK_LANTERN_SHAPE = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)1.0, (double)14.0), (VoxelShape)Block.func_208617_a((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0));
        VoxelShape THICC_LANTERN_SHAPE = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)1.0, (double)14.0), (VoxelShape)Block.func_208617_a((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0));
        VoxelShape DONUT_LANTERN_SHAPE_EAST = Block.func_208617_a((double)5.0, (double)0.0, (double)1.0, (double)11.0, (double)15.0, (double)15.0);
        VoxelShape DONUT_LANTERN_SHAPE_NORTH = Block.func_208617_a((double)1.0, (double)0.0, (double)5.0, (double)15.0, (double)15.0, (double)11.0);
        VoxelShape TALL_LANTERN_SHAPE = Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)15.0, (double)11.0);
        VoxelShape HANGING_WOOD_LANTERN = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)5.0, (double)2.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)4.0, (double)12.0, (double)4.0, (double)12.0, (double)13.0, (double)12.0), Block.func_208617_a((double)4.0, (double)1.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0), Block.func_208617_a((double)5.0, (double)13.0, (double)5.0, (double)11.0, (double)14.0, (double)11.0)});
        VoxelShape WOOD_LANTERN = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)4.0, (double)11.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0), Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)1.0, (double)12.0), Block.func_208617_a((double)5.0, (double)12.0, (double)5.0, (double)11.0, (double)13.0, (double)11.0)});
        VoxelShape HANGING_JAR_LANTERN = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)7.0, (double)11.0, (double)7.0, (double)9.0, (double)12.0, (double)9.0), (VoxelShape)Block.func_208617_a((double)6.0, (double)5.0, (double)6.0, (double)10.0, (double)11.0, (double)10.0));
        VoxelShape JAR_LANTERN = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)7.0, (double)6.0, (double)7.0, (double)9.0, (double)7.0, (double)9.0), (VoxelShape)Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0));
        VoxelShape HANGING_PAPER_LANTERN = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)4.0, (double)5.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)5.0, (double)3.0, (double)5.0, (double)11.0, (double)5.0, (double)11.0), Block.func_208617_a((double)5.0, (double)14.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0)});
        VoxelShape PAPER_LANTERN = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)4.0, (double)3.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)3.0, (double)11.0), Block.func_208617_a((double)5.0, (double)12.0, (double)5.0, (double)11.0, (double)14.0, (double)11.0), Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0)});
        VoxelShape HANGING_PAPER_LANTERN_2 = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)4.0, (double)9.0, (double)4.0, (double)12.0, (double)15.0, (double)12.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)5.0, (double)11.0), Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)1.0, (double)10.0), Block.func_208617_a((double)6.0, (double)5.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0), Block.func_208617_a((double)5.0, (double)15.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0), Block.func_208617_a((double)5.0, (double)8.0, (double)5.0, (double)11.0, (double)9.0, (double)11.0)});
        VoxelShape PAPER_LANTERN_2 = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)4.0, (double)3.0, (double)4.0, (double)12.0, (double)9.0, (double)12.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)5.0, (double)9.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0), Block.func_208617_a((double)5.0, (double)2.0, (double)5.0, (double)11.0, (double)3.0, (double)11.0), Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0)});
        for (int i3 : new int[]{1, 3, 4}) {
            lantern = ChippedBlocks.register("lantern_" + i3, () -> new LanternBlock(LANTERN_PROPERTIES));
            BlockRegistry.addGenericBlock(BenchType.MECHANIST, ChippedBlockTypes.LANTERNS, lantern);
        }
        ChippedBlocks.registerSpecialLantern(ChippedBlockTypes.LANTERNS, HANGING_WOOD_LANTERN, WOOD_LANTERN, 2);
        ChippedBlocks.registerSpecialLantern(ChippedBlockTypes.LANTERNS, HANGING_JAR_LANTERN, JAR_LANTERN, 6);
        ChippedBlocks.registerSpecialLantern(ChippedBlockTypes.LANTERNS, HANGING_PAPER_LANTERN, PAPER_LANTERN, 9, 10, 11, 12, 13, 14);
        for (int i3 : new int[]{1, 3}) {
            lantern = ChippedBlocks.register("soul_lantern_" + i3, () -> new LanternBlock(LANTERN_PROPERTIES));
            BlockRegistry.addGenericBlock(BenchType.MECHANIST, ChippedBlockTypes.SOUL_LANTERNS, lantern);
        }
        ChippedBlocks.registerSpecialLantern(ChippedBlockTypes.SOUL_LANTERNS, HANGING_WOOD_LANTERN, WOOD_LANTERN, 2);
        ChippedBlocks.registerSpecialLantern(ChippedBlockTypes.SOUL_LANTERNS, HANGING_JAR_LANTERN, JAR_LANTERN, 5);
        ChippedBlocks.registerSpecialLantern(ChippedBlockTypes.SOUL_LANTERNS, HANGING_PAPER_LANTERN_2, PAPER_LANTERN_2, 6, 7, 8, 9, 10, 11);
        RegistryObject<ChippedLantern> lantern1 = ChippedBlocks.register("special_lantern_1", () -> new ChippedLantern(LANTERN_PROPERTIES, CHONK_LANTERN_SHAPE));
        RegistryObject<ChippedLantern> lantern2 = ChippedBlocks.register("special_lantern_2", () -> new ChippedLantern(LANTERN_PROPERTIES, DONUT_LANTERN_SHAPE_EAST, DONUT_LANTERN_SHAPE_NORTH));
        RegistryObject<ChippedLantern> lantern3 = ChippedBlocks.register("special_lantern_3", () -> new ChippedLantern(LANTERN_PROPERTIES, TALL_LANTERN_SHAPE));
        RegistryObject<ChippedLantern> lantern4 = ChippedBlocks.register("special_lantern_4", () -> new ChippedLantern(LANTERN_PROPERTIES, THICC_LANTERN_SHAPE));
        BlockRegistry.addGenericBlock(BenchType.MECHANIST, ChippedBlockTypes.LANTERNS, lantern1);
        BlockRegistry.addGenericBlock(BenchType.MECHANIST, ChippedBlockTypes.LANTERNS, lantern2);
        BlockRegistry.addGenericBlock(BenchType.MECHANIST, ChippedBlockTypes.LANTERNS, lantern3);
        BlockRegistry.addGenericBlock(BenchType.MECHANIST, ChippedBlockTypes.LANTERNS, lantern4);
        RegistryObject<ChippedLantern> soulLantern1 = ChippedBlocks.register("special_soul_lantern_1", () -> new ChippedLantern(LANTERN_PROPERTIES, CHONK_LANTERN_SHAPE));
        RegistryObject<ChippedLantern> soulLantern2 = ChippedBlocks.register("special_soul_lantern_2", () -> new ChippedLantern(LANTERN_PROPERTIES, DONUT_LANTERN_SHAPE_EAST, DONUT_LANTERN_SHAPE_NORTH));
        RegistryObject<ChippedLantern> soulLantern3 = ChippedBlocks.register("special_soul_lantern_3", () -> new ChippedLantern(LANTERN_PROPERTIES, TALL_LANTERN_SHAPE));
        RegistryObject<ChippedLantern> soulLantern4 = ChippedBlocks.register("special_soul_lantern_4", () -> new ChippedLantern(LANTERN_PROPERTIES, THICC_LANTERN_SHAPE));
        BlockRegistry.addGenericBlock(BenchType.MECHANIST, ChippedBlockTypes.SOUL_LANTERNS, soulLantern1);
        BlockRegistry.addGenericBlock(BenchType.MECHANIST, ChippedBlockTypes.SOUL_LANTERNS, soulLantern2);
        BlockRegistry.addGenericBlock(BenchType.MECHANIST, ChippedBlockTypes.SOUL_LANTERNS, soulLantern3);
        BlockRegistry.addGenericBlock(BenchType.MECHANIST, ChippedBlockTypes.SOUL_LANTERNS, soulLantern4);
        AbstractBlock.Properties REDSTONE_TORCH_PROPERTIES = AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150429_aA);
        AbstractBlock.Properties REDSTONE_WALL_TORCH_PROPERTIES = AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_196677_cy);
        for (int i4 = 2; i4 <= 6; ++i4) {
            RegistryObject redstoneWallTorch = BLOCKS.register("redstone_wall_torch_" + i4, () -> new RedstoneWallTorchBlock(REDSTONE_WALL_TORCH_PROPERTIES));
            RegistryObject redstoneTorch = BLOCKS.register("redstone_torch_" + i4, () -> new RedstoneTorchBlock(REDSTONE_TORCH_PROPERTIES));
            ChippedItems.ITEMS.register("redstone_torch_" + i4, () -> new WallOrFloorItem((Block)redstoneTorch.get(), (Block)redstoneWallTorch.get(), new Item.Properties().func_200916_a(Chipped.CHIPPED)));
            BlockRegistry.addBlock(BenchType.MECHANIST, ChippedBlockTypes.REDSTONE_TORCHES, redstoneTorch);
            REDSTONE_WALL_TORCHES.add((RegistryObject<RedstoneWallTorchBlock>)redstoneWallTorch);
        }
        AbstractBlock.Properties TORCH_PROPERTIES = AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150478_aa);
        AbstractBlock.Properties WALL_TORCH_PROPERTIES = AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_196591_bQ);
        for (int i5 = 1; i5 <= 9; ++i5) {
            RegistryObject wallTorch = BLOCKS.register("wall_torch_" + i5, () -> new WallTorchBlock(TORCH_PROPERTIES, (IParticleData)ParticleTypes.field_197631_x));
            RegistryObject torch = BLOCKS.register("torch_" + i5, () -> new TorchBlock(WALL_TORCH_PROPERTIES, (IParticleData)ParticleTypes.field_197631_x));
            ChippedItems.ITEMS.register("torch_" + i5, () -> new WallOrFloorItem((Block)torch.get(), (Block)wallTorch.get(), new Item.Properties().func_200916_a(Chipped.CHIPPED)));
            BlockRegistry.addBlock(BenchType.CARPENTERS, ChippedBlockTypes.TORCHES, torch);
            WALL_TORCHES.add((RegistryObject<WallTorchBlock>)wallTorch);
        }
        AbstractBlock.Properties PUMPKIN_PROPERTIES = AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_196625_cS);
        AbstractBlock.Properties JACK_O_LANTERN_PROPERTIES = AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_196628_cT);
        for (String pumpkin : specialPumpkinList) {
            RegistryObject<PumpkinBlock> pumpkinBlock = ChippedBlocks.register("pumpkin_" + pumpkin, () -> new PumpkinBlock(PUMPKIN_PROPERTIES));
            RegistryObject<CarvedPumpkinBlock> jackOLanternBlock = ChippedBlocks.register("jack_o_lantern_" + pumpkin, () -> new CarvedPumpkinBlock(JACK_O_LANTERN_PROPERTIES));
            RegistryObject<CarvedPumpkinBlock> carvedPumpkinBlock = ChippedBlocks.register("carved_pumpkin_" + pumpkin, () -> new CarvedPumpkinBlock(PUMPKIN_PROPERTIES));
            BlockRegistry.addBlock(BenchType.BOTANIST, ChippedBlockTypes.JACK_O_LANTERNS, jackOLanternBlock);
            BlockRegistry.addBlock(BenchType.BOTANIST, ChippedBlockTypes.CARVED_PUMPKINS, carvedPumpkinBlock);
            BlockRegistry.addBlock(BenchType.BOTANIST, ChippedBlockTypes.PUMPKINS, pumpkinBlock);
            SPECIAL_CARVED_PUMPKINS.add(jackOLanternBlock);
            SPECIAL_CARVED_PUMPKINS.add(carvedPumpkinBlock);
        }
        for (i = 1; i <= 13; ++i) {
            RegistryObject<PumpkinBlock> pumpkinBlock = ChippedBlocks.register("pumpkin_" + i, () -> new PumpkinBlock(PUMPKIN_PROPERTIES));
            BlockRegistry.addBlock(BenchType.BOTANIST, ChippedBlockTypes.PUMPKINS, pumpkinBlock);
        }
        for (i = 1; i <= carvedPumpkinList.length; ++i) {
            RegistryObject<CarvedPumpkinBlock> jackOLanternBlock = ChippedBlocks.register("jack_o_lantern_" + i, () -> new CarvedPumpkinBlock(JACK_O_LANTERN_PROPERTIES));
            RegistryObject<CarvedPumpkinBlock> carvedPumpkinBlock = ChippedBlocks.register("carved_pumpkin_" + i, () -> new CarvedPumpkinBlock(PUMPKIN_PROPERTIES));
            BlockRegistry.addBlock(BenchType.BOTANIST, ChippedBlockTypes.JACK_O_LANTERNS, jackOLanternBlock);
            BlockRegistry.addBlock(BenchType.BOTANIST, ChippedBlockTypes.CARVED_PUMPKINS, carvedPumpkinBlock);
            VANILLA_CARVED_PUMPKINS.add(carvedPumpkinBlock);
            VANILLA_CARVED_PUMPKINS.add(jackOLanternBlock);
        }
    }

    private static void registerSpecialLantern(ChippedBlockType<Block> list, final VoxelShape hangingShape, final VoxelShape normalShape, int ... indices) {
        for (int i : indices) {
            RegistryObject<LanternBlock> lantern = ChippedBlocks.register(list.getId() + "_" + i, () -> new LanternBlock(LANTERN_PROPERTIES){

                @NotNull
                public VoxelShape func_220053_a(@NotNull BlockState blockState, @NotNull IBlockReader blockReader, @NotNull BlockPos pos, @NotNull ISelectionContext selectionContext) {
                    return (Boolean)blockState.func_177229_b((Property)field_220278_a) != false ? hangingShape : normalShape;
                }
            });
            BlockRegistry.addGenericBlock(BenchType.MECHANIST, list, lantern);
        }
    }

    private static void registerVanillaBlocks(BenchType bench, ChippedBlockType<Block> type, int count) {
        ChippedBlocks.registerVanillaBlocks(bench, (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("minecraft", type.getId())), type, count);
    }

    private static void registerVanillaBlocks(BenchType bench, Block vanillaBlock, ChippedBlockType<Block> type, int count) {
        ChippedBlocks.registerBlocks(bench, type, () -> new Block(AbstractBlock.Properties.func_200950_a((AbstractBlock)vanillaBlock)), count);
    }

    private static <T extends Block> void registerBlocks(BenchType bench, ChippedBlockType<T> type, Supplier<T> block, int count) {
        ChippedBlocks.registerBlocks(bench, type, type.getId(), block, count);
    }

    private static <T extends Block> void registerBlocks(BenchType bench, ChippedBlockType<T> type, String name, Supplier<T> block, int count) {
        for (int i = 1; i <= count; ++i) {
            BlockRegistry.addBlock(bench, type, ChippedBlocks.register(name + "_" + i, block));
        }
    }

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        ChippedItems.ITEMS.register(name, () -> new BlockItem((Block)toReturn.get(), new Item.Properties().func_200916_a(Chipped.CHIPPED)));
        return toReturn;
    }
}

