/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.customizableelytra.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ItemTags;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class DamagedIngredient
extends Ingredient {
    private final Ingredient.IItemList itemList;
    private final int damageValue;

    public DamagedIngredient(Ingredient.IItemList list, int damageValue) {
        super(Stream.of(list));
        this.itemList = list;
        this.damageValue = damageValue;
    }

    public boolean test(@Nullable ItemStack testStack) {
        if (testStack == null) {
            return false;
        }
        return super.test(testStack) && testStack.func_77952_i() == this.damageValue;
    }

    public boolean isSimple() {
        return false;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public JsonElement func_200304_c() {
        JsonObject json = new JsonObject();
        json.addProperty("type", CraftingHelper.getID((IIngredientSerializer)Serializer.INSTANCE).toString());
        json.add("itemlist", (JsonElement)this.itemList.func_200303_b());
        json.addProperty("damage", (Number)this.damageValue);
        return json;
    }

    public static class Serializer
    implements IIngredientSerializer<DamagedIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        public DamagedIngredient parse(PacketBuffer buffer) {
            JsonParser parser = new JsonParser();
            JsonElement itemList = parser.parse(buffer.func_218666_n());
            int damageValue = buffer.readInt();
            ItemTags.field_199906_c.func_232932_a_();
            return new DamagedIngredient(Ingredient.func_199803_a((JsonObject)itemList.getAsJsonObject()), damageValue);
        }

        public DamagedIngredient parse(JsonObject json) {
            JsonElement itemList = json.get("itemlist");
            int damageValue = json.get("damage").getAsInt();
            return new DamagedIngredient(Ingredient.func_199803_a((JsonObject)itemList.getAsJsonObject()), damageValue);
        }

        public void write(PacketBuffer buffer, DamagedIngredient ingredient) {
            buffer.func_180714_a(ingredient.itemList.func_200303_b().toString());
            buffer.writeInt(ingredient.damageValue);
        }
    }
}

