/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.customizableelytra.renderers;

import com.gildedgames.aether.common.item.accessories.cape.CapeItem;
import com.google.common.collect.ImmutableList;
import com.hidoni.customizableelytra.CustomizableElytra;
import com.hidoni.customizableelytra.mixin.ElytraLayerAccessor;
import com.hidoni.customizableelytra.renderers.models.ElytraWingModel;
import com.hidoni.customizableelytra.renderers.models.MirroredElytraWingModel;
import com.hidoni.customizableelytra.setup.ModItems;
import com.hidoni.customizableelytra.util.ElytraCustomizationData;
import com.hidoni.customizableelytra.util.ElytraCustomizationUtil;
import com.hidoni.customizableelytra.util.ElytraInventoryUtil;
import com.hidoni.customizableelytra.util.ElytraTextureUtil;
import com.hidoni.customizableelytra.util.SplitCustomizationHandler;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Optional;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.model.ElytraModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class CustomizableElytraLayer<T extends LivingEntity, M extends EntityModel<T>>
extends ElytraLayer<T, M> {
    public static final ResourceLocation TEXTURE_DYEABLE_ELYTRA = new ResourceLocation("customizableelytra", "textures/entity/elytra.png");
    private final ElytraModel<T> modelElytra = new ElytraModel();
    private final ElytraWingModel<T> leftElytraWing = new ElytraWingModel();
    private final MirroredElytraWingModel<T> rightElytraWing = new MirroredElytraWingModel();

    public CustomizableElytraLayer(IEntityRenderer<T, M> rendererIn) {
        super(rendererIn);
    }

    public void func_225628_a_(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack elytra = ElytraInventoryUtil.tryFindElytra(entitylivingbaseIn);
        if (elytra != ItemStack.field_190927_a) {
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(0.0, 0.0, 0.125);
            ElytraCustomizationData data = ElytraCustomizationUtil.getData(elytra);
            if (data.type != ElytraCustomizationData.CustomizationType.Split) {
                this.func_215332_c().func_217111_a(this.modelElytra);
                ResourceLocation elytraTexture = this.getTextureWithCape(entitylivingbaseIn, elytra.func_77978_p(), data.handler.isWingCapeHidden(0));
                data.handler.render(matrixStackIn, bufferIn, data.handler.modifyWingLight(packedLightIn, 0), entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, this.modelElytra, elytraTexture, elytra.func_77962_s());
            } else {
                ImmutableList models = ImmutableList.of(this.leftElytraWing, this.rightElytraWing);
                for (ElytraWingModel model : models) {
                    this.func_215332_c().func_217111_a((EntityModel)model);
                }
                CompoundNBT wingInfo = elytra.func_179543_a("WingInfo");
                ResourceLocation leftWingTexture = this.getTextureWithCape(entitylivingbaseIn, wingInfo.func_74775_l("left"), data.handler.isWingCapeHidden(0));
                ResourceLocation rightWingTexture = this.getTextureWithCape(entitylivingbaseIn, wingInfo.func_74775_l("right"), data.handler.isWingCapeHidden(1));
                ((SplitCustomizationHandler)data.handler).render(matrixStackIn, bufferIn, packedLightIn, entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, models, leftWingTexture, rightWingTexture, elytra.func_77962_s());
            }
            matrixStackIn.func_227865_b_();
        }
    }

    private ResourceLocation getTextureWithCape(T entitylivingbaseIn, CompoundNBT customizationTag, boolean capeHidden) {
        boolean isTextureGrayscale;
        ResourceLocation elytraTexture = null;
        boolean bl = isTextureGrayscale = ElytraCustomizationUtil.getData((CompoundNBT)customizationTag).type != ElytraCustomizationData.CustomizationType.None;
        if (!capeHidden) {
            if (entitylivingbaseIn instanceof AbstractClientPlayerEntity) {
                AbstractClientPlayerEntity abstractclientplayerentity = (AbstractClientPlayerEntity)entitylivingbaseIn;
                if (abstractclientplayerentity.func_184833_s() && abstractclientplayerentity.func_184834_t() != null) {
                    elytraTexture = abstractclientplayerentity.func_184834_t();
                } else if (abstractclientplayerentity.func_152122_n() && abstractclientplayerentity.func_110303_q() != null && abstractclientplayerentity.func_175148_a(PlayerModelPart.CAPE)) {
                    elytraTexture = abstractclientplayerentity.func_110303_q();
                }
            }
            if (elytraTexture == null && CustomizableElytra.aetherLoaded) {
                CapeItem cape;
                Optional stacksHandler;
                Optional curiosHelper = CuriosApi.getCuriosHelper().findEquippedCurio(item -> item.func_77973_b() instanceof CapeItem, entitylivingbaseIn);
                Optional curiosHandler = CuriosApi.getCuriosHelper().getCuriosHandler(entitylivingbaseIn).resolve();
                if (curiosHelper.isPresent() && curiosHandler.isPresent() && (stacksHandler = ((ICuriosItemHandler)curiosHandler.get()).getStacksHandler((String)((ImmutableTriple)curiosHelper.get()).getLeft())).isPresent() && (cape = (CapeItem)((ItemStack)((ImmutableTriple)curiosHelper.get()).getRight()).func_77973_b()).getCapeTexture() != null && ((Boolean)((ICurioStacksHandler)stacksHandler.get()).getRenders().get(((Integer)((ImmutableTriple)curiosHelper.get()).getMiddle()).intValue())).booleanValue()) {
                    elytraTexture = cape.getCapeTexture();
                }
            }
        }
        if (elytraTexture == null) {
            elytraTexture = this.getElytraTexture(isTextureGrayscale);
        } else if (isTextureGrayscale) {
            elytraTexture = ElytraTextureUtil.getGrayscale(elytraTexture);
        }
        return elytraTexture;
    }

    public boolean shouldRender(ItemStack stack, LivingEntity entity) {
        return stack.func_77973_b() == ModItems.CUSTOMIZABLE_ELYTRA.get();
    }

    public ResourceLocation getElytraTexture(boolean isTextureGrayscale) {
        if (isTextureGrayscale) {
            return TEXTURE_DYEABLE_ELYTRA;
        }
        return ((ElytraLayerAccessor)((Object)this)).getDefaultElytraTexture();
    }
}

