/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.customizableelytra.util;

import com.hidoni.customizableelytra.items.CustomizableElytraItem;
import com.hidoni.customizableelytra.util.CustomizationHandler;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.AgeableModel;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.tileentity.BannerTileEntity;
import net.minecraft.util.ResourceLocation;

public class BannerCustomizationHandler
extends CustomizationHandler {
    private final List<Pair<BannerPattern, DyeColor>> patterns;

    public BannerCustomizationHandler(ItemStack itemIn) {
        this(itemIn.func_196082_o());
    }

    public BannerCustomizationHandler(CompoundNBT tagIn) {
        super(tagIn.func_74767_n("HideCapePattern"), tagIn.func_74762_e("WingLightLevel"));
        CompoundNBT blockEntityTag = tagIn.func_74775_l("BlockEntityTag");
        DyeColor baseColor = DyeColor.func_196056_a((int)blockEntityTag.func_74762_e("Base"));
        ListNBT patternsList = blockEntityTag.func_150295_c("Patterns", 10).func_74737_b();
        this.patterns = BannerTileEntity.func_230138_a_((DyeColor)baseColor, (ListNBT)patternsList);
    }

    @Override
    public int getColor(int index) {
        return ((DyeColor)this.patterns.get(0).getSecond()).getColorValue();
    }

    @Override
    public <T extends LivingEntity, M extends AgeableModel<T>> void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, M renderModel, ResourceLocation textureLocation, boolean hasGlint) {
        renderModel.func_225597_a_(entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        IVertexBuilder ivertexbuilder = ItemRenderer.func_239391_c_((IRenderTypeBuffer)bufferIn, (RenderType)RenderType.func_228650_h_((ResourceLocation)textureLocation), (boolean)false, (boolean)hasGlint);
        renderModel.func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        float[] baseColor = ((DyeColor)this.patterns.get(0).getSecond()).func_193349_f();
        renderModel.func_225598_a_(matrixStackIn, ItemRenderer.func_229113_a_((IRenderTypeBuffer)bufferIn, (RenderType)RenderType.func_228644_e_((ResourceLocation)textureLocation), (boolean)false, (boolean)false), packedLightIn, OverlayTexture.field_229196_a_, baseColor[0], baseColor[1], baseColor[2], 1.0f);
        for (int i = 1; i < 17 && i < this.patterns.size(); ++i) {
            Pair<BannerPattern, DyeColor> pair = this.patterns.get(i);
            float[] afloat = ((DyeColor)pair.getSecond()).func_193349_f();
            RenderMaterial rendermaterial = new RenderMaterial(AtlasTexture.field_110575_b, CustomizableElytraItem.getTextureLocation((BannerPattern)pair.getFirst()));
            if (rendermaterial.func_229314_c_().func_195668_m() == MissingTextureSprite.func_195675_b()) continue;
            renderModel.func_225598_a_(matrixStackIn, rendermaterial.func_229311_a_(bufferIn, RenderType::func_228644_e_), packedLightIn, OverlayTexture.field_229196_a_, afloat[0], afloat[1], afloat[2], 1.0f);
        }
    }
}

