/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.customizableelytra.util;

import com.hidoni.customizableelytra.CustomizableElytra;
import com.hidoni.customizableelytra.mixin.DownloadingTextureAccessor;
import com.hidoni.customizableelytra.mixin.DownloadingTextureInvoker;
import com.hidoni.customizableelytra.mixin.SimpleTextureInvoker;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DownloadingTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.util.ResourceLocation;

public class ElytraTextureUtil {
    private static final Map<ResourceLocation, ResourceLocation> TEXTURE_CACHE = new HashMap<ResourceLocation, ResourceLocation>();

    private static void convertTextureToGrayscale(NativeImage nativeImage) {
        for (int x = 0; x < nativeImage.func_195702_a(); ++x) {
            for (int y = 0; y < nativeImage.func_195714_b(); ++y) {
                int pixelRGBA = nativeImage.func_195709_a(x, y);
                int originalRGB = pixelRGBA & 0xFFFFFF;
                int grayscale = (((originalRGB & 0xFF0000) >> 16) + ((originalRGB & 0xFF00) >> 8) + (originalRGB & 0xFF)) / 3;
                int newRGB = 65793 * grayscale;
                nativeImage.func_195700_a(x, y, pixelRGBA & 0xFF000000 | newRGB);
            }
        }
    }

    private static NativeImage getNativeImageFromTexture(ResourceLocation locationIn) {
        Texture texture = Minecraft.func_71410_x().func_110434_K().func_229267_b_(locationIn);
        if (texture instanceof DynamicTexture) {
            DynamicTexture dynamicTexture = (DynamicTexture)texture;
            NativeImage dynamicTextureData = dynamicTexture.func_195414_e();
            if (dynamicTextureData != null) {
                NativeImage returnTexture = new NativeImage(dynamicTextureData.func_195702_a(), dynamicTextureData.func_195714_b(), false);
                returnTexture.func_195703_a(dynamicTextureData);
                return returnTexture;
            }
        } else {
            if (texture instanceof DownloadingTexture) {
                File cacheFile = ((DownloadingTextureAccessor)texture).getCacheFile();
                if (cacheFile != null) {
                    try {
                        return ((DownloadingTextureInvoker)texture).callLoadTexture(new FileInputStream(cacheFile));
                    }
                    catch (FileNotFoundException e) {
                        return null;
                    }
                }
                return null;
            }
            if (texture instanceof SimpleTexture) {
                try {
                    return ((SimpleTextureInvoker)texture).invokeGetTextureData(Minecraft.func_71410_x().func_195551_G()).func_217800_b();
                }
                catch (IOException e) {
                    return null;
                }
            }
        }
        return null;
    }

    private static ResourceLocation createGrayscaleTexture(ResourceLocation locationIn) {
        NativeImage texture = ElytraTextureUtil.getNativeImageFromTexture(locationIn);
        if (texture == null) {
            return locationIn;
        }
        ElytraTextureUtil.convertTextureToGrayscale(texture);
        ResourceLocation locationOut = new ResourceLocation("customizableelytra", "grayscale_" + locationIn.func_110623_a());
        Minecraft.func_71410_x().func_110434_K().func_229263_a_(locationOut, (Texture)new DynamicTexture(texture));
        TEXTURE_CACHE.put(locationIn, locationOut);
        return locationOut;
    }

    public static ResourceLocation getGrayscale(ResourceLocation locationIn) {
        if (!TEXTURE_CACHE.containsKey(locationIn)) {
            CustomizableElytra.LOGGER.debug("Creating grayscale texture for: " + locationIn);
            return ElytraTextureUtil.createGrayscaleTexture(locationIn);
        }
        return TEXTURE_CACHE.get(locationIn);
    }
}

