/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui.dropdown;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xaero.common.gui.dropdown.IDropDownContainer;
import xaero.common.gui.dropdown.IDropDownWidgetCallback;

public class DropDownWidget
extends Widget {
    public static final int DEFAULT_BACKGROUND = -939524096;
    public static final int SELECTED_DEFAULT_BACKGROUND = -922757376;
    public static final int SELECTED_DEFAULT_HOVERED_BACKGROUND = -10496;
    public static final int TRIM = -6250336;
    public static final int TRIM_OPEN = -1;
    public static final int TRIM_INSIDE = -13487566;
    public static final int LINE_HEIGHT = 11;
    private int xOffset = 0;
    private int yOffset = 0;
    private String[] realOptions = new String[0];
    private String[] options = new String[0];
    private int selected = 0;
    private boolean closed = true;
    private int scroll;
    private long scrollTime;
    private int autoScrolling;
    protected boolean openingUp;
    private final IDropDownWidgetCallback callback;
    private final IDropDownContainer container;
    private final boolean hasEmptyOption;
    protected int selectedBackground;
    protected int selectedHoveredBackground;
    protected boolean shortenFromTheRight;
    private boolean wasHovered;

    protected DropDownWidget(String[] options, int x, int y, int w, Integer selected, boolean openingUp, IDropDownWidgetCallback callback, IDropDownContainer container, boolean hasEmptyOption, TextComponent narrationTitle) {
        super(x, y + (openingUp ? 11 : 0), w, 11, (ITextComponent)narrationTitle);
        this.realOptions = options;
        this.callback = callback;
        this.container = container;
        int emptyOptionCount = hasEmptyOption ? 1 : 0;
        this.options = new String[this.realOptions.length + emptyOptionCount];
        System.arraycopy(this.realOptions, 0, this.options, emptyOptionCount, this.realOptions.length);
        this.selectId(selected, false);
        this.openingUp = openingUp;
        this.hasEmptyOption = hasEmptyOption;
        this.selectedBackground = -922757376;
        this.selectedHoveredBackground = -10496;
        this.field_230693_o_ = true;
    }

    public int size() {
        return this.realOptions.length;
    }

    public int getXWithOffset() {
        return this.field_230690_l_ + this.xOffset;
    }

    public int getYWithOffset() {
        return this.field_230691_m_ + this.yOffset;
    }

    private void drawSlot(MatrixStack matrixStack, String text, int slotIndex, int pos, int mouseX, int mouseY, boolean scrolling, int optionLimit, int xWithOffset, int yWithOffset) {
        int slotBackground;
        int emptyOptionCount;
        int n = emptyOptionCount = this.hasEmptyOption ? 1 : 0;
        if (this.closed && this.func_230449_g_() || !this.closed && this.onDropDownSlot(mouseX, mouseY, slotIndex, scrolling, optionLimit)) {
            slotBackground = slotIndex - emptyOptionCount == this.selected ? this.selectedHoveredBackground : -13487566;
        } else {
            int n2 = slotBackground = slotIndex - emptyOptionCount == this.selected ? this.selectedBackground : -939524096;
        }
        if (this.openingUp) {
            pos = -pos - 1;
        }
        DropDownWidget.func_238467_a_((MatrixStack)matrixStack, (int)xWithOffset, (int)(yWithOffset + 11 * pos), (int)(xWithOffset + this.field_230688_j_), (int)(yWithOffset + 11 + 11 * pos), (int)slotBackground);
        this.func_238465_a_(matrixStack, xWithOffset + 1, xWithOffset + this.field_230688_j_ - 1, yWithOffset + 11 * pos, -13487566);
        int textWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(text);
        boolean shortened = false;
        while (textWidth > this.field_230688_j_ - 2) {
            text = this.shortenFromTheRight ? text.substring(0, text.length() - 1) : text.substring(1);
            textWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a("..." + text);
            shortened = true;
        }
        if (shortened) {
            text = this.shortenFromTheRight ? text + "..." : "..." + text;
        }
        int textColor = 0xFFFFFF;
        DropDownWidget.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (String)text, (int)(xWithOffset + 1 + this.field_230688_j_ / 2), (int)(yWithOffset + 2 + 11 * pos), (int)textColor);
    }

    private void drawMenu(MatrixStack matrixStack, int amount, int mouseX, int mouseY, int scaledHeight, int optionLimit) {
        int first;
        boolean scrolling = this.scrolling(optionLimit);
        int totalH = 11 * (amount + (scrolling ? 2 : 0));
        int height = scaledHeight;
        this.yOffset = !this.openingUp && this.field_230691_m_ + totalH + 1 > height ? height - this.field_230691_m_ - totalH - 1 : (this.openingUp && this.field_230691_m_ - totalH < 0 ? totalH - this.field_230691_m_ : 0);
        int xWithOffset = this.getXWithOffset();
        int yWithOffset = this.getYWithOffset();
        int n = first = this.closed ? 0 : this.scroll;
        if (scrolling) {
            this.drawSlot(matrixStack, (this.scroll == 0 ? "\u00a78" : "\u00a77") + I18n.func_135052_a((String)(this.openingUp ? "gui.xaero_down" : "gui.xaero_up"), (Object[])new Object[0]), -1, 0, mouseX, mouseY, scrolling, optionLimit, xWithOffset, yWithOffset);
            this.drawSlot(matrixStack, (this.scroll + optionLimit >= this.options.length ? "\u00a78" : "\u00a77") + I18n.func_135052_a((String)(this.openingUp ? "gui.xaero_up" : "gui.xaero_down"), (Object[])new Object[0]), -2, amount + 1, mouseX, mouseY, scrolling, optionLimit, xWithOffset, yWithOffset);
        }
        for (int i = first; i < first + amount; ++i) {
            String slotText = this.hasEmptyOption && i == 0 ? (!this.closed ? "-" : I18n.func_135052_a((String)this.realOptions[this.selected], (Object[])new Object[0]).replace("\u00a7\u00a7", ":")) : I18n.func_135052_a((String)this.options[i], (Object[])new Object[0]).replace("\u00a7\u00a7", ":");
            this.drawSlot(matrixStack, slotText, i, i - first + (scrolling ? 1 : 0), mouseX, mouseY, scrolling, optionLimit, xWithOffset, yWithOffset);
        }
        int trimPosY = yWithOffset - (this.openingUp ? totalH : 0);
        int trim = this.closed ? -6250336 : -1;
        this.func_238473_b_(matrixStack, xWithOffset, trimPosY, trimPosY + totalH, trim);
        this.func_238473_b_(matrixStack, xWithOffset + this.field_230688_j_, trimPosY, trimPosY + totalH, trim);
        this.func_238465_a_(matrixStack, xWithOffset, xWithOffset + this.field_230688_j_, trimPosY, trim);
        this.func_238465_a_(matrixStack, xWithOffset, xWithOffset + this.field_230688_j_, trimPosY + totalH, trim);
    }

    private boolean scrolling(int optionLimit) {
        return this.options.length > optionLimit && !this.closed;
    }

    public void mouseClicked(int mouseX, int mouseY, int mouseButton, int scaledHeight) {
        if (!this.closed) {
            int optionLimit = this.optionLimit(scaledHeight);
            int clickedId = this.getHoveredId(mouseX, mouseY, this.scrolling(optionLimit), optionLimit);
            if (clickedId >= 0) {
                this.selectId(clickedId - (this.hasEmptyOption ? 1 : 0), true);
            } else {
                this.autoScrolling = clickedId == -1 ? 1 : -1;
                this.scrollTime = System.currentTimeMillis();
                this.mouseScrolledInternal(this.autoScrolling, mouseX, mouseY, optionLimit);
            }
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        } else if (this.options.length > 1 && this.field_230693_o_) {
            this.setClosed(false);
            this.scroll = 0;
        }
    }

    public void mouseReleased(int mouseX, int mouseY, int mouseButton, int scaledHeight) {
        this.autoScrolling = 0;
    }

    private int getHoveredId(int mouseX, int mouseY, boolean scrolling, int optionLimit) {
        int yOnMenu = mouseY - this.getYWithOffset();
        int visibleSlotIndex = (this.openingUp ? -yOnMenu - 1 : yOnMenu) / 11;
        if (scrolling && visibleSlotIndex == 0) {
            return -1;
        }
        if (visibleSlotIndex >= optionLimit + (scrolling ? 1 : 0)) {
            return -2;
        }
        int slot = this.scroll + visibleSlotIndex - (scrolling ? 1 : 0);
        if (slot >= this.options.length) {
            slot = this.options.length - 1;
        }
        return slot;
    }

    public boolean onDropDown(int mouseX, int mouseY, int scaledHeight) {
        int optionLimit = this.optionLimit(scaledHeight);
        return this.onDropDown(mouseX, mouseY, this.scrolling(optionLimit), optionLimit);
    }

    public boolean onDropDown(int mouseX, int mouseY, boolean scrolling, int optionLimit) {
        int menuHeight;
        int menuTop = this.getYWithOffset();
        int n = this.closed ? 11 : (menuHeight = (Math.min(this.options.length, optionLimit) + (scrolling ? 2 : 0)) * 11);
        if (this.openingUp) {
            menuTop -= menuHeight;
        }
        int xOnMenu = mouseX - this.getXWithOffset();
        int yOnMenu = mouseY - menuTop;
        return xOnMenu >= 0 && yOnMenu >= 0 && xOnMenu <= this.field_230688_j_ && yOnMenu < menuHeight;
    }

    private boolean onDropDownSlot(int mouseX, int mouseY, int id, boolean scrolling, int optionLimit) {
        if (!this.onDropDown(mouseX, mouseY, scrolling, optionLimit)) {
            return false;
        }
        int hoveredSlot = this.getHoveredId(mouseX, mouseY, scrolling, optionLimit);
        return hoveredSlot == id;
    }

    public void selectId(int id, boolean callCallback) {
        boolean newId;
        if (id == -1) {
            this.setClosed(true);
            return;
        }
        boolean bl = newId = id != this.selected;
        if (newId && (!callCallback || this.callback.onSelected(this, id))) {
            this.selected = id;
        }
        this.setClosed(true);
        this.func_230994_c_(200);
    }

    public void func_230430_a_(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partial) {
        int scaledHeight = Minecraft.func_71410_x().field_71462_r.field_230709_l_;
        boolean bl = this.field_230692_n_ = this.field_230694_p_ && this.onDropDown(mouseX, mouseY, scaledHeight);
        if (!this.field_230694_p_) {
            return;
        }
        this.render(matrixStack, mouseX, mouseY, Minecraft.func_71410_x().field_71462_r.field_230709_l_, true);
        if (this.func_230458_i_() != null) {
            if (this.wasHovered != this.func_230449_g_()) {
                if (this.func_230449_g_()) {
                    if (this.func_230999_j_()) {
                        this.func_230994_c_(200);
                    } else {
                        this.func_230994_c_(750);
                    }
                } else {
                    this.field_230696_r_ = Long.MAX_VALUE;
                }
            }
            this.wasHovered = this.func_230449_g_();
            this.func_230997_f_();
        }
    }

    public void render(MatrixStack matrixStack, int mouseX, int mouseY, int scaledHeight, boolean closedOnly) {
        if (!this.closed && closedOnly) {
            return;
        }
        int optionLimit = this.optionLimit(scaledHeight);
        if (this.autoScrolling != 0 && System.currentTimeMillis() - this.scrollTime > 100L) {
            this.scrollTime = System.currentTimeMillis();
            this.mouseScrolledInternal(this.autoScrolling, mouseX, mouseY, optionLimit);
        }
        this.drawMenu(matrixStack, this.closed ? 1 : Math.min(optionLimit, this.options.length), mouseX, mouseY, scaledHeight, optionLimit);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        if (this.closed != closed) {
            if (!closed) {
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                this.container.onDropdownOpen(this);
            } else {
                this.container.onDropdownClosed(this);
            }
        }
        this.closed = closed;
    }

    public void mouseScrolled(int wheel, int mouseXScaled, int mouseYScaled, int scaledHeight) {
        this.mouseScrolledInternal(wheel * (this.openingUp ? -1 : 1), mouseXScaled, mouseYScaled, this.optionLimit(scaledHeight));
    }

    private void mouseScrolledInternal(int wheel, int mouseXScaled, int mouseYScaled, int optionLimit) {
        int newScroll = this.scroll - wheel;
        if (newScroll + optionLimit > this.options.length) {
            newScroll = this.options.length - optionLimit;
        }
        if (newScroll < 0) {
            newScroll = 0;
        }
        this.scroll = newScroll;
    }

    private int optionLimit(int scaledHeight) {
        return Math.max(1, scaledHeight / 11 - 2);
    }

    public int getSelected() {
        return this.selected;
    }

    protected IFormattableTextComponent func_230442_c_() {
        StringTextComponent narrationMessage = new StringTextComponent("");
        narrationMessage.func_150253_a().add(this.func_230458_i_());
        narrationMessage.func_150253_a().add(new StringTextComponent(". "));
        narrationMessage.func_150253_a().add(new TranslationTextComponent("gui.xaero_dropdown_selected_narration", new Object[]{this.realOptions[this.selected].replaceAll("(\u00a7[0-9a-gr])+", "")}));
        return narrationMessage;
    }

    public void func_212927_b(double $$0, double $$1) {
        super.func_212927_b($$0, $$1);
    }

    public boolean func_231043_a_(double mouseXScaled, double mouseYScaled, double wheel) {
        if (!this.isClosed()) {
            this.mouseScrolled((int)wheel, (int)mouseXScaled, (int)mouseYScaled, Minecraft.func_71410_x().field_71462_r.field_230709_l_);
            return true;
        }
        return super.func_231043_a_(mouseXScaled, mouseYScaled, wheel);
    }

    public boolean func_231046_a_(int $$0, int $$1, int $$2) {
        if ($$0 == 257 || $$0 == 32) {
            int nextSelection;
            if (Screen.func_231173_s_()) {
                nextSelection = this.getSelected() - 1;
                if (nextSelection < 0) {
                    nextSelection = this.realOptions.length - 1;
                }
            } else {
                nextSelection = (this.getSelected() + 1) % this.realOptions.length;
            }
            this.selectId(nextSelection, true);
            return true;
        }
        return super.func_231046_a_($$0, $$1, $$2);
    }

    public boolean func_223281_a_(int $$0, int $$1, int $$2) {
        return super.func_223281_a_($$0, $$1, $$2);
    }

    public boolean func_231042_a_(char $$0, int $$1) {
        return super.func_231042_a_($$0, $$1);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (this.field_230692_n_) {
            int scaledHeight = Minecraft.func_71410_x().field_71462_r.field_230709_l_;
            this.mouseClicked((int)mouseX, (int)mouseY, button, scaledHeight);
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        int scaledHeight = Minecraft.func_71410_x().field_71462_r.field_230709_l_;
        this.mouseReleased((int)mouseX, (int)mouseY, button, scaledHeight);
        return false;
    }

    public void setActive(boolean b) {
        this.field_230693_o_ = b;
    }

    public static final class Builder {
        private String[] options;
        private int x;
        private int y;
        private int w;
        private Integer selected;
        private boolean openingUp;
        private IDropDownWidgetCallback callback;
        private IDropDownContainer container;
        private boolean hasEmptyOption;
        private TextComponent narrationTitle;

        private Builder() {
        }

        public Builder setDefault() {
            this.setOptions(null);
            this.setX(0);
            this.setY(0);
            this.setW(0);
            this.setSelected(null);
            this.setOpeningUp(false);
            this.setCallback(null);
            this.setHasEmptyOption(true);
            this.setNarrationTitle(null);
            return this;
        }

        public Builder setOptions(String[] options) {
            this.options = options;
            return this;
        }

        public Builder setX(int x) {
            this.x = x;
            return this;
        }

        public Builder setY(int y) {
            this.y = y;
            return this;
        }

        public Builder setW(int w) {
            this.w = w;
            return this;
        }

        public Builder setSelected(Integer selected) {
            this.selected = selected;
            return this;
        }

        public Builder setOpeningUp(boolean openingUp) {
            this.openingUp = openingUp;
            return this;
        }

        public Builder setCallback(IDropDownWidgetCallback callback) {
            this.callback = callback;
            return this;
        }

        public Builder setContainer(IDropDownContainer container) {
            this.container = container;
            return this;
        }

        public Builder setHasEmptyOption(boolean hasEmptyOption) {
            this.hasEmptyOption = hasEmptyOption;
            return this;
        }

        public Builder setNarrationTitle(TextComponent narrationTitle) {
            this.narrationTitle = narrationTitle;
            return this;
        }

        public DropDownWidget build() {
            if (this.options == null || this.w == 0 || this.selected == null || this.callback == null || this.narrationTitle == null || this.container == null) {
                throw new IllegalStateException();
            }
            return new DropDownWidget(this.options, this.x, this.y, this.w, this.selected, this.openingUp, this.callback, this.container, this.hasEmptyOption, this.narrationTitle);
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

