/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.info.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import xaero.common.XaeroMinimapSession;
import xaero.common.graphics.CustomRenderTypes;
import xaero.common.minimap.MinimapInterface;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.info.InfoDisplay;
import xaero.common.minimap.info.render.compile.InfoDisplayCompiler;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.misc.Misc;
import xaero.common.settings.ModSettings;

public final class InfoDisplayRenderer {
    private final InfoDisplayCompiler compiler = new InfoDisplayCompiler();

    public void render(MatrixStack matrixStack, XaeroMinimapSession session, MinimapProcessor processor, MinimapInterface minimapInterface, MinimapRendererHelper helper, int x, int y, int width, int height, double scale, int size, int playerBlockX, int playerBlockY, int playerBlockZ, BlockPos playerPos, int scaledX, int scaledY, float mapScale, ModSettings settings, IRenderTypeBuffer.Impl renderTypeBuffer) {
        Iterator iterator = minimapInterface.getInfoDisplayManager().getStream().iterator();
        int interfaceSize = size;
        int scaledHeight = (int)((float)height * mapScale);
        int align = settings.minimapTextAlign;
        boolean under = scaledY + interfaceSize / 2 < scaledHeight / 2;
        int stringY = scaledY + (under ? interfaceSize : -9);
        int bgOpacityMask = settings.infoDisplayBackgroundOpacity * 255 / 100 << 24;
        while (iterator.hasNext()) {
            InfoDisplay infoDisplay = (InfoDisplay)iterator.next();
            List<ITextComponent> compiledLines = this.compiler.compile(infoDisplay, session, processor, x, y, width, height, scale, size, playerBlockX, playerBlockY, playerBlockZ, playerPos);
            int textColorIndex = infoDisplay.getTextColor();
            int backgroundColorIndex = infoDisplay.getBackgroundColor();
            int textColor = ModSettings.COLORS[textColorIndex < 0 ? 15 : textColorIndex % ModSettings.COLORS.length];
            int backgroundColor = backgroundColorIndex < 0 ? 0 : bgOpacityMask | ModSettings.COLORS[backgroundColorIndex % ModSettings.COLORS.length] & 0xFFFFFF;
            IVertexBuilder backgroundVertexBuffer = renderTypeBuffer.getBuffer(CustomRenderTypes.COLORED_WAYPOINTS_BGS);
            for (int i = 0; i < compiledLines.size(); ++i) {
                ITextComponent s = compiledLines.get(i);
                int stringWidth = Minecraft.func_71410_x().field_71466_p.func_238414_a_((ITextProperties)s);
                int stringX = scaledX + (align == 0 ? interfaceSize / 2 - stringWidth / 2 : (align == 1 ? 6 : interfaceSize - 6 - stringWidth));
                if (backgroundColor != 0) {
                    matrixStack.func_227861_a_(0.0, 0.0, -1.0);
                    helper.addColoredRectToExistingBuffer(matrixStack.func_227866_c_().func_227870_a_(), backgroundVertexBuffer, stringX - 1, stringY - 1, stringWidth + 2, 10, backgroundColor);
                    matrixStack.func_227861_a_(0.0, 0.0, 1.0);
                }
                Misc.drawNormalText(matrixStack, s, (float)stringX, (float)stringY, textColor, true, renderTypeBuffer);
                stringY += 10 * (under ? 1 : -1);
            }
            compiledLines.clear();
        }
        renderTypeBuffer.func_228461_a_();
    }
}

