/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.write.biome;

import net.minecraft.block.BlockState;
import net.minecraft.fluid.FluidState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.lighting.WorldLightManager;

public class BiomeBlendCalculator
implements IBlockDisplayReader {
    private World original;
    private int startI;
    private int endI;
    private int startJ;
    private int endJ;

    public void prepare(World original, boolean biomeBlending) {
        this.original = original;
        this.endJ = 0;
        this.startJ = 0;
        this.endI = 0;
        this.startI = 0;
        if (biomeBlending) {
            this.startI = -1;
            this.endI = 1;
            this.startJ = -1;
            this.endJ = 1;
        }
    }

    public TileEntity func_175625_s(BlockPos blockPos) {
        return this.original.func_175625_s(blockPos);
    }

    public BlockState func_180495_p(BlockPos blockPos) {
        return this.original.func_180495_p(blockPos);
    }

    public FluidState func_204610_c(BlockPos blockPos) {
        return this.original.func_204610_c(blockPos);
    }

    public float func_230487_a_(Direction direction, boolean bl) {
        return this.original.func_230487_a_(direction, bl);
    }

    public WorldLightManager func_225524_e_() {
        return this.original.func_225524_e_();
    }

    public int func_225525_a_(BlockPos blockPos, ColorResolver colorResolver) {
        BlockPos.Mutable mutableBlockPos = new BlockPos.Mutable();
        int x = blockPos.func_177958_n();
        int y = blockPos.func_177956_o();
        int z = blockPos.func_177952_p();
        int redAccumulator = 0;
        int greenAccumulator = 0;
        int blueAccumulator = 0;
        World original = this.original;
        int total = 0;
        for (int i = this.startI; i <= this.endI; ++i) {
            for (int j = this.startJ; j <= this.endJ; ++j) {
                if (i != 0 && j != 0) continue;
                mutableBlockPos.func_181079_c(x + i, y, z + j);
                Biome biome = original.func_226691_t_((BlockPos)mutableBlockPos);
                int colorSample = colorResolver.getColor(biome, (double)mutableBlockPos.func_177958_n(), (double)mutableBlockPos.func_177952_p());
                redAccumulator += colorSample & 0xFF0000;
                greenAccumulator += colorSample & 0xFF00;
                blueAccumulator += colorSample & 0xFF;
                ++total;
            }
        }
        int red = redAccumulator / total;
        int green = greenAccumulator / total;
        int blue = blueAccumulator / total;
        return 0xFF000000 | red & 0xFF0000 | green & 0xFF00 | blue;
    }
}

