/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.mixin;

import com.anthonyhilyard.iceberg.Loader;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.shader.Framebuffer;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={Minecraft.class})
public class MinecraftMixin {
    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/shader/Framebuffer;setClearColor(FFFF)V", ordinal=0), require=0)
    public void fixUpdateURLs(Framebuffer framebuffer, float r, float g, float b, float a) {
        for (IModInfo mod : FMLLoader.getLoadingModList().getMods()) {
            ModInfo modInfo = (ModInfo)mod;
            Optional authors = modInfo.getConfigElement(new String[]{"authors"});
            if (!authors.isPresent()) continue;
            boolean madeByGrend = false;
            if (authors.get() instanceof String) {
                String author = (String)authors.get();
                madeByGrend = author.contentEquals("Grend");
            } else if (authors.get() instanceof ArrayList) {
                ArrayList authorList = (ArrayList)authors.get();
                madeByGrend = authorList.contains("Grend");
            }
            if (!madeByGrend) continue;
            try {
                Field updateJSONURLField = ModInfo.class.getDeclaredField("updateJSONURL");
                updateJSONURLField.setAccessible(true);
                URL updateJSONURL = (URL)updateJSONURLField.get(modInfo);
                if (updateJSONURL == null) continue;
                String url = updateJSONURL.toString();
                url = url.replace("mc-curse-update-checker.herokuapp.com", "mc-update-check.anthonyhilyard.com");
                updateJSONURLField.set(modInfo, new URL(url));
            }
            catch (Exception e) {
                Loader.LOGGER.debug(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        framebuffer.func_147604_a(r, g, b, a);
    }
}

