/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.discordrpc;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;

public class ClientConfig {
    public static final ForgeConfigSpec CONFIG_SPEC;
    public static final ClientConfig CONFIG;
    public static ForgeConfigSpec.ConfigValue<String> NAME;
    public static ForgeConfigSpec.ConfigValue<String> SERVER_MESSAGE;
    public static ForgeConfigSpec.BooleanValue LOGTOCHAT;
    public static ForgeConfigSpec.ConfigValue<String> MENU_TEXT;
    public static ForgeConfigSpec.ConfigValue<String> WORLD_MESSAGE;
    public static ForgeConfigSpec.BooleanValue PREVENT_CLIENT_NAME_CHANGE;
    public static ForgeConfigSpec.ConfigValue<String> CLIENT_ID;
    public static ForgeConfigSpec.BooleanValue CONFIG_GUI_DISABLED;
    public static ForgeConfigSpec.BooleanValue ENABLE_HYPIXEL_INTEGRATION;
    public static ForgeConfigSpec.BooleanValue ENABLE_HIVEMC_INTEGRATION;
    public static ForgeConfigSpec.BooleanValue ENABLE_CUSTOM_INTEGRATION;

    ClientConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("Discord RichPresence Config File").push("Rich-Presence");
        NAME = builder.comment("First line of Rich Presence").define("Client-Name", (Object)"Forge 1.16");
        SERVER_MESSAGE = builder.comment("Placeholders:\n%ip%  Server IP").define("Server-Text", (Object)"Playing on %ip%");
        MENU_TEXT = builder.comment("No placeholders supported, Text that shows when you are in the main menu").define("Main-Menu", (Object)"In Main Menu");
        WORLD_MESSAGE = builder.comment("Placeholders:\n%coords% (X:??? Y:??? Z:???)\n%world% World name").define("Singleplayer-Text", (Object)"Playing in %world% (%coords%)");
        PREVENT_CLIENT_NAME_CHANGE = builder.comment("Setting this to true disables name changing through GUI").define("Disable-Name-changing", false);
        LOGTOCHAT = builder.comment("Do you want to print log of this mod to ingame chat?").define("LogToChat", false);
        CLIENT_ID = builder.comment(new String[]{"Custom client id, see https://github.com/ErdbeerbaerLP/DiscordRichPresence/wiki/Set-up-custom-Icons-(for-Modpacks) for more info", "Default: 511106082366554122"}).define("client-id", (Object)"511106082366554122");
        CONFIG_GUI_DISABLED = builder.comment("Disables config GUI\nRequires config file editing to enable again").define("Disable-Config-GUI", false);
        ENABLE_HYPIXEL_INTEGRATION = builder.comment("Do you want to use custom Hypixel integration (show what game you are playing and such)?").define("Hypixel-Integration", true);
        ENABLE_HIVEMC_INTEGRATION = builder.comment("Do you want to use custom Hivemc integration (show what game you are playing)?").define("Hivemc-Integration", true);
        ENABLE_CUSTOM_INTEGRATION = builder.comment("Do you want servers to send you a customized rich presence text?\nAlso toggles hardcoded custom icons and text of not fully integrated servers like mineplex").define("Custom-Messages-From-Server", true);
        builder.pop();
    }

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading configEvent) {
        LogManager.getLogger().info("Loaded drpc config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfig.Reloading configEvent) {
        System.out.println("DRPC config just got changed on the file system!");
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        System.out.println("Loading clientside config file...");
        CONFIG = (ClientConfig)specPair.getLeft();
        CONFIG_SPEC = (ForgeConfigSpec)specPair.getRight();
    }
}

