/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.discordrpc;

import de.erdbeerbaerlp.discordrpc.ClientConfig;
import de.erdbeerbaerlp.discordrpc.ConfigGui;
import de.erdbeerbaerlp.discordrpc.DRPCEventHandler;
import de.erdbeerbaerlp.discordrpc.DRPCLog;
import de.erdbeerbaerlp.discordrpc.Discord;
import de.erdbeerbaerlp.discordrpc.Message_Icon;
import de.erdbeerbaerlp.discordrpc.Message_Message;
import de.erdbeerbaerlp.discordrpc.ServerConfig;
import de.erdbeerbaerlp.guilib.IHasConfigGUI;
import drpcshadow.com.google.common.base.Predicate;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;

@Mod(value="discordrpc")
public class DRPC
implements IHasConfigGUI {
    public static final String MODID = "discordrpc";
    public static final long gameStarted = Instant.now().toEpochMilli();
    private static final String protVersion = "1.0.0";
    private static final Predicate<String> pred = ver -> ver.equals(protVersion) || ver.equals(NetworkRegistry.ACCEPTVANILLA) || ver.equals(NetworkRegistry.ABSENT);
    protected static final SimpleChannel MSG = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("discordrpc", "discord-msg"), () -> "1.0.0", pred, pred);
    protected static final SimpleChannel ICON = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("discordrpc", "discord-icon"), () -> "1.0.0", pred, pred);
    public static boolean started = false;
    protected static boolean isEnabled = true;
    protected static boolean isClient = true;
    protected static boolean preventConfigLoad = false;

    public DRPC() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::serverSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::postInit);
        ICON.registerMessage(1, Message_Icon.class, (a, b) -> a.encode((Message_Icon)a, (PacketBuffer)b), a -> new Message_Icon(DRPC.readString((ByteBuf)a)), (a, b) -> a.onMessageReceived((Message_Icon)a, (Supplier<NetworkEvent.Context>)b));
        MSG.registerMessage(1, Message_Message.class, (a, b) -> a.encode((Message_Message)a, (PacketBuffer)b), a -> new Message_Message(DRPC.readString((ByteBuf)a)), (a, b) -> a.onMessageReceived((Message_Message)a, (Supplier<NetworkEvent.Context>)b));
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, ClientConfig.CONFIG_SPEC, "DiscordRPC.toml");
            MinecraftForge.EVENT_BUS.register(ClientConfig.class);
            MinecraftForge.EVENT_BUS.addListener(ClientConfig::onFileChange);
            MinecraftForge.EVENT_BUS.addListener(ClientConfig::onLoad);
            MinecraftForge.EVENT_BUS.register(DRPCEventHandler.class);
        });
        DistExecutor.runWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> {
            ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, ServerConfig.CONFIG_SPEC, "DiscordRPC-Server.toml");
            MinecraftForge.EVENT_BUS.register(ServerConfig.class);
            MinecraftForge.EVENT_BUS.addListener(ServerConfig::onFileChange);
            MinecraftForge.EVENT_BUS.addListener(ServerConfig::onLoad);
            MinecraftForge.EVENT_BUS.addListener(DRPC::playerChangeDimension);
            MinecraftForge.EVENT_BUS.addListener(DRPC::playerJoin);
        });
    }

    private static String readString(ByteBuf b) {
        ArrayList<Byte> list = new ArrayList<Byte>();
        while (b.isReadable()) {
            list.add(b.readByte());
        }
        byte[] out = new byte[list.size()];
        int i1 = 0;
        if ((Byte)list.get(0) == 0) {
            i1 = 1;
        }
        for (int i = i1; i < list.size(); ++i) {
            out[i] = (Byte)list.get(i);
        }
        return new String(out, StandardCharsets.UTF_8).trim();
    }

    private static void sendPackets(ServerPlayerEntity p) {
        new Thread(() -> {
            try {
                Thread.sleep(1500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            PacketDistributor.PLAYER.with(() -> p).send(MSG.toVanillaPacket((Object)new Message_Message((String)ServerConfig.SERVER_MESSAGE.get()), NetworkDirection.PLAY_TO_CLIENT));
            PacketDistributor.PLAYER.with(() -> p).send(ICON.toVanillaPacket((Object)new Message_Icon((String)ServerConfig.SERVER_ICON.get()), NetworkDirection.PLAY_TO_CLIENT));
        }).start();
    }

    @SubscribeEvent
    public static void playerJoin(PlayerEvent.PlayerLoggedInEvent ev) {
        DistExecutor.runWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> DRPC.sendPackets((ServerPlayerEntity)ev.getPlayer()));
    }

    @SubscribeEvent
    public static void playerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent ev) {
        DistExecutor.runWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> DRPC.sendPackets((ServerPlayerEntity)ev.getPlayer()));
    }

    private void setup(FMLCommonSetupEvent event) {
    }

    private void clientSetup(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register(DRPCEventHandler.class);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            DRPCLog.Info("Shutting down DiscordHook.");
            Discord.shutdown();
        }));
        if (isEnabled) {
            Discord.initDiscord();
        }
        if (isEnabled) {
            Discord.setPresence((String)ClientConfig.NAME.get(), "Starting game...", "34565655649643693", false);
        }
    }

    public void serverSetup(FMLDedicatedServerSetupEvent event) {
        isClient = false;
    }

    public void postInit(InterModProcessEvent event) {
        if (isEnabled && isClient) {
            Discord.setPresence((String)ClientConfig.NAME.get(), "Starting game...", "3454083453475893469");
        }
        started = true;
    }

    public Screen getConfigGUI(Screen screen) {
        return (Boolean)ClientConfig.CONFIG_GUI_DISABLED.get() != false ? null : new ConfigGui(screen);
    }
}

