/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.discordrpc;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.text.TextFormatting;

public class ScoreboardUtils {
    public static List<String> getSidebarScores(Scoreboard scoreboard) {
        List<String> found = new ArrayList<String>();
        ScoreObjective sidebar = scoreboard.func_96539_a(1);
        if (sidebar != null) {
            ArrayList<Score> scores = new ArrayList<Score>(scoreboard.func_96534_i(sidebar));
            scores.sort(Comparator.comparingInt(Score::func_96652_c));
            found = scores.stream().filter(score -> {
                if (score.func_96645_d() == null || score.func_96645_d().func_96679_b() == null) {
                    return false;
                }
                return score.func_96645_d().func_96679_b().equals(sidebar.func_96679_b());
            }).map(score -> ScoreboardUtils.getPrefixFromContainingTeam(scoreboard, score.func_96653_e()) + ScoreboardUtils.getSuffixFromContainingTeam(scoreboard, score.func_96653_e())).collect(Collectors.toList());
        }
        return found;
    }

    private static String getSuffixFromContainingTeam(Scoreboard scoreboard, String member) {
        String suffix = null;
        for (ScorePlayerTeam team : scoreboard.func_96525_g()) {
            if (!team.func_96670_d().contains(member)) continue;
            suffix = TextFormatting.func_110646_a((String)team.func_207407_f().getString());
            break;
        }
        return suffix == null ? "" : suffix;
    }

    private static String getPrefixFromContainingTeam(Scoreboard scoreboard, String member) {
        String suffix = null;
        for (ScorePlayerTeam team : scoreboard.func_96525_g()) {
            if (!team.func_96670_d().contains(member)) continue;
            suffix = TextFormatting.func_110646_a((String)team.func_207406_e().getString());
            break;
        }
        return suffix == null ? "" : suffix;
    }
}

