/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.discordrpc;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;

public class ServerConfig {
    public static final ForgeConfigSpec CONFIG_SPEC;
    public static final ServerConfig CONFIG;
    public static ForgeConfigSpec.ConfigValue<String> SERVER_MESSAGE;
    public static ForgeConfigSpec.ConfigValue<String> SERVER_ICON;

    ServerConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("Server RichPresence config").push("RichPresence");
        SERVER_MESSAGE = builder.comment("The second line you have in the rich presence.\n Placeholders are:\n%players% - Amount of all players\n%otherpl% - Amount of players -1 (except you)").define("Message", (Object)"Playing on a random Server with %otherpl% other players");
        SERVER_ICON = builder.comment("The Icon-Key. Use 'world' or 'cube' if you don't have an special one.").define("IconKey", (Object)"world");
        builder.pop();
    }

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading configEvent) {
        LogManager.getLogger().info("Loaded drpc config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfig.Reloading configEvent) {
        System.out.println("DRPC config just got changed on the file system!");
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        System.out.println("Loading serverside config file...");
        CONFIG = (ServerConfig)specPair.getLeft();
        CONFIG_SPEC = (ForgeConfigSpec)specPair.getRight();
    }
}

