/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.data;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.File;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.world.storage.WorldSavedData;

public class TickingData
extends WorldSavedData {
    private final Object2IntMap<UUID> tickMap = new Object2IntOpenHashMap();

    public TickingData(String id) {
        super(id);
        this.tickMap.defaultReturnValue(-1);
    }

    public boolean isDone(UUID id) {
        int tick = this.tickMap.getInt((Object)id);
        return tick == 0 || tick == 1;
    }

    public int getValue(UUID id) {
        return this.tickMap.getInt((Object)id);
    }

    public boolean setValue(UUID id, int decayAmount) {
        return this.tickMap.put((Object)id, decayAmount) == -1;
    }

    public int removeDone(UUID id) {
        return this.tickMap.removeInt((Object)id);
    }

    public boolean tick() {
        if (this.tickMap.isEmpty()) {
            return false;
        }
        Object2IntOpenHashMap newMap = new Object2IntOpenHashMap();
        newMap.defaultReturnValue(-1);
        boolean changed = false;
        for (Object2IntMap.Entry entry : this.tickMap.object2IntEntrySet()) {
            int value = entry.getIntValue();
            if (value > 0) {
                --value;
                changed = true;
            }
            newMap.put(entry.getKey(), value);
        }
        if (changed) {
            this.tickMap.clear();
            this.tickMap.putAll((Map)newMap);
            return true;
        }
        return false;
    }

    public void func_76184_a(CompoundNBT pCompound) {
        this.tickMap.clear();
        this.tickMap.defaultReturnValue(-1);
        ListNBT decayList = pCompound.func_150295_c("result", 10);
        for (int i = 0; i < decayList.size(); ++i) {
            CompoundNBT thisTag = decayList.func_150305_b(i);
            this.tickMap.put((Object)thisTag.func_186857_a("id"), thisTag.func_74762_e("value"));
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT pCompound) {
        ListNBT decayList = new ListNBT();
        for (Object2IntMap.Entry entry : this.tickMap.object2IntEntrySet()) {
            CompoundNBT thisTag = new CompoundNBT();
            thisTag.func_186854_a("id", (UUID)entry.getKey());
            thisTag.func_74768_a("value", entry.getIntValue());
            decayList.add((Object)thisTag);
        }
        pCompound.func_218657_a("result", (INBT)decayList);
        return pCompound;
    }

    public void func_215158_a(File pFile) {
        if (this.func_76188_b()) {
            pFile.getParentFile().mkdirs();
        }
        super.func_215158_a(pFile);
    }
}

