/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.repack.shoulders.client.layers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.player.PlayerEntity;
import noobanidus.mods.lootr.repack.shoulders.client.models.IShoulderRidingModel;
import noobanidus.mods.lootr.repack.shoulders.data.ShoulderList;
import noobanidus.mods.lootr.repack.shoulders.info.ShoulderData;
import noobanidus.mods.lootr.repack.shoulders.info.ShoulderEntity;

public class NoobanidusShoulderLayer<T extends PlayerEntity>
extends LayerRenderer<T, PlayerModel<T>> {
    private static final Map<ShoulderEntity, IShoulderRidingModel> modelMap = new HashMap<ShoulderEntity, IShoulderRidingModel>();

    public NoobanidusShoulderLayer(IEntityRenderer<T, PlayerModel<T>> p_i50929_1_) {
        super(p_i50929_1_);
    }

    @Nullable
    private IShoulderRidingModel getModelFor(ShoulderData data) {
        return modelMap.computeIfAbsent(data.getEntity(), k -> k.getModel().get());
    }

    public void render(@Nonnull MatrixStack pMatrixStack, @Nonnull IRenderTypeBuffer pBuffer, int pPackedLight, @Nonnull T pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        ShoulderData data = ShoulderList.getData(pLivingEntity);
        if (data != null) {
            if (data.getShoulder().left() && !pLivingEntity.func_192023_dk().isEmpty() || data.getShoulder().right() && !pLivingEntity.func_192025_dl().isEmpty()) {
                return;
            }
            IShoulderRidingModel model = this.getModelFor(data);
            if (model != null) {
                pMatrixStack.func_227860_a_();
                data.getEntity().getTransformers().transform(pMatrixStack, data, (PlayerEntity)pLivingEntity, data.getEntity().getArmorOffset());
                IVertexBuilder vertex = pBuffer.getBuffer(model.getRenderType(data));
                model.renderOnShoulder(pMatrixStack, data, vertex, pPackedLight, OverlayTexture.field_229196_a_, pLimbSwing, pLimbSwingAmount, pNetHeadYaw, pHeadPitch, ((PlayerEntity)pLivingEntity).field_70173_aa);
                model.renderExtra(data, pMatrixStack, pBuffer, pPackedLight, (PlayerEntity)pLivingEntity, pLimbSwing, pLimbSwingAmount, pPartialTicks, pAgeInTicks, pNetHeadYaw, pHeadPitch);
                pMatrixStack.func_227865_b_();
            }
        }
    }
}

