/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.util;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.BarrelBlock;
import net.minecraft.block.Block;
import net.minecraft.block.ChestBlock;
import net.minecraft.entity.monster.piglin.PiglinTasks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.PacketDistributor;
import noobanidus.mods.lootr.api.tile.ILootTile;
import noobanidus.mods.lootr.block.LootrShulkerBlock;
import noobanidus.mods.lootr.block.tile.LootrInventoryTileEntity;
import noobanidus.mods.lootr.config.ConfigManager;
import noobanidus.mods.lootr.data.DataStorage;
import noobanidus.mods.lootr.data.SpecialChestInventory;
import noobanidus.mods.lootr.entity.LootrChestMinecartEntity;
import noobanidus.mods.lootr.init.ModAdvancements;
import noobanidus.mods.lootr.init.ModStats;
import noobanidus.mods.lootr.networking.CloseCart;
import noobanidus.mods.lootr.networking.PacketHandler;

public class ChestUtil {
    public static Random random = new Random();
    public static Set<Class<?>> tileClasses = new HashSet();

    public static boolean handleLootSneak(Block block, World world, BlockPos pos, PlayerEntity player) {
        if (world.func_201670_d()) {
            return false;
        }
        if (player.func_175149_v()) {
            return false;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ILootTile) {
            Set<UUID> openers = ((ILootTile)te).getOpeners();
            openers.remove(player.func_110124_au());
            ((ILootTile)te).updatePacketViaState();
            return true;
        }
        return false;
    }

    public static void handleLootCartSneak(World world, LootrChestMinecartEntity cart, PlayerEntity player) {
        if (world.func_201670_d()) {
            return;
        }
        if (player.func_175149_v()) {
            return;
        }
        cart.getOpeners().remove(player.func_110124_au());
        CloseCart open = new CloseCart(cart.func_145782_y());
        PacketHandler.sendInternal(PacketDistributor.TRACKING_ENTITY.with(() -> cart), open);
    }

    public static boolean handleLootChest(Block block, World world, BlockPos pos, PlayerEntity player) {
        if (world.func_201670_d()) {
            return false;
        }
        if (player.func_175149_v()) {
            player.func_213829_a(null);
            return false;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ILootTile) {
            int refreshValue;
            UUID tileId = ((ILootTile)te).getTileId();
            if (DataStorage.isDecayed(tileId)) {
                world.func_175655_b(pos, true);
                DataStorage.removeDecayed(tileId);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("lootr.message.decayed").func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.RED).func_240713_a_(Boolean.valueOf(true))), true);
                return false;
            }
            int decayValue = DataStorage.getDecayValue(tileId);
            if (decayValue > 0 && ConfigManager.shouldNotify(decayValue)) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("lootr.message.decay_in", new Object[]{decayValue / 20}).func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.RED).func_240713_a_(Boolean.valueOf(true))), true);
            } else if (decayValue == -1 && ConfigManager.isDecaying(world, (ILootTile)te)) {
                DataStorage.setDecaying(tileId, (Integer)ConfigManager.DECAY_VALUE.get());
                player.func_146105_b((ITextComponent)new TranslationTextComponent("lootr.message.decay_start", new Object[]{(Integer)ConfigManager.DECAY_VALUE.get() / 20}).func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.RED).func_240713_a_(Boolean.valueOf(true))), true);
            }
            if (block instanceof BarrelBlock) {
                ModAdvancements.BARREL_PREDICATE.trigger((ServerPlayerEntity)player, ((ILootTile)te).getTileId());
            } else if (block instanceof ChestBlock) {
                ModAdvancements.CHEST_PREDICATE.trigger((ServerPlayerEntity)player, ((ILootTile)te).getTileId());
            } else if (block instanceof LootrShulkerBlock) {
                ModAdvancements.SHULKER_PREDICATE.trigger((ServerPlayerEntity)player, ((ILootTile)te).getTileId());
            }
            if (DataStorage.isRefreshed(tileId)) {
                DataStorage.refreshInventory(world, ((ILootTile)te).getTileId(), (ServerPlayerEntity)player, pos);
                DataStorage.removeRefreshed(tileId);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("lootr.message.refreshed").func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.BLUE).func_240713_a_(Boolean.valueOf(true))), true);
            }
            if ((refreshValue = DataStorage.getRefreshValue(tileId)) > 0 && ConfigManager.shouldNotify(refreshValue)) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("lootr.message.refresh_in", new Object[]{refreshValue / 20}).func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.BLUE).func_240713_a_(Boolean.valueOf(true))), true);
            } else if (refreshValue == -1 && ConfigManager.isRefreshing(world, (ILootTile)te)) {
                DataStorage.setRefreshing(tileId, (Integer)ConfigManager.REFRESH_VALUE.get());
                player.func_146105_b((ITextComponent)new TranslationTextComponent("lootr.message.refresh_start", new Object[]{(Integer)ConfigManager.REFRESH_VALUE.get() / 20}).func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.BLUE).func_240713_a_(Boolean.valueOf(true))), true);
            }
            SpecialChestInventory provider = DataStorage.getInventory(world, ((ILootTile)te).getTileId(), pos, (ServerPlayerEntity)player, (LockableLootTileEntity)te, ((ILootTile)te)::fillWithLoot);
            if (!DataStorage.isScored(player.func_110124_au(), ((ILootTile)te).getTileId())) {
                player.func_71029_a(ModStats.LOOTED_STAT);
                ModAdvancements.SCORE_PREDICATE.trigger((ServerPlayerEntity)player, null);
                DataStorage.score(player.func_110124_au(), ((ILootTile)te).getTileId());
            }
            player.func_213829_a((INamedContainerProvider)provider);
            PiglinTasks.func_234478_a_((PlayerEntity)player, (boolean)true);
            return true;
        }
        return false;
    }

    public static void handleLootCart(World world, LootrChestMinecartEntity cart, PlayerEntity player) {
        if (!world.func_201670_d()) {
            if (player.func_175149_v()) {
                player.func_213829_a(null);
            } else {
                int refreshValue;
                UUID tileId = cart.func_110124_au();
                if (DataStorage.isDecayed(tileId)) {
                    cart.func_94095_a(DamageSource.field_76380_i);
                    DataStorage.removeDecayed(tileId);
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("lootr.message.decayed").func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.RED).func_240713_a_(Boolean.valueOf(true))), true);
                    return;
                }
                int decayValue = DataStorage.getDecayValue(tileId);
                if (decayValue > 0 && ConfigManager.shouldNotify(decayValue)) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("lootr.message.decay_in", new Object[]{decayValue / 20}).func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.RED).func_240713_a_(Boolean.valueOf(true))), true);
                } else if (decayValue == -1 && ConfigManager.isDecaying(world, cart)) {
                    DataStorage.setDecaying(tileId, (Integer)ConfigManager.DECAY_VALUE.get());
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("lootr.message.decay_start", new Object[]{(Integer)ConfigManager.DECAY_VALUE.get() / 20}).func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.RED).func_240713_a_(Boolean.valueOf(true))), true);
                }
                ModAdvancements.CART_PREDICATE.trigger((ServerPlayerEntity)player, cart.func_110124_au());
                if (!cart.getOpeners().contains(player.func_110124_au())) {
                    cart.addOpener(player);
                }
                if (!DataStorage.isScored(player.func_110124_au(), cart.func_110124_au())) {
                    player.func_71029_a(ModStats.LOOTED_STAT);
                    ModAdvancements.SCORE_PREDICATE.trigger((ServerPlayerEntity)player, null);
                    DataStorage.score(player.func_110124_au(), cart.func_110124_au());
                }
                if (DataStorage.isRefreshed(tileId)) {
                    DataStorage.refreshInventory(world, cart, (ServerPlayerEntity)player, cart.func_233580_cy_());
                    DataStorage.removeRefreshed(tileId);
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("lootr.message.refreshed").func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.BLUE).func_240713_a_(Boolean.valueOf(true))), true);
                }
                if ((refreshValue = DataStorage.getRefreshValue(tileId)) > 0 && ConfigManager.shouldNotify(refreshValue)) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("lootr.message.refresh_in", new Object[]{refreshValue / 20}).func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.BLUE).func_240713_a_(Boolean.valueOf(true))), true);
                } else if (refreshValue == -1 && ConfigManager.isRefreshing(world, cart)) {
                    DataStorage.setRefreshing(tileId, (Integer)ConfigManager.REFRESH_VALUE.get());
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("lootr.message.refresh_start", new Object[]{(Integer)ConfigManager.REFRESH_VALUE.get() / 20}).func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.BLUE).func_240713_a_(Boolean.valueOf(true))), true);
                }
                SpecialChestInventory provider = DataStorage.getInventory(world, cart, (ServerPlayerEntity)player, cart::addLoot, cart.func_233580_cy_());
                player.func_213829_a((INamedContainerProvider)provider);
            }
        }
    }

    public static boolean handleLootInventory(Block block, World world, BlockPos pos, PlayerEntity player) {
        if (world.func_201670_d()) {
            return false;
        }
        if (player.func_175149_v()) {
            player.func_213829_a(null);
            return false;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof LootrInventoryTileEntity) {
            int refreshValue;
            UUID tileId;
            ModAdvancements.CHEST_PREDICATE.trigger((ServerPlayerEntity)player, ((LootrInventoryTileEntity)te).getTileId());
            LootrInventoryTileEntity tile = (LootrInventoryTileEntity)te;
            NonNullList<ItemStack> stacks = null;
            if (tile.getCustomInventory() != null) {
                stacks = ChestUtil.copyItemList(tile.getCustomInventory());
            }
            if (DataStorage.isRefreshed(tileId = tile.getTileId())) {
                DataStorage.refreshInventory(world, ((ILootTile)te).getTileId(), stacks, (ServerPlayerEntity)player, pos);
                DataStorage.removeRefreshed(tileId);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("lootr.message.refreshed").func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.BLUE).func_240713_a_(Boolean.valueOf(true))), true);
            }
            if ((refreshValue = DataStorage.getRefreshValue(tileId)) > 0 && ConfigManager.shouldNotify(refreshValue)) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("lootr.message.refresh_in", new Object[]{refreshValue / 20}).func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.BLUE).func_240713_a_(Boolean.valueOf(true))), true);
            } else if (refreshValue == -1 && ConfigManager.isRefreshing(world, tile)) {
                DataStorage.setRefreshing(tileId, (Integer)ConfigManager.REFRESH_VALUE.get());
                player.func_146105_b((ITextComponent)new TranslationTextComponent("lootr.message.refresh_start", new Object[]{(Integer)ConfigManager.REFRESH_VALUE.get() / 20}).func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.BLUE).func_240713_a_(Boolean.valueOf(true))), true);
            }
            SpecialChestInventory provider = DataStorage.getInventory(world, tile.getTileId(), stacks, (ServerPlayerEntity)player, pos, (LockableLootTileEntity)tile);
            if (!DataStorage.isScored(player.func_110124_au(), ((ILootTile)te).getTileId())) {
                player.func_71029_a(ModStats.LOOTED_STAT);
                ModAdvancements.SCORE_PREDICATE.trigger((ServerPlayerEntity)player, null);
                DataStorage.score(player.func_110124_au(), ((ILootTile)te).getTileId());
            }
            player.func_213829_a((INamedContainerProvider)provider);
            PiglinTasks.func_234478_a_((PlayerEntity)player, (boolean)true);
            return true;
        }
        return false;
    }

    public static NonNullList<ItemStack> copyItemList(NonNullList<ItemStack> reference) {
        NonNullList contents = NonNullList.func_191197_a((int)reference.size(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < reference.size(); ++i) {
            contents.set(i, (Object)((ItemStack)reference.get(i)).func_77946_l());
        }
        return contents;
    }
}

