/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import net.coderbot.iris.Iris;
import net.coderbot.iris.vendored.joml.Vector3i;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.ARBDirectStateAccess;
import org.lwjgl.opengl.EXTShaderImageLoadStore;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30C;
import org.lwjgl.opengl.GL40C;
import org.lwjgl.opengl.GL45C;

public class IrisRenderSystem {
    private static DSAAccess dsaState;
    private static boolean hasMultibind;
    private static boolean supportsCompute;

    public static void initRenderer() {
        if (GL.getCapabilities().OpenGL45) {
            dsaState = new DSACore();
            Iris.logger.info("OpenGL 4.5 detected, enabling DSA.");
        } else if (GL.getCapabilities().GL_ARB_direct_state_access) {
            dsaState = new DSAARB();
            Iris.logger.info("ARB_direct_state_access detected, enabling DSA.");
        } else {
            dsaState = new DSAUnsupported();
            Iris.logger.info("DSA support not detected.");
        }
        hasMultibind = GL.getCapabilities().OpenGL45 || GL.getCapabilities().GL_ARB_multi_bind;
        supportsCompute = IrisRenderSystem.supportsCompute();
    }

    public static void getIntegerv(int pname, int[] params) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30C.glGetIntegerv((int)pname, (int[])params);
    }

    public static void getFloatv(int pname, float[] params) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30C.glGetFloatv((int)pname, (float[])params);
    }

    public static void generateMipmaps(int texture, int mipmapTarget) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        dsaState.generateMipmaps(texture, mipmapTarget);
    }

    public static void bindAttributeLocation(int program, int index, CharSequence name) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30C.glBindAttribLocation((int)program, (int)index, (CharSequence)name);
    }

    public static void texImage2D(int texture, int target, int level, int internalformat, int width, int height, int border, int format, int type, @Nullable ByteBuffer pixels) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GlStateManager.func_227760_t_((int)texture);
        GL30C.glTexImage2D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (int)format, (int)type, (ByteBuffer)pixels);
    }

    public static void uniformMatrix4fv(int location, boolean transpose, FloatBuffer matrix) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30C.glUniformMatrix4fv((int)location, (boolean)transpose, (FloatBuffer)matrix);
    }

    public static void copyTexImage2D(int target, int level, int internalFormat, int x, int y, int width, int height, int border) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30C.glCopyTexImage2D((int)target, (int)level, (int)internalFormat, (int)x, (int)y, (int)width, (int)height, (int)border);
    }

    public static void uniform1f(int location, float v0) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30C.glUniform1f((int)location, (float)v0);
    }

    public static void uniform1i(int location, int v0) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30C.glUniform1i((int)location, (int)v0);
    }

    public static void uniform2f(int location, float v0, float v1) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30C.glUniform2f((int)location, (float)v0, (float)v1);
    }

    public static void uniform2i(int location, int v0, int v1) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30C.glUniform2i((int)location, (int)v0, (int)v1);
    }

    public static void uniform3f(int location, float v0, float v1, float v2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30C.glUniform3f((int)location, (float)v0, (float)v1, (float)v2);
    }

    public static void uniform4f(int location, float v0, float v1, float v2, float v3) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30C.glUniform4f((int)location, (float)v0, (float)v1, (float)v2, (float)v3);
    }

    public static void uniform4i(int location, int v0, int v1, int v2, int v3) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30C.glUniform4i((int)location, (int)v0, (int)v1, (int)v2, (int)v3);
    }

    public static int getAttribLocation(int programId, String name) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        return GL30C.glGetAttribLocation((int)programId, (CharSequence)name);
    }

    public static int getUniformLocation(int programId, String name) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        return GL30C.glGetUniformLocation((int)programId, (CharSequence)name);
    }

    public static void texParameteriv(int texture, int target, int pname, int[] params) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        dsaState.texParameteriv(texture, target, pname, params);
    }

    public static void copyTexSubImage2D(int destTexture, int target, int i, int i1, int i2, int i3, int i4, int width, int height) {
        dsaState.copyTexSubImage2D(destTexture, target, i, i1, i2, i3, i4, width, height);
    }

    public static void texParameteri(int texture, int target, int pname, int param) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        dsaState.texParameteri(texture, target, pname, param);
    }

    public static void texParameterf(int texture, int target, int pname, float param) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        dsaState.texParameterf(texture, target, pname, param);
    }

    public static String getProgramInfoLog(int program) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        return GL30C.glGetProgramInfoLog((int)program);
    }

    public static String getShaderInfoLog(int shader) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        return GL30C.glGetShaderInfoLog((int)shader);
    }

    public static void drawBuffers(int framebuffer, int[] buffers) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        dsaState.drawBuffers(framebuffer, buffers);
    }

    public static void readBuffer(int framebuffer, int buffer) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        dsaState.readBuffer(framebuffer, buffer);
    }

    public static String getActiveUniform(int program, int index, int size, IntBuffer type, IntBuffer name) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        return GL30C.glGetActiveUniform((int)program, (int)index, (int)size, (IntBuffer)type, (IntBuffer)name);
    }

    public static void readPixels(int x, int y, int width, int height, int format, int type, float[] pixels) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30C.glReadPixels((int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (float[])pixels);
    }

    public static void bufferData(int target, float[] data, int usage) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30C.glBufferData((int)target, (float[])data, (int)usage);
    }

    public static int bufferStorage(int target, float[] data, int usage) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        return dsaState.bufferStorage(target, data, usage);
    }

    public static void vertexAttrib4f(int index, float v0, float v1, float v2, float v3) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30C.glVertexAttrib4f((int)index, (float)v0, (float)v1, (float)v2, (float)v3);
    }

    public static void detachShader(int program, int shader) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30C.glDetachShader((int)program, (int)shader);
    }

    public static void framebufferTexture2D(int fb, int fbtarget, int attachment, int target, int texture, int levels) {
        dsaState.framebufferTexture2D(fb, fbtarget, attachment, target, texture, levels);
    }

    public static int getTexParameteri(int texture, int target, int pname) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        return dsaState.getTexParameteri(texture, target, pname);
    }

    public static void bindImageTexture(int unit, int texture, int level, boolean layered, int layer, int access, int format) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        if (GL.getCapabilities().OpenGL42) {
            GL45C.glBindImageTexture((int)unit, (int)texture, (int)level, (boolean)layered, (int)layer, (int)access, (int)format);
        } else {
            EXTShaderImageLoadStore.glBindImageTextureEXT((int)unit, (int)texture, (int)level, (boolean)layered, (int)layer, (int)access, (int)format);
        }
    }

    public static int getMaxImageUnits() {
        if (GL.getCapabilities().OpenGL42) {
            return GlStateManager.func_227612_D_((int)36664);
        }
        if (GL.getCapabilities().GL_EXT_shader_image_load_store) {
            return GlStateManager.func_227612_D_((int)36664);
        }
        return 0;
    }

    public static void getProgramiv(int program, int value, int[] storage) {
        GL30C.glGetProgramiv((int)program, (int)value, (int[])storage);
    }

    public static void dispatchCompute(int workX, int workY, int workZ) {
        GL45C.glDispatchCompute((int)workX, (int)workY, (int)workZ);
    }

    public static void dispatchCompute(Vector3i workGroups) {
        GL45C.glDispatchCompute((int)workGroups.x, (int)workGroups.y, (int)workGroups.z);
    }

    public static void memoryBarrier(int barriers) {
        if (supportsCompute) {
            GL45C.glMemoryBarrier((int)barriers);
        }
    }

    public static boolean supportsBufferBlending() {
        return GL.getCapabilities().GL_ARB_draw_buffers_blend || GL.getCapabilities().OpenGL40;
    }

    public static void disableBufferBlend(int buffer) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30C.glDisablei((int)3042, (int)buffer);
    }

    public static void enableBufferBlend(int buffer) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30C.glEnablei((int)3042, (int)buffer);
    }

    public static void blendFuncSeparatei(int buffer, int srcRGB, int dstRGB, int srcAlpha, int dstAlpha) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL40C.glBlendFuncSeparatei((int)buffer, (int)srcRGB, (int)dstRGB, (int)srcAlpha, (int)dstAlpha);
    }

    public static void bindTextureToUnit(int unit, int texture) {
        dsaState.bindTextureToUnit(unit, texture);
    }

    @Deprecated
    public static void setupProjectionMatrix(float[] matrix) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        RenderSystem.matrixMode((int)5889);
        RenderSystem.pushMatrix();
        GL20.glLoadMatrixf((float[])matrix);
        RenderSystem.matrixMode((int)5888);
    }

    @Deprecated
    public static void restoreProjectionMatrix() {
        RenderSystem.matrixMode((int)5889);
        RenderSystem.popMatrix();
        RenderSystem.matrixMode((int)5888);
    }

    public static void blitFramebuffer(int source, int dest, int offsetX, int offsetY, int width, int height, int offsetX2, int offsetY2, int width2, int height2, int bufferChoice, int filter) {
        dsaState.blitFramebuffer(source, dest, offsetX, offsetY, width, height, offsetX2, offsetY2, width2, height2, bufferChoice, filter);
    }

    public static int createFramebuffer() {
        return dsaState.createFramebuffer();
    }

    public static int createTexture(int target) {
        return dsaState.createTexture(target);
    }

    public static boolean supportsCompute() {
        return GL.getCapabilities().glDispatchCompute != 0L;
    }

    public static class DSACore
    extends DSAARB {
    }

    public static interface DSAAccess {
        public void generateMipmaps(int var1, int var2);

        public void texParameteri(int var1, int var2, int var3, int var4);

        public void texParameterf(int var1, int var2, int var3, float var4);

        public void texParameteriv(int var1, int var2, int var3, int[] var4);

        public void readBuffer(int var1, int var2);

        public void drawBuffers(int var1, int[] var2);

        public int getTexParameteri(int var1, int var2, int var3);

        public void copyTexSubImage2D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

        public void bindTextureToUnit(int var1, int var2);

        public int bufferStorage(int var1, float[] var2, int var3);

        public void blitFramebuffer(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12);

        public void framebufferTexture2D(int var1, int var2, int var3, int var4, int var5, int var6);

        public int createFramebuffer();

        public int createTexture(int var1);
    }

    public static class DSAARB
    extends DSAUnsupported {
        @Override
        public void generateMipmaps(int texture, int target) {
            ARBDirectStateAccess.glGenerateTextureMipmap((int)texture);
        }

        @Override
        public void texParameteri(int texture, int target, int pname, int param) {
            ARBDirectStateAccess.glTextureParameteri((int)texture, (int)pname, (int)param);
        }

        @Override
        public void texParameterf(int texture, int target, int pname, float param) {
            ARBDirectStateAccess.glTextureParameterf((int)texture, (int)pname, (float)param);
        }

        @Override
        public void texParameteriv(int texture, int target, int pname, int[] params) {
            ARBDirectStateAccess.glTextureParameteriv((int)texture, (int)pname, (int[])params);
        }

        @Override
        public void readBuffer(int framebuffer, int buffer) {
            ARBDirectStateAccess.glNamedFramebufferReadBuffer((int)framebuffer, (int)buffer);
        }

        @Override
        public void drawBuffers(int framebuffer, int[] buffers) {
            ARBDirectStateAccess.glNamedFramebufferDrawBuffers((int)framebuffer, (int[])buffers);
        }

        @Override
        public int getTexParameteri(int texture, int target, int pname) {
            return ARBDirectStateAccess.glGetTextureParameteri((int)texture, (int)pname);
        }

        @Override
        public void copyTexSubImage2D(int destTexture, int target, int i, int i1, int i2, int i3, int i4, int width, int height) {
            ARBDirectStateAccess.glCopyTextureSubImage2D((int)destTexture, (int)i, (int)i1, (int)i2, (int)i3, (int)i4, (int)width, (int)height);
        }

        @Override
        public void bindTextureToUnit(int unit, int texture) {
            if (texture == 0) {
                super.bindTextureToUnit(unit, texture);
            } else {
                ARBDirectStateAccess.glBindTextureUnit((int)unit, (int)texture);
            }
        }

        @Override
        public int bufferStorage(int target, float[] data, int usage) {
            int buffer = GL45C.glCreateBuffers();
            GL45C.glNamedBufferData((int)buffer, (float[])data, (int)usage);
            return buffer;
        }

        @Override
        public void blitFramebuffer(int source, int dest, int offsetX, int offsetY, int width, int height, int offsetX2, int offsetY2, int width2, int height2, int bufferChoice, int filter) {
            ARBDirectStateAccess.glBlitNamedFramebuffer((int)source, (int)dest, (int)offsetX, (int)offsetY, (int)width, (int)height, (int)offsetX2, (int)offsetY2, (int)width2, (int)height2, (int)bufferChoice, (int)filter);
        }

        @Override
        public void framebufferTexture2D(int fb, int fbtarget, int attachment, int target, int texture, int levels) {
            ARBDirectStateAccess.glNamedFramebufferTexture((int)fb, (int)attachment, (int)texture, (int)levels);
        }

        @Override
        public int createFramebuffer() {
            return ARBDirectStateAccess.glCreateFramebuffers();
        }

        @Override
        public int createTexture(int target) {
            return ARBDirectStateAccess.glCreateTextures((int)target);
        }
    }

    public static class DSAUnsupported
    implements DSAAccess {
        @Override
        public void generateMipmaps(int texture, int target) {
            GlStateManager.func_227760_t_((int)texture);
            GL30C.glGenerateMipmap((int)target);
        }

        @Override
        public void texParameteri(int texture, int target, int pname, int param) {
            GlStateManager.func_227760_t_((int)texture);
            GL30C.glTexParameteri((int)target, (int)pname, (int)param);
        }

        @Override
        public void texParameterf(int texture, int target, int pname, float param) {
            GlStateManager.func_227760_t_((int)texture);
            GL30C.glTexParameterf((int)target, (int)pname, (float)param);
        }

        @Override
        public void texParameteriv(int texture, int target, int pname, int[] params) {
            GlStateManager.func_227760_t_((int)texture);
            GL30C.glTexParameteriv((int)target, (int)pname, (int[])params);
        }

        @Override
        public void readBuffer(int framebuffer, int buffer) {
            GlStateManager.func_227727_h_((int)36160, (int)framebuffer);
            GL30C.glReadBuffer((int)buffer);
        }

        @Override
        public void drawBuffers(int framebuffer, int[] buffers) {
            GlStateManager.func_227727_h_((int)36160, (int)framebuffer);
            GL30C.glDrawBuffers((int[])buffers);
        }

        @Override
        public int getTexParameteri(int texture, int target, int pname) {
            GlStateManager.func_227760_t_((int)texture);
            return GL30C.glGetTexParameteri((int)target, (int)pname);
        }

        @Override
        public void copyTexSubImage2D(int destTexture, int target, int i, int i1, int i2, int i3, int i4, int width, int height) {
            int previous = GlStateManager.func_237515_r_();
            GlStateManager.func_227760_t_((int)destTexture);
            GL30C.glCopyTexSubImage2D((int)target, (int)i, (int)i1, (int)i2, (int)i3, (int)i4, (int)width, (int)height);
            GlStateManager.func_227760_t_((int)previous);
        }

        @Override
        public void bindTextureToUnit(int unit, int texture) {
            GlStateManager.func_227756_r_((int)(33984 + unit));
            GlStateManager.func_227760_t_((int)texture);
        }

        @Override
        public int bufferStorage(int target, float[] data, int usage) {
            int buffer = GlStateManager.func_227746_o_();
            GlStateManager.func_227724_g_((int)target, (int)buffer);
            IrisRenderSystem.bufferData(target, data, usage);
            GlStateManager.func_227724_g_((int)target, (int)0);
            return buffer;
        }

        @Override
        public void blitFramebuffer(int source, int dest, int offsetX, int offsetY, int width, int height, int offsetX2, int offsetY2, int width2, int height2, int bufferChoice, int filter) {
            GlStateManager.func_227727_h_((int)36008, (int)source);
            GlStateManager.func_227727_h_((int)36009, (int)dest);
            GL30C.glBlitFramebuffer((int)offsetX, (int)offsetY, (int)width, (int)height, (int)offsetX2, (int)offsetY2, (int)width2, (int)height2, (int)bufferChoice, (int)filter);
        }

        @Override
        public void framebufferTexture2D(int fb, int fbtarget, int attachment, int target, int texture, int levels) {
            GlStateManager.func_227727_h_((int)fbtarget, (int)fb);
            GL30C.glFramebufferTexture2D((int)fbtarget, (int)attachment, (int)target, (int)texture, (int)levels);
        }

        @Override
        public int createFramebuffer() {
            int framebuffer = GlStateManager.func_227749_p_();
            GlStateManager.func_227727_h_((int)36160, (int)framebuffer);
            return framebuffer;
        }

        @Override
        public int createTexture(int target) {
            int texture = GlStateManager.func_227622_J_();
            GlStateManager.func_227760_t_((int)texture);
            return texture;
        }
    }
}

