/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gui.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gui.GuiUtil;
import net.coderbot.iris.gui.NavigationController;
import net.coderbot.iris.gui.element.ShaderPackOptionList;
import net.coderbot.iris.gui.element.ShaderPackSelectionList;
import net.coderbot.iris.gui.element.widget.AbstractElementWidget;
import net.coderbot.iris.gui.element.widget.CommentedElementWidget;
import net.coderbot.iris.gui.screen.HudHideable;
import net.coderbot.iris.shaderpack.ShaderPack;
import net.irisshaders.iris.api.v0.IrisApi;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.Util;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.Nullable;

public class ShaderPackScreen
extends Screen
implements HudHideable {
    public static final Set<Runnable> TOP_LAYER_RENDER_QUEUE = new HashSet<Runnable>();
    private static final ITextComponent SELECT_TITLE = new TranslationTextComponent("pack.iris.select.title").func_240701_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.ITALIC});
    private static final ITextComponent CONFIGURE_TITLE = new TranslationTextComponent("pack.iris.configure.title").func_240701_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.ITALIC});
    private static final int COMMENT_PANEL_WIDTH = 314;
    private final Screen parent;
    private final IFormattableTextComponent irisTextComponent;
    private ShaderPackSelectionList shaderPackList;
    @Nullable
    private ShaderPackOptionList shaderOptionList = null;
    @Nullable
    private NavigationController navigation = null;
    private Button screenSwitchButton;
    private ITextComponent notificationDialog = null;
    private int notificationDialogTimer = 0;
    @Nullable
    private AbstractElementWidget<?> hoveredElement = null;
    private Optional<ITextComponent> hoveredElementCommentTitle = Optional.empty();
    private List<IReorderingProcessor> hoveredElementCommentBody = new ArrayList<IReorderingProcessor>();
    private int hoveredElementCommentTimer = 0;
    private boolean optionMenuOpen = false;
    private boolean dropChanges = false;
    private static String development = "Development Environment";
    private IFormattableTextComponent developmentComponent;
    private IFormattableTextComponent updateComponent;
    private boolean guiHidden = false;
    private float guiButtonHoverTimer = 0.0f;

    public ShaderPackScreen(Screen parent) {
        super((ITextComponent)new TranslationTextComponent("options.iris.shaderPackSelection.title"));
        this.parent = parent;
        String irisName = "Oculus " + Iris.getVersion();
        if (irisName.contains("-development-environment")) {
            this.developmentComponent = new StringTextComponent("Development Environment").func_240699_a_(TextFormatting.GOLD);
            irisName = irisName.replace("-development-environment", "");
        }
        this.irisTextComponent = new StringTextComponent(irisName).func_240699_a_(TextFormatting.GRAY);
        this.refreshForChangedPack();
    }

    public void func_230430_a_(MatrixStack poseStack, int mouseX, int mouseY, float delta) {
        if (this.field_230706_i_.field_71441_e == null) {
            this.func_230446_a_(poseStack);
        } else if (!this.guiHidden) {
            this.func_238468_a_(poseStack, 0, 0, this.field_230708_k_, this.field_230709_l_, 1327702819, 1327702819);
        }
        if (!this.guiHidden) {
            if (this.optionMenuOpen && this.shaderOptionList != null) {
                this.shaderOptionList.func_230430_a_(poseStack, mouseX, mouseY, delta);
            } else {
                this.shaderPackList.func_230430_a_(poseStack, mouseX, mouseY, delta);
            }
        }
        float previousHoverTimer = this.guiButtonHoverTimer;
        super.func_230430_a_(poseStack, mouseX, mouseY, delta);
        if (previousHoverTimer == this.guiButtonHoverTimer) {
            this.guiButtonHoverTimer = 0.0f;
        }
        if (!this.guiHidden) {
            ShaderPackScreen.func_238472_a_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_230704_d_, (int)((int)((double)this.field_230708_k_ * 0.5)), (int)8, (int)0xFFFFFF);
            if (this.notificationDialog != null && this.notificationDialogTimer > 0) {
                ShaderPackScreen.func_238472_a_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.notificationDialog, (int)((int)((double)this.field_230708_k_ * 0.5)), (int)21, (int)0xFFFFFF);
            } else if (this.optionMenuOpen) {
                ShaderPackScreen.func_238472_a_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (ITextComponent)CONFIGURE_TITLE, (int)((int)((double)this.field_230708_k_ * 0.5)), (int)21, (int)0xFFFFFF);
            } else {
                ShaderPackScreen.func_238472_a_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (ITextComponent)SELECT_TITLE, (int)((int)((double)this.field_230708_k_ * 0.5)), (int)21, (int)0xFFFFFF);
            }
            if (this.isDisplayingComment()) {
                int panelHeight = Math.max(50, 18 + this.hoveredElementCommentBody.size() * 10);
                int x = (int)(0.5 * (double)this.field_230708_k_) - 157;
                int y = this.field_230709_l_ - (panelHeight + 4);
                GuiUtil.drawPanel(poseStack, x, y, 314, panelHeight);
                this.field_230712_o_.func_243246_a(poseStack, this.hoveredElementCommentTitle.orElse(StringTextComponent.field_240750_d_), (float)(x + 4), (float)(y + 4), 0xFFFFFF);
                for (int i = 0; i < this.hoveredElementCommentBody.size(); ++i) {
                    this.field_230712_o_.func_238407_a_(poseStack, this.hoveredElementCommentBody.get(i), (float)(x + 4), (float)(y + 16 + i * 10), 0xFFFFFF);
                }
            }
        }
        for (Runnable render : TOP_LAYER_RENDER_QUEUE) {
            render.run();
        }
        TOP_LAYER_RENDER_QUEUE.clear();
        if (this.developmentComponent != null) {
            this.field_230712_o_.func_243246_a(poseStack, (ITextComponent)this.developmentComponent, 2.0f, (float)(this.field_230709_l_ - 10), 0xFFFFFF);
            this.field_230712_o_.func_243246_a(poseStack, (ITextComponent)this.irisTextComponent, 2.0f, (float)(this.field_230709_l_ - 20), 0xFFFFFF);
        } else if (this.updateComponent != null) {
            this.field_230712_o_.func_243246_a(poseStack, (ITextComponent)this.updateComponent, 2.0f, (float)(this.field_230709_l_ - 10), 0xFFFFFF);
            this.field_230712_o_.func_243246_a(poseStack, (ITextComponent)this.irisTextComponent, 2.0f, (float)(this.field_230709_l_ - 20), 0xFFFFFF);
        } else {
            this.field_230712_o_.func_243246_a(poseStack, (ITextComponent)this.irisTextComponent, 2.0f, (float)(this.field_230709_l_ - 10), 0xFFFFFF);
        }
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        int bottomCenter = this.field_230708_k_ / 2 - 50;
        int topCenter = this.field_230708_k_ / 2 - 76;
        boolean inWorld = this.field_230706_i_.field_71441_e != null;
        this.field_230705_e_.remove((Object)this.shaderPackList);
        this.field_230705_e_.remove((Object)this.shaderOptionList);
        this.shaderPackList = new ShaderPackSelectionList(this, this.field_230706_i_, this.field_230708_k_, this.field_230709_l_, 32, this.field_230709_l_ - 58, 0, this.field_230708_k_);
        if (Iris.getCurrentPack().isPresent() && this.navigation != null) {
            ShaderPack currentPack = Iris.getCurrentPack().get();
            this.shaderOptionList = new ShaderPackOptionList(this, this.navigation, currentPack, this.field_230706_i_, this.field_230708_k_, this.field_230709_l_, 32, this.field_230709_l_ - 58, 0, this.field_230708_k_);
            this.navigation.setActiveOptionList(this.shaderOptionList);
            this.shaderOptionList.rebuild();
        } else {
            this.optionMenuOpen = false;
            this.shaderOptionList = null;
        }
        if (inWorld) {
            this.shaderPackList.func_244605_b(false);
            if (this.shaderOptionList != null) {
                this.shaderOptionList.func_244605_b(false);
            }
        }
        this.field_230710_m_.clear();
        if (!this.guiHidden) {
            if (this.optionMenuOpen && this.shaderOptionList != null) {
                this.field_230705_e_.add(this.shaderOptionList);
            } else {
                this.field_230705_e_.add(this.shaderPackList);
            }
            this.func_230480_a_((Widget)new Button(bottomCenter + 104, this.field_230709_l_ - 27, 100, 20, DialogTexts.field_240632_c_, button -> this.func_231175_as__()));
            this.func_230480_a_((Widget)new Button(bottomCenter, this.field_230709_l_ - 27, 100, 20, (ITextComponent)new TranslationTextComponent("options.iris.apply"), button -> this.applyChanges()));
            this.func_230480_a_((Widget)new Button(bottomCenter - 104, this.field_230709_l_ - 27, 100, 20, DialogTexts.field_240633_d_, button -> this.dropChangesAndClose()));
            this.func_230480_a_((Widget)new Button(topCenter - 78, this.field_230709_l_ - 51, 152, 20, (ITextComponent)new TranslationTextComponent("options.iris.openShaderPackFolder"), button -> this.openShaderPackFolder()));
            this.screenSwitchButton = (Button)this.func_230480_a_((Widget)new Button(topCenter + 78, this.field_230709_l_ - 51, 152, 20, (ITextComponent)new TranslationTextComponent("options.iris.shaderPackList"), button -> {
                this.optionMenuOpen = !this.optionMenuOpen;
                this.applyChanges();
                this.func_231160_c_();
            }));
            this.refreshScreenSwitchButton();
        }
        if (inWorld) {
            TranslationTextComponent showOrHide = this.guiHidden ? new TranslationTextComponent("options.iris.gui.show") : new TranslationTextComponent("options.iris.gui.hide");
            float endOfLastButton = (float)this.field_230708_k_ / 2.0f + 154.0f;
            float freeSpace = (float)this.field_230708_k_ - endOfLastButton;
            int x = freeSpace > 100.0f ? this.field_230708_k_ - 50 : (freeSpace < 20.0f ? this.field_230708_k_ - 20 : (int)(endOfLastButton + freeSpace / 2.0f) - 10);
            this.func_230480_a_((Widget)new ImageButton(x, this.field_230709_l_ - 39, 20, 20, this.guiHidden ? 20 : 0, 146, 20, GuiUtil.IRIS_WIDGETS_TEX, 256, 256, button -> {
                this.guiHidden = !this.guiHidden;
                this.func_231160_c_();
            }, (arg_0, arg_1, arg_2, arg_3) -> this.lambda$init$7((ITextComponent)showOrHide, arg_0, arg_1, arg_2, arg_3), (ITextComponent)showOrHide));
        }
        this.hoveredElement = null;
        this.hoveredElementCommentTimer = 0;
    }

    public void refreshForChangedPack() {
        if (Iris.getCurrentPack().isPresent()) {
            ShaderPack currentPack = Iris.getCurrentPack().get();
            this.navigation = new NavigationController(currentPack.getMenuContainer());
            if (this.shaderOptionList != null) {
                this.shaderOptionList.applyShaderPack(currentPack);
                this.shaderOptionList.rebuild();
            }
        } else {
            this.navigation = null;
        }
        this.refreshScreenSwitchButton();
    }

    public void refreshScreenSwitchButton() {
        if (this.screenSwitchButton != null) {
            this.screenSwitchButton.func_238482_a_((ITextComponent)(this.optionMenuOpen ? new TranslationTextComponent("options.iris.shaderPackList") : new TranslationTextComponent("options.iris.shaderPackSettings")));
            this.screenSwitchButton.field_230693_o_ = this.optionMenuOpen || this.shaderPackList.getTopButtonRow().shadersEnabled;
        }
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        if (this.notificationDialogTimer > 0) {
            --this.notificationDialogTimer;
        }
        this.hoveredElementCommentTimer = this.hoveredElement != null ? ++this.hoveredElementCommentTimer : 0;
    }

    public boolean func_231046_a_(int key, int j, int k) {
        if (key == 256) {
            if (this.guiHidden) {
                this.guiHidden = false;
                this.func_231160_c_();
                return true;
            }
            if (this.navigation != null && this.navigation.hasHistory()) {
                this.navigation.back();
                return true;
            }
            if (this.optionMenuOpen) {
                this.optionMenuOpen = false;
                this.func_231160_c_();
                return true;
            }
        }
        return this.guiHidden || super.func_231046_a_(key, j, k);
    }

    public void func_230476_a_(List<Path> paths) {
        if (this.optionMenuOpen) {
            this.onOptionMenuFilesDrop(paths);
        } else {
            this.onPackListFilesDrop(paths);
        }
    }

    public void onPackListFilesDrop(List<Path> paths) {
        List packs = paths.stream().filter(Iris::isValidShaderpack).collect(Collectors.toList());
        for (Path pack : packs) {
            String fileName = pack.getFileName().toString();
            try {
                Iris.getShaderpacksDirectoryManager().copyPackIntoDirectory(fileName, pack);
            }
            catch (FileAlreadyExistsException e) {
                this.notificationDialog = new TranslationTextComponent("options.iris.shaderPackSelection.copyErrorAlreadyExists", new Object[]{fileName}).func_240701_a_(new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.RED});
                this.notificationDialogTimer = 100;
                this.shaderPackList.refresh();
                return;
            }
            catch (IOException e) {
                Iris.logger.warn("Error copying dragged shader pack", e);
                this.notificationDialog = new TranslationTextComponent("options.iris.shaderPackSelection.copyError", new Object[]{fileName}).func_240701_a_(new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.RED});
                this.notificationDialogTimer = 100;
                this.shaderPackList.refresh();
                return;
            }
        }
        this.shaderPackList.refresh();
        if (packs.size() == 0) {
            if (paths.size() == 1) {
                String fileName = paths.get(0).getFileName().toString();
                this.notificationDialog = new TranslationTextComponent("options.iris.shaderPackSelection.failedAddSingle", new Object[]{fileName}).func_240701_a_(new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.RED});
            } else {
                this.notificationDialog = new TranslationTextComponent("options.iris.shaderPackSelection.failedAdd").func_240701_a_(new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.RED});
            }
        } else if (packs.size() == 1) {
            String packName = ((Path)packs.get(0)).getFileName().toString();
            this.notificationDialog = new TranslationTextComponent("options.iris.shaderPackSelection.addedPack", new Object[]{packName}).func_240701_a_(new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.YELLOW});
            this.shaderPackList.select(packName);
        } else {
            this.notificationDialog = new TranslationTextComponent("options.iris.shaderPackSelection.addedPacks", new Object[]{packs.size()}).func_240701_a_(new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.YELLOW});
        }
        this.notificationDialogTimer = 100;
    }

    public void displayNotification(ITextComponent component) {
        this.notificationDialog = component;
        this.notificationDialogTimer = 100;
    }

    public void onOptionMenuFilesDrop(List<Path> paths) {
        if (paths.size() != 1) {
            this.notificationDialog = new TranslationTextComponent("options.iris.shaderPackOptions.tooManyFiles").func_240701_a_(new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.RED});
            this.notificationDialogTimer = 100;
            return;
        }
        this.importPackOptions(paths.get(0));
    }

    public void importPackOptions(Path settingFile) {
        try (InputStream in = Files.newInputStream(settingFile, new OpenOption[0]);){
            Properties properties = new Properties();
            properties.load(in);
            Iris.queueShaderPackOptionsFromProperties(properties);
            this.notificationDialog = new TranslationTextComponent("options.iris.shaderPackOptions.importedSettings", new Object[]{settingFile.getFileName().toString()}).func_240701_a_(new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.YELLOW});
            this.notificationDialogTimer = 100;
            if (this.navigation != null) {
                this.navigation.refresh();
            }
        }
        catch (Exception e) {
            Iris.logger.error("Error importing shader settings file \"" + settingFile.toString() + "\"", e);
            this.notificationDialog = new TranslationTextComponent("options.iris.shaderPackOptions.failedImport", new Object[]{settingFile.getFileName().toString()}).func_240701_a_(new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.RED});
            this.notificationDialogTimer = 100;
        }
    }

    public void func_231175_as__() {
        if (!this.dropChanges) {
            this.applyChanges();
        } else {
            this.discardChanges();
        }
        this.field_230706_i_.func_147108_a(this.parent);
    }

    private void dropChangesAndClose() {
        this.dropChanges = true;
        this.func_231175_as__();
    }

    public void applyChanges() {
        ShaderPackSelectionList.BaseEntry base = (ShaderPackSelectionList.BaseEntry)this.shaderPackList.func_230958_g_();
        if (!(base instanceof ShaderPackSelectionList.ShaderPackEntry)) {
            return;
        }
        ShaderPackSelectionList.ShaderPackEntry entry = (ShaderPackSelectionList.ShaderPackEntry)base;
        this.shaderPackList.setApplied(entry);
        String name = entry.getPackName();
        if (!name.equals(Iris.getCurrentPackName())) {
            Iris.clearShaderPackOptionQueue();
        }
        boolean enabled = this.shaderPackList.getTopButtonRow().shadersEnabled;
        String previousPackName = Iris.getIrisConfig().getShaderPackName().orElse(null);
        boolean previousShadersEnabled = Iris.getIrisConfig().areShadersEnabled();
        if (!name.equals(previousPackName) || enabled != previousShadersEnabled || !Iris.getShaderPackOptionQueue().isEmpty() || Iris.shouldResetShaderPackOptionsOnNextReload()) {
            Iris.getIrisConfig().setShaderPackName(name);
            IrisApi.getInstance().getConfig().setShadersEnabledAndApply(enabled);
        }
        this.refreshForChangedPack();
    }

    private void discardChanges() {
        Iris.clearShaderPackOptionQueue();
    }

    private void openShaderPackFolder() {
        Util.func_110647_a().func_195642_a(Iris.getShaderpacksDirectoryManager().getDirectoryUri());
    }

    public void setElementHoveredStatus(AbstractElementWidget<?> widget, boolean hovered) {
        if (hovered && widget != this.hoveredElement) {
            this.hoveredElement = widget;
            if (widget instanceof CommentedElementWidget) {
                this.hoveredElementCommentTitle = ((CommentedElementWidget)widget).getCommentTitle();
                Optional<ITextComponent> commentBody = ((CommentedElementWidget)widget).getCommentBody();
                if (!commentBody.isPresent()) {
                    this.hoveredElementCommentBody.clear();
                } else {
                    String rawCommentBody = commentBody.get().getString();
                    if (rawCommentBody.endsWith(".")) {
                        rawCommentBody = rawCommentBody.substring(0, rawCommentBody.length() - 1);
                    }
                    List splitByPeriods = Arrays.stream(rawCommentBody.split("\\. [ ]*")).map(StringTextComponent::new).collect(Collectors.toList());
                    this.hoveredElementCommentBody = new ArrayList<IReorderingProcessor>();
                    for (IFormattableTextComponent text : splitByPeriods) {
                        this.hoveredElementCommentBody.addAll(this.field_230712_o_.func_238425_b_((ITextProperties)text, 306));
                    }
                }
            } else {
                this.hoveredElementCommentTitle = Optional.empty();
                this.hoveredElementCommentBody.clear();
            }
            this.hoveredElementCommentTimer = 0;
        } else if (!hovered && widget == this.hoveredElement) {
            this.hoveredElement = null;
            this.hoveredElementCommentTitle = Optional.empty();
            this.hoveredElementCommentBody.clear();
            this.hoveredElementCommentTimer = 0;
        }
    }

    public boolean isDisplayingComment() {
        return this.hoveredElementCommentTimer > 20 && this.hoveredElementCommentTitle.isPresent() && !this.hoveredElementCommentBody.isEmpty();
    }

    private /* synthetic */ void lambda$init$7(ITextComponent showOrHide, Button button, MatrixStack poseStack, int i, int j) {
        this.guiButtonHoverTimer += this.field_230706_i_.func_193989_ak();
        if (this.guiButtonHoverTimer >= 10.0f) {
            TOP_LAYER_RENDER_QUEUE.add(() -> this.func_238652_a_(poseStack, showOrHide, i, j));
        }
    }
}

