/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline.transform;

import io.github.douira.glsl_transformer.ast.node.Identifier;
import io.github.douira.glsl_transformer.ast.node.TranslationUnit;
import io.github.douira.glsl_transformer.ast.node.expression.Expression;
import io.github.douira.glsl_transformer.ast.node.expression.binary.DivisionExpression;
import io.github.douira.glsl_transformer.ast.node.expression.binary.MultiplicationExpression;
import io.github.douira.glsl_transformer.ast.node.expression.unary.MemberAccessExpression;
import io.github.douira.glsl_transformer.ast.query.Root;
import io.github.douira.glsl_transformer.ast.query.match.AutoHintedMatcher;
import io.github.douira.glsl_transformer.ast.query.match.Matcher;
import io.github.douira.glsl_transformer.ast.transform.ASTInjectionPoint;
import io.github.douira.glsl_transformer.ast.transform.ASTParser;
import java.util.ArrayList;
import java.util.List;
import net.coderbot.iris.pipeline.transform.Parameters;

class SodiumTerrainTransformer {
    private static final AutoHintedMatcher<Expression> glTextureMatrix0 = new AutoHintedMatcher<Expression>("gl_TextureMatrix[0]", Matcher.expressionPattern);
    private static final Matcher<Expression> glTextureMatrixMultMember = new Matcher<Expression>("(gl_TextureMatrix[1] * ___coord).___suffix", Matcher.expressionPattern, "___");
    private static final Matcher<Expression> glTextureMatrixMultS = new Matcher<Expression>("(gl_TextureMatrix[1] * ___coord).s", Matcher.expressionPattern, "___");
    private static final Matcher<Expression> glTextureMatrixMult = new Matcher<Expression>("gl_TextureMatrix[1] * ___coord", Matcher.expressionPattern, "___");
    private static final Matcher<Expression> xyDivision = new Matcher<Expression>("___coord.xy / 255.0", Matcher.expressionPattern, "___");
    private static final Matcher<Expression> xyDivision240 = new Matcher<Expression>("___coord.xy / 240.0", Matcher.expressionPattern, "___");
    private static final String lightmapCoordsExpression = "iris_LightCoord";
    private static final String lightmapCoordsExpressionS = "iris_LightCoord.s";
    private static final String lightmapCoordsExpressionWrapped = "vec4(iris_LightCoord, 0.0, 1.0)";
    private static final List<Expression> replaceExpressions = new ArrayList<Expression>();
    private static final List<Expression> replaceSExpressions = new ArrayList<Expression>();
    private static final List<Expression> replaceWrapExpressions = new ArrayList<Expression>();
    private static final AutoHintedMatcher<Expression> glTextureMatrix1 = new AutoHintedMatcher<Expression>("gl_TextureMatrix[1]", Matcher.expressionPattern);

    SodiumTerrainTransformer() {
    }

    public static void transform(ASTParser t, TranslationUnit tree, Root root, Parameters parameters) {
        switch (parameters.type) {
            case FRAGMENT: 
            case GEOMETRY: {
                SodiumTerrainTransformer.transformFragment(t, tree, root, parameters);
                break;
            }
            case VERTEX: {
                SodiumTerrainTransformer.transformVertex(t, tree, root, parameters);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected Sodium terrain patching shader type: " + (Object)((Object)parameters.type));
            }
        }
    }

    public static void transformVertex(ASTParser t, TranslationUnit tree, Root root, Parameters parameters) {
        tree.parseAndInjectNodes(t, ASTInjectionPoint.BEFORE_DECLARATIONS, "attribute vec3 iris_Pos;", "attribute vec4 iris_Color;", "attribute vec2 iris_TexCoord;", "attribute vec2 iris_LightCoord;", "attribute vec3 iris_Normal;", "uniform vec3 u_ModelScale;", "uniform vec2 u_TextureScale;", "attribute vec4 iris_ModelOffset;", "vec4 ftransform() { return gl_ModelViewProjectionMatrix * gl_Vertex; }");
        SodiumTerrainTransformer.transformShared(t, tree, root, parameters);
        root.replaceReferenceExpressions(t, "gl_Vertex", "vec4((iris_Pos * u_ModelScale) + iris_ModelOffset.xyz, 1.0)");
        root.replaceReferenceExpressions(t, "gl_MultiTexCoord0", "vec4(iris_TexCoord * u_TextureScale, 0.0, 1.0)");
        root.rename("gl_Color", "iris_Color");
        root.rename("gl_Normal", "iris_Normal");
        root.rename("ftransform", "iris_ftransform");
        SodiumTerrainTransformer.replaceLightmapForSodium(t, tree, root, parameters);
    }

    public static void transformFragment(ASTParser t, TranslationUnit tree, Root root, Parameters parameters) {
        SodiumTerrainTransformer.transformShared(t, tree, root, parameters);
    }

    private static void transformShared(ASTParser t, TranslationUnit tree, Root root, Parameters parameters) {
        tree.parseAndInjectNodes(t, ASTInjectionPoint.BEFORE_DECLARATIONS, "uniform mat4 iris_ModelViewMatrix;", "uniform mat4 u_ModelViewProjectionMatrix;", "uniform mat4 iris_NormalMatrix;");
        root.rename("gl_ModelViewMatrix", "iris_ModelViewMatrix");
        root.rename("gl_ModelViewProjectionMatrix", "u_ModelViewProjectionMatrix");
        root.replaceReferenceExpressions(t, "gl_NormalMatrix", "mat3(iris_NormalMatrix)");
        root.replaceExpressionMatches(t, glTextureMatrix0, "mat4(1.0)");
    }

    private static void processCoord(Root root, String coord) {
        for (Identifier identifier : root.identifierIndex.get(coord)) {
            MemberAccessExpression memberAccess = identifier.getAncestor(MemberAccessExpression.class);
            if (memberAccess != null && glTextureMatrixMultMember.matchesExtract(memberAccess)) {
                String suffix = glTextureMatrixMultMember.getStringDataMatch("suffix");
                if (glTextureMatrixMultMember.getStringDataMatch("coord").equals(coord) && suffix != null && ("st".equals(suffix) || "xy".equals(suffix))) {
                    replaceExpressions.add(memberAccess);
                    return;
                }
            }
            if (memberAccess != null && glTextureMatrixMultS.matchesExtract(memberAccess) && glTextureMatrixMultS.getStringDataMatch("coord").equals(coord)) {
                replaceSExpressions.add(memberAccess);
                return;
            }
            DivisionExpression division = identifier.getAncestor(DivisionExpression.class);
            if (division != null && xyDivision.matchesExtract(division) && xyDivision.getStringDataMatch("coord").equals(coord)) {
                replaceExpressions.add(division);
                return;
            }
            if (division != null && xyDivision240.matchesExtract(division) && xyDivision240.getStringDataMatch("coord").equals(coord)) {
                replaceExpressions.add(division);
                return;
            }
            MultiplicationExpression mult = identifier.getAncestor(MultiplicationExpression.class);
            if (mult == null || !glTextureMatrixMult.matchesExtract(mult) || !glTextureMatrixMult.getStringDataMatch("coord").equals(coord)) continue;
            replaceWrapExpressions.add(mult);
            return;
        }
    }

    private static void replaceLightmapForSodium(ASTParser t, TranslationUnit tree, Root root, Parameters parameters) {
        replaceExpressions.clear();
        replaceSExpressions.clear();
        replaceWrapExpressions.clear();
        SodiumTerrainTransformer.processCoord(root, "gl_MultiTexCoord1");
        SodiumTerrainTransformer.processCoord(root, "gl_MultiTexCoord2");
        Root.replaceExpressionsConcurrent(t, replaceExpressions, lightmapCoordsExpression);
        Root.replaceExpressionsConcurrent(t, replaceSExpressions, lightmapCoordsExpressionS);
        Root.replaceExpressionsConcurrent(t, replaceWrapExpressions, lightmapCoordsExpressionWrapped);
        replaceExpressions.clear();
        replaceSExpressions.clear();
        replaceWrapExpressions.clear();
        root.replaceExpressionMatches(t, glTextureMatrix1, "iris_LightmapTextureMatrix");
        root.replaceReferenceExpressions(t, "gl_MultiTexCoord1", "vec4(iris_LightCoord * 256.0 - 8.0, 0.0, 1.0)");
        root.replaceReferenceExpressions(t, "gl_MultiTexCoord2", "vec4(iris_LightCoord * 256.0 - 8.0, 0.0, 1.0)");
        if (root.identifierIndex.has("iris_LightmapTextureMatrix")) {
            tree.parseAndInjectNodes(t, ASTInjectionPoint.BEFORE_DECLARATIONS, "uniform mat4 iris_LightmapTextureMatrix;");
        }
    }
}

