/*
 * Decompiled with CFR 0.152.
 */
package repack.apache.commons.collections4.bloomfilter;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.LongPredicate;
import repack.apache.commons.collections4.bloomfilter.BitMap;
import repack.apache.commons.collections4.bloomfilter.CountingLongPredicate;
import repack.apache.commons.collections4.bloomfilter.IndexProducer;
import repack.apache.commons.collections4.bloomfilter.LongBiPredicate;

@FunctionalInterface
public interface BitMapProducer {
    public boolean forEachBitMap(LongPredicate var1);

    default public boolean forEachBitMapPair(BitMapProducer other, LongBiPredicate func) {
        CountingLongPredicate p = new CountingLongPredicate(this.asBitMapArray(), func);
        return other.forEachBitMap(p) && p.forEachRemaining();
    }

    default public long[] asBitMapArray() {
        class Bits {
            private long[] data = new long[16];
            private int size;

            Bits() {
            }

            boolean add(long bits) {
                if (this.size == this.data.length) {
                    this.data = Arrays.copyOf(this.data, this.size * 2);
                }
                this.data[this.size++] = bits;
                return true;
            }

            long[] toArray() {
                return this.size == this.data.length ? this.data : Arrays.copyOf(this.data, this.size);
            }
        }
        Bits bits = new Bits();
        this.forEachBitMap(bits::add);
        return bits.toArray();
    }

    public static BitMapProducer fromBitMapArray(final long ... bitMaps) {
        return new BitMapProducer(){

            @Override
            public boolean forEachBitMap(LongPredicate predicate) {
                for (long word : bitMaps) {
                    if (predicate.test(word)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public long[] asBitMapArray() {
                return Arrays.copyOf(bitMaps, bitMaps.length);
            }

            @Override
            public boolean forEachBitMapPair(BitMapProducer other, LongBiPredicate func) {
                CountingLongPredicate p = new CountingLongPredicate(bitMaps, func);
                return other.forEachBitMap(p) && p.forEachRemaining();
            }
        };
    }

    public static BitMapProducer fromIndexProducer(IndexProducer producer, int numberOfBits) {
        Objects.requireNonNull(producer, "producer");
        Objects.requireNonNull(Integer.valueOf(numberOfBits), "numberOfBits");
        long[] result = new long[BitMap.numberOfBitMaps(numberOfBits)];
        producer.forEachIndex(i -> {
            BitMap.set(result, i);
            return true;
        });
        return BitMapProducer.fromBitMapArray(result);
    }
}

