/*
 * Decompiled with CFR 0.152.
 */
package repack.apache.commons.collections4.bloomfilter;

import java.util.function.IntPredicate;
import repack.apache.commons.collections4.bloomfilter.BitMap;
import repack.apache.commons.collections4.bloomfilter.Shape;

public final class IndexFilter {
    private final IntPredicate tracker;
    private final int size;
    private final IntPredicate consumer;

    public static IntPredicate create(Shape shape, IntPredicate consumer) {
        return new IndexFilter(shape, consumer)::test;
    }

    private IndexFilter(Shape shape, IntPredicate consumer) {
        this.size = shape.getNumberOfBits();
        this.consumer = consumer;
        this.tracker = (long)(BitMap.numberOfBitMaps(shape.getNumberOfBits()) * 8) < (long)shape.getNumberOfHashFunctions() * 4L ? new BitMapTracker(shape) : new ArrayTracker(shape);
    }

    public boolean test(int number) {
        if (number >= this.size) {
            throw new IndexOutOfBoundsException(String.format("number too large %d >= %d", number, this.size));
        }
        return !this.tracker.test(number) || this.consumer.test(number);
    }

    static class BitMapTracker
    implements IntPredicate {
        private final long[] bits;

        BitMapTracker(Shape shape) {
            this.bits = new long[BitMap.numberOfBitMaps(shape.getNumberOfBits())];
        }

        @Override
        public boolean test(int number) {
            boolean retval = !BitMap.contains(this.bits, number);
            BitMap.set(this.bits, number);
            return retval;
        }
    }

    static class ArrayTracker
    implements IntPredicate {
        private final int[] seen;
        private int populated;

        ArrayTracker(Shape shape) {
            this.seen = new int[shape.getNumberOfHashFunctions()];
        }

        @Override
        public boolean test(int number) {
            if (number < 0) {
                throw new IndexOutOfBoundsException("number may not be less than zero. " + number);
            }
            for (int i = 0; i < this.populated; ++i) {
                if (this.seen[i] != number) continue;
                return false;
            }
            this.seen[this.populated++] = number;
            return true;
        }
    }
}

