/*
 * Decompiled with CFR 0.152.
 */
package repack.apache.commons.collections4.bloomfilter;

import java.util.BitSet;
import java.util.Objects;
import java.util.function.IntPredicate;
import java.util.function.LongPredicate;
import repack.apache.commons.collections4.bloomfilter.BitMapProducer;

@FunctionalInterface
public interface IndexProducer {
    public boolean forEachIndex(IntPredicate var1);

    public static IndexProducer fromIndexArray(final int ... values) {
        return new IndexProducer(){

            @Override
            public boolean forEachIndex(IntPredicate predicate) {
                for (int value : values) {
                    if (predicate.test(value)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public int[] asIndexArray() {
                return (int[])values.clone();
            }
        };
    }

    public static IndexProducer fromBitMapProducer(BitMapProducer producer) {
        Objects.requireNonNull(producer, "producer");
        return consumer -> {
            LongPredicate longPredicate = new LongPredicate(){
                int wordIdx = 0;

                @Override
                public boolean test(long word) {
                    int i = this.wordIdx;
                    while (word != 0L) {
                        if ((word & 1L) == 1L && !consumer.test(i)) {
                            return false;
                        }
                        word >>>= 1;
                        ++i;
                    }
                    this.wordIdx += 64;
                    return true;
                }
            };
            return producer.forEachBitMap(longPredicate::test);
        };
    }

    default public int[] asIndexArray() {
        BitSet result = new BitSet();
        this.forEachIndex(i -> {
            result.set(i);
            return true;
        });
        return result.stream().toArray();
    }
}

