/*
 * Decompiled with CFR 0.152.
 */
package tfar.darkerloadingscreen;

import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class Hooks {
    private static ForgeConfigSpec.ConfigValue<String> main_background_color;
    private static ForgeConfigSpec.ConfigValue<String> progress_start_color;
    private static ForgeConfigSpec.ConfigValue<String> progress_end_color;
    private static ForgeConfigSpec.ConfigValue<String> logo_color;
    public static int backgroundColor;
    public static int progStartColor;
    public static int progEndColor;
    public static int logoColor;
    public static final Hooks CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;

    public Hooks(ForgeConfigSpec.Builder builder) {
        builder.push("general");
        main_background_color = builder.define("main_background_color", (Object)"#2B2B2B");
        progress_start_color = builder.define("progress_start_color", (Object)"#FF0000");
        progress_end_color = builder.define("progress_end_color", (Object)"#00FF00");
        logo_color = builder.define("logo_color", (Object)"#FF0000");
        builder.pop();
    }

    public static void parse() {
        backgroundColor = Integer.decode((String)main_background_color.get()) | 0xFF000000;
        progStartColor = Integer.decode((String)progress_start_color.get()) | 0xFF000000;
        progEndColor = Integer.decode((String)progress_end_color.get()) | 0xFF000000;
        logoColor = Integer.decode((String)logo_color.get()) | 0xFF000000;
    }

    public static int getProgressColor(float progress) {
        int r1 = progStartColor >> 16 & 0xFF;
        int g1 = progStartColor >> 8 & 0xFF;
        int b1 = progStartColor & 0xFF;
        int r2 = progEndColor >> 16 & 0xFF;
        int g2 = progEndColor >> 8 & 0xFF;
        int b2 = progEndColor & 0xFF;
        int r = (int)MathHelper.func_219799_g((float)progress, (float)r1, (float)r2) << 16;
        int g = (int)MathHelper.func_219799_g((float)progress, (float)g1, (float)g2) << 8;
        int b = (int)MathHelper.func_219799_g((float)progress, (float)b1, (float)b2);
        return 0xFF000000 | r | g | b;
    }

    public static int getBarBackgroundColor(float progress) {
        float a = 1.0f - progress;
        int r = Math.round(a * 255.0f) << 16;
        int g = Math.round(a * 255.0f) << 8;
        int b = Math.round(a * 255.0f);
        return 0xFF000000 | r | g | b;
    }

    static {
        backgroundColor = 0;
        progStartColor = 0;
        progEndColor = 0;
        logoColor = 0xFF0000;
        Pair specPair = new ForgeConfigSpec.Builder().configure(Hooks::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Hooks)specPair.getLeft();
    }
}

