/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.rainbowoaks;

import com.eerussianguy.rainbowoaks.RORegistry;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.FoliageColors;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.biome.BiomeColors;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="rainbowoaks", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientEventHandler {
    @SubscribeEvent
    public static void onBlockColors(ColorHandlerEvent.Block event) {
        event.getBlockColors().func_186722_a((IBlockColor)new BlockColorRainbowLeaves(), new Block[]{(Block)RORegistry.RAINBOW_LEAVES.get()});
    }

    @SubscribeEvent
    public static void onItemColors(ColorHandlerEvent.Item event) {
        event.getItemColors().func_199877_a((IItemColor)new ItemColorRainbowLeaves(), new IItemProvider[]{((Block)RORegistry.RAINBOW_LEAVES.get()).func_199767_j()});
    }

    public static class BlockColorRainbowLeaves
    implements IBlockColor {
        public int getColor(@Nonnull BlockState state, @Nullable IBlockDisplayReader worldIn, @Nullable BlockPos pos, int tintindex) {
            if (worldIn != null && pos != null) {
                int red = 0;
                int green = 0;
                int blue = 0;
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        int averageColor = BiomeColors.func_228361_b_((IBlockDisplayReader)worldIn, (BlockPos)pos);
                        red += (averageColor & 0xFF0000) >> 16;
                        green += (averageColor & 0xFF00) >> 8;
                        blue += averageColor & 0xFF;
                    }
                }
                red = pos.func_177958_n() * 32 + pos.func_177956_o() * 16;
                if ((red & 0x100) != 0) {
                    red = 255 - (red & 0xFF);
                }
                red &= 0xFF;
                blue = pos.func_177956_o() * 32 + pos.func_177952_p() * 16;
                if ((blue & 0x100) != 0) {
                    blue = 255 - (blue & 0xFF);
                }
                blue ^= 0xFF;
                green = pos.func_177958_n() * 16 + pos.func_177952_p() * 32;
                if ((green & 0x100) != 0) {
                    green = 255 - (green & 0xFF);
                }
                return red << 16 | blue << 8 | (green &= 0xFF);
            }
            return FoliageColors.func_77468_c();
        }
    }

    public static class ItemColorRainbowLeaves
    implements IItemColor {
        public int getColor(@Nonnull ItemStack stack, int tintIndex) {
            int red = 0;
            int green = 0;
            int blue = 0;
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    int averageColor = FoliageColors.func_77468_c();
                    red += (averageColor & 0xFF0000) >> 16;
                    green += (averageColor & 0xFF00) >> 8;
                    blue += averageColor & 0xFF;
                }
            }
            red = stack.func_190916_E() * 64;
            if ((red & 0x100) != 0) {
                red = 255 - (red & 0xFF);
            }
            red &= 0xFF;
            blue = stack.func_190916_E() * 32;
            if ((blue & 0x100) != 0) {
                blue = 255 - (blue & 0xFF);
            }
            blue ^= 0xFF;
            green = stack.func_190916_E();
            if ((green & 0x100) != 0) {
                green = 255 - (green & 0xFF);
            }
            return red << 16 | blue << 8 | (green &= 0xFF);
        }
    }
}

