/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.rainbowoaks;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import net.minecraftforge.common.ForgeConfigSpec;

public class CommonConfig {
    public final ForgeConfigSpec.IntValue rarity;
    public final ForgeConfigSpec.IntValue extraAttempts;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> biomes;

    CommonConfig(ForgeConfigSpec.Builder innerBuilder) {
        Function<String, ForgeConfigSpec.Builder> builder = name -> innerBuilder.translation("rainbowoaks.config.server." + name);
        innerBuilder.push("general");
        this.rarity = builder.apply("rarity").comment("Rarity of a rainbow tree patch in 1/N chunks").worldRestart().defineInRange("rarity", 1, 1, Integer.MAX_VALUE);
        this.extraAttempts = builder.apply("extraAttempts").comment("Extra trees that spawn in a patch").worldRestart().defineInRange("extraAttempts", 2, 0, Integer.MAX_VALUE);
        this.biomes = builder.apply("biomes").comment("Resource Locations of biomes they spawn in. Separate with commas.").worldRestart().defineList("biomes", () -> Arrays.asList("minecraft:flower_forest"), o -> o instanceof String);
        innerBuilder.pop();
    }
}

