/*
 * Decompiled with CFR 0.152.
 */
package com.tterrag.blur;

import com.tterrag.blur.BlurConfig;
import com.tterrag.blur.util.ShaderResourcePack;
import java.lang.reflect.Field;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.shader.Shader;
import net.minecraft.client.shader.ShaderDefault;
import net.minecraft.client.shader.ShaderGroup;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IPackFinder;
import net.minecraft.resources.IPackNameDecorator;
import net.minecraft.resources.PackCompatibility;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.resources.SimpleReloadableResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;

@Mod(value="blur")
public class Blur {
    public static final String MODID = "blur";
    public static final String MOD_NAME = "Blur";
    public static final String VERSION = "@VERSION@";
    public static Blur instance;
    private Field _listShaders;
    private long start;
    @Nonnull
    private ShaderResourcePack dummyPack = new ShaderResourcePack();
    private float prevProgress = -1.0f;

    public Blur() {
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.DISPLAYTEST, () -> Pair.of(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
            MinecraftForge.EVENT_BUS.addListener(this::onGuiChange);
            MinecraftForge.EVENT_BUS.addListener(this::onRenderTick);
            ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, BlurConfig.clientSpec);
            ResourcePackList rps = (ResourcePackList)ObfuscationReflectionHelper.getPrivateValue(Minecraft.class, (Object)Minecraft.func_71410_x(), (String)"field_110448_aq");
            rps.addPackFinder(new IPackFinder(){

                public void func_230230_a_(Consumer<ResourcePackInfo> infoConsumer, ResourcePackInfo.IFactory infoFactory) {
                    ResourcePackInfo var3 = new ResourcePackInfo(Blur.MODID, true, () -> Blur.this.dummyPack, (ITextComponent)new StringTextComponent(Blur.this.dummyPack.func_195762_a()), (ITextComponent)new StringTextComponent("Default shaders for Blur"), PackCompatibility.COMPATIBLE, ResourcePackInfo.Priority.BOTTOM, true, IPackNameDecorator.field_232625_a_);
                    if (var3 != null) {
                        infoConsumer.accept(var3);
                    }
                }
            });
        });
        instance = this;
    }

    @SubscribeEvent
    public void preInit(FMLClientSetupEvent event) {
        ((SimpleReloadableResourceManager)Minecraft.func_71410_x().func_195551_G()).func_219534_a((IFutureReloadListener)this.dummyPack);
    }

    public void onGuiChange(GuiOpenEvent event) throws SecurityException {
        if (this._listShaders == null) {
            this._listShaders = ObfuscationReflectionHelper.findField(ShaderGroup.class, (String)"field_148031_d");
        }
        if (Minecraft.func_71410_x().field_71441_e != null) {
            boolean excluded;
            GameRenderer er = Minecraft.func_71410_x().field_71460_t;
            boolean bl = excluded = event.getGui() == null || ((List)BlurConfig.CLIENT.guiExclusions.get()).contains(event.getGui().getClass().getName());
            if (er.func_147706_e() == null && !excluded) {
                er.func_175069_a(new ResourceLocation("shaders/post/fade_in_blur.json"));
                this.updateUniform("Radius", ((Integer)BlurConfig.CLIENT.radius.get()).intValue());
                this.start = System.currentTimeMillis();
            } else if (er.func_147706_e() != null && excluded) {
                er.func_181022_b();
            }
        }
    }

    private float getProgress() {
        return Math.min((float)(System.currentTimeMillis() - this.start) / (float)((Integer)BlurConfig.CLIENT.fadeTime.get()).intValue(), 1.0f);
    }

    public void onRenderTick(TickEvent.RenderTickEvent event) {
        float progress;
        if (event.phase == TickEvent.Phase.END && Minecraft.func_71410_x().field_71462_r != null && Minecraft.func_71410_x().field_71460_t.func_147706_e() != null && (progress = this.getProgress()) != this.prevProgress) {
            this.prevProgress = progress;
            this.updateUniform("Progress", progress);
        }
    }

    public void updateUniform(String name, float value) {
        if (this._listShaders == null) {
            return;
        }
        ShaderGroup sg = Minecraft.func_71410_x().field_71460_t.func_147706_e();
        try {
            List shaders = (List)this._listShaders.get(sg);
            for (Shader s : shaders) {
                ShaderDefault su = s.func_217624_b().func_216538_b(name);
                if (su == null) continue;
                su.func_148090_a(value);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    public static int getBackgroundColor(boolean second) {
        int color = second ? BlurConfig.colorFirst : BlurConfig.colorSecond;
        int a = color >>> 24;
        int r = color >> 16 & 0xFF;
        int b = color >> 8 & 0xFF;
        int g = color & 0xFF;
        float prog = instance.getProgress();
        a = (int)((float)a * prog);
        r = (int)((float)r * prog);
        g = (int)((float)g * prog);
        b = (int)((float)b * prog);
        return a << 24 | r << 16 | b << 8 | g;
    }
}

