/*
 * Decompiled with CFR 0.152.
 */
package com.tterrag.blur;

import com.google.common.collect.Lists;
import com.tterrag.blur.Blur;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.gui.screen.SleepInMultiplayerScreen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="blur", bus=Mod.EventBusSubscriber.Bus.MOD)
public class BlurConfig {
    static final ForgeConfigSpec clientSpec;
    public static final Client CLIENT;
    public static int colorFirst;
    public static int colorSecond;

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading configEvent) {
        BlurConfig.updateColors();
    }

    @SubscribeEvent
    public static void onReload(ModConfig.Reloading configEvent) {
        BlurConfig.updateColors();
    }

    private static void updateColors() {
        colorFirst = Integer.parseUnsignedInt((String)BlurConfig.CLIENT.colorFirstRaw.get(), 16);
        colorSecond = Integer.parseUnsignedInt((String)BlurConfig.CLIENT.colorSecondRaw.get(), 16);
        Minecraft.func_71410_x().execute(() -> Blur.instance.updateUniform("Radius", ((Integer)BlurConfig.CLIENT.radius.get()).intValue()));
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        clientSpec = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> guiExclusions;
        public final ForgeConfigSpec.IntValue fadeTime;
        public final ForgeConfigSpec.IntValue radius;
        ForgeConfigSpec.ConfigValue<String> colorFirstRaw;
        ForgeConfigSpec.ConfigValue<String> colorSecondRaw;

        Client(ForgeConfigSpec.Builder builder) {
            this.guiExclusions = builder.comment("A list of classes to be excluded from the blur shader.").defineList("guiExclusions", (List)Lists.newArrayList((Object[])new String[]{ChatScreen.class.getName(), SleepInMultiplayerScreen.class.getName()}), o -> {
                try {
                    return o instanceof String && Class.forName((String)o) != null;
                }
                catch (ClassNotFoundException e) {
                    return false;
                }
            });
            this.fadeTime = builder.comment("The time it takes for the blur to fade in, in ms.").defineInRange("fadeTime", 200, 0, 10000);
            this.radius = builder.comment("The radius of the blur effect. This controls how \"strong\" the blur is.").defineInRange("radius", 12, 1, 100);
            Predicate<Object> hexValidator = o -> {
                if (o instanceof String) {
                    try {
                        Integer.parseInt((String)o, 16);
                        return true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                return false;
            };
            this.colorFirstRaw = builder.comment("The start color of the background gradient. Given in ARGB hex.").define("gradientStartColor", (Object)"75000000", hexValidator);
            this.colorSecondRaw = builder.comment("The end color of the background gradient. Given in ARGB hex.").define("gradientEndColor", (Object)"75000000", hexValidator);
        }
    }
}

