/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.biome;

import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.level.ColorResolver;
import xaero.map.MapProcessor;
import xaero.map.region.MapTile;

public class BiomeColorCalculator {
    public final RegistryKey<Biome> UNREACHABLE_BIOME = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("xaeroworldmap:unreachable_biome"));
    public final RegistryKey<Biome> RIVER_BIOME = Biomes.field_76781_i;
    private int startO;
    private int endO;
    private int startP;
    private int endP;

    public void prepare(boolean biomeBlending) {
        this.endP = 0;
        this.startP = 0;
        this.endO = 0;
        this.startO = 0;
        if (biomeBlending) {
            this.startO = -1;
            this.endO = 1;
            this.startP = -1;
            this.endP = 1;
        }
    }

    public int getBiomeColor(ColorResolver stateColorResolver, boolean overlay, BlockPos.Mutable pos, MapTile tile, int caveLayer, MutableRegistry<Biome> biomeRegistry, MapProcessor mapProcessor) {
        if (stateColorResolver == null) {
            return -1;
        }
        int i = 0;
        int j = 0;
        int k = 0;
        int total = 0;
        int initX = pos.func_177958_n();
        int initZ = pos.func_177952_p();
        for (int o = this.startO; o <= this.endO; ++o) {
            for (int p = this.startP; p <= this.endP; ++p) {
                if (o != 0 && p != 0) continue;
                pos.func_181079_c(initX + o, pos.func_177956_o(), initZ + p);
                RegistryKey<Biome> b = this.getBiomeAtPos((BlockPos)pos, tile, caveLayer, mapProcessor);
                if (b == this.UNREACHABLE_BIOME) continue;
                if (b == null && overlay) {
                    b = this.RIVER_BIOME;
                }
                if (b == null) continue;
                int l = 0;
                Biome gen = (Biome)biomeRegistry.func_230516_a_(b);
                if (gen == null) continue;
                l = stateColorResolver.getColor(gen, (double)pos.func_177958_n(), (double)pos.func_177952_p());
                i += l & 0xFF0000;
                j += l & 0xFF00;
                k += l & 0xFF;
                ++total;
            }
        }
        pos.func_181079_c(initX, pos.func_177956_o(), initZ);
        if (total == 0) {
            Biome defaultBiome = (Biome)biomeRegistry.func_230516_a_(Biomes.field_76781_i);
            if (defaultBiome == null) {
                return -1;
            }
            return stateColorResolver.getColor(defaultBiome, (double)pos.func_177958_n(), (double)pos.func_177952_p());
        }
        return i / total & 0xFF0000 | j / total & 0xFF00 | k / total;
    }

    public RegistryKey<Biome> getBiomeAtPos(BlockPos pos, MapTile centerTile, int caveLayer, MapProcessor mapProcessor) {
        MapTile tile;
        int tileX = pos.func_177958_n() >> 4;
        int tileZ = pos.func_177952_p() >> 4;
        MapTile mapTile = tile = tileX == centerTile.getChunkX() && tileZ == centerTile.getChunkZ() ? centerTile : mapProcessor.getMapTile(caveLayer, tileX, tileZ);
        if (tile != null && tile.isLoaded()) {
            return tile.getBlock(pos.func_177958_n() & 0xF, pos.func_177952_p() & 0xF).getBiome();
        }
        return this.UNREACHABLE_BIOME;
    }
}

