/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.core;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Path;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.network.play.server.SChunkDataPacket;
import net.minecraft.network.play.server.SJoinGamePacket;
import net.minecraft.network.play.server.SMultiBlockChangePacket;
import net.minecraft.network.play.server.SWorldSpawnChangedPacket;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.storage.SaveFormat;
import xaero.map.WorldMap;
import xaero.map.WorldMapSession;
import xaero.map.core.IWorldMapClientPlayNetHandler;
import xaero.map.core.IWorldMapSMultiBlockChangePacket;
import xaero.map.file.MapSaveLoad;
import xaero.map.misc.Misc;
import xaero.map.mods.SupportMods;
import xaero.map.patreon.Patreon;

public class XaeroWorldMapCore {
    public static Field chunkCleanField = null;
    public static WorldMapSession currentSession;

    public static void ensureField() {
        if (chunkCleanField == null) {
            try {
                chunkCleanField = Chunk.class.getDeclaredField("xaero_wm_chunkClean");
            }
            catch (NoSuchFieldException | SecurityException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void chunkUpdateCallback(int chunkX, int chunkZ) {
        XaeroWorldMapCore.ensureField();
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world != null) {
            try {
                for (int x = chunkX - 1; x < chunkX + 2; ++x) {
                    for (int z = chunkZ - 1; z < chunkZ + 2; ++z) {
                        Chunk chunk = world.func_212866_a_(x, z);
                        if (chunk == null) continue;
                        chunkCleanField.set(chunk, false);
                    }
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void onChunkData(SChunkDataPacket packetIn) {
        XaeroWorldMapCore.chunkUpdateCallback(packetIn.func_149273_e(), packetIn.func_149271_f());
    }

    public static void onBlockChange(SChangeBlockPacket packetIn) {
        XaeroWorldMapCore.chunkUpdateCallback(packetIn.func_179827_b().func_177958_n() >> 4, packetIn.func_179827_b().func_177952_p() >> 4);
    }

    public static void onMultiBlockChange(SMultiBlockChangePacket packetIn) {
        IWorldMapSMultiBlockChangePacket packetAccess = (IWorldMapSMultiBlockChangePacket)packetIn;
        XaeroWorldMapCore.chunkUpdateCallback(packetAccess.xaero_wm_getSectionPos().func_177958_n(), packetAccess.xaero_wm_getSectionPos().func_177952_p());
    }

    public static void onSpawn(SWorldSpawnChangedPacket packetIn) {
        WorldMap.events.spawnSet((World)Minecraft.func_71410_x().field_71441_e, packetIn.func_240832_b_());
    }

    public static ResourceLocation getPlayerCape(AbstractClientPlayerEntity player) {
        if (SupportMods.optifine) {
            return null;
        }
        return Patreon.getPlayerCape(WorldMap.fileLayoutID, player);
    }

    public static Boolean isWearing(PlayerEntity player, PlayerModelPart part) {
        if (SupportMods.optifine) {
            return null;
        }
        if (part != PlayerModelPart.CAPE || !(player instanceof AbstractClientPlayerEntity)) {
            return null;
        }
        return Patreon.isWearingCape(WorldMap.fileLayoutID, (AbstractClientPlayerEntity)player);
    }

    public static void onPlayNetHandler(ClientPlayNetHandler netHandler, SJoinGamePacket packet) {
        try {
            WorldMapSession worldmapSession;
            IWorldMapClientPlayNetHandler netHandlerAccess = (IWorldMapClientPlayNetHandler)netHandler;
            if (netHandlerAccess.getXaero_worldmapSession() != null) {
                return;
            }
            if (currentSession != null) {
                WorldMap.LOGGER.info("Previous world map session still active. Probably using MenuMobs. Forcing it to end...");
                XaeroWorldMapCore.cleanupCurrentSession();
            }
            currentSession = worldmapSession = new WorldMapSession();
            worldmapSession.init(packet.func_229742_c_());
            netHandlerAccess.setXaero_worldmapSession(worldmapSession);
            WorldMap.settings.updateRegionCacheHashCode();
        }
        catch (Throwable e) {
            if (currentSession != null) {
                XaeroWorldMapCore.cleanupCurrentSession();
            }
            RuntimeException wrappedException = new RuntimeException("Exception initializing Xaero's World Map! ", e);
            WorldMap.crashHandler.setCrashedBy(wrappedException);
        }
    }

    private static void cleanupCurrentSession() {
        try {
            currentSession.cleanup();
        }
        catch (Throwable supressed) {
            WorldMap.LOGGER.error("suppressed exception", supressed);
        }
        finally {
            currentSession = null;
        }
    }

    public static void onPlayNetHandlerCleanup(ClientPlayNetHandler netHandler) {
        try {
            WorldMapSession netHandlerSession = ((IWorldMapClientPlayNetHandler)netHandler).getXaero_worldmapSession();
            if (netHandlerSession == null) {
                return;
            }
            try {
                netHandlerSession.cleanup();
            }
            finally {
                if (netHandlerSession == currentSession) {
                    currentSession = null;
                }
                ((IWorldMapClientPlayNetHandler)netHandler).setXaero_worldmapSession(null);
            }
        }
        catch (Throwable e) {
            RuntimeException wrappedException = new RuntimeException("Exception finalizing Xaero's World Map! ", e);
            WorldMap.crashHandler.setCrashedBy(wrappedException);
        }
    }

    public static void onDeleteWorld(SaveFormat.LevelSave levelStorageAccess) {
        Path worldMapCacheFolder;
        Path worldName = levelStorageAccess.getWorldDir().getFileName();
        if (!worldName.toString().isEmpty() && (worldMapCacheFolder = MapSaveLoad.getRootFolder(worldName.toString())).toFile().exists()) {
            try {
                Misc.deleteFile(worldMapCacheFolder, 20);
                WorldMap.LOGGER.info(String.format("Deleted world map cache at %s", worldMapCacheFolder));
            }
            catch (IOException e) {
                WorldMap.LOGGER.error(String.format("Failed to delete world map cache at %s!", worldMapCacheFolder), (Throwable)e);
            }
        }
    }

    public static void onMinecraftRunTick() {
        if (WorldMap.fmlEvents != null) {
            WorldMap.fmlEvents.handleClientRunTickStart();
        }
    }
}

