/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.element;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.texture.TextureManager;
import org.lwjgl.opengl.GL11;
import xaero.map.WorldMap;
import xaero.map.element.HoveredMapElementHolder;
import xaero.map.element.MapElementReader;
import xaero.map.element.MapElementRenderProvider;
import xaero.map.element.MapElementRenderer;
import xaero.map.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.map.gui.GuiMap;
import xaero.map.mods.SupportMods;
import xaero.map.mods.gui.WaypointRenderer;

public class MapElementRenderHandler {
    private final List<MapElementRenderer<?, ?, ?>> renderers;
    protected final int location;

    private MapElementRenderHandler(List<MapElementRenderer<?, ?, ?>> renderers, int location) {
        this.renderers = renderers;
        this.location = location;
    }

    public void add(MapElementRenderer<?, ?, ?> renderer) {
        this.renderers.add(renderer);
    }

    public static <E, C> HoveredMapElementHolder<E, C> createResult(E hovered, MapElementRenderer<?, ?, ?> hoveredRenderer) {
        MapElementRenderer<?, ?, ?> rendererCast = hoveredRenderer;
        return new HoveredMapElementHolder(hovered, rendererCast);
    }

    private <E> MapElementRenderer<E, ?, ?> getRenderer(HoveredMapElementHolder<E, ?> holder) {
        return holder.getRenderer();
    }

    public HoveredMapElementHolder<?, ?> render(GuiMap mapScreen, MatrixStack matrixStack, IRenderTypeBuffer.Impl renderTypeBuffers, MultiTextureRenderTypeRendererProvider rendererProvider, double cameraX, double cameraZ, int width, int height, double screenSizeBasedScale, double scale, double mouseX, double mouseZ, float brightness, boolean cave, HoveredMapElementHolder<?, ?> oldHovered, Minecraft mc, float partialTicks) {
        HoveredMapElementHolder<?, ?> hoveredToReturn;
        Object hovered = null;
        MapElementRenderer<?, ?, ?> hoveredRenderer = null;
        TextureManager textureManager = mc.func_110434_K();
        FontRenderer fontRenderer = mc.field_71466_p;
        textureManager.func_110577_a(WorldMap.guiTextures);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        double baseScale = 1.0 / scale;
        Collections.sort(this.renderers);
        for (int i = this.renderers.size() - 1; i >= 0; --i) {
            MapElementRenderer<?, ?, ?> renderer = this.renderers.get(i);
            Object obj = this.getRendererHovered(renderer, mapScreen, mouseX, mouseZ, scale, screenSizeBasedScale, partialTicks);
            if (obj == null) continue;
            hovered = obj;
            hoveredRenderer = renderer;
            break;
        }
        HoveredMapElementHolder<Object, Object> hoveredMapElementHolder = oldHovered != null && oldHovered.is(hovered) ? oldHovered : (hoveredToReturn = hovered == null ? null : MapElementRenderHandler.createResult(hovered, hoveredRenderer));
        if (hovered == null && oldHovered != null) {
            hovered = oldHovered.getElement();
            hoveredRenderer = this.getRenderer(oldHovered);
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.0, -980.0);
        matrixStack.func_227862_a_((float)baseScale, (float)baseScale, 1.0f);
        for (MapElementRenderer mapElementRenderer : this.renderers) {
            this.renderWithRenderer(mapElementRenderer, hovered, mapScreen, matrixStack, renderTypeBuffers, rendererProvider, textureManager, fontRenderer, cameraX, cameraZ, width, height, screenSizeBasedScale, baseScale, scale, mouseX, mouseZ, brightness, cave, oldHovered, mc, true, partialTicks, 0, 0);
        }
        if (hovered != null) {
            this.renderHoveredWithRenderer(hoveredRenderer, hovered, mapScreen, matrixStack, renderTypeBuffers, rendererProvider, textureManager, fontRenderer, cameraX, cameraZ, width, height, screenSizeBasedScale, baseScale, scale, mouseX, mouseZ, brightness, cave, mc, true, partialTicks, 0, 0);
        }
        int indexLimit = 19490;
        for (MapElementRenderer<?, ?, ?> renderer : this.renderers) {
            int elementIndex = 0;
            elementIndex = this.renderWithRenderer(renderer, hovered, mapScreen, matrixStack, renderTypeBuffers, rendererProvider, textureManager, fontRenderer, cameraX, cameraZ, width, height, screenSizeBasedScale, baseScale, scale, mouseX, mouseZ, brightness, cave, oldHovered, mc, false, partialTicks, elementIndex, indexLimit);
            matrixStack.func_227861_a_(0.0, 0.0, this.getElementIndexDepth(elementIndex, indexLimit));
            if ((indexLimit -= elementIndex) >= 0) continue;
            indexLimit = 0;
        }
        if (hovered != null) {
            this.renderHoveredWithRenderer(hoveredRenderer, hovered, mapScreen, matrixStack, renderTypeBuffers, rendererProvider, textureManager, fontRenderer, cameraX, cameraZ, width, height, screenSizeBasedScale, baseScale, scale, mouseX, mouseZ, brightness, cave, mc, false, partialTicks, 0, indexLimit);
        }
        matrixStack.func_227865_b_();
        textureManager.func_110577_a(WorldMap.guiTextures);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        return hoveredToReturn;
    }

    private <E, C, R extends MapElementRenderer<E, C, R>> E getRendererHovered(MapElementRenderer<E, C, R> renderer, GuiMap mapScreen, double mouseX, double mouseZ, double scale, double screenSizeBasedScale, float partialTicks) {
        if (!renderer.shouldRender(this.location, false) && !renderer.shouldRender(this.location, true)) {
            return null;
        }
        MapElementReader reader = renderer.reader;
        MapElementRenderProvider provider = renderer.provider;
        Object context = renderer.context;
        int location = this.location;
        E result = null;
        provider.begin(location, context);
        while (provider.hasNext(location, context)) {
            Object e = provider.getNext(location, context);
            if (e == null || reader.isHidden(e, context) || !reader.isInteractable(location, e) || !reader.isHoveredOnMap(location, e, mouseX, mouseZ, scale, screenSizeBasedScale, context, partialTicks)) continue;
            result = e;
        }
        provider.end(location, context);
        return result;
    }

    private <E, C, R extends MapElementRenderer<E, C, R>> int renderHoveredWithRenderer(MapElementRenderer<E, C, R> renderer, Object hovered, GuiMap mapScreen, MatrixStack matrixStack, IRenderTypeBuffer.Impl renderTypeBuffers, MultiTextureRenderTypeRendererProvider rendererProvider, TextureManager textureManager, FontRenderer font, double cameraX, double cameraZ, int width, int height, double screenSizeBasedScale, double baseScale, double scale, double mouseX, double mouseZ, float brightness, boolean cave, Minecraft mc, boolean pre, float partialTicks, int elementIndex, int indexLimit) {
        if (!renderer.shouldRenderHovered(pre)) {
            return elementIndex;
        }
        renderer.beforeRender(this.location, mc, matrixStack, cameraX, cameraZ, mouseX, mouseZ, brightness, scale, screenSizeBasedScale, textureManager, font, renderTypeBuffers, rendererProvider, pre);
        Object hoveredCast = hovered;
        matrixStack.func_227860_a_();
        if (!pre) {
            matrixStack.func_227861_a_(0.0, 0.0, 1.0);
        }
        if (this.transformAndRenderElement(renderer, hoveredCast, hovered, mapScreen, matrixStack, renderTypeBuffers, rendererProvider, textureManager, font, cameraX, cameraZ, width, height, screenSizeBasedScale, baseScale, scale, mouseX, mouseZ, brightness, cave, mc, pre, partialTicks, elementIndex, indexLimit) && !pre) {
            ++elementIndex;
        }
        matrixStack.func_227865_b_();
        renderer.afterRender(this.location, mc, matrixStack, cameraX, cameraZ, mouseX, mouseZ, brightness, scale, screenSizeBasedScale, textureManager, font, renderTypeBuffers, rendererProvider, pre);
        return elementIndex;
    }

    private <E, C, R extends MapElementRenderer<E, C, R>> int renderWithRenderer(MapElementRenderer<E, C, R> renderer, Object hovered, GuiMap mapScreen, MatrixStack matrixStack, IRenderTypeBuffer.Impl renderTypeBuffers, MultiTextureRenderTypeRendererProvider rendererProvider, TextureManager textureManager, FontRenderer font, double cameraX, double cameraZ, int width, int height, double screenSizeBasedScale, double baseScale, double scale, double mouseX, double mouseZ, float brightness, boolean cave, HoveredMapElementHolder<?, ?> oldHovered, Minecraft mc, boolean pre, float partialTicks, int elementIndex, int indexLimit) {
        int location = this.location;
        if (!renderer.shouldRender(location, pre)) {
            return elementIndex;
        }
        MapElementReader reader = renderer.reader;
        MapElementRenderProvider provider = renderer.provider;
        Object context = renderer.context;
        renderer.beforeRender(location, mc, matrixStack, cameraX, cameraZ, mouseX, mouseZ, brightness, scale, screenSizeBasedScale, textureManager, font, renderTypeBuffers, rendererProvider, pre);
        provider.begin(location, context);
        while (provider.hasNext(location, context)) {
            Object e = provider.setupContextAndGetNext(location, context);
            if (e == null || reader.isHidden(e, context) || e == hovered || !reader.isOnScreen(e, cameraX, cameraZ, width, height, scale, screenSizeBasedScale, context, partialTicks) || !this.transformAndRenderElement(renderer, e, hovered, mapScreen, matrixStack, renderTypeBuffers, rendererProvider, textureManager, font, cameraX, cameraZ, width, height, screenSizeBasedScale, baseScale, scale, mouseX, mouseZ, brightness, cave, mc, pre, partialTicks, elementIndex, indexLimit) || pre) continue;
            ++elementIndex;
        }
        provider.end(location, context);
        renderer.afterRender(location, mc, matrixStack, cameraX, cameraZ, mouseX, mouseZ, brightness, scale, screenSizeBasedScale, textureManager, font, renderTypeBuffers, rendererProvider, pre);
        return elementIndex;
    }

    private <E, C, R extends MapElementRenderer<E, C, R>> boolean transformAndRenderElement(MapElementRenderer<E, C, R> renderer, E e, Object hovered, GuiMap mapScreen, MatrixStack matrixStack, IRenderTypeBuffer.Impl renderTypeBuffers, MultiTextureRenderTypeRendererProvider rendererProvider, TextureManager textureManager, FontRenderer font, double cameraX, double cameraZ, int width, int height, double screenSizeBasedScale, double baseScale, double scale, double mouseX, double mouseZ, float brightness, boolean cave, Minecraft mc, boolean pre, float partialTicks, int elementIndex, int indexLimit) {
        MapElementReader reader = renderer.reader;
        Object context = renderer.context;
        matrixStack.func_227860_a_();
        double offX = (reader.getRenderX(e, context, partialTicks) - cameraX) / baseScale;
        double offZ = (reader.getRenderZ(e, context, partialTicks) - cameraZ) / baseScale;
        long roundedOffX = Math.round(offX);
        long roundedOffZ = Math.round(offZ);
        double partialX = offX - (double)roundedOffX;
        double partialY = offZ - (double)roundedOffZ;
        matrixStack.func_227861_a_((double)roundedOffX, (double)roundedOffZ, 0.0);
        boolean result = false;
        if (pre) {
            renderer.renderElementPre(this.location, e, e == hovered, mc, matrixStack, cameraX, cameraZ, mouseX, mouseZ, brightness, scale, screenSizeBasedScale, textureManager, font, renderTypeBuffers, rendererProvider, (float)screenSizeBasedScale, partialX, partialY, cave, partialTicks);
        } else {
            double optionalDepth = this.getElementIndexDepth(elementIndex, indexLimit);
            result = renderer.renderElement(this.location, e, e == hovered, mc, matrixStack, cameraX, cameraZ, mouseX, mouseZ, brightness, scale, screenSizeBasedScale, textureManager, font, renderTypeBuffers, rendererProvider, elementIndex, optionalDepth, (float)screenSizeBasedScale, partialX, partialY, cave, partialTicks);
        }
        matrixStack.func_227865_b_();
        return result;
    }

    private double getElementIndexDepth(int elementIndex, int indexLimit) {
        return (double)(elementIndex >= indexLimit ? indexLimit : elementIndex) * 0.1;
    }

    public static final class Builder {
        private Builder() {
        }

        public MapElementRenderHandler build() {
            ArrayList<WaypointRenderer> renderers = new ArrayList<WaypointRenderer>();
            if (SupportMods.minimap()) {
                renderers.add(SupportMods.xaeroMinimap.getWaypointRenderer());
            }
            return new MapElementRenderHandler(renderers, 3);
        }

        public static Builder begin() {
            return new Builder();
        }
    }
}

