/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.file;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Hashtable;
import java.util.List;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.world.biome.Biome;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.biome.BlockTintProvider;
import xaero.map.cache.BlockStateShortShapeCache;
import xaero.map.exception.OpenGLException;
import xaero.map.file.MapRegionInfo;
import xaero.map.file.MapSaveLoad;
import xaero.map.file.RegionDetection;
import xaero.map.graphics.CustomRenderTypes;
import xaero.map.graphics.ImprovedFramebuffer;
import xaero.map.graphics.renderer.multitexture.MultiTextureRenderTypeRenderer;
import xaero.map.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.map.gui.GuiMap;
import xaero.map.misc.BufferCompatibilityFix;
import xaero.map.misc.Misc;
import xaero.map.mods.SupportMods;
import xaero.map.region.LeveledRegion;
import xaero.map.region.MapLayer;
import xaero.map.region.MapRegion;
import xaero.map.region.MapTileChunk;
import xaero.map.region.OverlayManager;
import xaero.map.region.texture.LeafRegionTexture;

public class PNGExporter {
    private Path destinationPath;
    private MatrixStack matrixStack;

    public PNGExporter(Path destinationPath) {
        this.destinationPath = destinationPath;
        this.matrixStack = new MatrixStack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(MapProcessor mapProcessor, MutableRegistry<Biome> biomeRegistry) throws IllegalArgumentException, IllegalAccessException, OpenGLException {
        BufferedImage image;
        long maxExportSizeInRegions;
        int exportHeightInRegions;
        if (!mapProcessor.getMapSaveLoad().isRegionDetectionComplete()) {
            WorldMap.LOGGER.info("Can't export the PNG just yet!");
            return;
        }
        int exportedLayer = mapProcessor.getCurrentCaveLayer();
        List<LeveledRegion<?>> list = mapProcessor.getMapWorld().getCurrentDimension().getLayeredMapRegions().getUnsyncedList();
        if (list.isEmpty()) {
            return;
        }
        Integer minX = null;
        Integer maxX = null;
        Integer minZ = null;
        Integer maxZ = null;
        for (LeveledRegion<?> region : list) {
            if (region.getLevel() != 0 || !((MapRegion)region).hasHadTerrain() || region.getCaveLayer() != exportedLayer) continue;
            if (minX == null || region.getRegionX() < minX) {
                minX = region.getRegionX();
            }
            if (maxX == null || region.getRegionX() > maxX) {
                maxX = region.getRegionX();
            }
            if (minZ == null || region.getRegionZ() < minZ) {
                minZ = region.getRegionZ();
            }
            if (maxZ != null && region.getRegionZ() <= maxZ) continue;
            maxZ = region.getRegionZ();
        }
        MapLayer mapLayer = mapProcessor.getMapWorld().getCurrentDimension().getLayeredMapRegions().getLayer(exportedLayer);
        Iterable<Hashtable<Integer, RegionDetection>> regionDetectionIterable = mapProcessor.getMapWorld().isMultiplayer() ? mapLayer.getDetectedRegions().values() : mapProcessor.getMapWorld().getCurrentDimension().getWorldSaveDetectedRegions();
        for (Hashtable<Integer, RegionDetection> column : regionDetectionIterable) {
            for (RegionDetection regionDetection : column.values()) {
                if (!regionDetection.isHasHadTerrain()) continue;
                if (minX == null || regionDetection.getRegionX() < minX) {
                    minX = regionDetection.getRegionX();
                }
                if (maxX == null || regionDetection.getRegionX() > maxX) {
                    maxX = regionDetection.getRegionX();
                }
                if (minZ == null || regionDetection.getRegionZ() < minZ) {
                    minZ = regionDetection.getRegionZ();
                }
                if (maxZ != null && regionDetection.getRegionZ() <= maxZ) continue;
                maxZ = regionDetection.getRegionZ();
            }
        }
        int exportWidthInRegions = maxX - minX + 1;
        long exportSizeInRegions = (long)exportWidthInRegions * (long)(exportHeightInRegions = maxZ - minZ + 1);
        if (exportSizeInRegions > (maxExportSizeInRegions = 0x6400000L)) {
            WorldMap.LOGGER.info("Can't export PNG because the map is too big: " + exportSizeInRegions);
            return;
        }
        float scale = exportSizeInRegions < 400L ? 1.0f : (float)(20.0 / Math.sqrt(exportSizeInRegions));
        float regionSize = 512.0f * scale;
        int exportWidth = (int)((float)exportWidthInRegions * regionSize);
        int exportHeight = (int)((float)exportHeightInRegions * regionSize);
        int maxTextureSize = GL11.glGetInteger((int)3379);
        OpenGLException.checkGLError();
        int frameWidth = Math.min(1024, Math.min(maxTextureSize, exportWidth));
        int frameHeight = Math.min(1024, Math.min(maxTextureSize, exportHeight));
        int horizontalFrames = (int)Math.ceil((double)exportWidth / (double)frameWidth);
        int verticalFrames = (int)Math.ceil((double)exportHeight / (double)frameHeight);
        if (WorldMap.settings.debug) {
            WorldMap.LOGGER.info(String.format("Exporting PNG of size %dx%d using a framebuffer of size %dx%d.", exportWidth, exportHeight, frameWidth, frameHeight));
        }
        try {
            image = new BufferedImage(exportWidth, exportHeight, 1);
        }
        catch (OutOfMemoryError oome) {
            WorldMap.LOGGER.info("Can't export PNG because java heap is out of memory. Required: " + (long)exportWidth * (long)exportHeight * 4L + " bytes");
            return;
        }
        ImprovedFramebuffer exportFrameBuffer = new ImprovedFramebuffer(frameWidth, frameHeight, false);
        ByteBuffer frameDataBuffer = BufferUtils.createByteBuffer((int)(frameWidth * frameHeight * 4));
        int[] bufferArray = new int[frameWidth * frameHeight];
        if (exportFrameBuffer.field_147616_f == -1) {
            WorldMap.LOGGER.info("Can't export PNG because FBOs are not supported.");
            return;
        }
        MatrixStack matrixStack = this.matrixStack;
        BlockStateShortShapeCache shortShapeCache = mapProcessor.getBlockStateShortShapeCache();
        BlockTintProvider blockTintProvider = mapProcessor.getWorldBlockTintProvider();
        OverlayManager overlayManager = mapProcessor.getOverlayManager();
        MapSaveLoad mapSaveLoad = mapProcessor.getMapSaveLoad();
        MultiTextureRenderTypeRendererProvider rendererProvider = mapProcessor.getMultiTextureRenderTypeRenderers();
        RenderSystem.disableLighting();
        RenderSystem.matrixMode((int)5889);
        RenderSystem.loadIdentity();
        RenderSystem.ortho((double)0.0, (double)frameWidth, (double)0.0, (double)frameHeight, (double)0.0, (double)1000.0);
        RenderSystem.matrixMode((int)5888);
        matrixStack.func_227860_a_();
        exportFrameBuffer.func_147610_a(true);
        matrixStack.func_227862_a_(scale, scale, 1.0f);
        boolean[] justMetaDest = new boolean[1];
        for (int i = 0; i < horizontalFrames; ++i) {
            for (int j = 0; j < verticalFrames; ++j) {
                RenderSystem.bindTexture((int)0);
                RenderSystem.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                RenderSystem.clear((int)16640, (boolean)Minecraft.field_142025_a);
                matrixStack.func_227860_a_();
                float frameLeft = (float)minX.intValue() * 512.0f + (float)(i * frameWidth) / scale;
                float frameRight = (float)minX.intValue() * 512.0f + (float)((i + 1) * frameWidth) / scale;
                float frameTop = (float)minZ.intValue() * 512.0f + (float)(j * frameHeight) / scale;
                float frameBottom = (float)minZ.intValue() * 512.0f + (float)((j + 1) * frameHeight) / scale;
                int minTileChunkX = (int)Math.floor(frameLeft) >> 6;
                int maxTileChunkX = (int)Math.floor(frameRight) >> 6;
                int minTileChunkZ = (int)Math.floor(frameTop) >> 6;
                int maxTileChunkZ = (int)Math.floor(frameBottom) >> 6;
                int minRegionX = minTileChunkX >> 3;
                int minRegionZ = minTileChunkZ >> 3;
                int maxRegionX = maxTileChunkX >> 3;
                int maxRegionZ = maxTileChunkZ >> 3;
                matrixStack.func_227861_a_((double)(-frameLeft) + 0.1, (double)(-frameTop), 0.0);
                Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
                for (int regionX = minRegionX; regionX <= maxRegionX; ++regionX) {
                    for (int regionZ = minRegionZ; regionZ <= maxRegionZ; ++regionZ) {
                        boolean loadingFromCache;
                        MapRegion originalRegion = mapProcessor.getMapRegion(exportedLayer, regionX, regionZ, false);
                        MapRegionInfo regionInfo = originalRegion;
                        if (originalRegion == null && mapLayer.regionDetectionExists(regionX, regionZ)) {
                            regionInfo = mapLayer.getRegionDetection(regionX, regionZ);
                        }
                        if (regionInfo == null) continue;
                        File cacheFile = regionInfo.getCacheFile();
                        boolean bl = loadingFromCache = originalRegion == null || !originalRegion.isBeingWritten() || originalRegion.getLoadState() != 2;
                        if (loadingFromCache && cacheFile == null) {
                            if (!regionInfo.hasLookedForCache()) {
                                try {
                                    cacheFile = mapSaveLoad.getCacheFile(regionInfo, exportedLayer, true, false);
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            if (cacheFile == null) continue;
                        }
                        MapRegion region = new MapRegion("png", "null", null, null, regionX, regionZ, exportedLayer, 0, false, biomeRegistry);
                        if (loadingFromCache) {
                            region.setShouldCache(true, "png");
                            region.setHasHadTerrain();
                            region.setCacheFile(cacheFile);
                            region.loadCacheTextures(mapProcessor, biomeRegistry, false, null, 0, null, justMetaDest, 1);
                        } else {
                            for (int o = 0; o < 8; ++o) {
                                for (int p = 0; p < 8; ++p) {
                                    MapTileChunk originalTileChunk = originalRegion.getChunk(o, p);
                                    if (originalTileChunk == null || !originalTileChunk.hasHadTerrain()) continue;
                                    MapTileChunk tileChunk = region.createTexture(o, p).getTileChunk();
                                    for (int tx = 0; tx < 4; ++tx) {
                                        for (int tz = 0; tz < 4; ++tz) {
                                            tileChunk.setTile(tx, tz, originalTileChunk.getTile(tx, tz), shortShapeCache);
                                        }
                                    }
                                    tileChunk.setLoadState((byte)2);
                                    tileChunk.updateBuffers(mapProcessor, blockTintProvider, overlayManager, WorldMap.settings.detailed_debug, shortShapeCache);
                                }
                            }
                        }
                        MultiTextureRenderTypeRenderer rendererLight = rendererProvider.getRenderer(t -> {
                            GlStateManager.func_227756_r_((int)33984);
                            GlStateManager.func_227760_t_((int)t);
                            GlStateManager.func_227756_r_((int)33985);
                            GlStateManager.func_227760_t_((int)t);
                            GlStateManager.func_227756_r_((int)33986);
                            GlStateManager.func_227760_t_((int)t);
                        }, CustomRenderTypes.MAP_WITH_LIGHT);
                        MultiTextureRenderTypeRenderer rendererNoLight = rendererProvider.getRenderer(MultiTextureRenderTypeRendererProvider::defaultTextureBind, CustomRenderTypes.MAP_NO_LIGHT);
                        IntArrayList texturesToDelete = new IntArrayList();
                        for (int localChunkX = 0; localChunkX < 8; ++localChunkX) {
                            for (int localChunkZ = 0; localChunkZ < 8; ++localChunkZ) {
                                MapTileChunk tileChunk = region.getChunk(localChunkX, localChunkZ);
                                if (tileChunk == null) continue;
                                LeafRegionTexture tileChunkTexture = tileChunk.getLeafTexture();
                                if (tileChunk.getX() < minTileChunkX || tileChunk.getX() > maxTileChunkX || tileChunk.getZ() < minTileChunkZ || tileChunk.getZ() > maxTileChunkZ) {
                                    tileChunkTexture.deleteColorBuffer();
                                    continue;
                                }
                                int textureId = tileChunkTexture.bindColorTexture(true);
                                if (tileChunkTexture.isColorBufferCompressed()) {
                                    GL13.glCompressedTexImage2D((int)3553, (int)0, (int)tileChunkTexture.getColorBufferFormat(), (int)64, (int)64, (int)0, (ByteBuffer)tileChunkTexture.getDirectColorBuffer());
                                } else {
                                    int internalFormat = tileChunkTexture.getColorBufferFormat() == -1 ? 32856 : tileChunkTexture.getColorBufferFormat();
                                    GL11.glTexImage2D((int)3553, (int)0, (int)internalFormat, (int)64, (int)64, (int)0, (int)32993, (int)32821, (ByteBuffer)tileChunkTexture.getDirectColorBuffer());
                                }
                                tileChunkTexture.deleteColorBuffer();
                                if (textureId == -1) continue;
                                GL11.glTexParameteri((int)3553, (int)33085, (int)9);
                                RenderSystem.texParameter((int)3553, (int)33083, (int)9);
                                exportFrameBuffer.generateMipmaps();
                                RenderSystem.texParameter((int)3553, (int)10241, (int)9987);
                                GuiMap.renderTexturedModalRectWithLighting3(matrix, tileChunk.getX() * 64, tileChunk.getZ() * 64, 64.0f, 64.0f, textureId, tileChunkTexture.getBufferHasLight(), tileChunkTexture.getBufferHasLight() ? rendererLight : rendererNoLight);
                                texturesToDelete.add(textureId);
                            }
                        }
                        float brightness = mapProcessor.getBrightness(exportedLayer, mapProcessor.getWorld(), WorldMap.settings.lighting && exportedLayer != Integer.MAX_VALUE);
                        GlStateManager.func_227702_d_((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
                        rendererProvider.draw(rendererLight);
                        rendererProvider.draw(rendererNoLight);
                        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        GL11.glDeleteTextures((int[])texturesToDelete.toIntArray());
                        RenderSystem.bindTexture((int)0);
                    }
                }
                matrixStack.func_227865_b_();
                RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
                exportFrameBuffer.func_147612_c();
                BufferCompatibilityFix.clear(frameDataBuffer);
                GL11.glGetTexImage((int)3553, (int)0, (int)32993, (int)33639, (ByteBuffer)frameDataBuffer);
                frameDataBuffer.asIntBuffer().get(bufferArray);
                int actualFrameWidth = Math.min(frameWidth, exportWidth - i * frameWidth);
                int actualFrameHeight = Math.min(frameHeight, exportHeight - j * frameWidth);
                image.setRGB(i * frameWidth, j * frameHeight, actualFrameWidth, actualFrameHeight, bufferArray, 0, frameWidth);
            }
        }
        exportFrameBuffer.func_147609_e();
        RenderSystem.enableCull();
        matrixStack.func_227865_b_();
        RenderSystem.matrixMode((int)5889);
        Minecraft mc = Minecraft.func_71410_x();
        ImprovedFramebuffer.bindDefaultFramebuffer(exportFrameBuffer.getType(), 36160, mc);
        Misc.minecraftOrtho(mc, SupportMods.vivecraft);
        RenderSystem.matrixMode((int)5888);
        RenderSystem.bindTexture((int)0);
        exportFrameBuffer.func_147608_a();
        mapProcessor.getBufferDeallocator().deallocate(frameDataBuffer, WorldMap.settings.debug);
        Stream<Path> exports = null;
        try {
            Object[] exportsArray;
            if (!Files.exists(this.destinationPath, new LinkOption[0])) {
                Files.createDirectories(this.destinationPath, new FileAttribute[0]);
            }
            int exportNumber = 1;
            exports = Files.list(this.destinationPath);
            if (exports == null) {
                return;
            }
            for (Object o : exportsArray = exports.toArray()) {
                Path path = (Path)o;
                if (!path.getFileName().toString().endsWith("png")) continue;
                try {
                    int currentNumber = Integer.parseInt(path.getFileName().toString().split("\\.")[0].split("_")[1]);
                    if (currentNumber < exportNumber) continue;
                    exportNumber = currentNumber + 1;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            ImageIO.write((RenderedImage)image, "png", this.destinationPath.resolve("export_" + exportNumber + ".png").toFile());
        }
        catch (IOException e1) {
            WorldMap.LOGGER.error("Failed to export PNG: ", (Throwable)e1);
        }
        finally {
            if (exports != null) {
                exports.close();
            }
            image.flush();
        }
    }
}

