/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xaero.map.WorldMap;
import xaero.map.gui.CursorBox;
import xaero.map.gui.GuiMap;
import xaero.map.gui.TooltipButton;
import xaero.map.settings.ModOptions;
import xaero.map.world.MapDimension;

public class GuiCaveModeOptions {
    private MapDimension dimension;
    private boolean enabled;
    private Widget caveModeStartSlider;
    private TextFieldWidget caveModeStartField;

    public void onInit(GuiMap screen) {
        this.caveModeStartSlider = null;
        this.caveModeStartField = null;
        this.dimension = screen.getDimension();
        if (this.enabled && this.dimension != null) {
            this.updateSlider(screen);
            this.updateField(screen);
            CursorBox caveModeTypeButtonTooltip = new CursorBox("gui.xaero_wm_box_cave_mode_type");
            screen.func_230480_a_(new TooltipButton(20, screen.field_230709_l_ - 62, 150, 20, this.getCaveModeTypeButtonMessage(), b -> this.onCaveModeTypeButton(b, screen), () -> caveModeTypeButtonTooltip));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCaveModeTypeButton(Button b, GuiMap screen) {
        this.dimension.toggleCaveModeType(true);
        Object object = screen.getMapProcessor().uiSync;
        synchronized (object) {
            this.dimension.saveConfigUnsynced();
        }
        b.func_238482_a_(this.getCaveModeTypeButtonMessage());
    }

    private TextFieldWidget createField(GuiMap screen) {
        TextFieldWidget field = new TextFieldWidget(Minecraft.func_71410_x().field_71466_p, 172, screen.field_230709_l_ - 40, 50, 20, (ITextComponent)new TranslationTextComponent("gui.xaero_wm_cave_mode_start"));
        field.func_146203_f(7);
        field.func_146180_a(WorldMap.settings.caveModeStart == Integer.MAX_VALUE ? "" : WorldMap.settings.caveModeStart + "");
        field.func_212954_a(text -> {
            try {
                WorldMap.settings.caveModeStart = text.isEmpty() || text.equalsIgnoreCase("auto") ? Integer.MAX_VALUE : Integer.parseInt(text);
                this.updateSlider(screen);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        return field;
    }

    private Widget createSlider(GuiMap screen) {
        return ModOptions.CAVE_MODE_START.getMcOption().func_216586_a(screen.getMinecraft().field_71474_y, 20, screen.field_230709_l_ - 40, 150);
    }

    private void updateField(GuiMap screen) {
        if (this.caveModeStartField == null) {
            this.caveModeStartField = this.createField(screen);
            screen.func_230480_a_(this.caveModeStartField);
        } else {
            this.caveModeStartField = this.createField(screen);
            screen.replaceWidget((Widget)this.caveModeStartField, (Widget)this.caveModeStartField);
        }
    }

    private void updateSlider(GuiMap screen) {
        if (this.caveModeStartSlider == null) {
            this.caveModeStartSlider = this.createSlider(screen);
            screen.func_230480_a_(this.caveModeStartSlider);
        } else {
            this.caveModeStartSlider = this.createSlider(screen);
            screen.replaceWidget(this.caveModeStartSlider, this.caveModeStartSlider);
        }
    }

    public void toggle(GuiMap screen) {
        this.enabled = WorldMap.settings.isCaveMapsAllowed() && !this.enabled;
        screen.func_231158_b_(Minecraft.func_71410_x(), screen.field_230708_k_, screen.field_230709_l_);
    }

    public void onCaveModeStartSet(GuiMap screen) {
        if (this.enabled) {
            this.updateField(screen);
        }
    }

    public void tick(GuiMap screen) {
        if (this.enabled) {
            this.caveModeStartField.func_195612_c(this.caveModeStartField.func_146179_b().isEmpty() ? I18n.func_135052_a((String)"gui.xaero_wm_cave_mode_start_auto", (Object[])new Object[0]) : "");
            this.caveModeStartField.func_146178_a();
        }
    }

    public void unfocusAll() {
        if (this.caveModeStartField != null) {
            this.caveModeStartField.func_146195_b(false);
        }
        if (this.caveModeStartSlider != null && this.caveModeStartSlider.func_230999_j_()) {
            this.caveModeStartSlider.func_231049_c__(true);
        }
    }

    private ITextComponent getCaveModeTypeButtonMessage() {
        return new StringTextComponent(I18n.func_135052_a((String)"gui.xaero_wm_cave_mode_type", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)(this.dimension == null ? "N/A" : (this.dimension.getCaveModeType() == 0 ? "gui.xaero_off" : (this.dimension.getCaveModeType() == 1 ? "gui.xaero_wm_cave_mode_type_layered" : "gui.xaero_wm_cave_mode_type_full"))), (Object[])new Object[0]));
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

