/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.ControlsScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.animation.Animation;
import xaero.map.animation.SinAnimation;
import xaero.map.animation.SlowingAnimation;
import xaero.map.controls.ControlsHandler;
import xaero.map.controls.ControlsRegister;
import xaero.map.effects.Effects;
import xaero.map.element.HoveredMapElementHolder;
import xaero.map.graphics.CustomRenderTypes;
import xaero.map.graphics.ImprovedFramebuffer;
import xaero.map.graphics.MapRenderHelper;
import xaero.map.graphics.renderer.multitexture.MultiTextureRenderTypeRenderer;
import xaero.map.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.map.gui.ConfirmScreenBase;
import xaero.map.gui.CursorBox;
import xaero.map.gui.GuiCaveModeOptions;
import xaero.map.gui.GuiMapSwitching;
import xaero.map.gui.GuiTexturedButton;
import xaero.map.gui.GuiWorldMapSettings;
import xaero.map.gui.IRightClickableElement;
import xaero.map.gui.MapMouseButtonPress;
import xaero.map.gui.MapTileSelection;
import xaero.map.gui.ScreenBase;
import xaero.map.gui.dropdown.DropDownWidget;
import xaero.map.gui.dropdown.rightclick.GuiRightClickMenu;
import xaero.map.gui.dropdown.rightclick.RightClickOption;
import xaero.map.misc.Misc;
import xaero.map.mods.SupportMods;
import xaero.map.mods.gui.Waypoint;
import xaero.map.region.BranchLeveledRegion;
import xaero.map.region.LayeredRegionManager;
import xaero.map.region.LeveledRegion;
import xaero.map.region.MapBlock;
import xaero.map.region.MapRegion;
import xaero.map.region.MapTile;
import xaero.map.region.MapTileChunk;
import xaero.map.region.texture.RegionTexture;
import xaero.map.settings.ModSettings;
import xaero.map.teleport.MapTeleporter;
import xaero.map.world.MapDimension;
import xaero.map.world.MapWorld;

public class GuiMap
extends ScreenBase
implements IRightClickableElement {
    public static final VertexFormatElement TEX_2F_1 = new VertexFormatElement(1, VertexFormatElement.Type.FLOAT, VertexFormatElement.Usage.UV, 2);
    public static final VertexFormatElement TEX_2F_2 = new VertexFormatElement(2, VertexFormatElement.Type.FLOAT, VertexFormatElement.Usage.UV, 2);
    public static final VertexFormat POSITION_TEX_TEX_TEX = new VertexFormat(ImmutableList.builder().add((Object)DefaultVertexFormats.field_181713_m).add((Object)DefaultVertexFormats.field_181715_o).add((Object)TEX_2F_1).add((Object)TEX_2F_2).build());
    private static final double ZOOM_STEP = 1.2;
    private static final int white = -1;
    private static final int black = -16777216;
    private static int lastAmountOfRegionsViewed = 1;
    private long loadingAnimationStart;
    private Entity player;
    private double screenScale = 0.0;
    private int mouseDownPosX = -1;
    private int mouseDownPosY = -1;
    private double mouseDownCameraX = -1.0;
    private double mouseDownCameraZ = -1.0;
    private int mouseCheckPosX = -1;
    private int mouseCheckPosY = -1;
    private long mouseCheckTimeNano = -1L;
    private int prevMouseCheckPosX = -1;
    private int prevMouseCheckPosY = -1;
    private long prevMouseCheckTimeNano = -1L;
    private double cameraX = 0.0;
    private double cameraZ = 0.0;
    private int[] cameraDestination = null;
    private SlowingAnimation cameraDestinationAnimX = null;
    private SlowingAnimation cameraDestinationAnimZ = null;
    private double scale;
    private double userScale;
    private static double destScale = 3.0;
    private boolean pauseZoomKeys;
    private int lastZoomMethod;
    private HoveredMapElementHolder<?, ?> viewed = null;
    private boolean viewedInList;
    private HoveredMapElementHolder<?, ?> viewedOnMousePress = null;
    private boolean overWaypointsMenu;
    private Animation zoomAnim;
    public boolean waypointMenu = false;
    private static ImprovedFramebuffer primaryScaleFBO = null;
    private float[] colourBuffer = new float[4];
    private ArrayList<MapRegion> regionBuffer = new ArrayList();
    private ArrayList<BranchLeveledRegion> branchRegionBuffer = new ArrayList();
    private boolean prevWaitingForBranchCache = true;
    private boolean prevLoadingLeaves = true;
    private RegistryKey<World> lastViewedDimensionId;
    private String lastViewedMultiworldId;
    private int mouseBlockPosX;
    private int mouseBlockPosY;
    private int mouseBlockPosZ;
    private long lastStartTime;
    private final GuiMapSwitching dimensionSettings;
    private MapMouseButtonPress leftMouseButton;
    private MapMouseButtonPress rightMouseButton;
    private MapProcessor mapProcessor;
    private MapDimension dimension;
    public boolean noUploadingLimits;
    private boolean[] waitingForBranchCache = new boolean[1];
    private Button settingsButton;
    private Button exportButton;
    private Button waypointsButton;
    private Button radarButton;
    private Button zoomInButton;
    private Button zoomOutButton;
    private Button keybindingsButton;
    private Button caveModeButton;
    private Button buttonPressed;
    private GuiRightClickMenu rightClickMenu;
    private int rightClickX;
    private int rightClickY;
    private int rightClickZ;
    private boolean lastFrameRenderedRootTextures;
    private MapTileSelection mapTileSelection;
    private boolean tabPressed;
    private GuiCaveModeOptions caveModeOptions;
    private static final Matrix4f identityMatrix = new Matrix4f();

    public GuiMap(Screen parent, Screen escape, MapProcessor mapProcessor, Entity player) {
        super(parent, escape, (ITextComponent)new TranslationTextComponent("gui.xaero_world_map_screen"));
        this.player = player;
        this.cameraX = (float)player.func_226277_ct_();
        this.cameraZ = (float)player.func_226281_cx_();
        this.leftMouseButton = new MapMouseButtonPress();
        this.rightMouseButton = new MapMouseButtonPress();
        this.dimensionSettings = new GuiMapSwitching(mapProcessor);
        this.userScale = destScale * (double)(WorldMap.settings.openMapAnimation ? 1.5f : 1.0f);
        this.zoomAnim = new SlowingAnimation(this.userScale, destScale, 0.88, destScale * 0.001);
        this.mapProcessor = mapProcessor;
        this.caveModeOptions = new GuiCaveModeOptions();
        if (SupportMods.minimap()) {
            SupportMods.xaeroMinimap.onMapConstruct();
        }
    }

    private double getScaleMultiplier(int screenShortSide) {
        return screenShortSide <= 1080 ? 1.0 : (double)screenShortSide / 1080.0;
    }

    public <T extends Widget> T func_230480_a_(T p_230480_1_) {
        return (T)super.func_230480_a_(p_230480_1_);
    }

    @Override
    public <T extends IGuiEventListener> T func_230481_d_(T guiEventListener) {
        return super.func_230481_d_(guiEventListener);
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        MapWorld mapWorld = this.mapProcessor.getMapWorld();
        this.dimension = mapWorld == null || mapWorld.getCurrentDimensionId() == null ? null : mapWorld.getCurrentDimension();
        this.tabPressed = false;
        boolean waypointsEnabled = SupportMods.minimap() && WorldMap.settings.waypoints;
        this.waypointMenu = this.waypointMenu && waypointsEnabled;
        this.dimensionSettings.init(this, this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
        CursorBox caveModeButtonTooltip = new CursorBox((ITextComponent)new TranslationTextComponent(WorldMap.settings.isCaveMapsAllowed() ? "gui.xaero_box_cave_mode" : "gui.xaero_box_cave_mode_not_allowed"));
        this.caveModeButton = new GuiTexturedButton(0, this.field_230709_l_ - 40, 20, 20, 229, 64, 16, 16, WorldMap.guiTextures, this::onCaveModeButton, () -> caveModeButtonTooltip);
        this.caveModeButton.field_230693_o_ = WorldMap.settings.isCaveMapsAllowed();
        this.func_230480_a_(this.caveModeButton);
        this.caveModeOptions.onInit(this);
        this.loadingAnimationStart = System.currentTimeMillis();
        if (SupportMods.minimap()) {
            SupportMods.xaeroMinimap.requestWaypointsRefresh();
        }
        this.screenScale = Minecraft.func_71410_x().func_228018_at_().func_198100_s();
        this.pauseZoomKeys = false;
        CursorBox openSettingsTooltip = new CursorBox((ITextComponent)new TranslationTextComponent("gui.xaero_box_open_settings", new Object[]{Misc.getKeyName(ControlsRegister.keyOpenSettings)}));
        this.settingsButton = new GuiTexturedButton(0, 0, 30, 30, 113, 0, 20, 20, WorldMap.guiTextures, this::onSettingsButton, () -> openSettingsTooltip);
        this.func_230480_a_(this.settingsButton);
        CursorBox waypointsTooltip = waypointsEnabled ? new CursorBox(this.waypointMenu ? "gui.xaero_box_close_waypoints" : "gui.xaero_box_open_waypoints") : new CursorBox(!SupportMods.minimap() ? "gui.xaero_box_waypoints_minimap_required" : "gui.xaero_box_waypoints_disabled");
        this.waypointsButton = new GuiTexturedButton(this.field_230708_k_ - 20, this.field_230709_l_ - 20, 20, 20, 213, 0, 16, 16, WorldMap.guiTextures, this::onWaypointsButton, () -> waypointsTooltip);
        this.func_230480_a_(this.waypointsButton);
        this.waypointsButton.field_230693_o_ = waypointsEnabled;
        CursorBox radarButtonTooltip = new CursorBox((ITextComponent)new TranslationTextComponent(WorldMap.settings.minimapRadar ? "gui.xaero_box_minimap_radar" : "gui.xaero_box_no_minimap_radar", new Object[]{new StringTextComponent(Misc.getKeyName(SupportMods.minimap() ? SupportMods.xaeroMinimap.getToggleRadarKey() : null)).func_240699_a_(TextFormatting.DARK_GREEN)}));
        this.radarButton = new GuiTexturedButton(this.field_230708_k_ - 20, this.field_230709_l_ - 40, 20, 20, WorldMap.settings.minimapRadar ? 213 : 229, 32, 16, 16, WorldMap.guiTextures, this::onRadarButton, () -> radarButtonTooltip);
        this.func_230480_a_(this.radarButton);
        this.getRadarButton().field_230693_o_ = SupportMods.minimap();
        CursorBox exportButtonTooltip = new CursorBox("gui.xaero_box_export");
        this.exportButton = new GuiTexturedButton(this.field_230708_k_ - 20, this.field_230709_l_ - 60, 20, 20, 133, 0, 16, 16, WorldMap.guiTextures, this::onExportButton, () -> exportButtonTooltip);
        this.func_230480_a_(this.exportButton);
        CursorBox controlsButtonTooltip = new CursorBox(I18n.func_135052_a((String)"gui.xaero_box_controls", (Object[])new Object[]{SupportMods.minimap() ? SupportMods.xaeroMinimap.getControlsTooltip() : ""}));
        this.keybindingsButton = new GuiTexturedButton(this.field_230708_k_ - 20, this.field_230709_l_ - 80, 20, 20, 197, 0, 16, 16, WorldMap.guiTextures, this::onKeybindingsButton, () -> controlsButtonTooltip);
        this.func_230480_a_(this.keybindingsButton);
        CursorBox zoomInButtonTooltip = new CursorBox((ITextComponent)new TranslationTextComponent("gui.xaero_box_zoom_in", new Object[]{new StringTextComponent(Misc.getKeyName(ControlsRegister.keyZoomIn)).func_240699_a_(TextFormatting.DARK_GREEN)}));
        this.zoomInButton = new GuiTexturedButton(this.field_230708_k_ - 20, this.field_230709_l_ - 120, 20, 20, 165, 0, 16, 16, WorldMap.guiTextures, this::onZoomInButton, () -> zoomInButtonTooltip);
        CursorBox zoomOutButtonTooltip = new CursorBox((ITextComponent)new TranslationTextComponent("gui.xaero_box_zoom_out", new Object[]{new StringTextComponent(Misc.getKeyName(ControlsRegister.keyZoomOut)).func_240699_a_(TextFormatting.DARK_GREEN)}));
        this.zoomOutButton = new GuiTexturedButton(this.field_230708_k_ - 20, this.field_230709_l_ - 100, 20, 20, 181, 0, 16, 16, WorldMap.guiTextures, this::onZoomOutButton, () -> zoomOutButtonTooltip);
        if (WorldMap.settings.zoomButtons) {
            this.func_230480_a_(this.zoomOutButton);
            this.func_230480_a_(this.zoomInButton);
        }
        if (this.rightClickMenu != null) {
            this.rightClickMenu.setClosed(true);
            this.rightClickMenu = null;
        }
        if (SupportMods.minimap() && this.waypointMenu) {
            SupportMods.xaeroMinimap.onMapInit(this, this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
        }
        this.field_230706_i_.field_195559_v.func_197967_a(true);
    }

    private void onCaveModeButton(Button b) {
        this.caveModeOptions.toggle(this);
        this.func_231035_a_((IGuiEventListener)this.caveModeButton);
    }

    private void onSettingsButton(Button b) {
        this.field_230706_i_.func_147108_a((Screen)new GuiWorldMapSettings(this, this));
    }

    private void onKeybindingsButton(Button b) {
        this.field_230706_i_.func_147108_a((Screen)new ControlsScreen((Screen)this, this.field_230706_i_.field_71474_y));
    }

    private void onExportButton(Button b) {
        this.field_230706_i_.func_147108_a((Screen)new ConfirmScreenBase(this, this, true, result -> {
            if (result) {
                if (this.mapProcessor.getMapSaveLoad().exportPNG(this) && this.field_230706_i_.field_71462_r instanceof ConfirmScreenBase) {
                    for (IGuiEventListener c : this.field_230706_i_.field_71462_r.func_231039_at__()) {
                        if (!(c instanceof Button)) continue;
                        ((Button)c).field_230693_o_ = false;
                    }
                }
            } else {
                this.field_230706_i_.func_147108_a((Screen)this);
            }
        }, (ITextComponent)new TranslationTextComponent("gui.xaero_export_confirm_1"), (ITextComponent)new TranslationTextComponent("gui.xaero_export_confirm_2")));
    }

    private void onWaypointsButton(Button b) {
        boolean bl = this.waypointMenu = !this.waypointMenu;
        if (!this.waypointMenu) {
            SupportMods.xaeroMinimap.getWaypointMenuRenderer().onMenuClosed();
            this.unfocusAll();
        }
        this.func_231158_b_(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
        this.func_231035_a_((IGuiEventListener)this.waypointsButton);
    }

    public void onRadarButton(Button b) {
        WorldMap.settings.minimapRadar = !WorldMap.settings.minimapRadar;
        try {
            WorldMap.settings.saveSettings();
        }
        catch (IOException e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
        }
        this.func_231158_b_(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
        this.func_231035_a_((IGuiEventListener)this.radarButton);
    }

    private void onZoomInButton(Button b) {
        this.buttonPressed = this.buttonPressed == null ? b : null;
    }

    private void onZoomOutButton(Button b) {
        this.buttonPressed = this.buttonPressed == null ? b : null;
    }

    @Override
    public boolean func_231044_a_(double par1, double par2, int par3) {
        boolean toReturn = super.func_231044_a_(par1, par2, par3);
        if (!toReturn) {
            if (par3 == 0) {
                this.leftMouseButton.clicked = true;
                this.leftMouseButton.isDown = true;
                this.leftMouseButton.pressedAtX = (int)Misc.getMouseX(this.field_230706_i_, SupportMods.vivecraft);
                this.leftMouseButton.pressedAtY = (int)Misc.getMouseY(this.field_230706_i_, SupportMods.vivecraft);
            } else if (par3 == 1) {
                this.rightMouseButton.clicked = true;
                this.rightMouseButton.isDown = true;
                this.rightMouseButton.pressedAtX = (int)Misc.getMouseX(this.field_230706_i_, SupportMods.vivecraft);
                this.rightMouseButton.pressedAtY = (int)Misc.getMouseY(this.field_230706_i_, SupportMods.vivecraft);
                this.viewedOnMousePress = this.viewed;
                this.rightClickX = this.mouseBlockPosX;
                this.rightClickY = this.mouseBlockPosY;
                this.rightClickZ = this.mouseBlockPosZ;
                if (this.viewedOnMousePress == null || !this.viewedOnMousePress.isRightClickValid()) {
                    this.mapTileSelection = new MapTileSelection(this.rightClickX >> 4, this.rightClickZ >> 4);
                }
            } else {
                toReturn = this.onInputPress(InputMappings.Type.MOUSE, par3);
            }
            if (!toReturn && this.caveModeOptions.isEnabled()) {
                this.caveModeOptions.toggle(this);
                toReturn = true;
            }
        }
        return toReturn;
    }

    @Override
    public boolean func_231048_c_(double par1, double par2, int par3) {
        boolean toReturn;
        this.buttonPressed = null;
        int mouseX = (int)Misc.getMouseX(this.field_230706_i_, SupportMods.vivecraft);
        int mouseY = (int)Misc.getMouseY(this.field_230706_i_, SupportMods.vivecraft);
        if (this.leftMouseButton.isDown && par3 == 0) {
            this.leftMouseButton.isDown = false;
            if (Math.abs(this.leftMouseButton.pressedAtX - mouseX) < 5 && Math.abs(this.leftMouseButton.pressedAtY - mouseY) < 5) {
                this.mapClicked(0, this.leftMouseButton.pressedAtX, this.leftMouseButton.pressedAtY);
            }
            this.leftMouseButton.pressedAtX = -1;
            this.leftMouseButton.pressedAtY = -1;
        }
        if (this.rightMouseButton.isDown && par3 == 1) {
            this.rightMouseButton.isDown = false;
            this.mapClicked(1, mouseX, mouseY);
            this.rightMouseButton.pressedAtX = -1;
            this.rightMouseButton.pressedAtY = -1;
        }
        if (this.waypointMenu) {
            SupportMods.xaeroMinimap.onMapMouseRelease(par1, par2, par3);
        }
        if (!(toReturn = super.func_231048_c_(par1, par2, par3))) {
            toReturn = this.onInputRelease(InputMappings.Type.MOUSE, par3);
        }
        return toReturn;
    }

    @Override
    public boolean func_231043_a_(double par1, double par2, double wheel) {
        int direction;
        int n = direction = wheel > 0.0 ? 1 : -1;
        if (this.waypointMenu && this.overWaypointsMenu) {
            SupportMods.xaeroMinimap.getWaypointMenuRenderer().mouseScrolled(direction);
        } else {
            this.changeZoom(wheel, 0);
        }
        return super.func_231043_a_(par1, par2, wheel);
    }

    private void changeZoom(double factor, int zoomMethod) {
        this.closeDropdowns();
        this.lastZoomMethod = zoomMethod;
        this.cameraDestinationAnimX = null;
        this.cameraDestinationAnimZ = null;
        if (GuiMap.func_231172_r_()) {
            double destScaleBefore = destScale;
            if (destScale >= 1.0) {
                destScale = factor > 0.0 ? Math.ceil(destScale) : Math.floor(destScale);
                if (destScaleBefore == destScale) {
                    destScale += factor > 0.0 ? 1.0 : -1.0;
                }
                if (destScale == 0.0) {
                    destScale = 0.5;
                }
            } else {
                double reversedScale = 1.0 / destScale;
                double log2 = Math.log(reversedScale) / Math.log(2.0);
                log2 = factor > 0.0 ? Math.floor(log2) : Math.ceil(log2);
                destScale = 1.0 / Math.pow(2.0, log2);
                if (destScaleBefore == destScale) {
                    destScale = 1.0 / Math.pow(2.0, log2 + (double)(factor > 0.0 ? -1 : 1));
                }
            }
        } else {
            destScale *= Math.pow(1.2, factor);
        }
        if (destScale < 0.0625) {
            destScale = 0.0625;
        } else if (destScale > 50.0) {
            destScale = 50.0;
        }
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        this.leftMouseButton.isDown = false;
        this.rightMouseButton.isDown = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void func_230430_a_(MatrixStack matrixStack, int scaledMouseX, int scaledMouseY, float partialTicks) {
        int direction;
        MapDimension currentDim;
        while (GL11.glGetError() != 0) {
        }
        GlStateManager.func_227673_b_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        Minecraft mc = Minecraft.func_71410_x();
        double cameraXBefore = this.cameraX;
        double cameraZBefore = this.cameraZ;
        double scaleBefore = this.scale;
        long startTime = System.currentTimeMillis();
        MapDimension mapDimension = currentDim = !this.mapProcessor.isMapWorldUsable() ? null : this.mapProcessor.getMapWorld().getCurrentDimension();
        if (currentDim != this.dimension) {
            this.dimensionSettings.active = false;
            this.func_231158_b_(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
        }
        this.dimensionSettings.preMapRender(this, this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
        long passed = this.lastStartTime == 0L ? 16L : startTime - this.lastStartTime;
        double passedScrolls = (float)passed / 64.0f;
        int n = this.buttonPressed == this.zoomInButton || ControlsHandler.isDown(ControlsRegister.keyZoomIn) ? 1 : (direction = this.buttonPressed == this.zoomOutButton || ControlsHandler.isDown(ControlsRegister.keyZoomOut) ? -1 : 0);
        if (direction != 0) {
            boolean ctrlKey = GuiMap.func_231172_r_();
            if (!ctrlKey || !this.pauseZoomKeys) {
                this.changeZoom((double)direction * passedScrolls, this.buttonPressed == this.zoomInButton || this.buttonPressed == this.zoomOutButton ? 2 : 1);
                if (ctrlKey) {
                    this.pauseZoomKeys = true;
                }
            }
        } else {
            this.pauseZoomKeys = false;
        }
        this.lastStartTime = startTime;
        if (this.cameraDestination != null) {
            this.cameraDestinationAnimX = new SlowingAnimation(this.cameraX, this.cameraDestination[0], 0.9, 0.01);
            this.cameraDestinationAnimZ = new SlowingAnimation(this.cameraZ, this.cameraDestination[1], 0.9, 0.01);
            this.cameraDestination = null;
        }
        if (this.cameraDestinationAnimX != null) {
            this.cameraX = this.cameraDestinationAnimX.getCurrent();
            if (this.cameraX == this.cameraDestinationAnimX.getDestination()) {
                this.cameraDestinationAnimX = null;
            }
        }
        if (this.cameraDestinationAnimZ != null) {
            this.cameraZ = this.cameraDestinationAnimZ.getCurrent();
            if (this.cameraZ == this.cameraDestinationAnimZ.getDestination()) {
                this.cameraDestinationAnimZ = null;
            }
        }
        this.lastViewedDimensionId = null;
        this.lastViewedMultiworldId = null;
        this.mouseBlockPosY = -1;
        boolean discoveredForHighlights = false;
        Object object = this.mapProcessor.renderThreadPauseSync;
        synchronized (object) {
            if (!this.mapProcessor.isRenderingPaused()) {
                boolean mapLoaded = this.mapProcessor.getCurrentWorldId() != null && !this.mapProcessor.isWaitingForWorldUpdate() && this.mapProcessor.getMapSaveLoad().isRegionDetectionComplete();
                boolean noWorldMapEffect = mc.field_71439_g.func_70644_a(Effects.NO_WORLD_MAP) || mc.field_71439_g.func_70644_a(Effects.NO_WORLD_MAP_HARMFUL);
                boolean allowedBasedOnItem = ModSettings.mapItem == null || Misc.hasItem((PlayerEntity)mc.field_71439_g, ModSettings.mapItem);
                boolean isLocked = this.mapProcessor.isCurrentMapLocked();
                if (mapLoaded && !noWorldMapEffect && allowedBasedOnItem && !isLocked) {
                    String subWorldNameToRender;
                    MapRegion leveledRegion;
                    double secondaryOffsetY;
                    double secondaryOffsetX;
                    RegionTexture tex;
                    MapRegion leafRegion;
                    if (SupportMods.vivecraft) {
                        GlStateManager.func_227673_b_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        GlStateManager.func_227658_a_((int)16384, (boolean)Minecraft.field_142025_a);
                    }
                    this.mapProcessor.updateCaveStart();
                    this.lastViewedDimensionId = this.mapProcessor.getMapWorld().getCurrentDimension().getDimId();
                    this.lastViewedMultiworldId = this.mapProcessor.getMapWorld().getCurrentDimension().getCurrentMultiworld();
                    if (SupportMods.minimap()) {
                        SupportMods.xaeroMinimap.checkWaypoints(this.mapProcessor.getMapWorld().isMultiplayer(), this.lastViewedDimensionId, this.lastViewedMultiworldId, this.field_230708_k_, this.field_230709_l_, this);
                    }
                    int mouseXPos = (int)Misc.getMouseX(mc, false);
                    int mouseYPos = (int)Misc.getMouseY(mc, false);
                    double scaleMultiplier = this.getScaleMultiplier(Math.min(mc.func_228018_at_().func_198109_k(), mc.func_228018_at_().func_198091_l()));
                    this.scale = this.userScale * scaleMultiplier;
                    if (this.mouseCheckPosX == -1 || System.nanoTime() - this.mouseCheckTimeNano > 30000000L) {
                        this.prevMouseCheckPosX = this.mouseCheckPosX;
                        this.prevMouseCheckPosY = this.mouseCheckPosY;
                        this.prevMouseCheckTimeNano = this.mouseCheckTimeNano;
                        this.mouseCheckPosX = mouseXPos;
                        this.mouseCheckPosY = mouseYPos;
                        this.mouseCheckTimeNano = System.nanoTime();
                    }
                    if (!this.leftMouseButton.isDown) {
                        if (this.mouseDownPosX != -1) {
                            this.mouseDownPosX = -1;
                            this.mouseDownPosY = -1;
                            if (this.prevMouseCheckTimeNano != -1L) {
                                double speed_z;
                                double frameTime60FPS;
                                double downTime = 0.0;
                                int draggedX = 0;
                                int draggedY = 0;
                                draggedX = mouseXPos - this.prevMouseCheckPosX;
                                downTime = System.nanoTime() - this.prevMouseCheckTimeNano;
                                double speedScale = downTime / (frameTime60FPS = 1.6666666666666666E7);
                                double speed_x = (double)(-draggedX) / this.scale / speedScale;
                                double speed = Math.sqrt(speed_x * speed_x + (speed_z = (double)(-(draggedY = mouseYPos - this.prevMouseCheckPosY)) / this.scale / speedScale) * speed_z);
                                if (speed > 0.0) {
                                    double cos = speed_x / speed;
                                    double sin = speed_z / speed;
                                    double maxSpeed = 500.0 / this.userScale;
                                    speed = Math.abs(speed) > maxSpeed ? Math.copySign(maxSpeed, speed) : speed;
                                    double speed_factor = 0.9;
                                    double ln = Math.log(speed_factor);
                                    double move_distance = -speed / ln;
                                    double moveX = cos * move_distance;
                                    double moveZ = sin * move_distance;
                                    this.cameraDestinationAnimX = new SlowingAnimation(this.cameraX, this.cameraX + moveX, 0.9, 0.01);
                                    this.cameraDestinationAnimZ = new SlowingAnimation(this.cameraZ, this.cameraZ + moveZ, 0.9, 0.01);
                                }
                            }
                        }
                    } else if (this.viewed == null || !this.viewedInList || this.mouseDownPosX != -1) {
                        if (this.mouseDownPosX != -1) {
                            this.cameraX = (double)(this.mouseDownPosX - mouseXPos) / this.scale + this.mouseDownCameraX;
                            this.cameraZ = (double)(this.mouseDownPosY - mouseYPos) / this.scale + this.mouseDownCameraZ;
                        } else {
                            this.mouseDownPosX = mouseXPos;
                            this.mouseDownPosY = mouseYPos;
                            this.mouseDownCameraX = this.cameraX;
                            this.mouseDownCameraZ = this.cameraZ;
                            this.cameraDestinationAnimX = null;
                            this.cameraDestinationAnimZ = null;
                        }
                    }
                    int mouseFromCentreX = mouseXPos - mc.func_228018_at_().func_198109_k() / 2;
                    int mouseFromCentreY = mouseYPos - mc.func_228018_at_().func_198091_l() / 2;
                    double oldMousePosX = (double)mouseFromCentreX / this.scale + this.cameraX;
                    double oldMousePosZ = (double)mouseFromCentreY / this.scale + this.cameraZ;
                    double preScale = this.scale;
                    if (destScale != this.userScale) {
                        if (this.zoomAnim != null) {
                            this.userScale = this.zoomAnim.getCurrent();
                            this.scale = this.userScale * scaleMultiplier;
                        }
                        if (this.zoomAnim == null || Misc.round(this.zoomAnim.getDestination(), 4) != Misc.round(destScale, 4)) {
                            this.zoomAnim = new SinAnimation(this.userScale, destScale, 100L);
                        }
                    }
                    if (this.scale > preScale && this.lastZoomMethod != 2) {
                        this.cameraX = oldMousePosX - (double)mouseFromCentreX / this.scale;
                        this.cameraZ = oldMousePosZ - (double)mouseFromCentreY / this.scale;
                    }
                    int textureLevel = 0;
                    double fboScale = this.scale >= 1.0 ? Math.max(1.0, Math.floor(this.scale)) : this.scale;
                    if (this.userScale < 1.0) {
                        double reversedScale = 1.0 / this.userScale;
                        double log2 = Math.floor(Math.log(reversedScale) / Math.log(2.0));
                        textureLevel = Math.min((int)log2, 3);
                    }
                    this.mapProcessor.getMapSaveLoad().mainTextureLevel = textureLevel;
                    int leveledRegionShift = 9 + textureLevel;
                    double secondaryScale = this.scale / fboScale;
                    matrixStack.func_227860_a_();
                    double mousePosX = (double)mouseFromCentreX / this.scale + this.cameraX;
                    double mousePosZ = (double)mouseFromCentreY / this.scale + this.cameraZ;
                    matrixStack.func_227860_a_();
                    matrixStack.func_227861_a_(0.0, 0.0, 971.0);
                    this.mouseBlockPosX = (int)Math.floor(mousePosX);
                    this.mouseBlockPosZ = (int)Math.floor(mousePosZ);
                    int mouseRegX = this.mouseBlockPosX >> leveledRegionShift;
                    int mouseRegZ = this.mouseBlockPosZ >> leveledRegionShift;
                    int renderedCaveLayer = this.mapProcessor.getCurrentCaveLayer();
                    LeveledRegion<?> reg = this.mapProcessor.getLeveledRegion(renderedCaveLayer, mouseRegX, mouseRegZ, textureLevel);
                    int maxRegBlockCoord = (1 << leveledRegionShift) - 1;
                    int mouseRegPixelX = (this.mouseBlockPosX & maxRegBlockCoord) >> textureLevel;
                    int mouseRegPixelZ = (this.mouseBlockPosZ & maxRegBlockCoord) >> textureLevel;
                    this.mouseBlockPosX = (mouseRegX << leveledRegionShift) + (mouseRegPixelX << textureLevel);
                    this.mouseBlockPosZ = (mouseRegZ << leveledRegionShift) + (mouseRegPixelZ << textureLevel);
                    if (this.mapTileSelection != null && this.rightClickMenu == null) {
                        this.mapTileSelection.setEnd(this.mouseBlockPosX >> 4, this.mouseBlockPosZ >> 4);
                    }
                    MapTileChunk chunk = (leafRegion = this.mapProcessor.getMapRegion(renderedCaveLayer, this.mouseBlockPosX >> 9, this.mouseBlockPosZ >> 9, false)) == null ? null : leafRegion.getChunk(this.mouseBlockPosX >> 6 & 7, this.mouseBlockPosZ >> 6 & 7);
                    int debugTextureX = this.mouseBlockPosX >> leveledRegionShift - 3 & 7;
                    int debugTextureY = this.mouseBlockPosZ >> leveledRegionShift - 3 & 7;
                    RegionTexture regionTexture = tex = reg != null && reg.hasTextures() ? (RegionTexture)reg.getTexture(debugTextureX, debugTextureY) : null;
                    if (WorldMap.settings.debug) {
                        if (reg != null) {
                            ArrayList<String> debugLines = new ArrayList<String>();
                            if (tex != null) {
                                MapBlock block;
                                MapTile mouseTile;
                                tex.addDebugLines(debugLines);
                                MapTile mapTile = mouseTile = chunk == null ? null : chunk.getTile(this.mouseBlockPosX >> 4 & 3, this.mouseBlockPosZ >> 4 & 3);
                                if (mouseTile != null && (block = mouseTile.getBlock(this.mouseBlockPosX & 0xF, this.mouseBlockPosZ & 0xF)) != null) {
                                    GuiMap.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (String)block.toRenderString(leafRegion.getBiomeRegistry()), (int)(this.field_230708_k_ / 2), (int)22, (int)-1);
                                    if (block.getNumberOfOverlays() != 0) {
                                        for (int i = 0; i < block.getOverlays().size(); ++i) {
                                            GuiMap.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (String)block.getOverlays().get(i).toRenderString(), (int)(this.field_230708_k_ / 2), (int)(32 + i * 10), (int)-1);
                                        }
                                    }
                                }
                            }
                            debugLines.add("");
                            debugLines.add(reg.toString());
                            reg.addDebugLines(debugLines, this.mapProcessor, debugTextureX, debugTextureY);
                            for (int i = 0; i < debugLines.size(); ++i) {
                                GuiMap.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (String)((String)debugLines.get(i)), (int)5, (int)(15 + 10 * i), (int)-1);
                            }
                        }
                        if (this.mapProcessor.getMapWorld().isMultiplayer()) {
                            GuiMap.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (String)("MultiWorld ID: " + this.mapProcessor.getMapWorld().getCurrentMultiworld()), (int)5, (int)255, (int)-1);
                        }
                        LayeredRegionManager regions = this.mapProcessor.getMapWorld().getCurrentDimension().getLayeredMapRegions();
                        GuiMap.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (String)String.format("regions: %d loaded: %d processed: %d viewed: %d benchmarks %s", regions.size(), regions.loadedCount(), this.mapProcessor.getProcessedCount(), lastAmountOfRegionsViewed, WorldMap.textureUploadBenchmark.getTotalsString()), (int)5, (int)265, (int)-1);
                        GuiMap.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (String)String.format("toLoad: %d toSave: %d tile pool: %d overlays: %d toLoadBranchCache: %d buffers: %d", this.mapProcessor.getMapSaveLoad().getSizeOfToLoad(), this.mapProcessor.getMapSaveLoad().getToSave().size(), this.mapProcessor.getTilePool().size(), this.mapProcessor.getOverlayManager().getNumberOfUniqueOverlays(), this.mapProcessor.getMapSaveLoad().getSizeOfToLoadBranchCache(), WorldMap.textureDirectBufferPool.size()), (int)5, (int)275, (int)-1);
                        long i = Runtime.getRuntime().maxMemory();
                        long j = Runtime.getRuntime().totalMemory();
                        long k = Runtime.getRuntime().freeMemory();
                        long l = j - k;
                        int debugFPS = this.mapProcessor.getDebugFPS(mc);
                        GuiMap.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (String)String.format("FPS: %d", debugFPS), (int)5, (int)295, (int)-1);
                        GuiMap.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (String)String.format("Mem: % 2d%% %03d/%03dMB", l * 100L / i, GuiMap.bytesToMb(l), GuiMap.bytesToMb(i)), (int)5, (int)305, (int)-1);
                        GuiMap.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (String)String.format("Allocated: % 2d%% %03dMB", j * 100L / i, GuiMap.bytesToMb(j)), (int)5, (int)315, (int)-1);
                        GuiMap.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (String)String.format("Available VRAM: %dMB", this.mapProcessor.getMapLimiter().getAvailableVRAM() / 1024), (int)5, (int)325, (int)-1);
                    }
                    int pixelInsideTexX = mouseRegPixelX & 0x3F;
                    int pixelInsideTexZ = mouseRegPixelZ & 0x3F;
                    boolean hasAmbiguousHeight = false;
                    int mouseBlockBottomY = -1;
                    int mouseBlockTopY = -1;
                    RegistryKey<Biome> pointedAtBiome = null;
                    if (tex != null) {
                        mouseBlockBottomY = this.mouseBlockPosY = tex.getHeight(pixelInsideTexX, pixelInsideTexZ);
                        mouseBlockTopY = tex.getTopHeight(pixelInsideTexX, pixelInsideTexZ);
                        hasAmbiguousHeight = this.mouseBlockPosY != mouseBlockTopY;
                        pointedAtBiome = tex.getBiome(pixelInsideTexX, pixelInsideTexZ);
                    }
                    if (hasAmbiguousHeight) {
                        if (mouseBlockTopY != -1) {
                            this.mouseBlockPosY = mouseBlockTopY;
                        } else if (WorldMap.settings.detectAmbiguousY) {
                            this.mouseBlockPosY = -1;
                        }
                    }
                    matrixStack.func_227865_b_();
                    if (primaryScaleFBO == null || GuiMap.primaryScaleFBO.field_147621_c != mc.func_228018_at_().func_198109_k() || GuiMap.primaryScaleFBO.field_147618_d != mc.func_228018_at_().func_198091_l()) {
                        primaryScaleFBO = new ImprovedFramebuffer(mc.func_228018_at_().func_198109_k(), mc.func_228018_at_().func_198091_l(), false);
                    }
                    if (GuiMap.primaryScaleFBO.field_147616_f == -1) {
                        matrixStack.func_227865_b_();
                        return;
                    }
                    primaryScaleFBO.func_147610_a(false);
                    GlStateManager.func_227673_b_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_227658_a_((int)16384, (boolean)Minecraft.field_142025_a);
                    matrixStack.func_227862_a_((float)(1.0 / this.screenScale), (float)(1.0 / this.screenScale), 1.0f);
                    matrixStack.func_227861_a_((double)(mc.func_228018_at_().func_198109_k() / 2), (double)(mc.func_228018_at_().func_198091_l() / 2), 0.0);
                    matrixStack.func_227860_a_();
                    int flooredCameraX = (int)Math.floor(this.cameraX);
                    int flooredCameraZ = (int)Math.floor(this.cameraZ);
                    double primaryOffsetX = 0.0;
                    double primaryOffsetY = 0.0;
                    if (fboScale < 1.0) {
                        double pixelInBlocks = 1.0 / fboScale;
                        int xInFullPixels = (int)Math.floor(this.cameraX / pixelInBlocks);
                        int zInFullPixels = (int)Math.floor(this.cameraZ / pixelInBlocks);
                        double fboOffsetX = (double)xInFullPixels * pixelInBlocks;
                        double fboOffsetZ = (double)zInFullPixels * pixelInBlocks;
                        flooredCameraX = (int)Math.floor(fboOffsetX);
                        flooredCameraZ = (int)Math.floor(fboOffsetZ);
                        primaryOffsetX = fboOffsetX - (double)flooredCameraX;
                        primaryOffsetY = fboOffsetZ - (double)flooredCameraZ;
                        secondaryOffsetX = (this.cameraX - fboOffsetX) * fboScale;
                        secondaryOffsetY = (this.cameraZ - fboOffsetZ) * fboScale;
                    } else {
                        int offset;
                        secondaryOffsetX = (this.cameraX - (double)flooredCameraX) * fboScale;
                        secondaryOffsetY = (this.cameraZ - (double)flooredCameraZ) * fboScale;
                        if (secondaryOffsetX >= 1.0) {
                            offset = (int)secondaryOffsetX;
                            matrixStack.func_227861_a_((double)(-offset), 0.0, 0.0);
                            secondaryOffsetX -= (double)offset;
                        }
                        if (secondaryOffsetY >= 1.0) {
                            offset = (int)secondaryOffsetY;
                            matrixStack.func_227861_a_(0.0, (double)offset, 0.0);
                            secondaryOffsetY -= (double)offset;
                        }
                    }
                    matrixStack.func_227862_a_((float)fboScale, (float)(-fboScale), 1.0f);
                    matrixStack.func_227861_a_(-primaryOffsetX, -primaryOffsetY, 0.0);
                    double leftBorder = this.cameraX - (double)(mc.func_228018_at_().func_198109_k() / 2) / this.scale;
                    double rightBorder = leftBorder + (double)mc.func_228018_at_().func_198109_k() / this.scale;
                    double topBorder = this.cameraZ - (double)(mc.func_228018_at_().func_198091_l() / 2) / this.scale;
                    double bottomBorder = topBorder + (double)mc.func_228018_at_().func_198091_l() / this.scale;
                    int minRegX = (int)Math.floor(leftBorder) >> leveledRegionShift;
                    int maxRegX = (int)Math.floor(rightBorder) >> leveledRegionShift;
                    int minRegZ = (int)Math.floor(topBorder) >> leveledRegionShift;
                    int maxRegZ = (int)Math.floor(bottomBorder) >> leveledRegionShift;
                    int blockToTextureConversion = 6 + textureLevel;
                    int minTextureX = (int)Math.floor(leftBorder) >> blockToTextureConversion;
                    int maxTextureX = (int)Math.floor(rightBorder) >> blockToTextureConversion;
                    int minTextureZ = (int)Math.floor(topBorder) >> blockToTextureConversion;
                    int maxTextureZ = (int)Math.floor(bottomBorder) >> blockToTextureConversion;
                    int minLeafRegX = minTextureX << blockToTextureConversion >> 9;
                    int maxLeafRegX = (maxTextureX + 1 << blockToTextureConversion) - 1 >> 9;
                    int minLeafRegZ = minTextureZ << blockToTextureConversion >> 9;
                    int maxLeafRegZ = (maxTextureZ + 1 << blockToTextureConversion) - 1 >> 9;
                    lastAmountOfRegionsViewed = (maxRegX - minRegX + 1) * (maxRegZ - minRegZ + 1);
                    if (this.mapProcessor.getMapLimiter().getMostRegionsAtATime() < lastAmountOfRegionsViewed) {
                        this.mapProcessor.getMapLimiter().setMostRegionsAtATime(lastAmountOfRegionsViewed);
                    }
                    this.regionBuffer.clear();
                    this.branchRegionBuffer.clear();
                    float brightness = this.mapProcessor.getBrightness();
                    int globalRegionCacheHashCode = WorldMap.settings.getRegionCacheHashCode();
                    int globalCaveStart = this.mapProcessor.getMapWorld().getCurrentDimension().getLayeredMapRegions().getLayer(renderedCaveLayer).getCaveStart();
                    int globalCaveDepth = WorldMap.settings.caveModeDepth;
                    boolean reloadEverything = WorldMap.settings.reloadEverything;
                    int globalReloadVersion = WorldMap.settings.reloadVersion;
                    boolean oldMinimapMessesUpTextureFilter = SupportMods.minimap() && SupportMods.xaeroMinimap.compatibilityVersion < 11;
                    int globalVersion = this.mapProcessor.getGlobalVersion();
                    boolean prevWaitingForBranchCache = this.prevWaitingForBranchCache;
                    this.waitingForBranchCache[0] = false;
                    Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
                    IRenderTypeBuffer.Impl renderTypeBuffers = this.mapProcessor.getCvc().getRenderTypeBuffers();
                    MultiTextureRenderTypeRendererProvider rendererProvider = this.mapProcessor.getMultiTextureRenderTypeRenderers();
                    MultiTextureRenderTypeRenderer withLightRenderer = rendererProvider.getRenderer(t -> {
                        GlStateManager.func_227756_r_((int)33984);
                        GlStateManager.func_227760_t_((int)t);
                        GlStateManager.func_227756_r_((int)33985);
                        GlStateManager.func_227760_t_((int)t);
                        GlStateManager.func_227756_r_((int)33986);
                        GlStateManager.func_227760_t_((int)t);
                    }, CustomRenderTypes.MAP_WITH_LIGHT);
                    MultiTextureRenderTypeRenderer noLightRenderer = rendererProvider.getRenderer(MultiTextureRenderTypeRendererProvider::defaultTextureBind, CustomRenderTypes.MAP_NO_LIGHT);
                    IVertexBuilder overlayBuffer = renderTypeBuffers.getBuffer(CustomRenderTypes.MAP_COLOR_OVERLAY);
                    LeveledRegion.setComparison(this.mouseBlockPosX >> leveledRegionShift, this.mouseBlockPosZ >> leveledRegionShift, textureLevel, this.mouseBlockPosX >> 9, this.mouseBlockPosZ >> 9);
                    LeveledRegion<?> lastUpdatedRootLeveledRegion = null;
                    boolean frameRenderedRootTextures = false;
                    boolean loadingLeaves = false;
                    for (int leveledRegX = minRegX; leveledRegX <= maxRegX; ++leveledRegX) {
                        for (int leveledRegZ = minRegZ; leveledRegZ <= maxRegZ; ++leveledRegZ) {
                            boolean rootHasTextures;
                            int leveledSideInRegions = 1 << textureLevel;
                            int leveledSideInBlocks = leveledSideInRegions * 512;
                            int leafRegionMinX = leveledRegX * leveledSideInRegions;
                            int leafRegionMinZ = leveledRegZ * leveledSideInRegions;
                            leveledRegion = null;
                            for (int leafX = 0; leafX < leveledSideInRegions; ++leafX) {
                                for (int leafZ = 0; leafZ < leveledSideInRegions; ++leafZ) {
                                    int regZ;
                                    int regX = leafRegionMinX + leafX;
                                    if (regX < minLeafRegX || regX > maxLeafRegX || (regZ = leafRegionMinZ + leafZ) < minLeafRegZ || regZ > maxLeafRegZ) continue;
                                    MapRegion region = this.mapProcessor.getMapRegion(renderedCaveLayer, regX, regZ, false);
                                    if (region == null) {
                                        region = this.mapProcessor.getMapRegion(renderedCaveLayer, regX, regZ, this.mapProcessor.regionExists(renderedCaveLayer, regX, regZ));
                                    }
                                    if (region == null) continue;
                                    if (leveledRegion == null) {
                                        leveledRegion = this.mapProcessor.getLeveledRegion(renderedCaveLayer, leveledRegX, leveledRegZ, textureLevel);
                                    }
                                    if (prevWaitingForBranchCache) continue;
                                    MapRegion mapRegion = region;
                                    synchronized (mapRegion) {
                                        if (textureLevel != 0 && region.getLoadState() == 0 && region.loadingNeededForBranchLevel != 0 && region.loadingNeededForBranchLevel != textureLevel) {
                                            region.loadingNeededForBranchLevel = 0;
                                            region.getParent().setShouldCheckForUpdatesRecursive(true);
                                        }
                                        if (!region.recacheHasBeenRequested() && !region.reloadHasBeenRequested() && !region.isRefreshing() && (region.getLoadState() == 4 || region.getLoadState() == 2 && region.isBeingWritten() || region.getLoadState() == 0) && (reloadEverything && region.getReloadVersion() != globalReloadVersion || region.getCacheHashCode() != globalRegionCacheHashCode || region.caveStartOutdated(globalCaveStart, globalCaveDepth) || region.getVersion() != globalVersion || (region.isMetaLoaded() || region.getLoadState() != 0 || !region.hasHadTerrain()) && region.getHighlightsHash() != region.getDim().getHighlightHandler().getRegionHash(region.getRegionX(), region.getRegionZ()) || region.getLoadState() != 2 && region.shouldCache() || region.getLoadState() == 0 && (textureLevel == 0 || region.loadingNeededForBranchLevel == textureLevel))) {
                                            loadingLeaves = true;
                                            region.calculateSortingDistance();
                                            Misc.addToListOfSmallest(10, this.regionBuffer, region);
                                        }
                                        continue;
                                    }
                                }
                            }
                            if (leveledRegion == null) continue;
                            LeveledRegion<?> rootLeveledRegion = leveledRegion.getRootRegion();
                            if (rootLeveledRegion == leveledRegion) {
                                rootLeveledRegion = null;
                            }
                            if (rootLeveledRegion != null && !rootLeveledRegion.isLoaded()) {
                                if (!rootLeveledRegion.recacheHasBeenRequested() && !rootLeveledRegion.reloadHasBeenRequested()) {
                                    rootLeveledRegion.calculateSortingDistance();
                                    Misc.addToListOfSmallest(10, this.branchRegionBuffer, (BranchLeveledRegion)rootLeveledRegion);
                                }
                                this.waitingForBranchCache[0] = true;
                                rootLeveledRegion = null;
                            }
                            if (!this.mapProcessor.isUploadingPaused() && !WorldMap.settings.pauseRequests) {
                                if (leveledRegion instanceof BranchLeveledRegion) {
                                    BranchLeveledRegion branchRegion = (BranchLeveledRegion)((Object)leveledRegion);
                                    branchRegion.checkForUpdates(this.mapProcessor, prevWaitingForBranchCache, this.waitingForBranchCache, this.branchRegionBuffer, textureLevel, minLeafRegX, minLeafRegZ, maxLeafRegX, maxLeafRegZ);
                                }
                                if ((textureLevel != 0 && !prevWaitingForBranchCache || textureLevel == 0 && !this.prevLoadingLeaves) && this.lastFrameRenderedRootTextures && rootLeveledRegion != null && rootLeveledRegion != lastUpdatedRootLeveledRegion) {
                                    BranchLeveledRegion branchRegion = (BranchLeveledRegion)rootLeveledRegion;
                                    branchRegion.checkForUpdates(this.mapProcessor, prevWaitingForBranchCache, this.waitingForBranchCache, this.branchRegionBuffer, textureLevel, minLeafRegX, minLeafRegZ, maxLeafRegX, maxLeafRegZ);
                                    lastUpdatedRootLeveledRegion = rootLeveledRegion;
                                }
                                this.mapProcessor.getMapWorld().getCurrentDimension().getLayeredMapRegions().bumpLoadedRegion((LeveledRegion<?>)leveledRegion);
                                if (rootLeveledRegion != null) {
                                    this.mapProcessor.getMapWorld().getCurrentDimension().getLayeredMapRegions().bumpLoadedRegion(rootLeveledRegion);
                                }
                            } else {
                                this.waitingForBranchCache[0] = prevWaitingForBranchCache;
                            }
                            int minXBlocks = leveledRegX * leveledSideInBlocks;
                            int minZBlocks = leveledRegZ * leveledSideInBlocks;
                            int textureSize = 64 * leveledSideInRegions;
                            int firstTextureX = leveledRegX << 3;
                            int firstTextureZ = leveledRegZ << 3;
                            int levelDiff = 3 - textureLevel;
                            int rootSize = 1 << levelDiff;
                            int maxInsideCoord = rootSize - 1;
                            int firstRootTextureX = firstTextureX >> levelDiff & 7;
                            int firstRootTextureZ = firstTextureZ >> levelDiff & 7;
                            int firstInsideTextureX = firstTextureX & maxInsideCoord;
                            int firstInsideTextureZ = firstTextureZ & maxInsideCoord;
                            boolean hasTextures = leveledRegion.hasTextures();
                            boolean bl = rootHasTextures = rootLeveledRegion != null && rootLeveledRegion.hasTextures();
                            if (hasTextures || rootHasTextures) {
                                for (int o = 0; o < 8; ++o) {
                                    int textureX = minXBlocks + o * textureSize;
                                    if ((double)textureX > rightBorder || (double)(textureX + textureSize) < leftBorder) continue;
                                    for (int p = 0; p < 8; ++p) {
                                        int texture;
                                        RegionTexture<Object> regionTexture2;
                                        int textureZ = minZBlocks + p * textureSize;
                                        if ((double)textureZ > bottomBorder || (double)(textureZ + textureSize) < topBorder) continue;
                                        RegionTexture regionTexture3 = regionTexture2 = hasTextures ? (RegionTexture)leveledRegion.getTexture(o, p) : null;
                                        if (regionTexture2 == null || regionTexture2.getGlColorTexture() == -1) {
                                            int texture2;
                                            int insideZ;
                                            int rootTextureZ;
                                            int insideX;
                                            int rootTextureX;
                                            if (!rootHasTextures || (regionTexture2 = rootLeveledRegion.getTexture(rootTextureX = firstRootTextureX + ((insideX = firstInsideTextureX + o) >> levelDiff), rootTextureZ = firstRootTextureZ + ((insideZ = firstInsideTextureZ + p) >> levelDiff))) == null) continue;
                                            int n2 = texture2 = oldMinimapMessesUpTextureFilter ? regionTexture2.bindColorTexture(false, 9728) : regionTexture2.getGlColorTexture();
                                            if (texture2 == -1) continue;
                                            frameRenderedRootTextures = true;
                                            int insideTextureX = insideX & maxInsideCoord;
                                            int insideTextureZ = insideZ & maxInsideCoord;
                                            float textureX1 = (float)insideTextureX / (float)rootSize;
                                            float textureX2 = (float)(insideTextureX + 1) / (float)rootSize;
                                            float textureY1 = (float)insideTextureZ / (float)rootSize;
                                            float textureY2 = (float)(insideTextureZ + 1) / (float)rootSize;
                                            boolean hasLight = regionTexture2.getTextureHasLight();
                                            GuiMap.renderTexturedModalSubRectWithLighting(matrix, textureX - flooredCameraX, textureZ - flooredCameraZ, textureX1, textureY1, textureX2, textureY2, textureSize, textureSize, texture2, hasLight, hasLight ? withLightRenderer : noLightRenderer);
                                            continue;
                                        }
                                        int n3 = texture = oldMinimapMessesUpTextureFilter ? regionTexture2.bindColorTexture(false, 9728) : regionTexture2.getGlColorTexture();
                                        if (texture == -1) continue;
                                        boolean hasLight = regionTexture2.getTextureHasLight();
                                        GuiMap.renderTexturedModalRectWithLighting3(matrix, textureX - flooredCameraX, textureZ - flooredCameraZ, textureSize, textureSize, texture, hasLight, hasLight ? withLightRenderer : noLightRenderer);
                                    }
                                }
                            }
                            if (((LeveledRegion)leveledRegion).loadingAnimation()) {
                                matrixStack.func_227860_a_();
                                matrixStack.func_227861_a_((double)leveledSideInBlocks * ((double)leveledRegX + 0.5) - (double)flooredCameraX, (double)leveledSideInBlocks * ((double)leveledRegZ + 0.5) - (double)flooredCameraZ, 0.0);
                                float loadingAnimationPassed = System.currentTimeMillis() - this.loadingAnimationStart;
                                if (loadingAnimationPassed > 0.0f) {
                                    int period = 2000;
                                    int numbersOfActors = 3;
                                    float loadingAnimation = loadingAnimationPassed % (float)period / (float)period * 360.0f;
                                    float step = 360.0f / (float)numbersOfActors;
                                    matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(loadingAnimation));
                                    int numberOfVisibleActors = 1 + (int)loadingAnimationPassed % (3 * period) / period;
                                    matrixStack.func_227862_a_((float)leveledSideInRegions, (float)leveledSideInRegions, 1.0f);
                                    for (int i = 0; i < numberOfVisibleActors; ++i) {
                                        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(step));
                                        MapRenderHelper.fillIntoExistingBuffer(matrixStack.func_227866_c_().func_227870_a_(), overlayBuffer, 16, -8, 32, 8, 1.0f, 1.0f, 1.0f, 1.0f);
                                    }
                                }
                                matrixStack.func_227865_b_();
                            }
                            if (WorldMap.settings.debug && leveledRegion instanceof MapRegion) {
                                MapRegion region = leveledRegion;
                                matrixStack.func_227860_a_();
                                matrixStack.func_227861_a_((double)(512 * region.getRegionX() + 32 - flooredCameraX), (double)(512 * region.getRegionZ() + 32 - flooredCameraZ), 0.0);
                                matrixStack.func_227862_a_(10.0f, 10.0f, 1.0f);
                                Misc.drawNormalText(matrixStack, "" + region.getLoadState(), 0.0f, 0.0f, -1, true, renderTypeBuffers);
                                matrixStack.func_227865_b_();
                            }
                            if (!WorldMap.settings.debug || textureLevel <= 0) continue;
                            for (int leafX = 0; leafX < leveledSideInRegions; ++leafX) {
                                for (int leafZ = 0; leafZ < leveledSideInRegions; ++leafZ) {
                                    boolean currentlyLoading;
                                    int regX = leafRegionMinX + leafX;
                                    int regZ = leafRegionMinZ + leafZ;
                                    MapRegion region = this.mapProcessor.getMapRegion(renderedCaveLayer, regX, regZ, false);
                                    if (region == null) continue;
                                    boolean bl2 = currentlyLoading = this.mapProcessor.getMapSaveLoad().getNextToLoadByViewing() == region;
                                    if (!currentlyLoading && !region.isLoaded() && !region.isMetaLoaded()) continue;
                                    matrixStack.func_227860_a_();
                                    matrixStack.func_227861_a_((double)(512 * region.getRegionX() - flooredCameraX), (double)(512 * region.getRegionZ() - flooredCameraZ), 0.0);
                                    float r = 0.0f;
                                    float g = 0.0f;
                                    float b = 0.0f;
                                    float a = 0.1569f;
                                    if (currentlyLoading) {
                                        b = 1.0f;
                                        r = 1.0f;
                                    } else if (region.isLoaded()) {
                                        g = 1.0f;
                                    } else {
                                        g = 1.0f;
                                        r = 1.0f;
                                    }
                                    MapRenderHelper.fillIntoExistingBuffer(matrixStack.func_227866_c_().func_227870_a_(), overlayBuffer, 0, 0, 512, 512, r, g, b, a);
                                    matrixStack.func_227865_b_();
                                }
                            }
                        }
                    }
                    this.lastFrameRenderedRootTextures = frameRenderedRootTextures;
                    GlStateManager.func_227702_d_((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
                    rendererProvider.draw(withLightRenderer);
                    rendererProvider.draw(noLightRenderer);
                    GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    LeveledRegion<?> nextToLoad = this.mapProcessor.getMapSaveLoad().getNextToLoadByViewing();
                    boolean shouldRequest = false;
                    if (nextToLoad != null) {
                        LeveledRegion<?> leveledSideInRegions = nextToLoad;
                        synchronized (leveledSideInRegions) {
                            if (!(nextToLoad.reloadHasBeenRequested() || nextToLoad.hasRemovableSourceData() || nextToLoad instanceof MapRegion && ((MapRegion)nextToLoad).isRefreshing())) {
                                shouldRequest = true;
                            }
                        }
                    } else {
                        shouldRequest = true;
                    }
                    boolean bl = shouldRequest = shouldRequest && this.mapProcessor.getAffectingLoadingFrequencyCount() < 16;
                    if (shouldRequest && !WorldMap.settings.pauseRequests) {
                        int i;
                        int toRequest = 2;
                        int counter = 0;
                        for (i = 0; i < this.branchRegionBuffer.size() && counter < toRequest; ++i) {
                            BranchLeveledRegion region = this.branchRegionBuffer.get(i);
                            if (region.reloadHasBeenRequested() || region.recacheHasBeenRequested() || region.isLoaded()) continue;
                            region.setReloadHasBeenRequested(true, "Gui");
                            this.mapProcessor.getMapSaveLoad().requestBranchCache(region, "Gui");
                            if (counter == 0) {
                                this.mapProcessor.getMapSaveLoad().setNextToLoadByViewing(region);
                            }
                            ++counter;
                        }
                        toRequest = 1;
                        counter = 0;
                        if (!prevWaitingForBranchCache) {
                            for (i = 0; i < this.regionBuffer.size() && counter < toRequest; ++i) {
                                MapRegion region = this.regionBuffer.get(i);
                                if (region == nextToLoad && this.regionBuffer.size() > 1) continue;
                                leveledRegion = region;
                                synchronized (leveledRegion) {
                                    if (region.reloadHasBeenRequested() || region.recacheHasBeenRequested() || region instanceof MapRegion && region.isRefreshing() || region.getLoadState() != 0 && region.getLoadState() != 4 && (region.getLoadState() != 2 || !region.isBeingWritten())) {
                                        continue;
                                    }
                                    if (region.getLoadState() == 2) {
                                        region.requestRefresh(this.mapProcessor);
                                    } else {
                                        this.mapProcessor.getMapSaveLoad().requestLoad(region, "Gui");
                                    }
                                    if (counter == 0) {
                                        this.mapProcessor.getMapSaveLoad().setNextToLoadByViewing((LeveledRegion<?>)region);
                                    }
                                    ++counter;
                                    if (region.getLoadState() == 4) {
                                        break;
                                    }
                                    continue;
                                }
                            }
                        }
                    }
                    this.prevWaitingForBranchCache = this.waitingForBranchCache[0];
                    this.prevLoadingLeaves = loadingLeaves;
                    int chunkHighlightLeftX = this.mouseBlockPosX >> 4 << 4;
                    int chunkHighlightRightX = (this.mouseBlockPosX >> 4) + 1 << 4;
                    int chunkHighlightTopZ = this.mouseBlockPosZ >> 4 << 4;
                    int chunkHighlightBottomZ = (this.mouseBlockPosZ >> 4) + 1 << 4;
                    MapRenderHelper.renderDynamicHighlight(matrixStack, overlayBuffer, flooredCameraX, flooredCameraZ, chunkHighlightLeftX, chunkHighlightRightX, chunkHighlightTopZ, chunkHighlightBottomZ, 0.0f, 0.0f, 0.0f, 0.2f, 1.0f, 1.0f, 1.0f, 0.1569f);
                    if (this.mapTileSelection != null) {
                        MapRenderHelper.renderDynamicHighlight(matrixStack, overlayBuffer, flooredCameraX, flooredCameraZ, this.mapTileSelection.getLeft() << 4, this.mapTileSelection.getRight() + 1 << 4, this.mapTileSelection.getTop() << 4, this.mapTileSelection.getBottom() + 1 << 4, 0.0f, 0.0f, 0.0f, 0.2f, 1.0f, 0.5f, 0.5f, 0.4f);
                    }
                    RenderSystem.disableCull();
                    renderTypeBuffers.func_228461_a_();
                    RenderSystem.enableCull();
                    primaryScaleFBO.func_147609_e();
                    ImprovedFramebuffer.bindDefaultFramebuffer(primaryScaleFBO.getType(), 36160, mc);
                    matrixStack.func_227865_b_();
                    matrixStack.func_227860_a_();
                    matrixStack.func_227862_a_((float)secondaryScale, (float)secondaryScale, 1.0f);
                    primaryScaleFBO.func_147612_c();
                    GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
                    GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
                    RenderSystem.depthMask((boolean)false);
                    IVertexBuilder colorBackgroundConsumer = renderTypeBuffers.getBuffer(CustomRenderTypes.MAP_COLOR_FILLER);
                    int lineX = -mc.func_228018_at_().func_198109_k() / 2;
                    int lineY = mc.func_228018_at_().func_198091_l() / 2 - 5;
                    int lineW = mc.func_228018_at_().func_198109_k();
                    int lineH = 6;
                    MapRenderHelper.fillIntoExistingBuffer(matrixStack.func_227866_c_().func_227870_a_(), colorBackgroundConsumer, lineX, lineY, lineX + lineW, lineY + lineH, 0.0f, 0.0f, 0.0f, 1.0f);
                    lineX = mc.func_228018_at_().func_198109_k() / 2 - 5;
                    lineY = -mc.func_228018_at_().func_198091_l() / 2;
                    lineW = 6;
                    lineH = mc.func_228018_at_().func_198091_l();
                    MapRenderHelper.fillIntoExistingBuffer(matrixStack.func_227866_c_().func_227870_a_(), colorBackgroundConsumer, lineX, lineY, lineX + lineW, lineY + lineH, 0.0f, 0.0f, 0.0f, 1.0f);
                    renderTypeBuffers.func_228461_a_();
                    RenderType mainFrameRenderType = CustomRenderTypes.GUI_BILINEAR;
                    if (SupportMods.vivecraft) {
                        mainFrameRenderType = CustomRenderTypes.MAP_FRAME_TEXTURE_OVER_TRANSPARENT;
                    }
                    MultiTextureRenderTypeRenderer mainFrameRenderer = rendererProvider.getRenderer(MultiTextureRenderTypeRendererProvider::defaultTextureBind, mainFrameRenderType);
                    BufferBuilder mainFrameVertexConsumer = mainFrameRenderer.begin(7, DefaultVertexFormats.field_181709_i, primaryScaleFBO.getFramebufferTexture());
                    GuiMap.renderTexturedModalRect(matrixStack.func_227866_c_().func_227870_a_(), (IVertexBuilder)mainFrameVertexConsumer, (float)(-mc.func_228018_at_().func_198109_k() / 2) - (float)secondaryOffsetX, (float)(-mc.func_228018_at_().func_198091_l() / 2) - (float)secondaryOffsetY, 0, 0, GuiMap.primaryScaleFBO.field_147621_c, GuiMap.primaryScaleFBO.field_147618_d, GuiMap.primaryScaleFBO.field_147621_c, GuiMap.primaryScaleFBO.field_147618_d, 1.0f, 1.0f, 1.0f, 1.0f);
                    rendererProvider.draw(mainFrameRenderer);
                    RenderSystem.depthMask((boolean)true);
                    matrixStack.func_227865_b_();
                    matrixStack.func_227862_a_((float)this.scale, (float)this.scale, 1.0f);
                    double screenSizeBasedScale = scaleMultiplier;
                    try {
                        this.viewed = WorldMap.mapElementRenderHandler.render(this, matrixStack, renderTypeBuffers, rendererProvider, this.cameraX, this.cameraZ, mc.func_228018_at_().func_198109_k(), mc.func_228018_at_().func_198091_l(), screenSizeBasedScale, this.scale, mousePosX, mousePosZ, brightness, renderedCaveLayer != Integer.MAX_VALUE, this.viewed, mc, partialTicks);
                    }
                    catch (Throwable t2) {
                        WorldMap.LOGGER.error("error rendering map elements", t2);
                        throw t2;
                    }
                    this.viewedInList = false;
                    matrixStack.func_227860_a_();
                    matrixStack.func_227861_a_(0.0, 0.0, 970.0);
                    IVertexBuilder regularUIObjectConsumer = renderTypeBuffers.getBuffer(CustomRenderTypes.GUI_BILINEAR);
                    if (WorldMap.settings.footsteps) {
                        ArrayList<Double[]> footprints;
                        ArrayList<Double[]> firstInsideTextureX = footprints = this.mapProcessor.getFootprints();
                        synchronized (firstInsideTextureX) {
                            for (int i = 0; i < footprints.size(); ++i) {
                                Double[] coords = footprints.get(i);
                                this.setColourBuffer(1.0f, 0.1f, 0.1f, 1.0f);
                                this.drawDotOnMap(matrixStack, regularUIObjectConsumer, coords[0] - this.cameraX, coords[1] - this.cameraZ, 0.0f, 1.0 / this.scale);
                            }
                        }
                    }
                    if (WorldMap.settings.renderArrow) {
                        boolean toTheLeft = this.player.func_226277_ct_() < leftBorder;
                        boolean toTheRight = this.player.func_226277_ct_() > rightBorder;
                        boolean down = this.player.func_226281_cx_() > bottomBorder;
                        boolean up = this.player.func_226281_cx_() < topBorder;
                        float configuredR = 1.0f;
                        float configuredG = 1.0f;
                        float configuredB = 1.0f;
                        int effectiveArrowColorIndex = WorldMap.settings.arrowColour;
                        if (effectiveArrowColorIndex == -2 && !SupportMods.minimap()) {
                            effectiveArrowColorIndex = 0;
                        }
                        if (effectiveArrowColorIndex == -2 && SupportMods.xaeroMinimap.getArrowColorIndex() == -1) {
                            effectiveArrowColorIndex = -1;
                        }
                        if (effectiveArrowColorIndex == -1) {
                            int rgb = Misc.getTeamColour((Entity)mc.field_71439_g);
                            if (rgb == -1) {
                                effectiveArrowColorIndex = 0;
                            } else {
                                configuredR = (float)(rgb >> 16 & 0xFF) / 255.0f;
                                configuredG = (float)(rgb >> 8 & 0xFF) / 255.0f;
                                configuredB = (float)(rgb & 0xFF) / 255.0f;
                            }
                        } else if (effectiveArrowColorIndex == -2) {
                            float[] c = SupportMods.xaeroMinimap.getArrowColor();
                            if (c == null) {
                                effectiveArrowColorIndex = 0;
                            } else {
                                configuredR = c[0];
                                configuredG = c[1];
                                configuredB = c[2];
                            }
                        }
                        if (effectiveArrowColorIndex >= 0) {
                            float[] c = WorldMap.settings.arrowColours[effectiveArrowColorIndex];
                            configuredR = c[0];
                            configuredG = c[1];
                            configuredB = c[2];
                        }
                        if (toTheLeft || toTheRight || up || down) {
                            double arrowX = this.player.func_226277_ct_();
                            double arrowZ = this.player.func_226281_cx_();
                            float a = 0.0f;
                            if (toTheLeft) {
                                a = up ? 1.5f : (down ? 0.5f : 1.0f);
                                arrowX = leftBorder;
                            } else if (toTheRight) {
                                a = up ? 2.5f : (down ? 3.5f : 3.0f);
                                arrowX = rightBorder;
                            }
                            if (down) {
                                arrowZ = bottomBorder;
                            } else if (up) {
                                if (a == 0.0f) {
                                    a = 2.0f;
                                }
                                arrowZ = topBorder;
                            }
                            this.setColourBuffer(0.0f, 0.0f, 0.0f, 0.9f);
                            this.drawFarArrowOnMap(matrixStack, regularUIObjectConsumer, arrowX - this.cameraX, arrowZ + 2.0 * screenSizeBasedScale / this.scale - this.cameraZ, a, screenSizeBasedScale / this.scale);
                            this.setColourBuffer(configuredR, configuredG, configuredB, 1.0f);
                            this.drawFarArrowOnMap(matrixStack, regularUIObjectConsumer, arrowX - this.cameraX, arrowZ - this.cameraZ, a, screenSizeBasedScale / this.scale);
                        } else {
                            this.setColourBuffer(0.0f, 0.0f, 0.0f, 0.9f);
                            this.drawArrowOnMap(matrixStack, regularUIObjectConsumer, this.player.func_226277_ct_() - this.cameraX, this.player.func_226281_cx_() + 2.0 * screenSizeBasedScale / this.scale - this.cameraZ, this.player.field_70177_z, screenSizeBasedScale / this.scale);
                            this.setColourBuffer(configuredR, configuredG, configuredB, 1.0f);
                            this.drawArrowOnMap(matrixStack, regularUIObjectConsumer, this.player.func_226277_ct_() - this.cameraX, this.player.func_226281_cx_() - this.cameraZ, this.player.field_70177_z, screenSizeBasedScale / this.scale);
                        }
                    }
                    this.field_230706_i_.func_110434_K().func_110577_a(WorldMap.guiTextures);
                    GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
                    GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
                    renderTypeBuffers.func_228461_a_();
                    this.field_230706_i_.func_110434_K().func_110577_a(WorldMap.guiTextures);
                    GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
                    GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
                    matrixStack.func_227865_b_();
                    matrixStack.func_227865_b_();
                    IVertexBuilder backgroundVertexBuffer = renderTypeBuffers.getBuffer(CustomRenderTypes.MAP_COLOR_OVERLAY);
                    int cursorDisplayOffset = 0;
                    if (WorldMap.settings.coordinates) {
                        String coordsString = "X: " + this.mouseBlockPosX;
                        if (mouseBlockBottomY != -1) {
                            coordsString = coordsString + " Y: " + mouseBlockBottomY;
                        }
                        if (hasAmbiguousHeight && mouseBlockTopY != -1) {
                            coordsString = coordsString + " (" + mouseBlockTopY + ")";
                        }
                        coordsString = coordsString + " Z: " + this.mouseBlockPosZ;
                        MapRenderHelper.drawCenteredStringWithBackground(matrixStack, this.field_230712_o_, coordsString, this.field_230708_k_ / 2, 2 + cursorDisplayOffset, -1, 0.0f, 0.0f, 0.0f, 0.4f, backgroundVertexBuffer);
                        cursorDisplayOffset += 10;
                    }
                    if (WorldMap.settings.hoveredBiome && pointedAtBiome != null) {
                        ResourceLocation biomeRL = pointedAtBiome.func_240901_a_();
                        String biomeText = biomeRL == null ? I18n.func_135052_a((String)"gui.xaero_wm_unknown_biome", (Object[])new Object[0]) : I18n.func_135052_a((String)("biome." + biomeRL.func_110624_b() + "." + biomeRL.func_110623_a()), (Object[])new Object[0]);
                        MapRenderHelper.drawCenteredStringWithBackground(matrixStack, this.field_230712_o_, biomeText, this.field_230708_k_ / 2, 2 + cursorDisplayOffset, -1, 0.0f, 0.0f, 0.0f, 0.4f, backgroundVertexBuffer);
                    }
                    int subtleTooltipOffset = 12;
                    if (WorldMap.settings.displayZoom) {
                        String zoomString = (double)Math.round(destScale * 1000.0) / 1000.0 + "x";
                        MapRenderHelper.drawCenteredStringWithBackground(matrixStack, mc.field_71466_p, zoomString, this.field_230708_k_ / 2, this.field_230709_l_ - subtleTooltipOffset, -1, 0.0f, 0.0f, 0.0f, 0.4f, backgroundVertexBuffer);
                    }
                    if (WorldMap.settings.displayCaveModeStart) {
                        subtleTooltipOffset += 12;
                        if (globalCaveStart != Integer.MAX_VALUE && globalCaveStart != Integer.MIN_VALUE) {
                            String caveModeStartString = I18n.func_135052_a((String)"gui.xaero_wm_cave_mode_start_display", (Object[])new Object[]{globalCaveStart});
                            MapRenderHelper.drawCenteredStringWithBackground(matrixStack, mc.field_71466_p, caveModeStartString, this.field_230708_k_ / 2, this.field_230709_l_ - subtleTooltipOffset, -1, 0.0f, 0.0f, 0.0f, 0.4f, backgroundVertexBuffer);
                        }
                    }
                    if (SupportMods.minimap() && (subWorldNameToRender = SupportMods.xaeroMinimap.getSubWorldNameToRender()) != null) {
                        MapRenderHelper.drawCenteredStringWithBackground(matrixStack, mc.field_71466_p, subWorldNameToRender, this.field_230708_k_ / 2, this.field_230709_l_ - (subtleTooltipOffset += 24), -1, 0.0f, 0.0f, 0.0f, 0.4f, backgroundVertexBuffer);
                    }
                    discoveredForHighlights = mouseBlockBottomY != -1;
                    ITextComponent subtleHighlightTooltip = this.mapProcessor.getMapWorld().getCurrentDimension().getHighlightHandler().getBlockHighlightSubtleTooltip(this.mouseBlockPosX, this.mouseBlockPosZ, discoveredForHighlights);
                    if (subtleHighlightTooltip != null) {
                        MapRenderHelper.drawCenteredStringWithBackground(matrixStack, mc.field_71466_p, subtleHighlightTooltip, this.field_230708_k_ / 2, this.field_230709_l_ - (subtleTooltipOffset += 12), -1, 0.0f, 0.0f, 0.0f, 0.4f, backgroundVertexBuffer);
                    }
                    renderTypeBuffers.func_228461_a_();
                    this.overWaypointsMenu = false;
                    if (this.waypointMenu && SupportMods.xaeroMinimap.getWaypointsSorted() != null) {
                        matrixStack.func_227860_a_();
                        matrixStack.func_227861_a_(0.0, 0.0, 972.0);
                        HoveredMapElementHolder<?, ?> hovered = SupportMods.xaeroMinimap.renderWaypointsMenu(matrixStack, this, this.scale, this.field_230708_k_, this.field_230709_l_, scaledMouseX, scaledMouseY, this.leftMouseButton.isDown, this.leftMouseButton.clicked, this.viewed, mc);
                        if (hovered != null) {
                            this.overWaypointsMenu = true;
                            if (hovered.getElement() instanceof Waypoint) {
                                this.viewed = hovered;
                                this.viewedInList = true;
                                if (this.leftMouseButton.clicked) {
                                    this.cameraDestination = new int[]{(int)((Waypoint)this.viewed.getElement()).getRenderX(), (int)((Waypoint)this.viewed.getElement()).getRenderZ()};
                                    this.leftMouseButton.isDown = false;
                                    if (WorldMap.settings.closeWaypointsWhenHopping) {
                                        this.onWaypointsButton(this.waypointsButton);
                                    }
                                }
                            }
                        }
                        matrixStack.func_227865_b_();
                    }
                    if (SupportMods.minimap()) {
                        SupportMods.xaeroMinimap.drawSetChange(matrixStack);
                    }
                } else if (!mapLoaded) {
                    this.renderLoadingScreen(matrixStack);
                } else if (isLocked) {
                    this.renderMessageScreen(matrixStack, I18n.func_135052_a((String)"gui.xaero_current_map_locked1", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.xaero_current_map_locked2", (Object[])new Object[0]));
                } else if (noWorldMapEffect) {
                    this.renderMessageScreen(matrixStack, I18n.func_135052_a((String)"gui.xaero_no_world_map_message", (Object[])new Object[0]));
                } else if (!allowedBasedOnItem) {
                    this.renderMessageScreen(matrixStack, I18n.func_135052_a((String)"gui.xaero_no_world_map_item_message", (Object[])new Object[0]), ModSettings.mapItem.func_200296_o().getString() + " (" + ModSettings.mapItemId + ")");
                }
            } else {
                this.renderLoadingScreen(matrixStack);
            }
            this.dimensionSettings.renderText(matrixStack, this.field_230706_i_, scaledMouseX, scaledMouseY, this.field_230708_k_, this.field_230709_l_);
            mc.func_110434_K().func_110577_a(WorldMap.guiTextures);
            this.func_238474_b_(matrixStack, this.field_230708_k_ - 34, 2, 0, 37, 32, 32);
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.0, 973.0);
        super.func_230430_a_(matrixStack, scaledMouseX, scaledMouseY, partialTicks);
        if (this.rightClickMenu != null) {
            this.rightClickMenu.func_230430_a_(matrixStack, scaledMouseX, scaledMouseY, partialTicks);
        }
        matrixStack.func_227861_a_(0.0, 0.0, 10.0);
        if (mc.field_71462_r == this) {
            if (!(this.renderTooltips(matrixStack, scaledMouseX, scaledMouseY, partialTicks) || this.leftMouseButton.isDown || this.rightMouseButton.isDown)) {
                if (this.viewed != null) {
                    CursorBox hoveredTooltip = this.hoveredElementTooltipHelper(this.viewed, this.viewedInList);
                    if (hoveredTooltip != null) {
                        hoveredTooltip.drawBox(matrixStack, scaledMouseX, scaledMouseY, this.field_230708_k_, this.field_230709_l_);
                    }
                } else {
                    object = this.mapProcessor.renderThreadPauseSync;
                    synchronized (object) {
                        ITextComponent bluntHighlightTooltip;
                        if (!this.mapProcessor.isRenderingPaused() && this.mapProcessor.getCurrentWorldId() != null && this.mapProcessor.getMapSaveLoad().isRegionDetectionComplete() && (bluntHighlightTooltip = this.mapProcessor.getMapWorld().getCurrentDimension().getHighlightHandler().getBlockHighlightBluntTooltip(this.mouseBlockPosX, this.mouseBlockPosZ, discoveredForHighlights)) != null) {
                            new CursorBox(bluntHighlightTooltip).drawBox(matrixStack, scaledMouseX, scaledMouseY, this.field_230708_k_, this.field_230709_l_);
                        }
                    }
                }
            }
            matrixStack.func_227861_a_(0.0, 0.0, 1.0);
            this.mapProcessor.getMessageBoxRenderer().render(matrixStack, this.mapProcessor.getMessageBox(), this.field_230712_o_, 1, this.field_230709_l_ / 2, false);
        }
        matrixStack.func_227865_b_();
        this.rightMouseButton.clicked = false;
        this.leftMouseButton.clicked = false;
        this.noUploadingLimits = this.cameraX == cameraXBefore && this.cameraZ == cameraZBefore && scaleBefore == this.scale;
    }

    @Override
    protected void renderPreDropdown(MatrixStack matrixStack, int scaledMouseX, int scaledMouseY, float partialTicks) {
        super.renderPreDropdown(matrixStack, scaledMouseX, scaledMouseY, partialTicks);
        if (this.waypointMenu) {
            SupportMods.xaeroMinimap.getWaypointMenuRenderer().postMapRender(matrixStack, this, scaledMouseX, scaledMouseY, this.field_230708_k_, this.field_230709_l_, partialTicks);
        }
        this.dimensionSettings.postMapRender(matrixStack, this.field_230706_i_, scaledMouseX, scaledMouseY, this.field_230708_k_, this.field_230709_l_);
    }

    private <E, C> CursorBox hoveredElementTooltipHelper(HoveredMapElementHolder<E, C> hovered, boolean viewedInList) {
        return hovered.getRenderer().getReader().getTooltip(hovered.getElement(), hovered.getRenderer().getContext(), viewedInList);
    }

    private void renderLoadingScreen(MatrixStack matrixStack) {
        this.renderMessageScreen(matrixStack, "Preparing World Map...");
    }

    private void renderMessageScreen(MatrixStack matrixStack, String message) {
        this.renderMessageScreen(matrixStack, message, null);
    }

    private void renderMessageScreen(MatrixStack matrixStack, String message, String message2) {
        GuiMap.func_238467_a_((MatrixStack)matrixStack, (int)0, (int)0, (int)this.field_230706_i_.func_228018_at_().func_198109_k(), (int)this.field_230706_i_.func_228018_at_().func_198091_l(), (int)-16777216);
        GlStateManager.func_227626_N_();
        GlStateManager.func_227688_c_((float)0.0f, (float)0.0f, (float)500.0f);
        GuiMap.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (String)message, (int)(this.field_230706_i_.func_228018_at_().func_198107_o() / 2), (int)(this.field_230706_i_.func_228018_at_().func_198087_p() / 2), (int)-1);
        if (message2 != null) {
            GuiMap.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (String)message2, (int)(this.field_230706_i_.func_228018_at_().func_198107_o() / 2), (int)(this.field_230706_i_.func_228018_at_().func_198087_p() / 2 + 10), (int)-1);
        }
        GlStateManager.func_227627_O_();
    }

    public void drawDotOnMap(MatrixStack matrixStack, IVertexBuilder guiLinearBuffer, double x, double z, float angle, double sc) {
        this.drawObjectOnMap(matrixStack, guiLinearBuffer, x, z, angle, sc, 2.5f, 2.5f, 0, 69, 5, 5, 9729);
    }

    public void drawArrowOnMap(MatrixStack matrixStack, IVertexBuilder guiLinearBuffer, double x, double z, float angle, double sc) {
        this.drawObjectOnMap(matrixStack, guiLinearBuffer, x, z, angle, sc, 13.0f, 5.0f, 0, 0, 26, 28, 9729);
    }

    public void drawFarArrowOnMap(MatrixStack matrixStack, IVertexBuilder guiLinearBuffer, double x, double z, float angle, double sc) {
        this.drawObjectOnMap(matrixStack, guiLinearBuffer, x, z, angle * 90.0f, sc, 27.0f, 13.0f, 26, 0, 54, 13, 9729);
    }

    public void drawObjectOnMap(MatrixStack matrixStack, IVertexBuilder guiLinearBuffer, double x, double z, float angle, double sc, float offX, float offY, int textureX, int textureY, int w, int h, int filter) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(x, z, 0.0);
        matrixStack.func_227862_a_((float)sc, (float)sc, 1.0f);
        if (angle != 0.0f) {
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(angle));
        }
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        GuiMap.renderTexturedModalRect(matrix, guiLinearBuffer, -offX, -offY, textureX, textureY, w, h, 256.0f, 256.0f, this.colourBuffer[0], this.colourBuffer[1], this.colourBuffer[2], this.colourBuffer[3]);
        matrixStack.func_227865_b_();
    }

    @Deprecated
    public static void renderTexturedModalRectWithLighting(float x, float y, int textureX, int textureY, float width, float height) {
        GL14.glBlendFuncSeparate((int)1, (int)0, (int)0, (int)1);
        GuiMap.renderTexturedModalRectWithLighting(x, y, width, height);
        GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
    }

    public static void renderTexturedModalRectWithLighting(float x, float y, float width, float height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, POSITION_TEX_TEX_TEX);
        GuiMap.buildTexturedModalRectWithLighting(identityMatrix, vertexBuffer, x, y, width, height);
        tessellator.func_78381_a();
    }

    public static void renderTexturedModalRectWithLighting2(Matrix4f matrix, float x, float y, float width, float height, int texture, MultiTextureRenderTypeRenderer renderer) {
        GuiMap.buildTexturedModalRectWithLighting(matrix, renderer.begin(7, POSITION_TEX_TEX_TEX, texture), x, y, width, height);
    }

    public static void renderTexturedModalRectWithLighting3(Matrix4f matrix, float x, float y, float width, float height, int texture, boolean hasLight, MultiTextureRenderTypeRenderer renderer) {
        if (hasLight) {
            GuiMap.buildTexturedModalRectWithLighting(matrix, renderer.begin(7, POSITION_TEX_TEX_TEX, texture), x, y, width, height);
        } else {
            BufferBuilder vertexBuffer = renderer.begin(7, DefaultVertexFormats.field_181707_g, texture);
            vertexBuffer.func_227888_a_(matrix, x + 0.0f, y + height, 0.0f).func_225583_a_(0.0f, 1.0f).func_181675_d();
            vertexBuffer.func_227888_a_(matrix, x + width, y + height, 0.0f).func_225583_a_(1.0f, 1.0f).func_181675_d();
            vertexBuffer.func_227888_a_(matrix, x + width, y + 0.0f, 0.0f).func_225583_a_(1.0f, 0.0f).func_181675_d();
            vertexBuffer.func_227888_a_(matrix, x + 0.0f, y + 0.0f, 0.0f).func_225583_a_(0.0f, 0.0f).func_181675_d();
        }
    }

    public static void renderTexturedModalSubRectWithLighting(Matrix4f matrix, float x, float y, float textureX1, float textureY1, float textureX2, float textureY2, float width, float height, int texture, boolean hasLight, MultiTextureRenderTypeRenderer renderer) {
        if (hasLight) {
            GuiMap.buildTexturedModalSubRectWithLighting(matrix, renderer.begin(7, POSITION_TEX_TEX_TEX, texture), x, y, textureX1, textureY1, textureX2, textureY2, width, height);
        } else {
            BufferBuilder vertexBuffer = renderer.begin(7, DefaultVertexFormats.field_181707_g, texture);
            vertexBuffer.func_227888_a_(matrix, x + 0.0f, y + height, 0.0f).func_225583_a_(textureX1, textureY2).func_181675_d();
            vertexBuffer.func_227888_a_(matrix, x + width, y + height, 0.0f).func_225583_a_(textureX2, textureY2).func_181675_d();
            vertexBuffer.func_227888_a_(matrix, x + width, y + 0.0f, 0.0f).func_225583_a_(textureX2, textureY1).func_181675_d();
            vertexBuffer.func_227888_a_(matrix, x + 0.0f, y + 0.0f, 0.0f).func_225583_a_(textureX1, textureY1).func_181675_d();
        }
    }

    public static void buildTexturedModalRectWithLighting(Matrix4f matrix, BufferBuilder vertexBuffer, float x, float y, float width, float height) {
        vertexBuffer.func_227888_a_(matrix, x + 0.0f, y + height, 0.0f);
        GuiMap.anyIndexFloatUV(vertexBuffer, 0.0f, 1.0f);
        GuiMap.anyIndexFloatUV(vertexBuffer, 0.0f, 1.0f);
        GuiMap.anyIndexFloatUV(vertexBuffer, 0.0f, 1.0f);
        vertexBuffer.func_181675_d();
        vertexBuffer.func_227888_a_(matrix, x + width, y + height, 0.0f);
        GuiMap.anyIndexFloatUV(vertexBuffer, 1.0f, 1.0f);
        GuiMap.anyIndexFloatUV(vertexBuffer, 1.0f, 1.0f);
        GuiMap.anyIndexFloatUV(vertexBuffer, 1.0f, 1.0f);
        vertexBuffer.func_181675_d();
        vertexBuffer.func_227888_a_(matrix, x + width, y + 0.0f, 0.0f);
        GuiMap.anyIndexFloatUV(vertexBuffer, 1.0f, 0.0f);
        GuiMap.anyIndexFloatUV(vertexBuffer, 1.0f, 0.0f);
        GuiMap.anyIndexFloatUV(vertexBuffer, 1.0f, 0.0f);
        vertexBuffer.func_181675_d();
        vertexBuffer.func_227888_a_(matrix, x + 0.0f, y + 0.0f, 0.0f);
        GuiMap.anyIndexFloatUV(vertexBuffer, 0.0f, 0.0f);
        GuiMap.anyIndexFloatUV(vertexBuffer, 0.0f, 0.0f);
        GuiMap.anyIndexFloatUV(vertexBuffer, 0.0f, 0.0f);
        vertexBuffer.func_181675_d();
    }

    public static void buildTexturedModalSubRectWithLighting(Matrix4f matrix, BufferBuilder vertexBuffer, float x, float y, float textureX1, float textureY1, float textureX2, float textureY2, float width, float height) {
        vertexBuffer.func_227888_a_(matrix, x + 0.0f, y + height, 0.0f);
        GuiMap.anyIndexFloatUV(vertexBuffer, textureX1, textureY2);
        GuiMap.anyIndexFloatUV(vertexBuffer, textureX1, textureY2);
        GuiMap.anyIndexFloatUV(vertexBuffer, textureX1, textureY2);
        vertexBuffer.func_181675_d();
        vertexBuffer.func_227888_a_(matrix, x + width, y + height, 0.0f);
        GuiMap.anyIndexFloatUV(vertexBuffer, textureX2, textureY2);
        GuiMap.anyIndexFloatUV(vertexBuffer, textureX2, textureY2);
        GuiMap.anyIndexFloatUV(vertexBuffer, textureX2, textureY2);
        vertexBuffer.func_181675_d();
        vertexBuffer.func_227888_a_(matrix, x + width, y + 0.0f, 0.0f);
        GuiMap.anyIndexFloatUV(vertexBuffer, textureX2, textureY1);
        GuiMap.anyIndexFloatUV(vertexBuffer, textureX2, textureY1);
        GuiMap.anyIndexFloatUV(vertexBuffer, textureX2, textureY1);
        vertexBuffer.func_181675_d();
        vertexBuffer.func_227888_a_(matrix, x + 0.0f, y + 0.0f, 0.0f);
        GuiMap.anyIndexFloatUV(vertexBuffer, textureX1, textureY1);
        GuiMap.anyIndexFloatUV(vertexBuffer, textureX1, textureY1);
        GuiMap.anyIndexFloatUV(vertexBuffer, textureX1, textureY1);
        vertexBuffer.func_181675_d();
    }

    public static void anyIndexFloatUV(BufferBuilder vertexBuffer, float u, float v) {
        vertexBuffer.func_225590_a_(0, u);
        vertexBuffer.func_225590_a_(4, v);
        vertexBuffer.func_181667_k();
    }

    public static void renderTexturedModalRect(Matrix4f matrix, IVertexBuilder vertexBuffer, float x, float y, int textureX, int textureY, float width, float height, float textureWidth, float textureHeight, float r, float g, float b, float a) {
        float normalizedTextureX = (float)textureX / textureWidth;
        float normalizedTextureY = (float)textureY / textureHeight;
        float normalizedTextureX2 = ((float)textureX + width) / textureWidth;
        float normalizedTextureY2 = ((float)textureY + height) / textureHeight;
        vertexBuffer.func_227888_a_(matrix, x + 0.0f, y + height, 0.0f).func_225583_a_(normalizedTextureX, normalizedTextureY2).func_227885_a_(r, g, b, a).func_181675_d();
        vertexBuffer.func_227888_a_(matrix, x + width, y + height, 0.0f).func_225583_a_(normalizedTextureX2, normalizedTextureY2).func_227885_a_(r, g, b, a).func_181675_d();
        vertexBuffer.func_227888_a_(matrix, x + width, y + 0.0f, 0.0f).func_225583_a_(normalizedTextureX2, normalizedTextureY).func_227885_a_(r, g, b, a).func_181675_d();
        vertexBuffer.func_227888_a_(matrix, x + 0.0f, y + 0.0f, 0.0f).func_225583_a_(normalizedTextureX, normalizedTextureY).func_227885_a_(r, g, b, a).func_181675_d();
    }

    public void mapClicked(int button, int x, int y) {
        if (button == 1) {
            if (this.viewedOnMousePress != null && this.viewedOnMousePress.isRightClickValid() && (!(this.viewedOnMousePress.getElement() instanceof Waypoint) || SupportMods.xaeroMinimap.waypointExists((Waypoint)this.viewedOnMousePress.getElement()))) {
                this.handleRightClick(this.viewedOnMousePress, (int)((double)x / this.screenScale), (int)((double)y / this.screenScale));
                this.mouseDownPosX = -1;
                this.mouseDownPosY = -1;
                this.mapTileSelection = null;
            } else {
                this.handleRightClick(this, (int)((double)x / this.screenScale), (int)((double)y / this.screenScale));
            }
        }
    }

    private void handleRightClick(IRightClickableElement target, int x, int y) {
        if (this.rightClickMenu != null) {
            this.rightClickMenu.setClosed(true);
        }
        this.rightClickMenu = GuiRightClickMenu.getMenu(target, this, x, y, 150);
    }

    public boolean func_231042_a_(char par1, int par2) {
        boolean result = super.func_231042_a_(par1, par2);
        if (this.waypointMenu && SupportMods.xaeroMinimap.getWaypointMenuRenderer().charTyped()) {
            return true;
        }
        return result;
    }

    public boolean func_231046_a_(int par1, int par2, int par3) {
        if (par1 == 258) {
            if (this.tabPressed && SupportMods.minimap() && WorldMap.settings.minimapRadar && Minecraft.func_71410_x().field_71474_y.field_74321_H.func_197976_a(par1, par2)) {
                return true;
            }
            this.tabPressed = true;
        }
        boolean result = super.func_231046_a_(par1, par2, par3);
        if (this.isUsingTextField()) {
            if (this.waypointMenu && SupportMods.xaeroMinimap.getWaypointMenuRenderer().keyPressed(this, par1)) {
                result = true;
            }
        } else {
            result = this.onInputPress(par1 != -1 ? InputMappings.Type.KEYSYM : InputMappings.Type.SCANCODE, par1 != -1 ? par1 : par2) || result;
        }
        return result;
    }

    public boolean func_223281_a_(int par1, int par2, int par3) {
        if (par1 == 258) {
            this.tabPressed = false;
        }
        if (this.onInputRelease(par1 != -1 ? InputMappings.Type.KEYSYM : InputMappings.Type.SCANCODE, par1 != -1 ? par1 : par2)) {
            return true;
        }
        return super.func_223281_a_(par1, par2, par3);
    }

    @Deprecated
    public static void bindMapTextureWithLighting(float brightness, MapTileChunk chunk, int magFilter, int lod) {
        GuiMap.setupTextureMatricesAndTextures(brightness);
        GuiMap.bindMapTextureWithLighting3(brightness, chunk, magFilter, lod);
    }

    @Deprecated
    public static void bindMapTextureWithLighting2(float brightness, MapTileChunk chunk, int magFilter, int lod) {
        GuiMap.setupTextures(brightness);
        GuiMap.bindMapTextureWithLighting3(brightness, chunk, magFilter, lod);
    }

    @Deprecated
    public static void bindMapTextureWithLighting3(float brightness, MapTileChunk chunk, int magFilter, int lod) {
        GlStateManager.func_227702_d_((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
        GuiMap.bindMapTextureWithLighting3(chunk.getLeafTexture(), magFilter, lod);
    }

    public static void bindMapTextureWithLighting3(MapTileChunk chunk, int magFilter, int lod) {
        GuiMap.bindMapTextureWithLighting3(chunk.getLeafTexture(), magFilter, lod);
    }

    public static void bindMapTextureWithLighting3(RegionTexture<?> regionTexture, int magFilter, int lod) {
        boolean hasLight = regionTexture.getTextureHasLight();
        GlStateManager.func_227756_r_((int)33984);
        int glTexture = regionTexture.bindColorTexture(false, magFilter);
        if (hasLight) {
            GL11.glTexEnvi((int)8960, (int)8704, (int)34160);
        } else {
            GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
        }
        GlStateManager.func_227756_r_((int)33985);
        if (hasLight) {
            GlStateManager.func_227619_H_();
            GlStateManager.func_227760_t_((int)glTexture);
        } else {
            GlStateManager.func_227621_I_();
        }
        GlStateManager.func_227756_r_((int)33986);
        if (hasLight) {
            GlStateManager.func_227619_H_();
            GlStateManager.func_227760_t_((int)glTexture);
        } else {
            GlStateManager.func_227621_I_();
        }
    }

    @Deprecated
    public static void setupTextureMatrices() {
        GlStateManager.func_227756_r_((int)33985);
        GlStateManager.func_227768_x_((int)5890);
        GlStateManager.func_227625_M_();
        GlStateManager.func_227756_r_((int)33986);
        GlStateManager.func_227625_M_();
        GlStateManager.func_227768_x_((int)5888);
        GlStateManager.func_227756_r_((int)33984);
    }

    private static void setupTexture0() {
        GL11.glTexEnvi((int)8960, (int)8704, (int)34160);
        GL11.glTexEnvi((int)8960, (int)34161, (int)34023);
        GL11.glTexEnvi((int)8960, (int)34176, (int)34167);
        GL11.glTexEnvi((int)8960, (int)34192, (int)768);
        GL11.glTexEnvi((int)8960, (int)34177, (int)5890);
        GL11.glTexEnvi((int)8960, (int)34193, (int)770);
        GL11.glTexEnvi((int)8960, (int)34162, (int)7681);
        GL11.glTexEnvi((int)8960, (int)34184, (int)34167);
        GL11.glTexEnvi((int)8960, (int)34200, (int)770);
    }

    private static void setupTexture1() {
        GL11.glTexEnvi((int)8960, (int)8704, (int)34160);
        GL11.glTexEnvi((int)8960, (int)34161, (int)260);
        GL11.glTexEnvi((int)8960, (int)34176, (int)34168);
        GL11.glTexEnvi((int)8960, (int)34192, (int)768);
        GL11.glTexEnvi((int)8960, (int)34177, (int)5890);
        GL11.glTexEnvi((int)8960, (int)34193, (int)770);
        GL11.glTexEnvi((int)8960, (int)34162, (int)7681);
        GL11.glTexEnvi((int)8960, (int)34184, (int)34167);
        GL11.glTexEnvi((int)8960, (int)34200, (int)770);
    }

    private static void setupTexture2() {
        GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
    }

    public static void setupTextures(float brightness) {
        GlStateManager.func_227702_d_((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
        GlStateManager.func_227700_d_();
        GlStateManager.func_227756_r_((int)33984);
        GlStateManager.func_227619_H_();
        GuiMap.setupTexture0();
        GlStateManager.func_227756_r_((int)33985);
        GuiMap.setupTexture1();
        GlStateManager.func_227756_r_((int)33986);
        GuiMap.setupTexture2();
        GlStateManager.func_227756_r_((int)33984);
    }

    public static void setupTextureMatricesAndTextures(float brightness) {
        GlStateManager.func_227702_d_((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
        GlStateManager.func_227700_d_();
        GlStateManager.func_227756_r_((int)33984);
        GlStateManager.func_227619_H_();
        GuiMap.setupTexture0();
        GlStateManager.func_227756_r_((int)33985);
        GuiMap.setupTexture1();
        GlStateManager.func_227768_x_((int)5890);
        GlStateManager.func_227625_M_();
        GlStateManager.func_227756_r_((int)33986);
        GuiMap.setupTexture2();
        GlStateManager.func_227625_M_();
        GlStateManager.func_227768_x_((int)5888);
        GlStateManager.func_227756_r_((int)33984);
    }

    public static void setupTextureMatricesAndTextures2() {
        GlStateManager.func_227756_r_((int)33984);
        GlStateManager.func_227619_H_();
        GuiMap.setupTexture0();
        GlStateManager.func_227756_r_((int)33985);
        GlStateManager.func_227619_H_();
        GuiMap.setupTexture1();
        GlStateManager.func_227768_x_((int)5890);
        GlStateManager.func_227625_M_();
        GlStateManager.func_227756_r_((int)33986);
        GlStateManager.func_227619_H_();
        GuiMap.setupTexture2();
        GlStateManager.func_227625_M_();
        GlStateManager.func_227768_x_((int)5888);
        GlStateManager.func_227756_r_((int)33984);
    }

    public static void restoreTextureStates() {
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_227709_e_();
        GuiMap.restoreTextureStates2();
    }

    public static void restoreTextureStates2() {
        GlStateManager.func_227756_r_((int)33985);
        GL11.glTexEnvi((int)8960, (int)34161, (int)8448);
        GL11.glTexEnvi((int)8960, (int)34176, (int)5890);
        GL11.glTexEnvi((int)8960, (int)34177, (int)34168);
        GL11.glTexEnvi((int)8960, (int)34193, (int)768);
        GL11.glTexEnvi((int)8960, (int)34162, (int)8448);
        GL11.glTexEnvi((int)8960, (int)34184, (int)5890);
        GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
        GlStateManager.func_227621_I_();
        GlStateManager.func_227756_r_((int)33986);
        GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
        GlStateManager.func_227621_I_();
        GlStateManager.func_227756_r_((int)33984);
        GL11.glTexEnvi((int)8960, (int)34161, (int)8448);
        GL11.glTexEnvi((int)8960, (int)34176, (int)5890);
        GL11.glTexEnvi((int)8960, (int)34192, (int)768);
        GL11.glTexEnvi((int)8960, (int)34177, (int)34168);
        GL11.glTexEnvi((int)8960, (int)34193, (int)768);
        GL11.glTexEnvi((int)8960, (int)34162, (int)8448);
        GL11.glTexEnvi((int)8960, (int)34184, (int)5890);
        GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
    }

    private static long bytesToMb(long bytes) {
        return bytes / 1024L / 1024L;
    }

    private void setColourBuffer(float r, float g, float b, float a) {
        this.colourBuffer[0] = r;
        this.colourBuffer[1] = g;
        this.colourBuffer[2] = b;
        this.colourBuffer[3] = a;
    }

    private boolean isUsingTextField() {
        Widget currentFocused = (Widget)this.func_241217_q_();
        return currentFocused != null && currentFocused.func_230999_j_() && currentFocused instanceof TextFieldWidget;
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        if (this.waypointMenu) {
            SupportMods.xaeroMinimap.getWaypointMenuRenderer().tick();
        }
        this.caveModeOptions.tick(this);
    }

    private boolean onInputPress(InputMappings.Type type, int code) {
        IRightClickableElement hoverTarget;
        if (Misc.inputMatchesKeyBinding(type, code, ControlsRegister.keyOpenSettings, (IKeyConflictContext)KeyConflictContext.GUI)) {
            this.onSettingsButton(this.settingsButton);
            return true;
        }
        boolean result = false;
        if (Misc.inputMatchesKeyBinding(type, code, this.field_230706_i_.field_71474_y.field_74321_H, (IKeyConflictContext)KeyConflictContext.GUI)) {
            this.field_230706_i_.field_71474_y.field_74321_H.func_225593_a_(true);
            result = true;
        }
        if (Misc.inputMatchesKeyBinding(type, code, ControlsRegister.keyOpenMap, (IKeyConflictContext)KeyConflictContext.GUI)) {
            this.goBack();
            result = true;
        }
        if ((type == InputMappings.Type.KEYSYM && code == 257 || Misc.inputMatchesKeyBinding(type, code, ControlsRegister.keyQuickConfirm, (IKeyConflictContext)KeyConflictContext.GUI)) && this.dimensionSettings.active) {
            this.dimensionSettings.confirm(this, this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
            result = true;
        }
        if (SupportMods.minimap()) {
            SupportMods.xaeroMinimap.onMapKeyPressed(type, code, this);
            result = true;
        }
        if ((hoverTarget = this.getHoverTarget()) != null && type == InputMappings.Type.KEYSYM) {
            boolean isValid = hoverTarget.isRightClickValid();
            if (isValid) {
                if (hoverTarget instanceof HoveredMapElementHolder && ((HoveredMapElementHolder)hoverTarget).getElement() instanceof Waypoint) {
                    switch (code) {
                        case 72: {
                            SupportMods.xaeroMinimap.disableWaypoint((Waypoint)((HoveredMapElementHolder)hoverTarget).getElement());
                            this.closeRightClick();
                            result = true;
                            break;
                        }
                        case 261: {
                            SupportMods.xaeroMinimap.deleteWaypoint((Waypoint)((HoveredMapElementHolder)hoverTarget).getElement());
                            this.closeRightClick();
                            result = true;
                        }
                    }
                }
            } else {
                this.closeRightClick();
            }
        }
        return result;
    }

    private boolean onInputRelease(InputMappings.Type type, int code) {
        boolean result = false;
        if (Misc.inputMatchesKeyBinding(type, code, this.field_230706_i_.field_71474_y.field_74321_H, (IKeyConflictContext)KeyConflictContext.GUI)) {
            this.field_230706_i_.field_71474_y.field_74321_H.func_225593_a_(false);
            result = true;
        }
        if (SupportMods.minimap() && SupportMods.xaeroMinimap.onMapKeyReleased(type, code, this)) {
            result = true;
        }
        if (SupportMods.minimap() && this.lastViewedDimensionId != null && !this.isUsingTextField()) {
            IRightClickableElement hoverTarget;
            int waypointDestinationX = this.mouseBlockPosX;
            int waypointDestinationY = this.mouseBlockPosY;
            int waypointDestinationZ = this.mouseBlockPosZ;
            if (this.rightClickMenu != null && this.rightClickMenu.getTarget() == this) {
                waypointDestinationX = this.rightClickX;
                waypointDestinationY = this.rightClickY;
                waypointDestinationZ = this.rightClickZ;
            }
            if (SupportMods.xaeroMinimap.canCreateWaypoint(waypointDestinationY)) {
                if (Misc.inputMatchesKeyBinding(type, code, SupportMods.xaeroMinimap.getWaypointKeyBinding(), (IKeyConflictContext)KeyConflictContext.GUI) && WorldMap.settings.waypoints) {
                    SupportMods.xaeroMinimap.createWaypoint(this, waypointDestinationX, waypointDestinationY == -1 ? -1 : waypointDestinationY + 1, waypointDestinationZ);
                    this.closeRightClick();
                    result = true;
                }
                if (Misc.inputMatchesKeyBinding(type, code, SupportMods.xaeroMinimap.getTempWaypointKeyBinding(), (IKeyConflictContext)KeyConflictContext.GUI) && WorldMap.settings.waypoints) {
                    this.closeRightClick();
                    SupportMods.xaeroMinimap.createTempWaypoint(waypointDestinationX, waypointDestinationY == -1 ? -1 : waypointDestinationY + 1, waypointDestinationZ);
                    result = true;
                }
            }
            if ((hoverTarget = this.getHoverTarget()) != null && type == InputMappings.Type.KEYSYM) {
                boolean isValid = hoverTarget.isRightClickValid();
                if (isValid) {
                    if (hoverTarget instanceof HoveredMapElementHolder && ((HoveredMapElementHolder)hoverTarget).getElement() instanceof Waypoint) {
                        switch (code) {
                            case 84: {
                                SupportMods.xaeroMinimap.teleportToWaypoint(this, (Waypoint)((HoveredMapElementHolder)hoverTarget).getElement());
                                this.closeRightClick();
                                result = true;
                                break;
                            }
                            case 69: {
                                SupportMods.xaeroMinimap.openWaypoint(this, (Waypoint)((HoveredMapElementHolder)hoverTarget).getElement());
                                this.closeRightClick();
                                result = true;
                            }
                        }
                    }
                } else {
                    this.closeRightClick();
                }
            }
        }
        return result;
    }

    private IRightClickableElement getHoverTarget() {
        return this.rightClickMenu != null ? this.rightClickMenu.getTarget() : this.viewed;
    }

    private void unfocusAll() {
        if (SupportMods.minimap()) {
            SupportMods.xaeroMinimap.getWaypointMenuRenderer().unfocusAll();
        }
        this.caveModeOptions.unfocusAll();
        this.func_231035_a_(null);
    }

    public void closeRightClick() {
        if (this.rightClickMenu != null) {
            this.rightClickMenu.setClosed(true);
        }
    }

    public void onRightClickClosed() {
        this.rightClickMenu = null;
        this.mapTileSelection = null;
    }

    private void closeDropdowns() {
        if (this.openDropdown != null) {
            this.openDropdown.setClosed(true);
        }
    }

    @Override
    public ArrayList<RightClickOption> getRightClickOptions() {
        ArrayList<RightClickOption> options = new ArrayList<RightClickOption>();
        options.add(new RightClickOption("gui.xaero_right_click_map_title", options.size(), this){

            @Override
            public void onAction(Screen screen) {
            }
        });
        if (!(!WorldMap.settings.coordinates || SupportMods.minimap() && SupportMods.xaeroMinimap.hidingWaypointCoordinates())) {
            if (this.mapTileSelection != null) {
                String chunkOption = this.mapTileSelection.getStartX() != this.mapTileSelection.getEndX() || this.mapTileSelection.getStartZ() != this.mapTileSelection.getEndZ() ? String.format("C: (%d;%d):(%d;%d)", this.mapTileSelection.getLeft(), this.mapTileSelection.getTop(), this.mapTileSelection.getRight(), this.mapTileSelection.getBottom()) : String.format("C: (%d;%d)", this.mapTileSelection.getLeft(), this.mapTileSelection.getTop());
                options.add(new RightClickOption(chunkOption, options.size(), this){

                    @Override
                    public void onAction(Screen screen) {
                    }
                });
            }
            options.add(new RightClickOption(String.format(this.rightClickY != -1 ? "X: %1$d, Y: %2$d, Z: %3$d" : "X: %1$d, Z: %3$d", this.rightClickX, this.rightClickY, this.rightClickZ), options.size(), this){

                @Override
                public void onAction(Screen screen) {
                }
            });
        }
        if (SupportMods.minimap() && WorldMap.settings.waypoints) {
            if (SupportMods.xaeroMinimap.canCreateWaypoint(this.rightClickY)) {
                options.add(new RightClickOption("gui.xaero_right_click_map_create_waypoint", options.size(), this){

                    @Override
                    public void onAction(Screen screen) {
                        SupportMods.xaeroMinimap.createWaypoint(GuiMap.this, GuiMap.this.rightClickX, GuiMap.this.rightClickY == -1 ? -1 : GuiMap.this.rightClickY + 1, GuiMap.this.rightClickZ);
                    }
                }.setNameFormatArgs(Misc.getKeyName(SupportMods.xaeroMinimap.getWaypointKeyBinding())));
                options.add(new RightClickOption("gui.xaero_right_click_map_create_temporary_waypoint", options.size(), this){

                    @Override
                    public void onAction(Screen screen) {
                        SupportMods.xaeroMinimap.createTempWaypoint(GuiMap.this.rightClickX, GuiMap.this.rightClickY == -1 ? -1 : GuiMap.this.rightClickY + 1, GuiMap.this.rightClickZ);
                    }
                }.setNameFormatArgs(Misc.getKeyName(SupportMods.xaeroMinimap.getTempWaypointKeyBinding())));
            } else {
                options.add(new RightClickOption("gui.xaero_right_click_map_cant_create_waypoint", options.size(), this){

                    @Override
                    public void onAction(Screen screen) {
                    }
                });
            }
        }
        MapDimension currentDimension = this.mapProcessor.getMapWorld().getCurrentDimension();
        if (!this.field_230706_i_.field_71442_b.func_78755_b() || currentDimension != null && currentDimension.currentMultiworldWritable) {
            if (this.mapProcessor.getMapWorld().isTeleportAllowed() && (this.rightClickY != -1 || !this.field_230706_i_.field_71442_b.func_78755_b())) {
                options.add(new RightClickOption("gui.xaero_right_click_map_teleport", options.size(), this){

                    @Override
                    public void onAction(Screen screen) {
                        MapDimension currentDimension = GuiMap.this.mapProcessor.getMapWorld().getCurrentDimension();
                        if (!(((GuiMap)GuiMap.this).field_230706_i_.field_71442_b.func_78755_b() && (currentDimension == null || !currentDimension.currentMultiworldWritable) || GuiMap.this.rightClickY == -1 && ((GuiMap)GuiMap.this).field_230706_i_.field_71442_b.func_78755_b())) {
                            new MapTeleporter().teleport(GuiMap.this, GuiMap.this.mapProcessor.getMapWorld(), GuiMap.this.rightClickX, GuiMap.this.rightClickY == -1 ? -1 : GuiMap.this.rightClickY + 1, GuiMap.this.rightClickZ);
                        }
                    }
                });
            } else if (!this.mapProcessor.getMapWorld().isTeleportAllowed()) {
                options.add(new RightClickOption("gui.xaero_wm_right_click_map_teleport_not_allowed", options.size(), this){

                    @Override
                    public void onAction(Screen screen) {
                    }
                });
            } else {
                options.add(new RightClickOption("gui.xaero_right_click_map_cant_teleport", options.size(), this){

                    @Override
                    public void onAction(Screen screen) {
                    }
                });
            }
        } else {
            options.add(new RightClickOption("gui.xaero_right_click_map_cant_teleport_world", options.size(), this){

                @Override
                public void onAction(Screen screen) {
                }
            });
        }
        if (SupportMods.minimap()) {
            if (SupportMods.xaeroMinimap.canCreateWaypoint(this.rightClickY)) {
                options.add(new RightClickOption("gui.xaero_right_click_map_share_location", options.size(), this){

                    @Override
                    public void onAction(Screen screen) {
                        SupportMods.xaeroMinimap.shareLocation(GuiMap.this, GuiMap.this.rightClickX, GuiMap.this.rightClickY == -1 ? -1 : GuiMap.this.rightClickY + 1, GuiMap.this.rightClickZ);
                    }
                });
            } else {
                options.add(new RightClickOption("gui.xaero_right_click_map_cant_share_location", options.size(), this){

                    @Override
                    public void onAction(Screen screen) {
                    }
                });
            }
            if (WorldMap.settings.waypoints) {
                options.add(new RightClickOption("gui.xaero_right_click_map_waypoints_menu", options.size(), this){

                    @Override
                    public void onAction(Screen screen) {
                        SupportMods.xaeroMinimap.openWaypointsMenu(GuiMap.this.field_230706_i_, GuiMap.this);
                    }
                }.setNameFormatArgs(Misc.getKeyName(SupportMods.xaeroMinimap.getTempWaypointsMenuKeyBinding())));
            }
        }
        options.add(new RightClickOption("gui.xaero_right_click_box_map_export", options.size(), this){

            @Override
            public void onAction(Screen screen) {
                GuiMap.this.onExportButton(GuiMap.this.exportButton);
            }
        });
        options.add(new RightClickOption("gui.xaero_right_click_box_map_settings", options.size(), this){

            @Override
            public void onAction(Screen screen) {
                GuiMap.this.onSettingsButton(GuiMap.this.settingsButton);
            }
        }.setNameFormatArgs(Misc.getKeyName(ControlsRegister.keyOpenSettings)));
        return options;
    }

    @Override
    public boolean isRightClickValid() {
        return true;
    }

    @Override
    public int getRightClickTitleBackgroundColor() {
        return -10461088;
    }

    @Override
    public boolean shouldSkipWorldRender() {
        return true;
    }

    public double getUserScale() {
        return this.userScale;
    }

    public Button getRadarButton() {
        return this.radarButton;
    }

    @Override
    public void onDropdownOpen(DropDownWidget menu) {
        super.onDropdownOpen(menu);
        this.unfocusAll();
    }

    @Override
    public void onDropdownClosed(DropDownWidget menu) {
        super.onDropdownClosed(menu);
        if (menu == this.rightClickMenu) {
            this.onRightClickClosed();
        }
    }

    public void onCaveModeStartSet() {
        this.caveModeOptions.onCaveModeStartSet(this);
    }

    public MapDimension getDimension() {
        return this.dimension;
    }

    public MapProcessor getMapProcessor() {
        return this.mapProcessor;
    }

    public void enableCaveModeOptions() {
        if (!this.caveModeOptions.isEnabled()) {
            this.caveModeOptions.toggle(this);
        }
    }

    static {
        identityMatrix.func_226591_a_();
    }
}

