/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.mods;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import xaero.map.WorldMap;
import xaero.map.misc.Misc;

public class SupportFramedBlocks {
    private Class<?> framedTileBlockClass;
    private Method framedTileEntityCamoStateMethod;
    private Method framedTileEntityCamoMethod;
    private Method camoContainerStateMethod;
    private boolean usable;
    private Set<Block> framedBlocks;

    public SupportFramedBlocks() {
        try {
            this.framedTileBlockClass = Class.forName("xfacthd.framedblocks.common.tileentity.FramedTileEntity");
        }
        catch (ClassNotFoundException cnfe) {
            try {
                this.framedTileBlockClass = Class.forName("xfacthd.framedblocks.api.block.FramedBlockEntity");
            }
            catch (ClassNotFoundException cnfe2) {
                WorldMap.LOGGER.info("Failed to init Framed Blocks support!", (Throwable)cnfe2);
                return;
            }
        }
        try {
            this.framedTileEntityCamoStateMethod = this.framedTileBlockClass.getDeclaredMethod("getCamoState", new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e1) {
            try {
                Class<?> camoContainerClass = Class.forName("xfacthd.framedblocks.api.data.CamoContainer");
                this.framedTileEntityCamoMethod = this.framedTileBlockClass.getDeclaredMethod("getCamo", new Class[0]);
                this.camoContainerStateMethod = camoContainerClass.getDeclaredMethod("getState", new Class[0]);
            }
            catch (ClassNotFoundException | NoSuchMethodException | SecurityException e2) {
                WorldMap.LOGGER.info("Failed to init Framed Blocks support!", (Throwable)e1);
                WorldMap.LOGGER.info("Failed to init Framed Blocks support!", (Throwable)e2);
            }
        }
        this.usable = this.framedTileBlockClass != null && (this.framedTileEntityCamoStateMethod != null || this.framedTileEntityCamoMethod != null && this.camoContainerStateMethod != null);
    }

    public void onWorldChange() {
        this.framedBlocks = null;
    }

    private void findFramedBlocks(World world, Registry<Block> registry) {
        if (this.framedBlocks == null) {
            this.framedBlocks = new HashSet<Block>();
            if (registry == null) {
                registry = Registry.field_212618_g;
            }
            registry.func_239659_c_().forEach(entry -> {
                RegistryKey key = (RegistryKey)entry.getKey();
                if (key.func_240901_a_().func_110624_b().equals("framedblocks") && key.func_240901_a_().func_110623_a().startsWith("framed_")) {
                    this.framedBlocks.add((Block)entry.getValue());
                }
            });
        }
    }

    public boolean isFrameBlock(World world, Registry<Block> registry, BlockState state) {
        if (!this.usable) {
            return false;
        }
        this.findFramedBlocks(world, registry);
        return this.framedBlocks.contains(state.func_177230_c());
    }

    public BlockState unpackFramedBlock(World world, Registry<Block> registry, BlockState original, TileEntity tileEntity) {
        if (!this.usable) {
            return original;
        }
        if (this.framedTileBlockClass.isAssignableFrom(tileEntity.getClass())) {
            if (this.framedTileEntityCamoStateMethod != null) {
                return (BlockState)Misc.getReflectMethodValue(tileEntity, this.framedTileEntityCamoStateMethod, new Object[0]);
            }
            Object camoContainer = Misc.getReflectMethodValue(tileEntity, this.framedTileEntityCamoMethod, new Object[0]);
            return (BlockState)Misc.getReflectMethodValue(camoContainer, this.camoContainerStateMethod, new Object[0]);
        }
        return original;
    }
}

