/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.patreon;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import javax.crypto.Cipher;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.fml.loading.FMLPaths;
import xaero.common.mods.SupportXaeroWorldmap;
import xaero.map.WorldMap;
import xaero.map.patreon.PatreonMod;
import xaero.map.patreon.decrypt.DecryptInputStream;

public class Patreon {
    private static HashMap<Integer, ArrayList<String>> patrons = new HashMap();
    private static boolean notificationDisplayed;
    private static boolean loaded;
    private static boolean showCapes;
    private static int patronPledge;
    private static String updateLocation;
    private static HashMap<String, Object> mods;
    private static ArrayList<Object> outdatedMods;
    private static Cipher cipher;
    private static int KEY_VERSION;
    private static String publicKeyString;
    private static boolean shouldRedirectToMinimap;
    private static File optionsFile;
    private static String rendersCapes;
    private static ResourceLocation cape1;
    private static ResourceLocation cape2;
    private static ResourceLocation cape3;
    private static ResourceLocation cape4;
    private static boolean pauseCapes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkPatreon() {
        if (shouldRedirectToMinimap) {
            xaero.common.patreon.Patreon.checkPatreon();
            return;
        }
        HashMap<Integer, ArrayList<String>> hashMap = patrons;
        synchronized (hashMap) {
            if (loaded) {
                return;
            }
            Patreon.loadSettings();
            String s = "http://data.chocolateminecraft.com/Versions_" + KEY_VERSION + "/Patreon.dat";
            s = s.replaceAll(" ", "%20");
            try {
                String[] args;
                String line;
                URL url = new URL(s);
                URLConnection conn = url.openConnection();
                conn.setReadTimeout(900);
                conn.setConnectTimeout(900);
                if (conn.getContentLengthLong() > 524288L) {
                    throw new IOException("Input too long to trust!");
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(new DecryptInputStream(conn.getInputStream(), cipher)));
                int pledge = -1;
                while ((line = reader.readLine()) != null && !line.equals("LAYOUTS")) {
                    if (line.startsWith("PATREON")) {
                        pledge = Integer.parseInt(line.substring(7));
                        patrons.put(pledge, new ArrayList());
                        continue;
                    }
                    if (pledge == -1) continue;
                    args = line.split("\\t");
                    patrons.get(pledge).add(args[0]);
                    if (!args[0].equalsIgnoreCase(Minecraft.func_71410_x().func_110432_I().func_148256_e().getName())) continue;
                    patronPledge = pledge;
                }
                updateLocation = reader.readLine();
                while ((line = reader.readLine()) != null) {
                    args = line.split("\\t");
                    mods.put(args[0], new PatreonMod(args[0], args[1], args[2], args[3]));
                }
                reader.close();
            }
            catch (Throwable e) {
                WorldMap.LOGGER.error("suppressed exception", e);
                patrons.clear();
                mods.clear();
            }
            finally {
                loaded = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addOutdatedMod(Object mod) {
        if (shouldRedirectToMinimap) {
            xaero.common.patreon.Patreon.addOutdatedMod((Object)mod);
            return;
        }
        ArrayList<Object> arrayList = Patreon.getOutdatedMods();
        synchronized (arrayList) {
            Patreon.getOutdatedMods().add(mod);
        }
    }

    public static int getPatronPledge(String name) {
        if (shouldRedirectToMinimap) {
            return xaero.common.patreon.Patreon.getPatronPledge((String)name);
        }
        Integer[] keys = patrons.keySet().toArray(new Integer[0]);
        for (int i = 0; i < keys.length; ++i) {
            if (!patrons.get(keys[i]).contains(name)) continue;
            return keys[i];
        }
        return -1;
    }

    public static void saveSettings() {
        if (shouldRedirectToMinimap) {
            xaero.common.patreon.Patreon.saveSettings();
            return;
        }
        try {
            PrintWriter writer = new PrintWriter(new FileWriter(optionsFile));
            writer.println("showCapes:" + showCapes);
            writer.close();
        }
        catch (IOException e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
        }
    }

    public static void loadSettings() {
        if (shouldRedirectToMinimap) {
            xaero.common.patreon.Patreon.loadSettings();
            return;
        }
        try {
            String line;
            if (!optionsFile.exists()) {
                Patreon.saveSettings();
                return;
            }
            BufferedReader reader = new BufferedReader(new FileReader(optionsFile));
            while ((line = reader.readLine()) != null) {
                String[] args = line.split(":");
                if (!args[0].equalsIgnoreCase("showCapes")) continue;
                showCapes = args[1].equals("true");
            }
            reader.close();
        }
        catch (IOException e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
        }
    }

    public static ResourceLocation getPlayerCape(String modID, AbstractClientPlayerEntity playerEntity) {
        if (shouldRedirectToMinimap) {
            return xaero.common.patreon.Patreon.getPlayerCape((String)modID, (AbstractClientPlayerEntity)playerEntity);
        }
        if (!pauseCapes && showCapes && modID.equals(rendersCapes)) {
            ResourceLocation cape = null;
            int pledge = Patreon.getPatronPledge(playerEntity.func_200200_C_().getString());
            if (pledge == 2) {
                cape = cape1;
            } else if (pledge == 5) {
                cape = cape2;
            } else if (pledge == 10) {
                cape = cape3;
            } else if (pledge == 50) {
                cape = cape4;
            }
            if (cape == null) {
                return null;
            }
            pauseCapes = true;
            ResourceLocation realCape = playerEntity.func_110303_q();
            boolean realIsWearing = playerEntity.func_175148_a(PlayerModelPart.CAPE);
            pauseCapes = false;
            if (realCape != null && realIsWearing) {
                return realCape;
            }
            return cape;
        }
        return null;
    }

    public static Boolean isWearingCape(String modID, AbstractClientPlayerEntity playerEntity) {
        if (shouldRedirectToMinimap) {
            return xaero.common.patreon.Patreon.isWearingCape((String)modID, (AbstractClientPlayerEntity)playerEntity);
        }
        if (!pauseCapes && showCapes && modID.equals(rendersCapes)) {
            pauseCapes = true;
            ResourceLocation realCape = playerEntity.func_110303_q();
            boolean realIsWearing = playerEntity.func_175148_a(PlayerModelPart.CAPE);
            pauseCapes = false;
            if (realIsWearing || realCape == null) {
                return realIsWearing;
            }
            int pledge = Patreon.getPatronPledge(playerEntity.func_200200_C_().getString());
            return pledge >= 2;
        }
        return null;
    }

    public static void renderCapeFallback(String modID, RenderPlayerEvent.Post event) {
        if (shouldRedirectToMinimap) {
            xaero.common.patreon.Patreon.renderCapeFallback((String)modID, (RenderPlayerEvent.Post)event);
            return;
        }
        if (!event.getPlayer().func_70089_S() || event.getPlayer().func_70608_bn() || event.getPlayer().func_203007_ba()) {
            return;
        }
        pauseCapes = true;
        ResourceLocation realCape = ((AbstractClientPlayerEntity)event.getPlayer()).func_110303_q();
        boolean realIsWearing = event.getPlayer().func_175148_a(PlayerModelPart.CAPE);
        pauseCapes = false;
        if (realCape != null && realIsWearing || realCape == null && !realIsWearing) {
            return;
        }
        AbstractClientPlayerEntity player = (AbstractClientPlayerEntity)event.getPlayer();
        ResourceLocation cape = Patreon.getPlayerCape(modID, player);
        if (cape == null) {
            return;
        }
        ItemStack itemstack = event.getPlayer().func_184582_a(EquipmentSlotType.CHEST);
        if (itemstack == null || itemstack.func_77973_b() != Items.field_185160_cR) {
            float partialTick = event.getPartialRenderTick();
            MatrixStack matrixStack = event.getMatrixStack();
            matrixStack.func_227860_a_();
            matrixStack.func_227862_a_(-1.0f, -1.0f, 1.0f);
            matrixStack.func_227861_a_(0.0, -1.35, 0.0);
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
            float bodyRotation = player.field_70760_ar + (player.field_70761_aq - player.field_70760_ar) * partialTick;
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(bodyRotation));
            GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            matrixStack.func_227861_a_(0.0, 0.0, 0.125);
            double capeOffX = player.field_71091_bM + (player.field_71094_bP - player.field_71091_bM) * (double)partialTick - (player.field_70169_q + (player.func_226277_ct_() - player.field_70169_q) * (double)partialTick);
            double capeOffY = player.field_71096_bN + (player.field_71095_bQ - player.field_71096_bN) * (double)partialTick - (player.field_70167_r + (player.func_226278_cu_() - player.field_70167_r) * (double)partialTick);
            double capeOffZ = player.field_71097_bO + (player.field_71085_bR - player.field_71097_bO) * (double)partialTick - (player.field_70166_s + (player.func_226281_cx_() - player.field_70166_s) * (double)partialTick);
            double bodyRotSin = MathHelper.func_76126_a((float)(bodyRotation * ((float)Math.PI / 180)));
            double bodyRotCos = -MathHelper.func_76134_b((float)(bodyRotation * ((float)Math.PI / 180)));
            float scaledCapeOffY = MathHelper.func_76131_a((float)((float)capeOffY * 10.0f), (float)-6.0f, (float)32.0f);
            float scaledCapeOffZBodySpace = MathHelper.func_76131_a((float)((float)(capeOffX * bodyRotSin + capeOffZ * bodyRotCos) * 100.0f), (float)0.0f, (float)150.0f);
            float scaledCapeOffXBodySpace = MathHelper.func_76131_a((float)((float)(capeOffX * bodyRotCos - capeOffZ * bodyRotSin) * 100.0f), (float)-20.0f, (float)20.0f);
            float bob = player.field_71107_bF + (player.field_71109_bG - player.field_71107_bF) * partialTick;
            scaledCapeOffY += MathHelper.func_76126_a((float)((player.field_70141_P + (player.field_70140_Q - player.field_70141_P) * partialTick) * 6.0f)) * 32.0f * bob;
            if (player.func_225608_bj_()) {
                scaledCapeOffY += 25.0f;
            }
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(6.0f + Math.min(90.0f, scaledCapeOffZBodySpace / 2.0f) + scaledCapeOffY));
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(scaledCapeOffXBodySpace / 2.0f));
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - scaledCapeOffXBodySpace / 2.0f));
            IVertexBuilder vertexbuilder = event.getBuffers().getBuffer(RenderType.func_228634_a_((ResourceLocation)cape));
            ((PlayerModel)event.getRenderer().func_217764_d()).func_228289_b_(matrixStack, vertexbuilder, event.getLight(), OverlayTexture.field_229196_a_);
            matrixStack.func_227865_b_();
        }
    }

    public static ArrayList<Object> getOutdatedMods() {
        if (shouldRedirectToMinimap) {
            return xaero.common.patreon.Patreon.getOutdatedMods();
        }
        return outdatedMods;
    }

    public static boolean needsNotification() {
        if (shouldRedirectToMinimap) {
            return false;
        }
        return !Patreon.isNotificationDisplayed() && !outdatedMods.isEmpty();
    }

    public static int getPatronPledge() {
        if (shouldRedirectToMinimap) {
            return xaero.common.patreon.Patreon.getPatronPledge();
        }
        return patronPledge;
    }

    public static void setPatronPledge(int patronPledge) {
        if (shouldRedirectToMinimap) {
            xaero.common.patreon.Patreon.setPatronPledge((int)patronPledge);
            return;
        }
        Patreon.patronPledge = patronPledge;
    }

    public static boolean isNotificationDisplayed() {
        if (shouldRedirectToMinimap) {
            return xaero.common.patreon.Patreon.isNotificationDisplayed();
        }
        return notificationDisplayed;
    }

    public static void setNotificationDisplayed(boolean notificationDisplayed) {
        if (shouldRedirectToMinimap) {
            xaero.common.patreon.Patreon.setNotificationDisplayed((boolean)notificationDisplayed);
            return;
        }
        Patreon.notificationDisplayed = notificationDisplayed;
    }

    public static HashMap<String, Object> getMods() {
        if (shouldRedirectToMinimap) {
            return xaero.common.patreon.Patreon.getMods();
        }
        return mods;
    }

    public static String getUpdateLocation() {
        if (shouldRedirectToMinimap) {
            return xaero.common.patreon.Patreon.getUpdateLocation();
        }
        return updateLocation;
    }

    public static String getRendersCapes() {
        if (shouldRedirectToMinimap) {
            return xaero.common.patreon.Patreon.getRendersCapes();
        }
        return rendersCapes;
    }

    public static void setRendersCapes(String rendersCapes) {
        if (shouldRedirectToMinimap) {
            xaero.common.patreon.Patreon.setRendersCapes((String)rendersCapes);
            return;
        }
        Patreon.rendersCapes = rendersCapes;
    }

    public static void setModInfo(Object mod, File modJAR, String versionID, String latestVersion, String latestVersionMD5, Runnable onVersionIgnore) {
        if (shouldRedirectToMinimap) {
            xaero.common.patreon.PatreonMod patreonEntry = (xaero.common.patreon.PatreonMod)mod;
            patreonEntry.modJar = modJAR;
            patreonEntry.currentVersion = versionID;
            patreonEntry.latestVersion = latestVersion;
            patreonEntry.md5 = latestVersionMD5;
            patreonEntry.onVersionIgnore = onVersionIgnore;
            return;
        }
        PatreonMod patreonEntry = (PatreonMod)mod;
        patreonEntry.modJar = modJAR;
        patreonEntry.currentVersion = versionID;
        patreonEntry.latestVersion = latestVersion;
        patreonEntry.md5 = latestVersionMD5;
        patreonEntry.onVersionIgnore = onVersionIgnore;
    }

    public static String getPublicKeyString() {
        if (shouldRedirectToMinimap) {
            if (SupportXaeroWorldmap.WORLDMAP_COMPATIBILITY_VERSION < 10) {
                return xaero.common.patreon.Patreon.getPublicKeyString();
            }
            return xaero.common.patreon.Patreon.getPublicKeyString2();
        }
        return publicKeyString;
    }

    public static int getKEY_VERSION() {
        if (shouldRedirectToMinimap) {
            if (SupportXaeroWorldmap.WORLDMAP_COMPATIBILITY_VERSION < 10) {
                return xaero.common.patreon.Patreon.getKEY_VERSION();
            }
            return xaero.common.patreon.Patreon.getKEY_VERSION2();
        }
        return KEY_VERSION;
    }

    static {
        loaded = false;
        showCapes = true;
        patronPledge = -1;
        mods = new HashMap();
        outdatedMods = new ArrayList();
        cipher = null;
        KEY_VERSION = 4;
        publicKeyString = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAoBeELcruvAEIeLF/UsWF/v5rxyRXIpCs+eORLCbDw5cz9jHsnoypQKx0RTk5rcXIeA0HbEfY0eREB25quHjhZKul7MnzotQT+F2Qb1bPfHa6+SPie+pj79GGGAFP3npki6RqoU/wyYkd1tOomuD8v5ytEkOPC4U42kxxvx23A7vH6w46dew/E/HvfbBvZF2KrqdJtwKAunk847C3FgyhVq8/vzQc6mqAW6Mmn4zlwFvyCnTOWjIRw/I93WIM/uvhE3lt6pmtrWA2yIbKIj1z4pgG/K72EqHfYLGkBFTh7fV1wwCbpNTXZX2JnTfmvMGqzHjq7FijwVfCpFB/dWR3wQIDAQAB";
        shouldRedirectToMinimap = false;
        try {
            Class.forName("xaero.common.patreon.Patreon");
            shouldRedirectToMinimap = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (!shouldRedirectToMinimap) {
            try {
                cipher = Cipher.getInstance("RSA");
                KeyFactory factory = KeyFactory.getInstance("RSA");
                byte[] byteKey = Base64.getDecoder().decode(Patreon.getPublicKeyString().getBytes());
                X509EncodedKeySpec X509publicKey = new X509EncodedKeySpec(byteKey);
                PublicKey publicKey = factory.generatePublic(X509publicKey);
                cipher.init(2, publicKey);
            }
            catch (Exception e) {
                cipher = null;
                WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
            }
        }
        optionsFile = FMLPaths.GAMEDIR.get().resolve("config").resolve("xaeropatreon.txt").toFile();
        rendersCapes = null;
        cape1 = new ResourceLocation("xaeropatreon", "capes/cape1.png");
        cape2 = new ResourceLocation("xaeropatreon", "capes/cape2.png");
        cape3 = new ResourceLocation("xaeropatreon", "capes/cape3.png");
        cape4 = new ResourceLocation("xaeropatreon", "capes/cape4.png");
        pauseCapes = false;
    }
}

