/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.region;

import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import xaero.map.MapProcessor;
import xaero.map.MapWriter;
import xaero.map.biome.BlockTintProvider;
import xaero.map.region.MapBlock;
import xaero.map.region.MapPixel;
import xaero.map.region.MapTile;
import xaero.map.region.MapTileChunk;
import xaero.map.region.OverlayManager;

public class Overlay
extends MapPixel {
    private short opacity;

    public Overlay(BlockState state, byte light, boolean glowing) {
        this.write(state, light, glowing);
    }

    public void write(BlockState state, byte light, boolean glowing) {
        this.opacity = 0;
        this.state = state;
        this.light = light;
        this.glowing = glowing;
    }

    public boolean isWater() {
        return this.state.func_177230_c() == Blocks.field_150355_j;
    }

    public int getParametres() {
        int parametres = 0;
        parametres |= !this.isWater() ? 1 : 0;
        parametres |= this.opacity > 1 ? 8 : 0;
        return parametres |= this.light << 4;
    }

    public void getPixelColour(MapBlock block, int[] result_dest, MapWriter mapWriter, World world, MapTileChunk tileChunk, MapTileChunk prevChunk, MapTileChunk prevChunkDiagonal, MapTileChunk prevChunkHorisontal, MapTile mapTile, int x, int z, int caveStart, int caveDepth, BlockPos.Mutable mutableGlobalPos, MutableRegistry<Biome> biomeRegistry, float shadowR, float shadowG, float shadowB, BlockTintProvider blockTintProvider, MapProcessor mapProcessor, OverlayManager overlayManager) {
        super.getPixelColours(result_dest, mapWriter, world, tileChunk, prevChunk, prevChunkDiagonal, prevChunkHorisontal, mapTile, x, z, block, -1, -1, caveStart, caveDepth, null, mutableGlobalPos, biomeRegistry, shadowR, shadowG, shadowB, blockTintProvider, mapProcessor, overlayManager, null);
    }

    public String toRenderString() {
        return "(S: " + this.getState() + ", O: " + this.opacity + ", L: " + this.light + ")";
    }

    public boolean equals(Overlay p) {
        return p != null && this.opacity == p.opacity && this.light == p.light && this.getState() == p.getState();
    }

    void fillManagerKeyHolder(Object[] keyHolder) {
        keyHolder[0] = this.state;
        keyHolder[1] = this.light;
        keyHolder[2] = this.opacity;
    }

    public void increaseOpacity(int toAdd) {
        this.opacity = (short)(this.opacity + toAdd);
    }

    public int getOpacity() {
        return this.opacity;
    }
}

