/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.item;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.blay09.mods.waystones.Waystones;
import net.blay09.mods.waystones.api.IAttunementItem;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.block.WarpPlateBlock;
import net.blay09.mods.waystones.container.WarpPlateContainer;
import net.blay09.mods.waystones.core.WaystoneProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AttunedShardItem
extends Item
implements IAttunementItem {
    public static final String name = "attuned_shard";
    public static final ResourceLocation registryName = new ResourceLocation("waystones", "attuned_shard");

    public AttunedShardItem() {
        super(new Item.Properties().func_200916_a(Waystones.itemGroup).func_200917_a(1));
    }

    public boolean func_77636_d(ItemStack itemStack) {
        IWaystone waystoneAttunedTo = this.getWaystoneAttunedTo(itemStack);
        return waystoneAttunedTo != null && waystoneAttunedTo.isValid();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        IWaystone attunedWarpPlate = this.getWaystoneAttunedTo(stack);
        if (attunedWarpPlate == null || !attunedWarpPlate.isValid()) {
            TranslationTextComponent textComponent = new TranslationTextComponent("tooltip.waystones.attuned_shard.attunement_lost");
            textComponent.func_240699_a_(TextFormatting.GRAY);
            tooltip.add((ITextComponent)textComponent);
            return;
        }
        tooltip.add(WarpPlateBlock.getGalacticName(attunedWarpPlate));
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && player.field_71070_bA instanceof WarpPlateContainer) {
            IWaystone currentWarpPlate = ((WarpPlateContainer)player.field_71070_bA).getWaystone();
            if (attunedWarpPlate.getWaystoneUid().equals(currentWarpPlate.getWaystoneUid())) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.waystones.attuned_shard.move_to_other_warp_plate"));
            } else {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.waystones.attuned_shard.plug_into_warp_plate"));
            }
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.waystones.attuned_shard.plug_into_warp_plate"));
        }
    }

    @Override
    @Nullable
    public IWaystone getWaystoneAttunedTo(ItemStack itemStack) {
        CompoundNBT compound = itemStack.func_77978_p();
        if (compound != null && compound.func_150297_b("AttunedToWaystone", 11)) {
            return new WaystoneProxy(NBTUtil.func_186860_b((INBT)Objects.requireNonNull(compound.func_74781_a("AttunedToWaystone"))));
        }
        return null;
    }

    public static void setWaystoneAttunedTo(ItemStack itemStack, @Nullable IWaystone waystone) {
        CompoundNBT tagCompound = itemStack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new CompoundNBT();
            itemStack.func_77982_d(tagCompound);
        }
        if (waystone != null) {
            tagCompound.func_218657_a("AttunedToWaystone", (INBT)NBTUtil.func_240626_a_((UUID)waystone.getWaystoneUid()));
        } else {
            tagCompound.func_82580_o("AttunedToWaystone");
        }
    }
}

