/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.network.message;

import java.util.Objects;
import java.util.function.Supplier;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.block.WaystoneBlock;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.Waystone;
import net.blay09.mods.waystones.core.WaystoneManager;
import net.blay09.mods.waystones.core.WaystoneProxy;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;

public class RemoveWaystoneMessage {
    private final IWaystone waystone;

    public RemoveWaystoneMessage(IWaystone waystone) {
        this.waystone = waystone;
    }

    public static void encode(RemoveWaystoneMessage message, PacketBuffer buf) {
        buf.func_179252_a(message.waystone.getWaystoneUid());
    }

    public static RemoveWaystoneMessage decode(PacketBuffer buf) {
        WaystoneProxy waystone = new WaystoneProxy(buf.func_179253_g());
        return new RemoveWaystoneMessage(waystone);
    }

    public static void handle(RemoveWaystoneMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            IWaystone backingWaystone;
            ServerPlayerEntity player = context.getSender();
            if (player == null) {
                return;
            }
            PlayerWaystoneManager.deactivateWaystone((PlayerEntity)player, message.waystone);
            if (message.waystone.isGlobal() && player.field_71075_bZ.field_75098_d && message.waystone instanceof WaystoneProxy && (backingWaystone = ((WaystoneProxy)message.waystone).getBackingWaystone()) instanceof Waystone) {
                BlockState state;
                ((Waystone)backingWaystone).setGlobal(false);
                ServerWorld targetWorld = Objects.requireNonNull(player.field_70170_p.func_73046_m()).func_71218_a(backingWaystone.getDimension());
                BlockPos pos = backingWaystone.getPos();
                BlockState blockState = state = targetWorld != null ? targetWorld.func_180495_p(pos) : null;
                if (targetWorld == null || !(state.func_177230_c() instanceof WaystoneBlock)) {
                    WaystoneManager.get().removeWaystone(backingWaystone);
                    PlayerWaystoneManager.removeKnownWaystone(backingWaystone);
                }
            }
        });
        context.setPacketHandled(true);
    }
}

