/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.fluid;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.brackets.CommandStringDisplayable;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.impl.tag.MCTagWithAmount;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.fluid.Fluid;
import net.minecraft.tags.ITag;
import net.minecraftforge.fluids.FluidStack;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.fluid.FluidIngredient")
@Document(value="vanilla/api/fluid/FluidIngredient")
public abstract class CTFluidIngredient
implements CommandStringDisplayable {
    CTFluidIngredient() {
    }

    @Override
    public abstract String getCommandString();

    public abstract <T> T mapTo(Function<FluidStack, T> var1, BiFunction<ITag<Fluid>, Integer, T> var2, Function<Stream<T>, T> var3);

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.OR)
    public CTFluidIngredient asCompound(CTFluidIngredient other) {
        ArrayList<CTFluidIngredient> ingredients = new ArrayList<CTFluidIngredient>();
        if (other instanceof CompoundFluidIngredient) {
            ingredients.addAll(((CompoundFluidIngredient)other).elements);
        } else {
            ingredients.add(other);
        }
        if (this instanceof CompoundFluidIngredient) {
            ((CompoundFluidIngredient)this).elements.addAll(ingredients);
            return this;
        }
        ingredients.add(this);
        return new CompoundFluidIngredient(ingredients);
    }

    public static final class CompoundFluidIngredient
    extends CTFluidIngredient {
        final List<CTFluidIngredient> elements;

        public CompoundFluidIngredient(List<CTFluidIngredient> elements) {
            this.elements = elements;
        }

        @Override
        public String getCommandString() {
            return this.elements.stream().map(CTFluidIngredient::getCommandString).collect(Collectors.joining(" | "));
        }

        @Override
        public <T> T mapTo(Function<FluidStack, T> fluidMapper, BiFunction<ITag<Fluid>, Integer, T> tagMapper, Function<Stream<T>, T> compoundMapper) {
            Stream<Object> stream = this.elements.stream().map(element -> element.mapTo(fluidMapper, tagMapper, compoundMapper));
            return compoundMapper.apply(stream);
        }
    }

    public static final class FluidTagWithAmountIngredient
    extends CTFluidIngredient {
        final MCTagWithAmount<Fluid> tag;

        public FluidTagWithAmountIngredient(MCTagWithAmount<Fluid> tag) {
            this.tag = tag;
        }

        @Override
        public String getCommandString() {
            return this.tag.getCommandString();
        }

        @Override
        public <T> T mapTo(Function<FluidStack, T> fluidMapper, BiFunction<ITag<Fluid>, Integer, T> tagMapper, Function<Stream<T>, T> compoundMapper) {
            return tagMapper.apply((ITag<Fluid>)this.tag.getTag().getInternalRaw(), this.tag.getAmount());
        }
    }

    public static final class FluidStackIngredient
    extends CTFluidIngredient {
        final IFluidStack fluidStack;

        public FluidStackIngredient(IFluidStack fluidStack) {
            this.fluidStack = fluidStack;
        }

        @Override
        public String getCommandString() {
            return this.fluidStack.getCommandString();
        }

        @Override
        public <T> T mapTo(Function<FluidStack, T> fluidMapper, BiFunction<ITag<Fluid>, Integer, T> tagMapper, Function<Stream<T>, T> compoundMapper) {
            return fluidMapper.apply(this.fluidStack.getImmutableInternal());
        }
    }
}

