/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.zencode.impl;

import com.blamejared.crafttweaker.api.zencode.IPreprocessor;
import com.blamejared.crafttweaker.api.zencode.PreprocessorMatch;
import com.blamejared.crafttweaker.api.zencode.impl.preprocessors.LoadFirstPreprocessor;
import com.blamejared.crafttweaker.api.zencode.impl.preprocessors.LoadLastPreprocessor;
import com.blamejared.crafttweaker.api.zencode.impl.preprocessors.PriorityPreprocessor;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.openzen.zencode.shared.SourceFile;

public class SourceFilePreprocessed
implements SourceFile {
    private final String fileName;
    private List<String> fileContent;
    private final Map<IPreprocessor, List<PreprocessorMatch>> matches;

    public SourceFilePreprocessed(String fileName, List<String> fileContent, Map<IPreprocessor, List<PreprocessorMatch>> matches) {
        this.fileName = fileName;
        this.fileContent = fileContent;
        this.matches = matches;
    }

    @Override
    public String getFilename() {
        return this.fileName;
    }

    @Override
    public Reader open() {
        return new StringReader(String.join((CharSequence)System.lineSeparator(), this.fileContent) + System.lineSeparator());
    }

    @Override
    public void update(String content) {
        this.fileContent = Arrays.asList(content.split(System.lineSeparator()));
    }

    public Map<IPreprocessor, List<PreprocessorMatch>> getMatches() {
        return this.matches;
    }

    @Override
    public int getOrder() {
        if (this.getMatches().containsKey(LoadFirstPreprocessor.INSTANCE)) {
            return Integer.MAX_VALUE;
        }
        if (this.getMatches().containsKey(LoadLastPreprocessor.INSTANCE)) {
            return Integer.MIN_VALUE;
        }
        return Integer.parseInt(this.getMatches().get(PriorityPreprocessor.INSTANCE).get(0).getContent());
    }
}

